<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

/** @noinspection PhpUndefinedClassInspection */

/**
 * Class ControllerResponsesQuickViewQuickView
 * @property ModelQuickViewQuickView $model_quick_view_quick_view
 * @property ModelQuickViewQuickViewVerify $model_quick_view_quick_view_verify
 * @property ModelOptionPriceLinkProProduct $model_option_price_link_pro_product
 * @property ModelExtensionProductPricingPlus $model_extension_product_pricing_plus
 */

class ControllerResponsesQuickViewQuickView extends AController {
    public $data=[];
    private $routes = [];
    public $error = [];

    private function _init(){
        //is this an embed mode
        if($this->config->get('embed_mode') == true){
            $this->routes['cart_rt'] = 'r/checkout/cart/embed';
        } else{
            $this->routes['cart_rt'] = 'checkout/cart';
        }
    }

    public function main() {
        $this->_init();
        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/styles.css'),
                'rel' => 'stylesheet',
            ]
        );
        $this->data['getCartDetails'] = $this->html->getSecureURL('r/quick_view/quick_view/getCartsContent');

        $product_id=$this->request->get['product_id'];
        $promotion = new APromotion();
        $request = $this->request->get;
        $this->load->model('catalog/product');
        $this->load->model('catalog/review');
        $this->load->language('product/product');
        $this->load->language('quick_view/quick_view');
        $this->load->language('license_generator/license_generator');
        $this->load->model('quick_view/quick_view');
        $this->load->model('quick_view/quick_view_verify');
        $product_info = $this->model_catalog_product->getProduct($product_id);

        if ($product_info['name']==='Multi-Store Additional License' && !$request['key']) {
            $this->data['addl_license'] = '1';
            $this->data['heading_title'] = $this->language->get('heading_cannot_order');
            if ($this->customer && ($this->customer->isLogged() || $this->customer->isUnauthCustomer())) {
                $this->data['text_error'] = $this->language->get('text_logged_in_cannot_order');
            } else {
                $this->data['text_error'] = $this->language->get('text_cannot_order');
            }
        } else {
            $this->data['addl_license'] = '0';
            $this->data['minimum'] = $product_info['minimum'];
            $this->data['heading_title'] = $product_info['name'];
            $this->data['text_minimum'] = sprintf($this->language->get('text_minimum'), $product_info['minimum']);
            $this->data['maximum'] = $product_info['maximum'];
            $this->data['text_maximum'] = sprintf($this->language->get('text_maximum'), $product_info['maximum']);
            $this->data['option_resources_url'] = $this->html->getURL('r/product/product/get_option_resources');
            $this->data['calc_total_url'] = $this->html->getURL('r/product/product/calculateTotal');
            $this->data['product_review_url'] = $this->html->getURL('r/quick_view/quick_view/review', '&product_id=' . $product_id);
            $this->data['product_review_write_url'] = $this->html->getURL('r/quick_view/quick_view/write', '&product_id=' . $product_id);
            $this->data['product_wishlist_add_url'] = $this->html->getURL('product/wishlist/add', '&product_id=' . $product_id);
            $this->data['product_wishlist_remove_url'] = $this->html->getURL('product/wishlist/remove', '&product_id=' . $product_id);
            $this->data['captcha_url'] = $this->html->getURL('common/captcha');
            $this->data['update_view_count_url'] = $this->html->getURL('common/view_count/product', '&product_id=' . $product_id);
            $this->data['product_url'] = $this->html->getSEOURL('product/product', '&product_id=' . $product_id, '&encode');
            $this->loadModel('catalog/review');
            $this->data['tab_review'] = sprintf($this->language->get('tab_review'), $this->model_catalog_review->getTotalReviewsByProductId($product_id));
            $this->data['tab_description'] = $this->language->get('tab_description');
            $this->data['text_total_price'] = $this->language->get('text_total_price');
            $this->data['text_qty'] = $this->language->get('text_qty');
            $this->data['entry_rating'] = $this->language->get('entry_rating');
            $this->data['entry_good'] = $this->language->get('entry_good');
            $this->data['entry_bad'] = $this->language->get('entry_bad');
            $this->data['entry_captcha'] = $this->language->get('entry_captcha');
            $this->data['entry_name'] = $this->language->get('entry_name');
            $this->data['entry_review'] = $this->language->get('entry_review');
            $this->data['text_availability'] = $this->language->get('text_availability');
            $this->data['text_model'] = $this->language->get('text_model');
            $this->data['text_manufacturer'] = $this->language->get('text_manufacturer');
            $this->data['text_add_cart_confirm'] = $this->language->get('text_add_cart_confirm');
            $this->data['text_product_page'] = $this->language->get('text_product_page');
            $this->data['show_button'] = $this->config->get('quick_view_show_view');
            $this->data['price_with_tax'] = $this->language->get('price_with_tax');
            if ($this->config->get('addthis_status') == '1') {
                $this->load->language('addthis/addthis');
                $this->data['headJSCode'] = $this->config->get('addthis_headJSCode');
                $this->data['addthis'] = $this->config->get('addthis_status');
                $this->data['spans'] = $this->config->get('addthis_divTag');
                $this->data['addthis_text'] = $this->language->get('addthis_text');
            }

            $this->data['display_reviews'] = $this->config->get('display_reviews');
            if ($this->data['display_reviews']) {
                $this->data['tab_review'] = sprintf($this->language->get('tab_review'), $this->model_catalog_review->getTotalReviewsByProductId($product_id));
            } else {
                $this->data['tab_review'] = $this->language->get('tab_review_empty');
            }

            $this->data['review_form_status'] = $this->isReviewAllowed($product_id);
            $average = $this->data['display_reviews']
                ? $this->model_catalog_review->getAverageRating($product_id)
                : false;

            if ($this->data['review_form_status']) {
                $this->data['rating_element'] = HtmlElementFactory::create(
                    [
                        'type' => 'rating',
                        'name' => 'rating',
                        'value' => '',
                        'options' => [1 => 1, 2, 3, 4, 5],
                        'pack' => true,
                    ]);
            }

            $this->data['product_info'] = $product_info;

            $form = new AForm();
            $form->setForm(['form_name' => 'prod']);
            $this->data['form']['form_open'] = $form->getFieldHtml(
                [
                    'type' => 'form',
                    'name' => 'prod']);

            $final_price = $product_info['price'];

            $discount = $promotion->getProductDiscount($product_id);

            if ($discount) {
                $final_price = $discount;
                $this->data['price_num'] = $this->tax->calculate(
                    $discount,
                    $product_info['tax_class_id'],
                    (bool)$this->config->get('config_tax')
                );
                $this->data['special'] = false;
            } else {
                $this->data['price_num'] = $this->tax->calculate(
                    $product_info['price'],
                    $product_info['tax_class_id'],
                    (bool)$this->config->get('config_tax')
                );

                $special = $promotion->getProductSpecial($product_id);

                if ($special) {
                    $final_price = $special;
                    $this->data['special_num'] = $this->tax->calculate(
                        $special,
                        $product_info['tax_class_id'],
                        (bool)$this->config->get('config_tax')
                    );
                } else {
                    $this->data['special'] = false;
                }
            }

            $this->data['price'] = $this->currency->format($this->data['price_num']);

            if (isset($this->data['special_num'])) {
                $this->data['special'] = $this->currency->format($this->data['special_num']);
            }

            $product_discounts = $promotion->getProductDiscounts($product_id);

            $discounts = [];

            foreach ($product_discounts as $discount) {
                $discounts[] = [
                    'quantity' => $discount['quantity'],
                    'price' => $this->currency->format($this->tax->calculate($discount['price'], $product_info['tax_class_id'], (bool)$this->config->get('config_tax')))
                ];
            }
            $this->data['discounts'] = $discounts;
            $this->data['product_price'] = $final_price;
            $this->data['tax_class_id'] = $product_info['tax_class_id'];


            if (!$product_info['call_to_order']) {
                $qnt = (int)$request['quantity'];
                if (!$qnt) {
                    $qnt = ($product_info['minimum'] ? (int)$product_info['minimum'] : 1);
                }

                $qnt = (int)$product_info['minimum'] && $product_info['minimum'] > $qnt ? (int)$product_info['minimum'] : $qnt;
                $qnt = (int)$product_info['maximum'] && $product_info['maximum'] < $qnt ? (int)$product_info['maximum'] : $qnt;

                $this->data['form']['minimum'] = $form->getFieldHtml(
                    [
                        'type' => 'input',
                        'name' => 'quantity',
                        'value' => $qnt,
                        'style' => 'short',
                        'attr' => ' size="3" ']);

                $this->data['form']['add_to_cart'] = $form->getFieldHtml(
                    [
                        'type' => 'button',
                        'name' => 'add_to_cart',
                        'text' => $this->language->get('button_add_to_cart'),
                        'style' => 'button1']);

                $this->data['button_add_to_cart'] = $this->language->get('button_add_to_cart');
            }
            $this->data['button_print'] = $this->language->get('button_print');
            $this->data['text_free_shipping'] = $this->language->get('text_free_shipping');
            $this->data['form']['product_id'] = $form->getFieldHtml(
                [
                    'type' => 'hidden',
                    'name' => 'product_id',
                    'value' => $product_id]);

            $this->data['model'] = $product_info['model'];
            $this->data['manufacturer'] = $product_info['manufacturer'];
            $this->data['manufacturers'] = $this->html->getSEOURL('product/manufacturer', '&manufacturer_id=' . $product_info['manufacturer_id'], '&encode');
            $this->data['description'] = html_entity_decode($product_info['description'], ENT_QUOTES, 'UTF-8');
            $this->data['product_id'] = $product_id;
            $this->data['average'] = $average;

            $resource = new AResource('image');
            $thumbnail = $resource->getMainThumb(
                'manufacturers',
                $product_info['manufacturer_id'],
                $this->config->get('config_image_grid_width'),
                $this->config->get('config_image_grid_height')
            );

            if (!preg_match('/no_image/', $thumbnail['thumb_url'])) {
                $this->data['manufacturer_icon'] = $thumbnail['thumb_url'];
            }

            // Prepare options and values for display
            $elements_with_options = HtmlElementFactory::getElementsWithOptions();
            $options = [];
            $option_images = [];
            if ($this->model_quick_view_quick_view_verify->verifyOptionLink() === true) {
                $this->load->model('option_price_link_pro/product');
                $product_options = $this->model_option_price_link_pro_product->getProductOptions($product_id);
            } else {
                $product_options = $this->model_catalog_product->getProductOptions($product_id);
            }

            //get info from cart if key presents
            $cart_product_info = [];

            foreach ($product_options as $option) {
                if ($this->model_quick_view_quick_view_verify->verifyOptionPro() === true) {
                    $this->load->model('option_price_pro/product');
                    $configs = $this->model_option_price_pro_product->getBasePrice($option['product_option_id']);
                    $calculate = $configs['calculate'];
                    $base_price = $configs['base_price'];
                } else {
                    $calculate = $option['calculate'];
                    $base_price = $option['base_price'];
                }
                $values = [];
                $name = $price = '';
                $default_value = $cart_product_info['options'][$option['product_option_id']];

                if ($option['element_type'] == 'R') {
                    $default_value = is_array($default_value) ? current($default_value) : (string)$default_value;
                }
                $preset_value = $default_value;
                $opt_stock_message = '';
                foreach ($option['option_value'] as $option_value) {
                    $default_value = $option_value['default'] && !$default_value ? $option_value['product_option_value_id'] : $default_value;

                    // for case when trying to add to cart withot required options. we get option-array back inside _GET
                    if (has_value($request['option'][$option['product_option_id']])) {
                        $default_value = $request['option'][$option['product_option_id']];
                    }

                    $name = $option_value['name'];
                    //check if we disable options based on out of stock setting
                    if ($option_value['subtract'] && $this->config->get('config_nostock_autodisable') && $option_value['quantity'] <= 0) {
                        continue;
                    }
                    $special_price = $promotion->getProductSpecial($product_id);
                    $discount_price = $promotion->getProductDiscount($product_id);
                    $option_price = $option_value['price'];
                    $product_price = $product_info['price'];
                    if ($special_price != '') {
                        $final_price = $special_price;
                    } elseif ($discount_price != '') {
                        $final_price = $discount_price;
                    } else {
                        $final_price = $product_price;
                    }

                    //Apply option price modifier
                    if ($this->model_quick_view_quick_view_verify->verifyOptionLink() ||
                        $this->model_quick_view_quick_view_verify->verifyOptionPro()) {
                        if ($option_value['prefix'] == '%') {
                            if ($calculate == '0') {
                                $price = $this->tax->calculate(
                                    ($final_price * $option_value['price'] / 100),
                                    $product_info['tax_class_id'],
                                    (bool)$this->config->get('config_tax'));
                            } else {
                                $price = $this->tax->calculate(
                                    $final_price + ($final_price * $option_value['price'] / 100),
                                    $product_info['tax_class_id'],
                                    (bool)$this->config->get('config_tax'));
                            }
                            if ($price != 0) {
                                $price = $this->currency->format($price);
                            } else {
                                $price = '';
                            }
                        } else {
                            if ($calculate == '0') {
                                $price = $this->tax->calculate($option_price, $product_info['tax_class_id'], (bool)$this->config->get('config_tax'));
                            } else {
                                $price = $this->tax->calculate($final_price + $option_price, $product_info['tax_class_id'], (bool)$this->config->get('config_tax'));
                            }
                            if ($price != 0) {
                                $price = $this->currency->format($price);
                            } else {
                                $price = '';
                            }
                        }
                        $opt_stock_message = '';
                        if ($option_value['subtract']) {
                            if ($option_value['quantity'] <= 0) {
                                //show out of stock message
                                $opt_stock_message = $product_info['stock_status'];
                            } else {
                                if ($this->config->get('config_stock_display')) {
                                    $opt_stock_message = $option_value['quantity'] . " " . $this->language->get('text_instock');
                                }
                            }
                        }
                        if ($base_price == '1') {
                            $values[$option_value['product_option_value_id']] = $name . ' ' . $price . ' ' . $opt_stock_message;
                        } else {
                            if ($option_price != '0.0000') {
                                $values[$option_value['product_option_value_id']] = $name . ' ' . $price . ' ' . $opt_stock_message;
                            } else {
                                $values[$option_value['product_option_value_id']] = $name . ' ' . $opt_stock_message;
                            }
                        }
                    } elseif ($this->model_quick_view_quick_view_verify->verifyOptionLite()) {
                        if ($option_value['prefix'] == '%') {
                            $price = $this->tax->calculate(
                                $final_price + ($final_price * $option_value['price'] / 100),
                                $product_info['tax_class_id'],
                                (bool)$this->config->get('config_tax'));
                            if ($price != 0) {
                                $price = $this->currency->format($price);
                            } else {
                                $price = '';
                            }
                        } else {
                            $price = $this->tax->calculate($final_price + $option_price, $product_info['tax_class_id'], (bool)$this->config->get('config_tax'));
                            if ($price != 0) {
                                $price = $this->currency->format($price);
                            } else {
                                $price = '';
                            }
                        }
                        $opt_stock_message = '';
                        if ($option_value['subtract']) {
                            if ($option_value['quantity'] <= 0) {
                                //show out of stock message
                                $opt_stock_message = $product_info['stock_status'];
                            } else {
                                if ($this->config->get('config_stock_display')) {
                                    $opt_stock_message = $option_value['quantity'] . " " . $this->language->get('text_instock');
                                }
                            }
                        }

                        $optionSeparator = $this->config->get('option_price_name_separator');
                        $priceSeparator = $this->config->get('option_price_price_separator');
                        $showPrice = $this->config->get('option_price_show_baseprice');
                        $hidePrice = $this->config->get('option_price_hide_price');
                        if ($optionSeparator === '') {
                            $optionSymbol = '&nbsp;&nbsp;&nbsp;';
                        } else {
                            $optionSymbol = '&nbsp;' . $optionSeparator . '&nbsp;';
                        }
                        if ($priceSeparator === '') {
                            $priceSymbol = '&nbsp;&nbsp;&nbsp;';
                        } else {
                            $priceSymbol = '&nbsp;' . $priceSeparator . '&nbsp;';
                        }

                        if (!empty($opt_stock_message)) {
                            $stock_message = $priceSymbol . $opt_stock_message;
                        } else {
                            $stock_message = '';
                        }

                        if ($hidePrice === '1') {
                            $values[$option_value['product_option_value_id']] = $name . $stock_message;
                        } elseif ($showPrice === '1') {
                            $values[$option_value['product_option_value_id']] = $name . $optionSymbol . $price . $stock_message;
                        } else {
                            if ($option_price != '0.0000') {
                                $values[$option_value['product_option_value_id']] = $name . $optionSymbol . $price . $stock_message;
                            } else {
                                $values[$option_value['product_option_value_id']] = $name . $stock_message;
                            }
                        }

                    } else {
                        if ($option_value['prefix'] == '%') {
                            $price = $this->tax->calculate(
                                ($final_price * $option_value['price'] / 100),
                                $product_info['tax_class_id'],
                                (bool)$this->config->get('config_tax'));
                            if ($price != 0) {
                                $price = $this->currency->format($price);
                            } else {
                                $price = '';
                            }
                        } else {
                            $price = $this->tax->calculate($option_value['price'], $product_info['tax_class_id'], (bool)$this->config->get('config_tax'));
                            if ($price != 0) {
                                $price = $this->currency->format($price);
                            } else {
                                $price = '';
                            }
                        }
                        $opt_stock_message = '';
                        if ($option_value['subtract']) {
                            if ($option_value['quantity'] <= 0) {
                                //show out of stock message
                                $opt_stock_message = $product_info['stock_status'];
                            } else {
                                if ($this->config->get('config_stock_display')) {
                                    $opt_stock_message = $option_value['quantity'] . " " . $this->language->get('text_instock');
                                }
                            }
                        }
                        $values[$option_value['product_option_value_id']] = $option_value['name'] . ' ' . $price . ' ' . $opt_stock_message;
                    }
                    //Check stock and status
                }

                //if not values are build, nothing to show
                if (sizeof((array)$values)) {
                    $value = '';
                    //add price to option name if it is not element with options
                    if (!in_array($option['element_type'], $elements_with_options)) {
                        $option['name'] .= ' <small>' . $price . '</small>';
                        if ($opt_stock_message) {
                            $option['name'] .= '<br />' . $opt_stock_message;
                        }
                        $value = $default_value ? $default_value : $name;
                    }

                    //set default selection is nothing selected
                    if (!has_value($value)) {
                        if (has_value($default_value)) {
                            $value = $default_value;
                        }
                    }

                    //for checkbox with empty value
                    if ($value == '' && $option['element_type'] == 'C') {
                        $value = 1;
                    }

                    $option_data = [
                        'type' => $option['html_type'],
                        'name' => !in_array($option['element_type'], HtmlElementFactory::getMultivalueElements()) ? 'option[' . $option['product_option_id'] . ']' : 'option[' . $option['product_option_id'] . '][]',
                        'value' => $value,
                        'options' => $values,
                        'required' => $option['required'],
                        'placeholder' => $option['option_placeholder'],
                        'regexp_pattern' => $option['regexp_pattern'],
                        'error_text' => $option['error_text']
                    ];
                    if ($option['element_type'] == 'C') {
                        if (!in_array($value, ['0', '1'])) {
                            $option_data['label_text'] = $value;
                        }
                        $option_data['checked'] = $preset_value ? true : false;
                    }

                    if ($this->model_quick_view_quick_view_verify->verifyOptionLink() === true) {
                        $options[] = [
                            'info' => html_entity_decode($option['info']),
                            'name' => $option['name'],
                            'html' => $this->html->buildElement($option_data),  // not a string!!! it's object!
                        ];
                    } else {
                        $options[] = [
                            'name' => $option['name'],
                            'html' => $this->html->buildElement($option_data),  // not a string!!! it's object!
                        ];
                    }
                }
            }

            $this->data['options'] = $options;

            //handle stock messages
            // if track stock is off. no messages needed.
            if ($this->model_catalog_product->isStockTrackable($product_id)) {
                //NOTE: total quantity can be integer and true(in case stock-track is off)
                $total_quantity = $this->model_catalog_product->hasAnyStock($product_id);
                $this->data['track_stock'] = true;
                $this->data['can_buy'] = true;
                //out of stock if no quantity and no stock checkout is disabled
                if ($total_quantity <= 0 && !$product_info['stock_checkout']) {
                    $this->data['can_buy'] = false;
                    $this->data['in_stock'] = false;
                    //show out of stock message
                    $this->data['stock'] = $this->language->get('text_out_of_stock');
                } else {
                    $this->data['can_buy'] = true;
                    $this->data['in_stock'] = true;
                    $this->data['stock'] = '';
                    if ($this->config->get('config_stock_display') && $total_quantity > 0) {
                        //if not tracked - show nothing
                        $this->data['stock'] = $total_quantity !== true ? $total_quantity . ' ' : '';
                    }
                    if ($total_quantity <= 0) {
                        $this->data['stock'] = $product_info['stock_status'];
                    } else {
                        $this->data['stock'] .= $this->language->get('text_instock');
                    }
                }

                //check if we need to disable product for no stock
                if ($this->config->get('config_nostock_autodisable') && $total_quantity <= 0) {
                    //set available data
                    $pd_identifiers = "ID: " . $product_id;
                    $pd_identifiers .= (empty($product_info['model']) ? '' : " Model: " . $product_info['model']);
                    $pd_identifiers .= (empty($product_info['sku']) ? '' : " SKU: " . $product_info['sku']);
                    $message_ttl = sprintf($this->language->get('notice_out_of_stock_ttl'), $product_info['name']);
                    $product_url = '#admin#rt=catalog/product/update&product_id=' . $product_id;
                    $message_txt = sprintf($this->language->get('notice_out_of_stock_body'), $product_info['name'], $pd_identifiers, $product_url);
                    //record to message box
                    $msg = new AMessage();
                    $msg->saveNotice($message_ttl, $message_txt);
                    $this->model_catalog_product->updateStatus($product_id, 0);
                    redirect($this->html->getSEOURL('product/product', '&product_id=' . $product_info['product_id'], '&encode'));
                }
            } else {
                $this->data['can_buy'] = true;
                if ($product_info['quantity'] <= 0) {
                    $this->data['stock'] = $product_info['stock_status'];
                }
            }

            // main product image
            $sizes = [
                'main' => [
                    'width' => $this->config->get('config_image_popup_width'),
                    'height' => $this->config->get('config_image_popup_height'),
                ],
                'thumb' => [
                    'width' => $this->config->get('config_image_thumb_width'),
                    'height' => $this->config->get('config_image_thumb_height'),
                ],
            ];
            if (!$option_images['main']) {
                $this->data['image_main'] = $resource->getResourceAllObjects('products', $product_id, $sizes, 1, false);
                if ($this->data['image_main']) {
                    $this->data['image_main']['sizes'] = $sizes;
                }
            } else {
                $this->data['image_main'] = $option_images['main'];
                if ($this->data['image_main']) {
                    $this->data['image_main']['sizes'] = $sizes;
                }
                unset($option_images['main']);
            }

            // additional images
            $sizes = [
                'main' => [
                    'width' => $this->config->get('config_image_popup_width'),
                    'height' => $this->config->get('config_image_popup_height'),
                ],
                'thumb' => [
                    'width' => $this->config->get('config_image_additional_width'),
                    'height' => $this->config->get('config_image_additional_height'),
                ],
                'thumb2' => [
                    'width' => $this->config->get('config_image_thumb_width'),
                    'height' => $this->config->get('config_image_thumb_height'),
                ]
            ];
            if (!$option_images['images']) {
                $this->data['images'] = $resource->getResourceAllObjects('products', $product_id, $sizes, 0, false);
            } else {
                $this->data['images'] = $option_images['images'];
            }

            $products = [];
            $results = $this->model_catalog_product->getProductRelated($product_id);
            foreach ($results as $result) {

                // related product image
                $sizes = [
                    'main' => [
                        'width' => $this->config->get('config_image_related_width'),
                        'height' => $this->config->get('config_image_related_height'),
                    ],
                    'thumb' => [
                        'width' => $this->config->get('config_image_related_width'),
                        'height' => $this->config->get('config_image_related_height'),
                    ],
                ];
                $image = $resource->getResourceAllObjects('products', $result['product_id'], $sizes, 1);

                if ($this->config->get('display_reviews')) {
                    $rating = $this->model_catalog_review->getAverageRating($result['product_id']);
                } else {
                    $rating = false;
                }

                $special = false;
                $discount = $promotion->getProductDiscount($result['product_id']);
                if ($discount) {
                    $price = $this->currency->format($this->tax->calculate($discount, $result['tax_class_id'], (bool)$this->config->get('config_tax')));
                } else {
                    $price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], (bool)$this->config->get('config_tax')));
                    $special = $promotion->getProductSpecial($result['product_id']);
                    if ($special) {
                        $special = $this->currency->format($this->tax->calculate($special, $result['tax_class_id'], (bool)$this->config->get('config_tax')));
                    }
                }

                $options = $this->model_catalog_product->getProductOptions($result['product_id']);
                if ($options) {
                    $add = $this->html->getSEOURL('product/product', '&product_id=' . $result['product_id'], '&encode');
                } else {
                    if ($this->config->get('config_cart_ajax')) {
                        $add = '#';
                    } else {
                        $add = $this->html->getSecureURL($this->routes['cart_rt'], '&product_id=' . $result['product_id'], '&encode');
                    }
                }

                $products[] = [
                    'product_id' => $result['product_id'],
                    'name' => $result['name'],
                    'model' => $result['model'],
                    'rating' => $rating,
                    'stars' => sprintf($this->language->get('text_stars'), $rating),
                    'price' => $price,
                    'call_to_order' => $result['call_to_order'],
                    'options' => $options,
                    'special' => $special,
                    'image' => $image,
                    'href' => $this->html->getSEOURL('product/product', '&product_id=' . $result['product_id'], '&encode'),
                    'add' => $add,
                    'tax_class_id' => $result['tax_class_id'],
                ];
            }

            $this->data['related_products'] = $products;

            if ($this->config->get('config_customer_price')) {
                $display_price = true;
            } elseif ($this->customer->isLogged()) {
                $display_price = true;
            } else {
                $display_price = false;
            }
            $this->data['display_price'] = $display_price;

            $tags = [];
            $results = $this->model_catalog_product->getProductTags($product_id);
            foreach ($results as $result) {
                if ($result['tag']) {
                    $tags[] = [
                        'tag' => $result['tag'],
                        'href' => $this->html->getURL('product/search', '&keyword=' . $result['tag'], '&encode')
                    ];
                }
            }
            $this->data['tags'] = $tags;

            //downloads before order if allowed
            if ($this->config->get('config_download')) {
                $dwn = new ADownload();
                $download_list = $dwn->getDownloadsBeforeOrder($product_id);
                if ($download_list) {
                    $downloads = [];

                    foreach ($download_list as $download) {
                        $href = $this->html->getURL('account/download/startdownload', '&download_id=' . $download['download_id']);
                        $download['attributes'] = $this->download->getDownloadAttributesValuesForCustomer($download['download_id']);

                        $download['button'] = $form->getFieldHtml(
                            ['type' => 'button',
                                'id' => 'download_' . $download['download_id'],
                                'href' => $href,
                                'title' => $this->language->get('text_start_download'),
                                'text' => $this->language->get('text_start_download')]);

                        $downloads[] = $download;
                    }

                    $this->data['downloads'] = $downloads;
                }
            }

            #check if product is in a wishlist
            $this->data['is_customer'] = false;
            if ($this->customer->isLogged() || $this->customer->isUnauthCustomer()) {
                $this->data['is_customer'] = true;
                $whishlist = $this->customer->getWishList();
                if ($whishlist[$product_id]) {
                    $this->data['in_wishlist'] = true;
                }
            }

            if ($this->model_quick_view_quick_view_verify->verifyProductPricingPlus()) {
                $this->load->model('extension/product_pricing_plus');
                $product_id = $this->request->get['product_id'];
                $settings = $this->model_extension_product_pricing_plus->getSettings($product_id);
                if ($settings['show_product_page']) {
                    $this->data['base_price_content'] = $settings['content'];
                }

                if ($this->data['price'] === '$0.00') {
                    $this->data['price'] = '';
                }
            }
            $this->data['direction'] = $this->language->get('direction');
            $this->data['cart_url'] = $this->html->getURL('checkout/cart');
            $this->data['cart_ajax'] = (int)$this->config->get('config_cart_ajax');
            $this->data['cart_ajax_url'] = $this->html->getURL('r/quick_view/quick_view/addToCart');
            $this->data['search_url'] = $this->html->getURL('product/search');
            $this->data['call_to_order_url'] = $this->html->getURL('content/contact');
        }
        
        $this->view->batchAssign($this->data);
        $this->processTemplate('responses/quick_view/quick_view.tpl');
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

    }

    /*
	 * Load images for product option
	 * */
    public function get_option_resources() {
        $attribute_value_id = (int)$this->request->post['attribute_value_id'];
        $product_id = (int)$this->request->post['product_id'];
        $output = [];
        if ($attribute_value_id && is_int($attribute_value_id)) {
            $resource = new AResource('image');

            // main product image
            $msizes = [
                'main'  =>
                    [
                        'width'  => $this->config->get('config_image_popup_width'),
                        'height' => $this->config->get('config_image_popup_height'),
                    ],
                'thumb' => [
                    'width'  => $this->config->get('config_image_thumb_width'),
                    'height' => $this->config->get('config_image_thumb_height'),
                ],
            ];

            $output['main'] = $resource->getResourceAllObjects('product_option_value', $attribute_value_id, $msizes, 1, false);
            if (!$output['main']) {
                unset($output['main']);
            }

            // additional images
            $osizes = [
                'main'   =>
                    [
                        'width'  => $this->config->get('config_image_popup_width'),
                        'height' => $this->config->get('config_image_popup_height'),
                    ],
                'thumb'  =>
                    [
                        'width'  => $this->config->get('config_image_additional_width'),
                        'height' => $this->config->get('config_image_additional_height'),
                    ],
                //product image zoom related thumbnail
                'thumb2' =>
                    [
                        'width'  => $this->config->get('config_image_thumb_width'),
                        'height' => $this->config->get('config_image_thumb_height'),
                    ],
            ];

            $output['images'] = $resource->getResourceAllObjects('product_option_value', $attribute_value_id, $osizes, 0, false);
            if (!$output['images']) {
                unset($output['images']);
            }

            //no image? return main product images
            if (!count($output) && $product_id) {
                $output['main'] = $resource->getResourceAllObjects('products', $product_id, $msizes, 1, false);
                $output['images'] = $resource->getResourceAllObjects('products', $product_id, $osizes, 0, false);
            }
        }

        //update controller data
        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($output));
    }

    public function addToCart() {
        $product_rt = 'product/product';
        $text_errors = [];
        $post = $this->request->post;
        $product_id = $post['product_id'];
        $this->load->model('catalog/product');
        $product_info = $this->model_catalog_product->getProduct($product_id);
        $this->load->model('quick_view/quick_view_verify');
        $option_lite_status=$this->model_quick_view_quick_view_verify->verifyOptionLite();
        $option_pro_status=$this->model_quick_view_quick_view_verify->verifyOptionPro();
        $option_link_pro_status=$this->model_quick_view_quick_view_verify->verifyOptionLink();
        $license_generator_status=$this->model_quick_view_quick_view_verify->verifyLicenseGenerator();
        if ($option_lite_status|| $option_pro_status || $option_link_pro_status || $license_generator_status) {
            if ($option_lite_status) {
                $this->load->language('option_price/option_price');
                $this->load->model('option_price/option');
            } elseif ($option_pro_status) {
                $this->load->language('option_price_pro/option_price_pro');
                $this->load->model('option_price_pro/product');
            } elseif ($option_link_pro_status) {
                $this->load->language('option_price_link_pro/option_price_link_pro');
                $this->load->model('option_price_link_pro/product');
            } elseif ($license_generator_status) {
                $this->load->language('license_generator/license_generator');
                $this->load->model('extension/license_generator');
            }

            if (isset($post['option'])) {
                $options = $post['option'];
                $i=$j=0;
                foreach ($options as $option_id => $option) {
                    if ($option_lite_status) {
                        $options_info = $this->model_option_price_option->getOptionType($option_id);
                    } elseif ($option_pro_status) {
                        $options_info = $this->model_option_price_pro_product->getOptionType($option_id);
                    } elseif ($option_link_pro_status) {
                        $options_info = $this->model_option_price_link_pro_product->getOptionType($option_id);
                    } elseif ($license_generator_status) {
                        $options_info = $this->model_extension_license_generator->getOptionType($option_id);
                        $option_name = $options_info['name'];
                        if (stripos($option_name,'Buy ')!==false) {
                            if ($option==='') {
                                $i++;
                                $missing_buy = true;
                            } else {
                                $j++;
                            }
                        } elseif ( stripos($option_name,'Rent ')!==false) {
                            if ($option==='') {
                                $i++;
                                $missing_rent = true;
                            } else {
                                $j++;
                            }
                        }

                        if ( $i==1 && $missing_buy && (stripos($product_info['name'],' pack') !== false || stripos($product_info['name'],' + ') !== false)) {
                            $text_errors = $this->language->get('error_missing_buy');
                          } elseif ( $i==2 ) {
                            $text_errors = $this->language->get('error_rent_or_buy');
                        } elseif ($j===2) {
                            $text_errors = $this->language->get('error_rent_and_buy');
                        }
                    }

                    $option_type = $options_info['element_type'];

                    if ($option_type === 'G' || $option_type === 'M') {
                        $id = $option_id;
                        $settings = [];
                        $error = false;
                        $error_message = $default_message = $min_warning = $error_min_warning = $max_warning = $error_max_warning='';
                        if ($option_lite_status) {
                            $settings = $this->model_option_price_option->getSettings($option_id);
                            $min_warning=$this->config->get('option_price_enter_minimum_warning');
                            $error_min_warning= $this->language->get('error_minimum_warning');
                            $max_warning=$this->config->get('option_price_enter_maximum_warning');
                            $error_max_warning=$this->language->get('error_maximum_warning');
                        } elseif ($option_pro_status) {
                            $settings = $this->model_option_price_pro_product->getSettings($option_id);
                            $min_warning=$this->config->get('option_price_pro_enter_minimum_warning');
                            $error_min_warning= $this->language->get('error_pro_minimum_warning');
                            $max_warning=$this->config->get('option_price_pro_enter_maximum_warning');
                            $error_max_warning=$this->language->get('error_pro_maximum_warning');
                        } elseif ($option_link_pro_status) {
                            $settings = $this->model_option_price_link_pro_product->getSettings($option_id);
                            $min_warning=$this->config->get('option_price_link_pro_enter_minimum_warning');
                            $error_min_warning= $this->language->get('error_link_pro_minimum_warning');
                            $max_warning=$this->config->get('option_price_link_pro_enter_maximum_warning');
                            $error_max_warning=$this->language->get('error_link_pro_maximum_warning');
                        }
                        if (!is_null($settings)) {
                            $minimum = $settings['minimum'];
                            $maximum = $settings['maximum'];
                            $status = $settings['maximum_status'];
                            $total = sizeof($options[$id]);
                            if ($status === '1') {
                                if ($minimum !== '' && $total < $minimum) {
                                    $searchArray = ['{min}', '{total}'];
                                    $replaceArray = [$minimum, $total];
                                    $error_message = str_replace($searchArray, $replaceArray, $min_warning);
                                    $default_message = str_replace('{total}', $total, $error_min_warning);
                                    $default_message = $minimum . ' ' . $default_message;
                                    $error = true;
                                } elseif ($maximum !== '' && $total > $maximum) {
                                    $searchArray = ['{max}', '{total}'];
                                    $replaceArray = [$maximum, $total];
                                    $error_message = str_replace($searchArray, $replaceArray, $max_warning);
                                    $searchDefaultArray = ['{max}', '{total}'];
                                    $replaceDefaultArray = [$maximum, $total];
                                    $default_message = str_replace($searchDefaultArray, $replaceDefaultArray, $error_max_warning);
                                    $error = true;
                                }
                            } elseif ($status === '0') {
                                if ($minimum !== '' && $total < $minimum) {
                                    $searchArray = ['{min}', '{total}'];
                                    $replaceArray = [$minimum, $total];
                                    $error_message = str_replace($searchArray, $replaceArray, $min_warning);
                                    $default_message = str_replace('{total}', $total, $error_min_warning);
                                    $default_message = $minimum . ' ' . $default_message;
                                    $error = true;
                                }
                            }
                            if ($error === true) {
                                if ($error_message !== '') {
                                    $text_errors[] = $option_name . ": " . $error_message;
                                } else {
                                    $text_errors[] = $option_name . ": " . $default_message;
                                }
                            }
                        }
                    }
                }
                if ($text_errors) {
                    $product_rt = 'product/product';
                    $this->error = $text_errors;
                }
            }
        }

        if (isset($this->request->post['quantity'])){
            //we update cart
            if (!is_array($this->request->post['quantity'])){

                $this->loadModel('catalog/product', 'storefront');
                $product_id = $this->request->post['product_id'];

                if (isset($this->request->post['option'])){
                    $options = $this->request->post['option'];
                } else{
                    $options = array ();
                }
                //for FILE-attributes
                if (has_value($this->request->files['option']['name'])){

                    $fm = new AFile();
                    foreach ($this->request->files['option']['name'] as $id => $name){

                        $attribute_data = $this->model_catalog_product->getProductOption($product_id, $id);
                        $attribute_data['settings'] = unserialize($attribute_data['settings']);
                        $file_path_info = $fm->getUploadFilePath($attribute_data['settings']['directory'], $name);

                        $options[$id] = $file_path_info['name'];

                        if (!has_value($name)){
                            continue;
                        }

                        if ($attribute_data['required'] && !$this->request->files['option']['size'][$id]){
                            $this->session->data['error'] = $this->language->get('error_required_options');
                            $this->redirect($_SERVER['HTTP_REFERER']);
                        }

                        $file_data = array (
                            'option_id' => $id,
                            'name'      => $file_path_info['name'],
                            'path'      => $file_path_info['path'],
                            'type'      => $this->request->files['option']['type'][$id],
                            'tmp_name'  => $this->request->files['option']['tmp_name'][$id],
                            'error'     => $this->request->files['option']['error'][$id],
                            'size'      => $this->request->files['option']['size'][$id],
                        );

                        $file_errors = $fm->validateFileOption($attribute_data['settings'], $file_data);

                        if (has_value($file_errors)){
                            $this->error  = implode('<br/>', $file_errors);
                            //$this->redirect($_SERVER['HTTP_REFERER']);
                        } else{
                            $result = move_uploaded_file($file_data['tmp_name'], $file_path_info['path']);

                            if (!$result || $this->request->files['package_file']['error']){
                                $this->error  .= '<br>Error: ' . getTextUploadError($this->request->files['option']['error'][$id]);
                                $this->redirect($_SERVER['HTTP_REFERER']);
                            }
                        }

                        $dataset = new ADataset('file_uploads', 'admin');
                        $dataset->addRows(
                            array (
                                'date_added' => date("Y-m-d H:i:s", time()),
                                'name'       => $file_path_info['name'],
                                'type'       => $file_data['type'],
                                'section'    => 'product_option',
                                'section_id' => $attribute_data['attribute_id'],
                                'path'       => $file_path_info['path'],
                            )
                        );

                    }
                }

                if ($text_errors = $this->model_catalog_product->validateProductOptions($product_id, $options)){
                    $this->error = $text_errors;
                    //send options values back via _GET
                    //$url = '&' . http_build_query(array ('option' => $this->request->post['option']));
                    //$this->redirect($this->html->getSecureURL($product_rt, '&product_id=' . $this->request->post['product_id'] . $url));
                }
                if (empty($this->error)) {
                    $this->cart->add($this->request->post['product_id'], $this->request->post['quantity'], $options);
                }
            } else{
                foreach ($this->request->post['quantity'] as $key => $value){
                    $this->cart->update($key, $value);
                }
            }

            unset($this->session->data['shipping_methods']);
            unset($this->session->data['shipping_method']);
            unset($this->session->data['payment_methods']);
            unset($this->session->data['payment_method']);
        }

        if ($this->error) {
            $this->data['error'] = $this->error ;
        } else {
            $this->data['error'] = '';
        }

        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($this->data));
    }

    public function getCartsContent() {
        $display_totals = $this->cart->buildTotalDisplay();

        $dispatch = $this->dispatch('responses/quick_view/quick_view/get_carts_details',[$display_totals]);

        $this->data['cart_details'] = $dispatch->dispatchGetOutput();
        $this->data['item_count'] = $this->cart->countProducts();

        $this->data['total'] = $this->currency->format($display_totals['total']);
        //update controller data

        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($this->data));
    }

    public function get_carts_details($totals){
        if(!$this->view->isTemplateExists('responses/checkout/cart_details.tpl')){
            return '';
        }

        $cart_products = $this->cart->getProducts() + $this->cart->getVirtualProducts();
        $product_ids = array_column($cart_products, 'product_id');
        $resource = new AResource('image');
        $thumbnails = $product_ids
            ? $resource->getMainThumbList(
                'products',
                $product_ids,
                $this->config->get('config_image_additional_width'),
                $this->config->get('config_image_additional_width')
            )
            : [];

        foreach ($cart_products as $result) {
            $option_data = [];
            $thumbnail = $thumbnails[$result['product_id']];
            foreach ($result['option'] as $option) {
                $value = $option['value'];
                // hide binary value for checkbox
                if($option['element_type']=='C' && in_array($value, [0,1])){
                    $value = '';
                }
                // strip long textarea value
                if($option['element_type']=='T'){
                    $title = strip_tags($value);
                    $title = str_replace('\r\n',"\n",$title);

                    $value = str_replace('\r\n',"\n",$value);
                    if(mb_strlen($value) > 64){
                        $value = mb_substr($value, 0, 64) . '...';
                    }
                }

                $option_data[] = [
                    'name'  => $option['name'],
                    'value' => $value,
                    'title' => $title
                ];
            }
            $qty = 0;
            $qty += $result['quantity'];

            $this->data['products'][] = [
                'key' => $result['key'],
                'name' => $result['name'],
                'option' => $option_data,
                'quantity' => $result['quantity'],
                'stock' => $result['stock'],
                'price' => $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax'))),
                'href' => $this->html->getSEOURL('product/product', '&product_id=' . $result['product_id']),
                'thumb' => $thumbnail,
            ];
        }

        $this->data['totals'] = $totals['total_data'];
        $this->data['subtotal'] = $this->currency->format($this->tax->calculate($totals['total'], $result['tax_class_id'], $this->config->get('config_tax')));
        $this->data['taxes'] = $totals['taxes'];
        $this->data['view'] = $this->html->getURL('checkout/cart');

        $this->view->batchAssign($this->data);
        $this->processTemplate('responses/checkout/cart_details.tpl');
    }

    public function review() {
        $this->loadLanguage('product/product');
        $this->loadModel('catalog/review');

        $this->view->assign('text_no_reviews', $this->language->get('text_no_reviews') );

        $request = $this->request->get;

        $product_id = (int)$request['product_id'];

        if (isset($request['page'])) {
            $page = $request['page'];
        } else {
            $page = 1;
        }
        $reviews = [];
        if ($this->config->get('display_reviews')) {
            $results = $this->model_catalog_review->getReviewsByProductId($product_id, ($page - 1) * 5, 5);
            if ($results) {
                foreach ($results as $result) {
                    $reviews[] = [
                        'author' => $result['author'],
                        'rating' => $result['rating'],
                        'verified_purchase' => $result['verified_purchase'],
                        'text' => str_replace("\n", '<br />', strip_tags($result['text'])),
                        'stars' => sprintf($this->language->get('text_stars'), $result['rating']),
                        'date_added' => dateISO2Display($result['date_added'], $this->language->get('date_format_short'))
                    ];
                }
            }
        }

        $this->data['reviews'] =  $reviews;

        $review_total = $this->model_catalog_review->getTotalReviewsByProductId($product_id);

        $this->data['pagination_bootstrap'] = HtmlElementFactory::create( array (
            'type' => 'Pagination',
            'name' => 'pagination',
            'text'=> $this->language->get('text_pagination'),
            'text_limit' => $this->language->get('text_per_page'),
            'total'	=> $review_total,
            'page'	=> $page,
            'limit'	=> 5,
            'no_perpage' => true,
            'url' => $this->html->getURL('r/quick_view/quick_view/review','&product_id=' . $product_id . '&page={page}'),
            'style' => 'pagination'));
        $this->view->batchAssign($this->data);

        $this->processTemplate('responses/product/review.tpl' );
    }

    public function write() {
        $product_id = (int)$this->request->get['product_id'];

        $this->loadLanguage('product/product');
        $this->loadModel('catalog/review');
        $json = [];

        if ($this->request->is_POST() && $this->_validate()) {

            $this->request->post['name']=$this->request->post['author'];
            $this->request->post['text']=$this->request->post['review'];
            unset($this->request->post['author']);
            unset($this->request->post['review']);
            $review_id = $this->model_catalog_review->addReview($product_id, $this->request->post);
            unset($this->session->data['captcha']);
            $json['success'] = $this->language->get('text_success_product');
            //notify admin
            $this->loadLanguage('common/im');
            $message_arr = [
                1 => ['message' => sprintf($this->language->get('im_product_review_text_to_admin'), $review_id)
                ]
            ];
            $this->im->send('product_review', $message_arr);
        } else {
            $json['error'] = $this->error['message'];
        }

        $this->load->library('json');
        $this->response->setOutput(AJson::encode($json));
    }

    private function _validate() {
        if ( mb_strlen($this->request->post['author']) < 3 || mb_strlen($this->request->post['author']) > 25 ) {
            $this->error['message'] = $this->language->get('error_name');
        }

        if ( mb_strlen($this->request->post['review']) < 25 || mb_strlen($this->request->post['review']) > 1000 ) {
            $this->error['message'] = $this->language->get('error_text');
        }

        if (!$this->request->post['rating']) {
            $this->error['message'] = $this->language->get('error_rating');
        }

        if($this->config->get('config_recaptcha_secret_key')) {
            require_once DIR_VENDORS . '/google_recaptcha/autoload.php';
            $recaptcha = new \ReCaptcha\ReCaptcha($this->config->get('config_recaptcha_secret_key'));
            $resp = $recaptcha->verify(	$this->request->post['g-recaptcha-response'],
                $this->request->server['REMOTE_ADDR']);
            if (!$resp->isSuccess() && $resp->getErrorCodes()) {
                $this->error['message'] = $this->language->get('error_captcha');
            }
        } else {
            if (!isset($this->session->data['captcha'])
                || ($this->session->data['captcha'] != $this->request->post['captchas'])) {
                $this->error['message'] = $this->language->get('error_captcha');
            }
        }

        if (!$this->error) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    
}