<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ExtensionProductPricingPlus extends Extension {

    public $errors = [];
    public $data = [];
    protected $controller;
    protected $registry;

    protected $exemptGroups = [];

    public function __construct() {
        $this->registry = Registry::getInstance();
    }

    protected function _is_enabled() {
        return $this->baseObject->config->get('product_pricing_plus_status') ? true : false;
    }

    // Storefront Common Head Section
    public function onControllerCommonHead_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that = $this->baseObject;
        if (IS_ADMIN === false) {
            $that->document->addStyle(
                [
                    'href' => $that->view->templateResource( '/stylesheet/pricing-plus.css' ),
                    'rel'  => 'stylesheet',
                ]
            );
        }
    }
    // End Of Storefront Common Head Section

    public function onControllerCommonListingGrid_InitData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if($that->data['table_id'] === 'product_grid') {
            $that->loadLanguage('product_pricing_plus/product_pricing_plus');
            $that->data['actions']['dropdown']['children']['product_pricing_plus'] = [
                'text' => $that->language->get('product_pricing_plus_name'),
                'href' => $that->html->getSecureURL('catalog/product_pricing_plus', '&product_id=%ID%'),
            ];
        }
    }

    public function onControllerPagesCatalogProductTabs_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->loadLanguage('product_pricing_plus/product_pricing_plus');

        $this->data = [];
        $this->data['tabs'][] = [
            'href'   => $that->html->getSecureURL(
                'catalog/product_pricing_plus',
                '&product_id='.$that->request->get['product_id']
            ),
            'text'   => $that->language->get('product_pricing_plus_name'),
            'active' => ($that->data['active'] == 'product_pricing_plus'),
        ];

        $view = new AView(Registry::getInstance(), 0);
        $view->batchAssign($this->data);
        $that->view->addHookVar('extension_tabs', $view->fetch('pages/product_pricing_plus/tabs.tpl'));
    }

    public function onControllerPagesProductProduct_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->load->model('extension/product_pricing_plus');
            $product_id=$that->request->get['product_id'];
            $settings = $that->model_extension_product_pricing_plus->getSettings($product_id);
            if ($settings['show_product_page']) {
                $special = $that->data['special'];
                $price = $that->data['price'] !='$0.00' ? $that->data['price'] : '';
                if ($special) {
                    $that->view->assign('special' , html_entity_decode($settings['content']).' '.$special);
                } else {
                    $that->view->assign('price' , html_entity_decode($settings['content']).' '.$price);
                }
            }
        }
    }

    public function onControllerBlocksBestSeller_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main' ) {
            if ( ! $that->config->get( 'embed_mode' ) ) {
                $this->data['bestseller_products'] = [];
                $this->data['bestseller_products'] = $that->data['products'];
                $that->load->model('extension/product_pricing_plus');
                foreach ($this->data['bestseller_products'] as $key => $product) {
                    $product_id = $product['product_id'];
                    $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                    if ($settings['show_product_listing']==='1') {
                        if ($product['special']) {
                            $this->data['bestseller_products'][$key]['special']= html_entity_decode($settings['content']).' '.$product['special'];
                        } else {
                            $this->data['bestseller_products'][$key]['price']= html_entity_decode($settings['content']).' '.$product['price'];
                        }
                    }
                }
                $that->view->assign('products',$this->data['bestseller_products']);
            }
        }
    }

    public function onControllerBlocksSpecial_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main' ) {
            if ( ! $that->config->get( 'embed_mode' ) ) {
                $this->data['block_special_products'] = [];
                $this->data['special_products']=$that->data['products'];
                $that->load->model('extension/product_pricing_plus');
                foreach ($this->data['special_products'] as $key => $product) {
                    $product_id = $product['product_id'];
                    $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                    if ($settings['show_product_listing']==='1') {
                        if ($product['special']) {
                            $this->data['special_products'][$key]['special']= html_entity_decode($settings['content']).' '.$product['special'];
                        } else {
                            $this->data['special_products'][$key]['price']= html_entity_decode($settings['content']).' '.$product['price'];
                        }
                    }
                }
                $that->view->assign('products',$this->data['block_special_products']);
            }
        }
    }

    public function onControllerBlocksfeatured_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }

        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main' ) {
            if ( ! $that->config->get( 'embed_mode' ) ) {
                $this->data['featured_products'] = [];
                $this->data['featured_products']=$that->data['products'];
                $that->load->model('extension/product_pricing_plus');
                foreach ($this->data['featured_products'] as $key => $product) {
                    $product_id = $product['product_id'];
                    $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                    if ($settings['show_product_listing']==='1') {
                        $product_price = html_entity_decode($settings['content']);
                        if ($product['special']) {
                            $this->data['featured_products'][$key]['special']= html_entity_decode($settings['content']).' '.$product['special'];
                        } else {
                            if ($product['price']!=='$0.00') {
                                $product_price .= ' ' . $product['price'];
                            }
                            $this->data['featured_products'][$key]['price']= $product_price;
                        }
                    }
                }
                $that->view->assign('products',$this->data['featured_products']);
            }
        }
    }

    public function onControllerBlocksLatest_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main' ) {
            if ( ! $that->config->get( 'embed_mode' ) ) {
                $this->data['latest_products'] = [];
                $this->data['latest_products']=$that->data['products'];
                $that->load->model('extension/product_pricing_plus');
                foreach ($this->data['latest_products'] as $key => $product) {
                    $product_id = $product['product_id'];
                    $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                    if ($settings['show_product_listing']==='1') {
                        $product_price = html_entity_decode($settings['content']);
                        if ($product['special']) {
                            $this->data['latest_products'][$key]['special']= html_entity_decode($settings['content']).' '.$product['special'];
                        } else {
                            if ($product['price']!=='$0.00') {
                                $product_price .= ' ' . $product['price'];
                            }
                            $this->data['latest_products'][$key]['price']= $product_price;
                        }
                    }
                }
                $that->view->assign('products',$this->data['latest_products']);
            }
        }
    }

    public function onControllerPagesProductSpecial_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main' ) {
            if(!$that->config->get('embed_mode')) {
                $this->data['product_special'] = [];
                $this->data['product_special']=$that->data['products'];
                $that->load->model('extension/product_pricing_plus');
                foreach ($this->data['product_special'] as $key => $product) {
                    $product_id = $product['product_id'];
                    $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                    if ($settings['show_product_listing']==='1') {
                        $product_price = html_entity_decode($settings['content']);
                        if ($product['special']) {
                            $this->data['product_special'][$key]['special']= html_entity_decode($settings['content']).' '.$product['special'];
                        } else {
                            if ($product['price']!=='$0.00') {
                                $product_price .= ' ' . $product['price'];
                            }
                            $this->data['product_special'][$key]['price']= $product_price;
                        }
                    }
                }
                $that->view->assign('products',$this->data['product_special']);
            }
        }
    }

    public function onControllerPagesProductCategory_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main' ) {
            if(!$that->config->get('embed_mode')) {
                $this->data['product_category'] = [];
                $this->data['product_category']=$that->data['products'];
                $that->load->model('extension/product_pricing_plus');
                foreach ($this->data['product_category'] as $key => $product) {
                    $product_id = $product['product_id'];
                    $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                    if ($settings['show_product_listing']==='1') {
                        $product_price = html_entity_decode($settings['content']);
                        if ($product['special']) {
                            $this->data['product_category'][$key]['special']= html_entity_decode($settings['content']).' '.$product['special'];
                        } else {
                            if ($product['price']!=='$0.00') {
                                $product_price .= ' ' . $product['price'];
                            }
                            $this->data['product_category'][$key]['price']= $product_price;
                        }
                    }
                }
                $that->view->assign('products',$this->data['product_category']);
            }
        }
    }

    public function onControllerPagesProductManufacturer_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main' ) {
            if (!$that->config->get('embed_mode')) {
                $this->data['product_manufacturer'] = [];
                $this->data['product_manufacturer']=$that->data['products'];
                $that->load->model('extension/product_pricing_plus');
                foreach ($this->data['product_manufacturer'] as $key => $product) {
                    $product_id = $product['product_id'];
                    $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                    if ($settings['show_product_listing']==='1') {
                        $product_price = html_entity_decode($settings['content']);
                        if ($product['special']) {
                            $this->data['product_manufacturer'][$key]['special']= html_entity_decode($settings['content']).' '.$product['special'];
                        } else {
                            if ($product['price']!=='$0.00') {
                                $product_price .= ' ' . $product['price'];
                            }
                            $this->data['product_manufacturer'][$key]['price']= $product_price;
                        }
                    }
                }
                $that->view->assign('products',$this->data['product_manufacturer']);
            }
        }
    }

    public function onControllerPagesProductSearch_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method == 'main') {
            $that =& $this->baseObject;
            if ( $this->baseObject_method === 'main') {
                if ( ! $that->config->get( 'embed_mode' ) ) {
                    $this->data['product_search'] = [];
                    $this->data['product_search']=$that->data['products'];
                    $that->load->model('extension/product_pricing_plus');
                    foreach ($this->data['product_search'] as $key => $product) {
                        $product_id = $product['product_id'];
                        $settings=$that->model_extension_product_pricing_plus->getSettings($product_id);
                        if ($settings['show_product_listing']==='1') {
                            $product_price = html_entity_decode($settings['content']);
                            if ($product['special']) {
                                $this->data['product_search'][$key]['special']= html_entity_decode($settings['content']).' '.$product['special'];
                            } else {
                                if ($product['price']!=='$0.00') {
                                    $product_price .= ' ' . $product['price'];
                                }
                                $this->data['product_search'][$key]['price']= $product_price;
                            }
                        }
                    }
                    $that->view->assign('products',$this->data['product_search']);
                }
            }
        }
    }

    // Dispatch new controller to be ran
    protected function dispatch($dispatch_rt, $args = ['']) {
        return new ADispatcher($dispatch_rt, $args);
    }
    
}