<?php

/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ModelExtensionProductPricingPlus
 */

class ModelExtensionProductPricingPlus extends Model {

    /**
     * @param $product_id
     * @param $data
     * @return int
     */

    public function saveSettings($product_id,$data) {
        $exists = $this->exist($product_id);

        if ($exists !== '0') {
            $this->updateContent($product_id,$data);

        } else {
            $this->db->query('INSERT INTO ' . $this->db->table("product_pricing_plus") . ' SET product_id=' . (int)$product_id . ',
                         show_product_listing=' . (int)$data['show_product_listing'] . ',
                         show_product_page=' . (int)$data['show_product_page'] . ',
                         content="' . addslashes($data['content']) . '"');
        }
        return $this->db->getLastId();
    }

    /**
     * @param $product_id
     * @param $data
     * @return int
     */

    public function updateContent($product_id,$data) {
        $update=[];
        $fields = [
            'show_product_listing',
            'show_product_page',
            'content'
            ];

        foreach ($fields as $f) {
            if (isset($data[$f])) {
                if ($f==='content') {
                    $update[] = $f.' = "'.addslashes($data[$f]).'"';
                } else {
                    $update[] = $f." = '".$data[$f]."'";
                }
            }
        }

        $this->db->query(
            "UPDATE `".$this->db->table("product_pricing_plus")."`
            SET ".implode(',', $update)."
            WHERE product_id = ".(int)$product_id
        );
        return $this->db->getLastId();
    }

    /**
     * @param $product_id
     * @return mixed
     */

    public function exist($product_id) {
        $query = $this->db->query("SELECT count(*) as total FROM ".$this->db->table("product_pricing_plus")." WHERE product_id=".(int)$product_id);
        return $query->row['total'];
    }

    /**
     * @param $product_id
     * @return mixed
     */

    public function getSettings($product_id) {
        $query = $this->db->query("SELECT * FROM ".$this->db->table("product_pricing_plus")." WHERE product_id=".(int)$product_id);
        return $query->row;
    }

    /**
     * @param $product_id
     */
    public function removeContent($product_id) {
        $this->db->query("DELETE FROM ".$this->db->table("product_pricing_plus")." WHERE product_id=".(int)$product_id);
    }

}