<?php

/*------------------------------------------------------------------------------



  For Abante Cart, E-commerce Solution

  http://www.AbanteCart.com



  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)



------------------------------------------------------------------------------*/



if (!defined('DIR_CORE')) {

    header('Location: static_pages/');

}



/**

 * Class ControllerPagesCatalogProductFeatures

 *

 * @property ModelExtensionProductPricingPlus $model_extension_product_pricing_plus

 * @property AAttribute_Manager              $attribute_manager

 */





class ControllerPagesCatalogProductPricingPlus extends AController {

    public $error = [];

    public $data = [];



    public function main() {



        $this->loadLanguage('product_pricing_plus/product_pricing_plus');

        $this->loadLanguage('catalog/product');

        $this->loadModel('extension/product_pricing_plus');

        $this->loadModel('catalog/product');

        $this->attribute_manager = new AAttribute_Manager();



        if ($this->request->is_POST() && $this->validateForm()) {

            $this->model_extension_product_pricing_plus->saveSettings($this->request->get['product_id'],$this->request->post);

            $this->session->data['success'] = $this->language->get('text_success');

            redirect(

                $this->html->getSecureURL(

                    'catalog/product_pricing_plus',

                    '&product_id='.$this->request->get['product_id']

                )

            );

        }



        $this->document->setTitle($this->language->get('product_pricing_plus_title'));

        $this->data = $this->model_extension_product_pricing_plus->getSettings(

            $this->request->get['product_id']

        );

        $this->data['heading_title'] = $this->language->get('text_edit').'&nbsp;'.$this->language->get('text_product');



        $this->view->assign('error', $this->error);

        $this->view->assign('success', $this->session->data['success']);

        if (isset($this->session->data['success'])) {

            unset($this->session->data['success']);

        }



        $this->document->initBreadcrumb([

            'href'      => $this->html->getSecureURL('index/home'),

            'text'      => $this->language->get('text_home'),

            'separator' => false,

        ]);

        $this->document->addBreadcrumb([

            'href'      => $this->html->getSecureURL('catalog/product'),

            'text'      => $this->language->get('heading_title'),

            'separator' => ' :: ',

        ]);

        $this->document->addBreadcrumb([

            'href'      => $this->html->getSecureURL('catalog/product/update',

                '&product_id='.$this->request->get['product_id']),

            'text'      => $this->language->get('text_edit')

                .'&nbsp;'

                .$this->language->get('text_product')

                .' - '

                .$this->data['product_description'][$this->session->data['content_language_id']]['name'],

            'separator' => ' :: ',

        ]);

        $this->document->addBreadcrumb([

            'href'      => $this->html->getSecureURL(

                'catalog/product_pricing_plus',

                '&product_id='.$this->request->get['product_id']

            ),

            'text'      => $this->language->get('product_pricing_plus_name'),

            'separator' => ' :: ',

            'current'   => true,

        ]);



        $this->data['language_id'] = $this->session->data['content_language_id'];



        //load tabs controller

        $this->data['active'] = 'product_pricing_plus';

        $tabs_obj = $this->dispatch('pages/catalog/product_tabs', [$this->data]);

        $this->data['product_tabs'] = $tabs_obj->dispatchGetOutput();

        unset($tabs_obj);



        $form = new AForm('HT');

        $form->setForm([

            'form_name' => 'new_product_pricing_plus_form',

            'update'    => '',

        ]);



        $this->data['form']['fields']['show_product_listing'] = $form->getFieldHtml([

            'type' => 'checkbox',

            'name' => 'show_product_listing',

            'value' => $this->data['show_product_listing'],

            'style'  => 'btn_switch',

        ]);

        $this->data['form']['text']['show_product_listing'] = $this->language->get('entry_show_product_listing');

        $this->data['form']['fields']['show_product_page'] = $form->getFieldHtml([

            'type' => 'checkbox',

            'name' => 'show_product_page',

            'value' => $this->data['show_product_page'],

            'style'  => 'btn_switch',

        ]);

        $this->data['form']['text']['show_product_page'] = $this->language->get('entry_show_product_page');

        $this->data['form']['fields']['content'] = $form->getFieldHtml([

            'type'     => 'texteditor',

            'name'     => 'content',

            'required' => false,

            'value'    => $this->data['content'],

        ]);

        $this->data['form']['text']['content'] = $this->language->get('entry_content');



        $this->data['action'] = $this->html->getSecureURL('catalog/product_pricing_plus', '&product_id='.$this->request->get['product_id']);

        $this->data['form_title'] = $this->language->get('text_edit').'&nbsp;'.$this->language->get('text_product');

        $this->data['update'] = '';

        $form = new AForm('HT');



        $form->setForm([

            'form_name' => 'product_pricing_plus_form',

            'update'    => $this->data['update'],

        ]);



        $this->data['form']['id'] = 'product_pricing_plus_form';

        $this->data['form']['form_open'] = $form->getFieldHtml([

            'type'   => 'form',

            'name'   => 'product_pricing_plus_form',

            'action' => $this->data['action'],

            'attr'   => 'data-confirm-exit="true" class="aform form-horizontal"',

        ]);

        $this->data['form']['submit'] = $form->getFieldHtml([

            'type'  => 'button',

            'name'  => 'submit',

            'text'  => $this->language->get('button_save'),

            'style' => 'button1',

        ]);

        $this->data['form']['cancel'] = $form->getFieldHtml([

            'type'  => 'button',

            'name'  => 'cancel',

            'text'  => $this->language->get('button_cancel'),

            'style' => 'button2',

        ]);



        $this->addChild('pages/catalog/product_summary', 'summary_form', 'pages/catalog/product_summary.tpl');

        $this->addChild('responses/common/resource_library/get_resources_html', 'resources_html',

            'responses/common/resource_library_scripts.tpl');

            $resources_scripts = $this->dispatch(

                'responses/common/resource_library/get_resources_scripts',

                [

                    'object_name' => '',

                    'object_id'   => '',

                    'types'       => ['image'],

                ]

            );

            $this->data['resources_scripts'] = $resources_scripts->dispatchGetOutput();

            $this->data['rl'] = $this->html->getSecureURL('common/resource_library',

                '&action=list_library&object_name=&object_id&type=image&mode=single');

        $this->view->batchAssign($this->data);

        $this->processTemplate('pages/product_pricing_plus/product_pricing_plus_form.tpl');

    }



    protected function validateForm() {

        if (!$this->user->hasPermission('modify', 'catalog/product_pricing_plus')) {

            $this->error['warning'] = $this->language->get('error_permission');

        }



        if (!$this->error) {

            return true;

        } else {

            return false;

        }

    }



}