<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerExtensionAdditionalLicense
 * @property ModelAccountOrder $model_account_order
 * @property ModelCatalogProduct $model_catalog_product
 * @property ModelCheckoutOrder $model_checkout_order
 * @property ModelExtensionAdditionalLicense $model_extension_additional_license
 * @property ModelExtensionLicenseGenerator $model_extension_license_generator
 */
class ControllerResponsesExtensionAdditionalLicense extends AController
{
    public $data = [];

    public function orderAdditionalLicense() {
        $this->load->library('json');

        $this->response->addJSONHeader();
        $post = $this->request->post;
        $license_generator_info_id = $post['license_generator_info_id'];
        $order_id = $post['order_id'];
        $this->load->model('account/order');
        $this->load->model('extension/additional_license');
        $this->load->model('catalog/product');
        $this->load->model('checkout/order');
        $this->load->language('license_generator/license_generator');
        $order_info = $this->model_extension_additional_license->getLicenseInfoById($license_generator_info_id);
        if ($order_info) {
            $product_name = $order_info['extension_name'];
            $store_url = $order_info['store_url'];
            $license_code = $order_info['license_code'];
            $cart_version = $order_info['cart_version'];
            $productId = $this->model_extension_additional_license->getProductId('Multi-Store Additional License');
            $product_info = $this->model_extension_additional_license->getProduct($productId);
            $stockInfo = $this->model_extension_additional_license->getProductsStockInfo([$productId]);

            $options = $this->model_catalog_product->getProductOptions($productId);
            $option_data = [];
            if ($options) {
                foreach ($options as $option) {
                    if ($option['element_type'] === 'S') {
                        $option_value = $option['option_value'];
                        foreach ($option_value as $val) {
                            if ($option['name'] === 'Extension Name' && $product_name === $val['name']) {
                                $option_data['extension_name'] = $val['name'];
                            } elseif ($option['name'] === 'AbanteCart version of the above URL' && $cart_version === $val['name']) {
                                $option_data['cart_version'] = $val['name'];
                            }
                        }
                    } elseif ($option['element_type'] === 'I') {
                        if ($option['name'] === 'The URL where you will install') {
                            $option_data['store_url'] = $store_url;
                        } elseif ($option['name'] === 'Main Store License Key') {
                            $option_data['main_store_license_key'] = $license_code;
                        }
                    }
                }
            }
            $customer_id = $this->customer->getId();
            $this->session->data['additional_license_' . $customer_id][$productId]['options'] = $option_data;
            $this->data['redirect'] = $this->html->getSEOURL('product/product&product_id=' . $productId . '&key=' . $productId . ':' . md5(serialize($option_data)) . '&additional_license=true');
        }
        $this->response->setOutput(AJson::encode($this->data));
    }

    public function orderPacksAdditionalLicense() {
        $this->load->library('json');

        $this->response->addJSONHeader();
        $post = $this->request->post;
        $license_generator_info_id = $post['license_generator_pack_info_id'];
        $order_id = $post['order_id'];
        $this->load->model('account/order');
        $this->load->model('extension/additional_license');
        $this->load->model('catalog/product');
        $this->load->model('checkout/order');
        $this->load->language('license_generator/license_generator');
        $order_info = $this->model_extension_additional_license->getPacksLicenseInfoById($license_generator_info_id);
        if ($order_info) {
            $product_name = $order_info['extension_name'];
            $store_url = $order_info['store_url'];
            $license_code = $order_info['license_code'];
            $cart_version = $order_info['cart_version'];
            $productId = $this->model_extension_additional_license->getProductId('Multi-Store Additional License');
            $product_info = $this->model_extension_additional_license->getProduct($productId);
            $stockInfo = $this->model_extension_additional_license->getProductsStockInfo([$productId]);

            $options = $this->model_catalog_product->getProductOptions($productId);
            $option_data = [];
            if ($options) {
                foreach ($options as $option) {
                    if ($option['element_type'] === 'S') {
                        $option_value = $option['option_value'];
                        foreach ($option_value as $val) {
                            if ($option['name'] === 'Extension Name' && $product_name === $val['name']) {
                                $option_data['extension_name'] = $val['name'];
                            } elseif ($option['name'] === 'AbanteCart version of the above URL' && $cart_version === $val['name']) {
                                $option_data['cart_version'] = $val['name'];
                            }
                        }
                    } elseif ($option['element_type'] === 'I') {
                        if ($option['name'] === 'The URL where you will install') {
                            $option_data['store_url'] = $store_url;
                        } elseif ($option['name'] === 'Main Store License Key') {
                            $option_data['main_store_license_key'] = $license_code;
                        }
                    }
                }
            }
            $customer_id = $this->customer->getId();
            $this->session->data['additional_license_' . $customer_id][$productId]['options'] = $option_data;
            $this->data['redirect'] = $this->html->getSEOURL('product/product&product_id=' . $productId . '&key=' . $productId . ':' . md5(serialize($option_data)) . '&additional_license=true');
        }
        $this->response->setOutput(AJson::encode($this->data));
    }
}