<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerPagesExtensionWebhook
 * @property ModelExtensionLicenseGenerator $model_extension_license_generator
 * @property ModelCheckoutOrder $model_checkout_order
 */

class ControllerPagesLicenseGeneratorWebhooks extends AController {
    public $data=[];

    public function main() {
        $post = $_POST;
        $this->load->model('extension/license_generator');
        $this->load->model('checkout/order');

        if (isset($post['invoice_id'])) {
            $invoice_id = $this->db->escape($post['invoice_id']);
            $order_id = $this->model_extension_license_generator->getOrderIdByBlestaInvoice($invoice_id);
            if ($order_id) {
                $license_order_status_id = $this->config->get('license_generator_order_status_id');
                if ($this->config->get('license_generator_debug_blesta')) {
                    $this->log->write('order id: ' . $order_id);
                    $this->log->write('order status id: ' . $license_order_status_id);
                }
                $this->model_checkout_order->update($order_id, $license_order_status_id, $this->config->get('license_generator_payment_received_comment'), true);
            }
        }

        if (isset($post['service_id'])) {
            $data['license_code'] = $this->db->escape($post['license_code']);
            $data['service_id'] = $this->db->escape($post['service_id']);
            $packs_exist = $this->model_extension_license_generator->getBlestaPacksLicenseInfoByServiceId($data['service_id']);
            $exist = $this->model_extension_license_generator->getBlestaLicenseInfoByServiceId($data['service_id']);
            if ($packs_exist) {
                if ($data['license_code']!=='') {
                    $this->model_extension_license_generator->updatePacksLicenseInfo($data);
                }
                if (isset($post['license_status'])) {
                    $data['license_status'] = $post['license_status'];
                    $this->model_extension_license_generator->updatePacksLicenseStatus($data);
                }
            } elseif ($exist) {
                if ($data['license_code']!=='') {
                    $this->model_extension_license_generator->updateLicenseInfo($data);
                }
                if (isset($post['license_status'])) {
                    $data['license_status'] = $post['license_status'];
                    $this->model_extension_license_generator->updateLicenseStatus($data);
                }
            }
        }
    }
}