<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerPagesOptionPriceFastCheckout
 * @property ModelCatalogProduct $model_catalog_product
 * @property ModelOptionPriceOption $model_license_generator_option
 * @property ModelExtensionLicenseGenerator $model_extension_license_generator
 */

class ControllerPagesLicenseGeneratorFastCheckout extends AController {
    public $data=[];

    public function main() {

        $this->loadLanguage('fast_checkout/fast_checkout');
        $this->loadLanguage('license_generator/license_generator');

        if ($this->request->is_POST() && $this->request->get['single_checkout']) {
            $this->session->data['fc']['cart_key'] = randomWord(5);
        } elseif (!$this->session->data['fc']['cart_key']) {
            $this->session->data['fc']['cart_key'] = randomWord(5);
        }

        $this->extensions->hk_InitData($this, __FUNCTION__);

        //set sign for commonHead controller.
        // Needed to change url in the tpl. See addToCart method inside js
        $this->registry->set('fast_checkout', true);
        //short name
        $fcSession =& $this->session->data['fc'];

        $cartClassName = get_class($this->cart);
        //create new cart with single product (onclick buy-now button)
        if ($this->request->get['single_checkout'] && $this->request->is_POST()) {
            $post = $this->request->post;
            $fcSession['single_checkout'] = $this->data['single_checkout'] = true;
            $fcSession['cart'] = [];
            $this->registry->set(
                'cart',
                new $cartClassName($this->registry, $fcSession)
            );
            if (isset($this->request->post['product_id'])) {
                $this->loadModel('catalog/product', 'storefront');
                $productId = $post['product_id'];

                if (isset($post['option'])) {
                    $options = $post['option'];
                } else {
                    $options = [];
                }

                //for FILE-attributes
                if (has_value($this->request->files['option']['name'])) {
                    $fm = new AFile();
                    foreach ($this->request->files['option']['name'] as $id => $name) {
                        $attributeData = $this->model_catalog_product->getProductOption($productId, $id);
                        $attributeData['settings'] = unserialize($attributeData['settings']);
                        $filePathInfo = $fm->getUploadFilePath($attributeData['settings']['directory'], $name);

                        $options[$id] = $filePathInfo['name'];

                        if (!has_value($name)) {
                            continue;
                        }

                        if ($attributeData['required'] && !$this->request->files['option']['size'][$id]) {
                            $this->session->data['error'] = $this->language->get('error_required_options');
                            redirect($_SERVER['HTTP_REFERER']);
                        }

                        $fileData = [
                            'option_id' => $id,
                            'name'      => $filePathInfo['name'],
                            'path'      => $filePathInfo['path'],
                            'type'      => $this->request->files['option']['type'][$id],
                            'tmp_name'  => $this->request->files['option']['tmp_name'][$id],
                            'error'     => $this->request->files['option']['error'][$id],
                            'size'      => $this->request->files['option']['size'][$id],
                        ];

                        $fileErrors = $fm->validateFileOption($attributeData['settings'], $fileData);

                        if (has_value($fileErrors)) {
                            $this->session->data['error'] = implode('<br/>', $fileErrors);
                            redirect($_SERVER['HTTP_REFERER']);
                        } else {
                            $result = move_uploaded_file($fileData['tmp_name'], $filePathInfo['path']);

                            if (!$result || $this->request->files['package_file']['error']) {
                                $this->session->data['error'] .= '<br>Error: '.getTextUploadError(
                                        $this->request->files['option']['error'][$id]
                                    );
                                redirect($_SERVER['HTTP_REFERER']);
                            }
                        }

                        $dataset = new ADataset('file_uploads', 'admin');
                        $dataset->addRows(
                            [
                                'date_added' => date("Y-m-d H:i:s", time()),
                                'name'       => $filePathInfo['name'],
                                'type'       => $fileData['type'],
                                'section'    => 'product_option',
                                'section_id' => $attributeData['attribute_id'],
                                'path'       => $filePathInfo['path'],
                            ]
                        );
                    }
                }

                $this->load->model( 'extension/license_generator' );
                $this->load->model( 'catalog/product' );
                $i=$j=0;
                $main_store_license_key = '';
                $rent = $license_key_status = $licensed_extension_name = false;
                $product_info = $this->model_catalog_product->getProduct($post['product_id']);
                $max_qty = $product_info['maximum'];
                if ($post['quantity'] > $max_qty) {
                    $text_errors = $this->language->get('error_maximum_order');
                    $this->session->data['error'] = $text_errors;
                    $url = '&' . http_build_query( [ 'option' => $post['option'] ] );
                    redirect( $this->html->getSecureURL( 'product/product', '&product_id=' . $post['product_id']).$url);
                }
                $main_store_license_key = $missing_buy = $missing_rent = '';
                foreach ( $options as $option_id => $option ) {
                    $options_info = $this->model_extension_license_generator->getOptionType( $option_id );
                    $option_name  = $options_info['name'];
                    if (stripos($option_name,'Additional License')!==false) {
                        $additional_license = $option==='' ? '' : $option;
                    } elseif (stripos($option_name,'Buy ')!==false) {
                        if ($option==='') {
                            $i++;
                            $missing_buy = true;
                        } else {
                            $j++;
                        }
                    } elseif (stripos($option_name,'Rent ')!==false) {
                        if ($option==='') {
                            $i++;
                            $missing_rent = true;
                        } else {
                            $j++;
                        }
                    } elseif ( stripos($option_name,'Main Store License Key')!==false) {
                        if ($option!=='' && stripos($product_info['name'],' Additional License')!==false && stripos($option,'own-')!==false) {
                            $main_store_license_key = $option;
                            $licenseKeyInfo = $this->model_extension_license_generator->validateMainStore($option);
                            if ($option===$licenseKeyInfo['blesta_license_code']) {
                                $license_key_status = true;
                            }
                            if (stripos($product_info['name'],$licenseKeyInfo['extension_name'])!==false) {
                                $licensed_extension_name = true;
                            }
                        }
                    }
                }
                if (stripos($product_info['name'],' Additional License')!==false) {
                    if (!$license_key_status) {
                        $errors[] = $this->language->get('error_invalid_license_code');
                    } elseif (!$licensed_extension_name) {
                        $errors[] = $this->language->get('error_extension_name_unmatch');
                    }
                } elseif (stripos($main_store_license_key,'rent-') && $main_store_license_key!=='') {
                    $errors[] = $this->language->get('error_rent_additional_license');
                } elseif ($i==1 && $missing_buy) {
                    $errors[] = $this->language->get('error_missing_buy');
                } elseif ( $i==1 && $missing_buy && (stripos($product_info['name'],' pack') !== false || stripos($product_info['name'],' + ') !== false)) {
                    $errors[] = $this->language->get('error_rent_or_buy');
                } elseif ($j === 2) {
                    $errors[] = $this->language->get('error_rent_and_buy');
                }

                if ($errors) {
                    $this->session->data['error'] = $errors;
                    redirect(
                        $this->html->getSecureURL(
                            'product/product',
                            '&product_id=' . $post['product_id']
                        )
                    );
                } elseif ($textErrors = $this->model_catalog_product->validateProductOptions($productId, $options)) {
                    $this->session->data['error'] = $textErrors;
                    //send options values back via _GET
                    $url = '&'.http_build_query(['option' => $post['option']]);
                    redirect(
                        $this->html->getSecureURL(
                            'product/product',
                            '&product_id='.$post['product_id'].$url
                        )
                    );
                }

                $this->cart->add($post['product_id'], $post['quantity'], $options);
                $productCartKey = !$options ? $productId : $productId.':'.md5(serialize($options));
                if (!$this->cart->hasProducts() || (!$this->cart->hasStock() && !$this->config->get('config_stock_checkout'))) {
                    $this->session->data['error'] = $this->language->get('fast_checkout_text_not_enough_stock');
                    //send options values back via _GET
                    $url = '&'.http_build_query(['option' => $post['option']]);
                    redirect(
                        $this->html->getSecureURL(
                            'product/product',
                            '&product_id='.$post['product_id'].$url
                        )
                    );
                }
            }
            //if we added single product via POST request - do redirect to self
            redirect($this->html->getSecureURL('checkout/fast_checkout', '&product_key='.$productCartKey));
        } //do clone of default cart
        else {
            if (!$fcSession['single_checkout']) {
                $fcSession['single_checkout'] = false;
            }
            $fcSession['cart'] = $fcSession['cart'] ? : $this->session->data['cart'];
            $this->removeNoStockProducts();
            if (isset($this->session->data['coupon'])) {
                $fcSession['coupon'] = $this->session->data['coupon'];
            }
            $this->registry->set(
                'cart',
                new $cartClassName($this->registry, $fcSession)
            );
        }

        if ($this->request->get['single_checkout']) {
            $this->data['single_checkout'] = true;
        }
        //save cart_key into cookie to check on js-side
        // if another fc changed it
        setCookieOrParams(
            'fc_cart_key',
            $fcSession['cart_key'],
            [
                'path'     => dirname($this->request->server['PHP_SELF']),
                'domain'   => null,
                'secure'   => (defined('HTTPS') && HTTPS),
                'httponly' => false,
                'samesite' => ((defined('HTTPS') && HTTPS) ? 'None' : 'lax')
            ]
        );

        //check if two single-checkout tabs opened
        if (isset($this->request->get['product_key'])) {
            $cartProducts = $this->cart->getProducts();
            //warning about min/max qty exceeding
            if($fcSession['error']) {
                $this->data['error'] = $fcSession['error'];
                unset($this->session->data['fc']['error']);
            }
            $cartSingleProduct = $cartProducts[$this->request->get['product_key']];
            if (count($cartProducts) > 1 && $cartSingleProduct) {
                redirect(
                    $this->html->getSEOURL(
                        'product/product',
                        '&product_id='.$cartSingleProduct['product_id']
                    )
                );
            } elseif (!$cartSingleProduct) {
                //if product not found in the cart - just redirect to home
                redirect($this->html->getHomeURL());
            }
        }
    }

    protected function removeNoStockProducts() {
        $cartProducts = $this->cart->getProducts();
        foreach ($cartProducts as $key => $cartProduct) {
            if (!$cartProduct['stock'] && !$this->config->get('config_stock_checkout')) {
                unset(
                    $this->session->data['fc']['cart'][$key]
                );
            }
        }
    }
}