<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

include_once DIR_EXT.'license_generator'.DIR_EXT_CORE.'lib/download.php';

class ControllerPagesExtensionLicenseGeneratorDownload extends AController {
    public $data = [];

    public function main() {
        $this->load->language('account/download');
        $this->load->language('license_generator/license_generator');

        $order_id = $this->request->get['order_id'];

        if (!$this->customer->isLogged()) {
            $this->session->data['redirect'] = $this->html->getSecureURL('extension/license_generator_download');
            redirect($this->html->getSecureURL('account/login'));
        }

        $this->document->setTitle($this->language->get('heading_title_download_extension'));
        $this->document->resetBreadcrumbs();
        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getHomeURL(),
                'text'      => $this->language->get('text_home'),
                'separator' => false,
            ]
        );
        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('account/download'),
                'text'      => $this->language->get('text_downloads'),
                'separator' => $this->language->get('text_separator'),
            ]
        );

        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('extension/license_generator_download'),
                'text'      => $this->language->get('heading_title_download_extension').$order_id,
                'separator' => $this->language->get('text_separator'),
            ]
        );

        if (isset($this->request->get['limit'])) {
            $limit = (int) $this->request->get['limit'];
            $limit = $limit > 50 ? 50 : $limit;
        } else {
            $limit = $this->config->get('config_catalog_limit');
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $downloads = [];

        $download = new ALicenseGeneratorDownload();
        $customer_downloads = $download->getEntireOrderDownloads($order_id, 0);

        $product_ids = array_column($customer_downloads, 'product_id');
        $product_ids = array_map('intval', $product_ids);

        $resource = new AResource('image');
        $thumbnails = $product_ids
            ? $resource->getMainThumbList(
                'products',
                $product_ids,
                $this->config->get('config_image_cart_width'),
                $this->config->get('config_image_cart_height'),
                false
            )
            : [];
        $suffix = [
            'B',
            'KB',
            'MB',
            'GB',
            'TB',
            'PB',
            'EB',
            'ZB',
            'YB',
        ];

        foreach ($customer_downloads as $download_info) {
            $text_status = $this->download->getTextStatusForOrderDownload($download_info);
            $size = 0;
            if (is_numeric($download_info['filename'])) {
                $rl = new AResource('download');
                $resource = $rl->getResource($download_info['filename']);
                if ($resource && $resource['resource_path']) {
                    $size = filesize(DIR_RESOURCE.$rl->getTypeDir().$resource['resource_path']);
                }
            }else{
                $size = filesize(DIR_RESOURCE.$download_info['filename']);
            }
            $i = 0;
            while (($size / 1024) > 1) {
                $size = $size / 1024;
                $i++;
            }

            $download_text = $download_button = '';
            if (!$text_status) {
                $download_button = $this->html->buildElement(
                    [
                        'type'  => 'button',
                        'name'  => 'download_button_'.$download_info['order_download_id'],
                        'title' => $this->language->get('text_download'),
                        'text'  => $this->language->get('text_download'),
                        'style' => 'button',
                        'href'  => $this->html->getSecureURL(
                            'account/download/startdownload',
                            '&order_download_id='.$download_info['order_download_id']
                        ),
                        'icon'  => 'fa fa-download-alt',
                    ]
                );
            } else {
                $download_text = $text_status;
            }

            $thumbnail = $thumbnails[$download_info['product_id']];
            $attributes = $this->download->getDownloadAttributesValuesForCustomer($download_info['download_id']);

            $downloads[] = [
                'order_download_id' => $download_info['order_download_id'],
                'thumbnail'         => $thumbnail,
                'attributes'        => $attributes,
                'order_id'          => $download_info['order_id'],
                'date_added'        => dateISO2Display(
                    $download_info['date_added'],
                    $this->language->get('date_format_short')
                ),
                'name'              => $download_info['name'],
                'remaining'         => $download_info['remaining_count'],
                'size'              => round(substr($size, 0, strpos($size, '.') + 4), 2).$suffix[$i],
                'button'            => $download_button,
                'text'              => $download_text,
                'expire_date'       => dateISO2Display(
                    $download_info['expire_date'],
                    $this->language->get('date_format_short').' '.$this->language->get('time_format_short')
                ),
            ];
        }

        $this->data['downloads'] = $downloads;

        $this->data['pagination_bootstrap'] = $this->html->buildElement(
            [
                'type'       => 'Pagination',
                'name'       => 'pagination',
                'text'       => $this->language->get('text_pagination'),
                'text_limit' => $this->language->get('text_per_page'),
                'total'      => $this->download->getTotalOrderDownloads($order_id,$this->customer->getId()),
                'page'       => $page,
                'limit'      => $limit,
                'url'        => $this->html->getURL('account/download&limit='.$limit.'&page={page}', '&encode'),
                'style'      => 'pagination',
            ]
        );

        if ($downloads) {
            $template = 'pages/extension/license_generator_download.tpl';
        } else {
            $template = 'pages/error/not_found.tpl';
        }

        $this->data['order_id'] = $order_id;

        $this->view->batchAssign($this->language->getASet());

        $this->view->batchAssign($this->data);
        $this->processTemplate($template);

        //init controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

    }
}