<?php

/*------------------------------------------------------------------------------
  $Id$

  AbanteCart, Ideal OpenSource Ecommerce Solution
  http://www.AbanteCart.com

  Copyright © 2011-2020 Belavier Commerce LLC

  This source file is subject to Open Software License (OSL 3.0)
  License details is bundled with this package in the file LICENSE.txt.
  It is also available at this URL:
  <http://www.opensource.org/licenses/OSL-3.0>

 UPGRADE NOTE:
   Do not edit or add to this file if you wish to upgrade AbanteCart to newer
   versions in the future. If you wish to customize AbanteCart for your
   needs please refer to http://www.AbanteCart.com for more information.
------------------------------------------------------------------------------*/
if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ADownload - class to manage downloads
 *
 * @property ADB $db
 * @property ALanguageManager $language
 * @property ACustomer $customer
 * @property AConfig $config
 * @property ALog $log
 * @property ALoader $load
 * @property ExtensionsAPI $extensions
 * @property ARequest $request
 */
class ALicenseGeneratorDownload extends ADownload
{

    public $errors = [];

    /**
     * @var registry - access to application registry
     */
    protected $registry;

    public function __construct() {
        $this->registry = Registry::getInstance();
        $this->errors = [];
    }

    public function getDownloadInfo($download_id) {
        if (!(int) $download_id) {
            return [];
        }
        if (IS_ADMIN === true) {
            $language_id = $this->language->getContentLanguageID();
        } else {
            $language_id = $this->language->getLanguageID();
        }

        $result = $this->db->query(
            "SELECT dd.*, d.*
                                    FROM ".$this->db->table('downloads')." d
                                    LEFT JOIN ".$this->db->table('download_descriptions')." dd
                                        ON (d.download_id = dd.download_id AND dd.language_id = '".$language_id."')
                                    WHERE d.download_id='".(int) $download_id."'"
        );
        return $result->row;
    }

    /**
     * Method returns order download info selected by order_download_id
     *
     * @param int $order_download_id
     * @param int|string $language_id (optional)
     *
     * @return array
     * @throws AException
     */
    public function getOrderDownloadInfo($order_download_id, $language_id = '') {
        if (!(int) $order_download_id) {
            return [];
        }
        if (!$language_id) {
            if (IS_ADMIN === true) {
                $language_id = $this->language->getContentLanguageID();
            } else {
                $language_id = $this->language->getLanguageID();
            }
        }

        $result = $this->db->query(
            "SELECT dd.*, d.*, od.*
                                    FROM ".$this->db->table('order_downloads')." od
                                    LEFT JOIN ".$this->db->table('downloads')." d 
                                        ON od.download_id = d.download_id
                                    LEFT JOIN ".$this->db->table('download_descriptions')." dd 
                                        ON d.download_id = dd.download_id AND dd.language_id = '".$language_id."'
                                    WHERE od.order_download_id='".(int) $order_download_id."'"
        );
        return $result->row;
    }

    /**
     * @param int $start
     * @param int $limit
     *
     * @return array
     * @throws AException
     */
    public function getCustomerDownloads($start = 0, $limit = 0) {
        $customer_id = (int) $this->customer->getId();
        if (!$customer_id) {
            return [];
        }
        $start = $start < 0 ? 0 : (int) $start;

        $sql = "SELECT o.order_id,
                      o.order_status_id,
                      od.order_product_id,
                      od.download_id,
                      od.status,
                      od.date_added,
                      od.order_download_id,
                      d.activate,
                      od.activate_order_status_id,
                      od.name,
                      od.filename,
                      od.mask,
                      od.remaining_count,
                      od.expire_date,
                      op.product_id
               FROM ".$this->db->table("order_downloads")." od
               LEFT JOIN ".$this->db->table("orders")." o ON (od.order_id = o.order_id)
               LEFT JOIN ".$this->db->table("downloads")." d ON (d.download_id = od.download_id)
               LEFT JOIN ".$this->db->table("order_products")." op ON (op.order_product_id = od.order_product_id)
               LEFT JOIN ".$this->db->table("license_generator_info")." lgi ON lgi.order_id = od.order_id AND lgi.order_product_id = od.order_product_id
               WHERE o.customer_id = '".$customer_id."' AND od.name LIKE CONCAT('%', lgi.extension_version, '%')
               ORDER BY o.order_id DESC,od.name ASC ";
        if ($limit) {
            $sql .= "LIMIT ".(int) $start.",".(int) $limit;
        }
        $query = $this->db->query($sql);

        $downloads = [];
        foreach ($query->rows as $download_info) {
            $downloads[$download_info['order_download_id']] = $download_info;
        }
        return $downloads;
    }

    /**
     * @param int $order_id
     * @param int $customer_id
     *
     * @return array
     * @throws AException
     */
    public function getCustomerOrderDownloads($order_id, $customer_id) {
        $customer_id = (int) $customer_id;
        $order_id = (int) $order_id;
        if (!$order_id) {
            return [];
        }
        $sql = "SELECT o.order_id,
                      o.order_status_id,
                      od.download_id,
                      od.order_product_id,
                      od.status,
                      od.date_added,
                      od.order_download_id,
                      d.activate,
                      od.activate_order_status_id,
                      od.name,
                      od.filename,
                      od.mask,
                      od.remaining_count,
                      od.expire_date,
                      op.product_id
               FROM ".$this->db->table("order_downloads")." od
               INNER JOIN ".$this->db->table("orders")." o ON (od.order_id = o.order_id)
               LEFT JOIN ".$this->db->table("downloads")." d ON (d.download_id = od.download_id)
               LEFT JOIN ".$this->db->table("order_products")." op ON (op.order_product_id = od.order_product_id)
               LEFT JOIN ".$this->db->table("license_generator_info")." lgi ON lgi.order_id = od.order_id AND lgi.order_product_id = od.order_product_id
               WHERE o.order_id = '".$order_id."' AND od.name LIKE CONCAT('%', lgi.extension_version, '%')
               ".($customer_id ? " AND o.customer_id = '".$customer_id."'" : "")."
               ORDER BY  o.order_id DESC,od.sort_order DESC,od.name ASC ";

        $query = $this->db->query($sql);
        $downloads = [];
        foreach ($query->rows as $download_info) {
            $downloads[$download_info['order_download_id']] = $download_info;
        }
        return $downloads;
    }

    public function getEntireOrderDownloads($order_id, $customer_id) {
        $customer_id = (int) $customer_id;
        $order_id = (int) $order_id;
        if (!$order_id) {
            return [];
        }
        $sql = "SELECT o.order_id,
                      o.order_status_id,
                      od.download_id,
                      od.status,
                      od.date_added,
                      od.order_download_id,
                      d.activate,
                      od.activate_order_status_id,
                      od.name,
                      od.filename,
                      od.mask,
                      od.remaining_count,
                      od.expire_date,
                      op.product_id
               FROM ".$this->db->table("order_downloads")." od
               INNER JOIN ".$this->db->table("orders")." o ON (od.order_id = o.order_id)
               LEFT JOIN ".$this->db->table("downloads")." d ON (d.download_id = od.download_id)
               LEFT JOIN ".$this->db->table("order_products")." op ON (op.order_product_id = od.order_product_id)
               WHERE o.order_id = '".$order_id."'
               ".($customer_id ? " AND o.customer_id = '".$customer_id."'" : "")."
               ORDER BY  o.date_added DESC, od.name ASC ";

        $query = $this->db->query($sql);
        $downloads = [];
        foreach ($query->rows as $download_info) {
            $downloads[$download_info['order_download_id']] = $download_info;
        }
        return $downloads;
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getTotalDownloads() {
        return sizeof($this->getCustomerDownloads());
    }

    /**
     * @param int $order_id
     * @param int $customer_id
     *
     * @return mixed
     * @throws AException
     */
    public function getTotalOrderDownloads($order_id, $customer_id) {
        return sizeof($this->getCustomerOrderDownloads($order_id, $customer_id));
    }

    /**
     * @param int $order_id
     *
     * @return int
     * @throws AException
     */
    public function OrderHasDownloads($order_id) {
        $customer = (int) $this->customer->getId();
        return $this->getTotalOrderDownloads($order_id, $customer);
    }

    /**
     * @param string $resource_path
     *
     * @return bool
     * @throws AException
     */
    public function isFileAvailable($resource_path = '') {
        if (!$resource_path) {
            return false;
        }
        if (is_numeric($resource_path)) {
            $rl = new AResource('download');
            $resource = $rl->getResource($resource_path);
            if ($resource && $resource['resource_path']) {
                $resource_path = $rl->getTypeDir().$resource['resource_path'];
            }
        }

        if (!is_file(DIR_RESOURCE.$resource_path) || !is_readable(DIR_RESOURCE.$resource_path)) {
            return false;
        }

        if (!filesize(DIR_RESOURCE.$resource_path)) {
            return false;
        }

        return true;
    }

    public function getTextStatusForOrderDownload($download_info) {
        $this->load->language('account/download');
        $text_status = '';

        if ($download_info['status'] == 0) {
            $text_status = $this->language->get('text_pending');
        } elseif (dateISO2Int($download_info['expire_date']) < time()) {
            $text_status = $this->language->get('text_expired');
        } elseif ($download_info['remaining_count'] == '0') {
            $text_status = $this->language->get('text_reached_limit');
        }

        if ((int) $download_info['activate_order_status_id'] > 0) {
            if ((int) $download_info['activate_order_status_id'] != (int) $download_info['order_status_id']) {
                $text_status = $this->language->get('text_pending');
            }
        }

        //2. check is file exists
        $download_info['filename'] = trim($download_info['filename']);
        if (!$this->isFileAvailable($download_info['filename'])) {
            $err = new AError(
                'Error: file "'.$download_info['filename'].'" (download_id = '.$download_info['order_id'].') of order #'
                .$download_info['order_id'].' is unavailable for download!'
            );
            $err->toLog()->toDebug();
            $text_status = $this->language->get('text_unavailable');
        }

        return $text_status;
    }
}
