<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

if(!class_exists('ExtensionEmailEditor')){
    include_once('core/email_editor_hook.php');
}

$controllers = [
    'storefront' => [
        'pages/extension/email_logo',
        'pages/extension/order_products'
    ],
    'admin' => [
        'pages/extension/email_logo',
        'pages/extension/preview_email_logo',
        'pages/extension/preview_order_confirm',
        'pages/extension/email_templates',
        'pages/extension/email_signatures',
	    'responses/listing_grid/customer_transactions',
        'responses/listing_grid/email_templates_list',
        'responses/listing_grid/email_signatures_list',
	    'responses/extension/email_editor',
	    'responses/extension/contact',
	    'responses/extension/tracking',
	    'task/extension/contact'
    ]
];

$models = [
    'storefront' => [
        'extension/email_editor',
        'extension/tracking'],
    'admin' => [
        'extension/email_order',
        'extension/email_templates',
        'extension/email_signatures',
	    'extension/contact',
	    'extension/tracking'],
];

$languages = [
    'storefront' => [
        'email_editor/email_editor'],
    'admin' => [
        'email_editor/email_editor',
    ]
];

$templates = [
    'storefront' => [
        'pages/extension/email_logo.tpl',
        'pages/extension/order_confirm.tpl',
	    'pages/extension/tracking_invoice.tpl'
    ],
    'admin' => [
       'pages/extension/email_logo.tpl',
       'pages/extension/contact.tpl',
       'pages/extension/preview_email_logo.tpl',
       'pages/extension/preview_order_confirm.tpl',
       'pages/extension/email_templates.tpl',
       'pages/extension/email_templates_form.tpl',
       'pages/extension/email_signatures.tpl',
       'pages/extension/email_signatures_form.tpl',
	   'pages/extension/tracking.tpl',
	   'responses/extension/contact_incomplete.tpl'
    ]
];