<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

$sql='CREATE TABLE IF NOT EXISTS ' . $this->db->table('email_editor_templates') . ' (
`email_template_id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
`section` VARCHAR(256) NOT NULL,
`sender_name` VARCHAR(32) NOT NULL,
`sender_email` VARCHAR(32) NOT NULL,
`subject` BLOB NOT NULL,
`default_subject` BLOB NOT NULL,
`content` BLOB NOT NULL,
`default_content` BLOB NOT NULL,
`email_signature_id` INT(11),
`notify_admin` INT(1) DEFAULT 0
)ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci';

$this->db->query($sql);

$sql1='CREATE TABLE IF NOT EXISTS ' . $this->db->table('email_editor_signatures') . ' (
`email_signature_id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
`title` VARCHAR(256) NOT NULL,
`content` BLOB NOT NULL
)ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci';

$this->db->query($sql1);

$account_create_subject='{store_name} - Thank you for registering';
$account_create_content='Welcome and thank you for registering at {store_name}! Two accounts have been created for you:<br><br>';
$account_create_content.='1. Your store account. You can access it by visiting our website or at the following URL: <br><br> {login_url} <br><br>';
$account_create_content.='<br>Upon logging in to your store, you will be able to buy or rent extension(s),  access other account  services including reviewing past orders, downloading the extensions that you bought or rented via account > downloads page, manage rental account,  and editing your account information.<br><br>';
$account_create_content.='2. WHY2 Support Account: You can access it at the following URL: <br><br> {support_login_url} <br><br>';
$account_create_content.="WHY2 Support Username. {support_system_username}<br>WHY2 Support Password:  (Use the WHY2 support system password you signed up with)<br><br>";
$account_create_content.='<br>Upon logging in to support system, you will be able to create support ticket for help or questions about your extension(s) or account.  Also renew rent fee or annual fee for your extension(s) support and updates service for purchased extension(s).<br><br>';
$account_create_content.="All support requests need to be submitted using your  WHY2 support account.<br><br>";
$account_create_content.='Thank you,';

$this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') ."  
SET `email_template_id`=1, `section` = 'account_create', 
`sender_name`='',`sender_email`='',`subject`='".$this->db->escape($account_create_subject)."', 
`default_subject`='".$this->db->escape($account_create_subject)."',
`content` = '" . $this->db->escape($account_create_content) . "', 
`default_content` = '" . $this->db->escape($account_create_content) . "',`email_signature_id` = 0,
`notify_admin`=0
ON DUPLICATE KEY UPDATE  
`section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");


$account_create_existing_support_subject='{store_name} - Thank you for registering';
$account_create_existing_support_content='Welcome and thank you for registering at {store_name}! One account have been created for you:<br><br>';
$account_create_existing_support_content.='Your store account. You can access it by visiting our website or at the following URL: <br><br> {login_url} <br><br>';
$account_create_existing_support_content.='<br>Upon logging in to your store, you will be able to buy or rent extension(s),  access other account  services including reviewing past orders, downloading the extensions that you bought or rented via account > downloads page, manage rental account,  and editing your account information.<br><br>';
$account_create_existing_support_content.='You can access WHY2 Support Account at the following URL: <br><br> {support_login_url} <br><br>';
$account_create_existing_support_content.="WHY2 Support Username. {support_system_username}<br>WHY2 Support Password:  (Use the WHY2 support system password you signed up with)<br><br>";
$account_create_existing_support_content.='<br>Upon logging in to support system, you will be able to create support ticket for help or questions about your extension(s) or account.  Also renew rent fee or annual fee for your extension(s) support and updates service for purchased extension(s).<br><br>';
$account_create_existing_support_content.="All support requests need to be submitted using your  WHY2 support account.<br><br>";
$account_create_existing_support_content.='Thank you,';

$this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') ."  
SET `email_template_id`=2, `section` = 'account_create_existing_support', 
`sender_name`='',`sender_email`='',`subject`='".$this->db->escape($account_create_existing_support_subject)."', 
`default_subject`='".$this->db->escape($account_create_existing_support_subject)."',
`content` = '" . $this->db->escape($account_create_existing_support_content) . "', 
`default_content` = '" . $this->db->escape($account_create_existing_support_content) . "',`email_signature_id` = 0,
`notify_admin`=0
ON DUPLICATE KEY UPDATE  
`section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");


$account_activated_subject='{store_name} - Your Account has been activated!';
$account_activated_content='Welcome and thank you for registering at {store_name}!<br><br>';
$account_activated_content.='Your account has now been created and you can access it by visiting our website or at the following URL: <br><br> {login_url} <br><br>';
$account_activated_content.='<br>Upon logging in, you will be able to access other services including reviewing past orders, printing invoices and editing your account information.<br><br>';
$account_activated_content.='Thank you,';
$this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') ."  
SET `email_template_id`=3, `section` = 'account_activated', 
`sender_name`='',`sender_email`='',`subject`='".$this->db->escape($account_activated_subject)."', 
`default_subject`='".$this->db->escape($account_activated_subject)."',
`content` = '" . $this->db->escape($account_activated_content) . "', 
`default_content` = '" . $this->db->escape($account_activated_content) . "',`email_signature_id` = 0,
`notify_admin`=0
ON DUPLICATE KEY UPDATE  
`section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

$account_approval_subject='{store_name} - Thank you for registering';
$account_approval_content='Welcome and thank you for registering at {store_name}!<br><br>';
$account_approval_content.='Your account must be approved before you can login. Once approved you can log in by using your email address and password by visiting our website or at the following URL: <br><br> {login_url} <br><br>';
$account_approval_content.='Thank you,';
$this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') ."  
SET `email_template_id`=4, `section` = 'account_approval', 
`sender_name`='',`sender_email`='',`subject`='".$this->db->escape($account_approval_subject)."', 
`default_subject`='".$this->db->escape($account_approval_subject)."',
`content` = '" . $this->db->escape($account_approval_content) . "', 
`default_content` = '" . $this->db->escape($account_approval_content) . "',`email_signature_id` = 0,
`notify_admin`=0
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

$account_activation_subject='{store_name} - Thank you for registering';
$account_activation_content='Welcome and thank you for registering at {store_name}!<br><br>';
$account_activation_content.='Before we can activate your account one last step must be taken to complete your registration.<br><br>
    You must complete this last step to become a registered member. Please click the following link to activate your account <br><br> {activate_url} <br><br>';
$account_activation_content.='Thank you,<br>{store_name}';
$this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') ."  SET 
`email_template_id`=5,
`sender_name`='',`sender_email`='',`section` = 'account_activation', 
`subject`='".$this->db->escape($account_activation_subject)."', 
`default_subject`='".$this->db->escape($account_activation_subject)."' , 
`content` = '" . $this->db->escape($account_activation_content) . "', 
`default_content` = '" . $this->db->escape($account_activation_content) . "',`email_signature_id` = 0,
`notify_admin`=0
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

$account_reset_password_subject='{store_name} - Password reset';
$account_reset_password_content='A password reset was requested from {store_name}.<br><br>';
$account_reset_password_content.='To reset your password click link below:<br><br>{reset_password}';
$this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') ."  SET 
`email_template_id`=6,`section` = 'account_reset_password', 
`sender_name`='',`sender_email`='',`subject`='".$this->db->escape($account_reset_password_subject)."', 
`default_subject`='".$this->db->escape($account_reset_password_subject)."' ,
`content` = '" . $this->db->escape($account_reset_password_content) . "', 
`default_content` = '" . $this->db->escape($account_reset_password_content) . "',`email_signature_id` = 0,
`notify_admin`=0
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

$account_reset_password_success_subject='{store_name} - Password reset';
$account_reset_password_success_content='Your password was successfully reset on {store_name}.';
$this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') ."  SET 
`email_template_id`=7,`section` = 'account_reset_password_success', 
`sender_name`='',`sender_email`='',`subject`='".$this->db->escape($account_reset_password_success_subject)."', 
`default_subject`='".$this->db->escape($account_reset_password_success_subject)."' , 
`content` = '" . $this->db->escape($account_reset_password_success_content) . "', 
`default_content` = '" . $this->db->escape($account_reset_password_success_content) . "',`email_signature_id` = 0,
`notify_admin`=0
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

$account_loginname_reminder_subject='{store_name} - Login name reminder';
$account_loginname_reminder_content='Login name reminder was requested from {store_name}.<br><br>';
$account_loginname_reminder_content.='Your login name is: <br><br>{loginname}';
$this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') ."  SET 
`email_template_id`=8,`section` = 'account_loginname_reminder', 
`sender_name`='',`sender_email`='',`subject`='".$this->db->escape($account_loginname_reminder_subject)."',
 `default_subject`='".$this->db->escape($account_loginname_reminder_subject)."' , 
 `content` = '" . $this->db->escape($account_loginname_reminder_content) . "',
 `default_content` = '" . $this->db->escape($account_loginname_reminder_content) . "',`email_signature_id` = 0,
`notify_admin`=0
 ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

$order_status_update_subject='{store_name} - Order Update {order_id}';
$order_status_update_content='Order ID: {order_id}<br>';
$order_status_update_content.='Date Ordered: {order_date} <br><br>';
$order_status_update_content.='Your order has been updated to the following status:<br><br>';
$order_status_update_content.='{order_status}<br><br>';
$order_status_update_content.='To view your order click on the link below:<br><br>{invoice_url}<br><br>';
if (file_exists(DIR_EXT.'delivery_scheduler') && $this->config->get('delivery_scheduler_status')==='1') {
    $order_status_update_content .= '[The comments or special delivery instruction for your order are:]<br><br>{order_comment}<br><br>';
} else {
    $order_status_update_content .= '[The comments for your order are:]<br><br>{order_comment}<br><br>';
}
$order_status_update_content.='Please reply to this email if you have any questions.';
$this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') ."  SET 
`email_template_id`=9,`section` = 'order_status_update', 
`sender_name`='',`sender_email`='',`subject`='".$this->db->escape($order_status_update_subject)."', 
`default_subject`='".$this->db->escape($order_status_update_subject)."' , 
`content` = '" . $this->db->escape($order_status_update_content) . "', 
`default_content` = '" . $this->db->escape($order_status_update_content) . "',`email_signature_id` = 0,
`notify_admin`=0
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

$order_confirmation_subject='{store_name} - Order {order_id}';
$order_confirmation_content='Thank you for your interest in {store_name} products.<br><br>Your order has been received and will be processed after payment is confirmed.<br><br>';

if (file_exists(DIR_EXT.'delivery_scheduler') && $this->config->get('delivery_scheduler_status')==='1') {
    $order_confirmation_content.='{order_details}<br><br>[The comments or special delivery instructions for your order are:]<br><br>{order_comment}<br><br>[To view your order click on the link below:]<br><br>{invoice_url}<br><br>Please reply to this email if you have any questions.';
} else {
    $order_confirmation_content.='{order_details}<br><br>[The comments for your order are:]<br><br>{order_comment}<br><br>[To view your order click on the link below:]<br><br>{invoice_url}<br><br>Please reply to this email if you have any questions.';
}

$this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') ."  SET 
`email_template_id`=10,`section` = 'order_confirmation', 
`sender_name`='',`sender_email`='',`subject`='".$this->db->escape($order_confirmation_subject)."', 
`default_subject`='".$this->db->escape($order_confirmation_subject)."' , 
`content` = '" . $this->db->escape($order_confirmation_content) . "', 
`default_content` = '" . $this->db->escape($order_confirmation_content) . "',`email_signature_id` = 0,
`notify_admin`=0
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

$customer_transaction_subject='New transaction has been posted to your {store_name} account';
$customer_transaction_content='New transaction has been posted to your {store_name} account in the amount of {amount}. For more details, login to {store_name} account<br><br>';
$customer_transaction_content.='{transaction_url}<br><br>{comment}';
$this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') ."  SET 
`email_template_id`=11,`section` = 'customer_transaction', 
`sender_name`='',`sender_email`='',`subject`='".$this->db->escape($customer_transaction_subject)."', 
`default_subject`='".$this->db->escape($customer_transaction_subject)."' , 
`content` = '" . $this->db->escape($customer_transaction_content) . "', 
`default_content` = '" . $this->db->escape($customer_transaction_content) . "',`email_signature_id` = 0,
`notify_admin`=0
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

$shipper_info_content='Your order has been shipped via: {shipper_name}.<br>The tracking number is: {tracking_number}.<br> You can track it via {tracking_url}.';

$this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') ."  SET 
`email_template_id`=12,`section` = 'shipping_info', 
`sender_name`='',`sender_email`='',`subject`='', 
`default_subject`='' , 
`content` = '" . $this->db->escape($shipper_info_content) . "', 
`default_content` = '" . $this->db->escape($shipper_info_content) . "',`email_signature_id` = 0,
`notify_admin`=0
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

$local_delivery_info_content='Your order will be delivered on {delivery_date} via {shipper_name}.<br>';

$this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') ."  SET 
`email_template_id`=13,`section` = 'local_shipping_info', 
`sender_name`='',`sender_email`='',`subject`='', 
`default_subject`='' , 
`content` = '" . $this->db->escape($local_delivery_info_content) . "', 
`default_content` = '" . $this->db->escape($local_delivery_info_content) . "',`email_signature_id` = 0,
`notify_admin`=0
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

$this->db->query("Create table if not exists ".$this->db->table('email_editor_tmp')." ( `id` int(2) , `title` VARCHAR(100) )ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;");

$store_pickup_info_content='Your package will be available for pickup at {available_date}.<br>';

$this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') ."  SET 
`email_template_id`=14,`section` = 'store_pickup_info', 
`sender_name`='',`sender_email`='',`subject`='', 
`default_subject`='' , 
`content` = '" . $this->db->escape($store_pickup_info_content) . "', 
`default_content` = '" . $this->db->escape($store_pickup_info_content) . "',`email_signature_id` = 0,
`notify_admin`=0
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");

$account_approved_subject='Welcome, {store_name} ';
$account_approved_content='Welcome and thank you for registering at {store_name}<br><br>';
$account_approved_content.='Your account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:<br/>
            <a href="{login_url}">{login_url}</a><br/><br/>
            Once you logging in, you will be able to access, your wishlist, order history, printing invoices and editing your account information.';
$account_approved_content.='Thank you.<br/>{store_name}';
$this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') ."  SET 
`email_template_id`=15,
`sender_name`='',`sender_email`='',`section` = 'account_approved', 
`subject`='".$this->db->escape($account_approved_subject)."', 
`default_subject`='".$this->db->escape($account_approved_subject)."' , 
`content` = '" . $this->db->escape($account_approved_content) . "', 
`default_content` = '" . $this->db->escape($account_approved_content) . "',`email_signature_id` = 0,
`notify_admin`=0
ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");


$this->db->query("Create table if not exists ".$this->db->table('email_editor_tmp')." ( `id` int(2) , `title` VARCHAR(100) )ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;");

$fast_checkout_exist = $this->db->query("SELECT COUNT(*) as total FROM ".$this->db->table('email_editor_templates')." WHERE `section`='fast_checkout_account_create'");
if ($fast_checkout_exist->row['total']==='0') {

    $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_fast_checkout_account_create_info','Important Notes: <br>
        1.&nbsp;This template has several defined tags such as {store_name}, {login_url}, {login}, {password}. You should not remove or edit them as they are used by this extension  and are necessary for the system generated input.<br>
        2.&nbsp;Preview Email Template won\'t replace the defined tags into system generated input, it will only let you preview how the logo, content and email signatures looks like within the email.',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

    $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_fast_checkout_account_create_subject','Fast Checkout Account Create Email Subject:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

    $this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','email_editor_email_editor','text_fast_checkout_account_create_content','Fast Checkout Account Create Email Content:',now(),now())
        ON DUPLICATE KEY UPDATE language_value = language_value");

    $fast_checkout_account_create_subject = 'Welcome, {store_name} ';
    $fast_checkout_account_create_content = 'Welcome and thank you for registering at {store_name}<br><br>';
    $fast_checkout_account_create_content .= 'Your account has now been created and you can log in by using your email address and password by visiting our website or at the following URL:<br/>
            <a href="{login_url}">{login_url}</a><br/><br/>';
    $fast_checkout_account_create_content .= "Your Login Name: {login} <br/>
                               Your Password: {password} <br/><br/>";
    $fast_checkout_account_create_content .= 'Thank you.<br/>{store_name}';
    $this->db->query('INSERT INTO ' . $this->db->table('email_editor_templates') . "  SET 
                    `sender_name`='',`sender_email`='',`section` = 'fast_checkout_account_create', 
                    `subject`='" . $this->db->escape($fast_checkout_account_create_subject) . "', 
                    `default_subject`='" . $this->db->escape($fast_checkout_account_create_subject) . "' , 
                    `content` = '" . $this->db->escape($fast_checkout_account_create_content) . "', 
                    `default_content` = '" . $this->db->escape($fast_checkout_account_create_content) . "',`email_signature_id` = 0,
                    `notify_admin`=0
                    ON DUPLICATE KEY UPDATE `section`=VALUES(`section`),`default_subject`=VALUES(`default_subject`),`default_content`=VALUES(`default_content`)");
}

$rm = new AResourceManager();
$rm->setType('image');

$language_id = $this->language->getLanguageID();
$data = [];
$data['resource_code'] = '<i class="fa fa-envelope"></i>&nbsp;';
$data['name'] = [$language_id => 'Menu Icon Email Editor'];
$data['title'] = [$language_id => ''];
$data['description'] = [$language_id => ''];
$resource_id = $rm->addResource($data);

$menu = new AMenu ( "admin" );
$menu->insertMenuItem ( array (  "item_id" => "email_editor",
        "parent_id" => "",
        "item_text" => "Email Editor",
        "item_url" => "",
        "item_type"=>"core",
        "sort_order"=>"10",
        "item_icon_rl_id" => $resource_id
    )
);

$menu->insertMenuItem ( array (  "item_id" => "email_editor_templates",
        "parent_id"=>"email_editor",
        "item_text" => "Email Editor Templates",
        "item_url" => "extension/email_templates",
        "item_type"=>"core",
        "sort_order"=>"10",
        "item_icon_rl_id" => $resource_id
    )
);

$menu->insertMenuItem ( array (  "item_id" => "email_editor_signatures",
        "parent_id" =>"email_editor",
        "item_text" => "Email Editor Signature",
        "item_url" => "extension/email_signatures",
        "item_type" =>"core",
        "sort_order" =>"11",
        "item_icon_rl_id" => $resource_id
    )
);

$menu->deleteMenuItem("shipper_tracking_url");

$this->db->query("DELETE FROM ".$this->db->table('order_data_types'). " WHERE `name`='tracking'");

$this->db->query("INSERT INTO ".$this->db->table('order_data_types'). " (`language_id`, `name`) VALUES ('1', 'tracking')");

$this->db->query("DROP TABLE IF EXISTS ".$this->db->table('shipper_tracking_url'));

$sql4='CREATE TABLE IF NOT EXISTS ' . $this->db->table('shipper_tracking_url') . ' (
`shipper_tracking_url_id` INT(11) NOT NULL AUTO_INCREMENT PRIMARY KEY,
`shipper_name` VARCHAR(256) NOT NULL,
`tracking_url` VARCHAR(256) NOT NULL
)ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci';

$this->db->query($sql4);

$this->db->query("INSERT INTO " . $this->db->table('shipper_tracking_url') . " (`shipper_name`,`tracking_url`) VALUES 
('Australia Post','https://auspost.com.au/mypost/track/#/details/{tracking_number}'),
('Canada Post','https://www.canadapost.ca/trackweb/en#/details/{tracking_number}'),
('FedEx','https://www.fedex.com/apps/fedextrack/?action=track&trackingnumber={tracking_number}'),
('Purolator','https://www.purolator.com/en/shipping/tracker?pins={tracking_number}'),
('Parcel Force','https://www.parcelforce.com/track-trace?trackNumber={tracking_number}'),
('Royal Mail','http://www.royalmail.com/portal/rm/track?trackNumber={tracking_number}'),
('UPS','https://wwwapps.ups.com/tracking/tracking.cgi?tracknum={tracking_number}'),
('USPS','https://tools.usps.com/go/TrackConfirmAction?tLabels={tracking_number}'),
('Store Pickup',''),
('Local Delivery','')");