<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerResponsesListingGridCustomerTransactions
 * @property ModelExtensionEmailOrder $model_extension_email_order
 */
class ControllerResponsesListingGridCustomerTransactions extends AController {
    public $data=[];
    public $error=[];

    public function addTransaction() {
        if (!$this->csrftoken->isTokenValid()) {
            $error = new AError('');
            return $error->toJSONResponse(
                'NO_PERMISSIONS_402',
                ['error_text' => 'Unknown error']
            );
        }
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        if (!$this->user->canModify('listing_grid/customer_transaction') || $this->request->is_GET()) {
            $error = new AError('');
            return $error->toJSONResponse(
                'NO_PERMISSIONS_402',
                [
                    'error_text'  => sprintf(
                        $this->language->get('error_permission_modify'),
                        'listing_grid/customer_transaction'
                    ),
                    'reset_value' => true,
                ]
            );
        }

        $this->loadLanguage('sale/customer');
        $this->loadModel('sale/customer_transaction');
        $this->loadModel('extension/email_order');
        //check is data valid
        $post = $this->request->post;

        if ($post['credit']) {
            $post['credit'] = preformatFloat($post['credit']);
        }
        if ($post['debit']) {
            $post['debit'] = preformatFloat($post['debit']);
        }

        $valid_data = $this->validateForm($post);
        $valid_data['customer_id'] = $this->request->get['customer_id'];

        if (!$this->error) {
            $this->model_extension_email_order->addCustomerTransaction($valid_data);
            $result['result'] = true;
            $result['result_text'] = $this->language->get('text_transaction_success');
            $balance = $this->model_sale_customer_transaction->getBalance($this->request->get['customer_id']);
            $result['balance'] = $this->language->get('text_balance').' '.$this->currency->format($balance,
                    $this->config->get('config_currency'));
        } else {
	        $error = new AError( '' );

	        return $error->toJSONResponse( 'VALIDATION_ERROR_406',
		        [
			        'error_text'   => $this->error,
			        'csrfinstance' => $this->csrftoken->setInstance(),
			        'csrftoken'    => $this->csrftoken->setToken(),
			        'reset_value'  => true,
		        ] );
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($result));
    }

    private function validateForm($data = []) {
        $output = [
            'credit' => (float)$data['credit'],
            'debit'  => (float)$data['debit'],
        ];

        if (!$output['credit'] && !$output['debit']) {
            $this->error[] = $this->language->get('error_empty_debit_credit');
        } else {
            if ($output['credit'] > 99999999999.9999 || $output['debit'] > 99999999999.9999) {
                $this->error[] = $this->language->get('error_incorrect_debit_credit');
            }
        }

        if ($data['transaction_type'][1]) {
            $output['transaction_type'] = trim($data['transaction_type'][1]);
            $this->cache->remove('transaction_types');
        } else {
            $output['transaction_type'] = trim($data['transaction_type'][0]);
        }

        if (!$output['transaction_type']) {
            $this->error[] = $this->language->get('error_transaction_type');
        }
        $output['transaction_type'] = htmlentities($output['transaction_type'], ENT_QUOTES, 'UTF-8');
        $output['comment'] = htmlentities($data['comment'], ENT_QUOTES, 'UTF-8');
        $output['description'] = htmlentities($data['description'], ENT_QUOTES, 'UTF-8');
        $output['notify'] = (int)$data['notify'] ? 1 : 0;
        $this->data['output'] = $output;
        $this->extensions->hk_ValidateData($this);

        return $this->data['output'];
    }
}