<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ControllerPagesExtensionEmailLogo extends AController {
    public $data=[];

    public function main() {
        $languageId = $this->language->getContentLanguageID() ?? $this->language->getLanguageID();
        $this->data['store_url']=$this->config->get('config_url');
        $this->data['store_name']=$this->config->get('store_name');

        $mailLogo = $this->config->get('config_mail_logo_'.$languageId)
            ? : $this->config->get('config_mail_logo');
        $mailLogo = $mailLogo ? : $this->config->get('config_logo_'.$languageId);
        $mailLogo = $mailLogo ? : $this->config->get('config_logo');

        if ($mailLogo) {
            $result = getMailLogoDetails($mailLogo);
            if ($result['uri']) {
                if (is_file(DIR_RESOURCE.$mailLogo)) {
                    if (HTTPS) {
                        $img=HTTPS_SERVER."resources/$mailLogo";
                    } else {
                        $img=HTTP_SERVER."resources/$mailLogo";
                    }
                    $this->data['logo_uri'] = $img;
                }
            } elseif($result['html']){
                $this->data['logo_html'] = $result['html'];
            }
        }

        $this->view->batchAssign($this->data);
        $this->processTemplate('pages/extension/email_logo.tpl');
    }
}