<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\Understand;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class ServiceOptions
{
    /**
     * @param string  $friendlyName The friendly_name
     * @param boolean $logQueries   The log_queries
     * @param integer $ttl          The ttl
     * @param string  $uniqueName   The unique_name
     *
     * @return CreateServiceOptions Options builder
     */
    public static function create($friendlyName = Values::NONE, $logQueries = Values::NONE, $ttl = Values::NONE, $uniqueName = Values::NONE)
    {
        return new CreateServiceOptions($friendlyName, $logQueries, $ttl, $uniqueName);
    }

    /**
     * @param string  $friendlyName The friendly_name
     * @param boolean $logQueries   The log_queries
     * @param integer $ttl          The ttl
     * @param string  $uniqueName   The unique_name
     *
     * @return UpdateServiceOptions Options builder
     */
    public static function update($friendlyName = Values::NONE, $logQueries = Values::NONE, $ttl = Values::NONE, $uniqueName = Values::NONE)
    {
        return new UpdateServiceOptions($friendlyName, $logQueries, $ttl, $uniqueName);
    }
}

class CreateServiceOptions extends Options
{
    /**
     * @param string  $friendlyName The friendly_name
     * @param boolean $logQueries   The log_queries
     * @param integer $ttl          The ttl
     * @param string  $uniqueName   The unique_name
     */
    public function __construct($friendlyName = Values::NONE, $logQueries = Values::NONE, $ttl = Values::NONE, $uniqueName = Values::NONE)
    {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['logQueries'] = $logQueries;
        $this->options['ttl'] = $ttl;
        $this->options['uniqueName'] = $uniqueName;
    }

    /**
     * The friendly_name
     *
     * @param string $friendlyName The friendly_name
     *
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName)
    {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The log_queries
     *
     * @param boolean $logQueries The log_queries
     *
     * @return $this Fluent Builder
     */
    public function setLogQueries($logQueries)
    {
        $this->options['logQueries'] = $logQueries;
        return $this;
    }

    /**
     * The ttl
     *
     * @param integer $ttl The ttl
     *
     * @return $this Fluent Builder
     */
    public function setTtl($ttl)
    {
        $this->options['ttl'] = $ttl;
        return $this;
    }

    /**
     * The unique_name
     *
     * @param string $uniqueName The unique_name
     *
     * @return $this Fluent Builder
     */
    public function setUniqueName($uniqueName)
    {
        $this->options['uniqueName'] = $uniqueName;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString()
    {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Preview.Understand.CreateServiceOptions '.implode(' ', $options).']';
    }
}

class UpdateServiceOptions extends Options
{
    /**
     * @param string  $friendlyName The friendly_name
     * @param boolean $logQueries   The log_queries
     * @param integer $ttl          The ttl
     * @param string  $uniqueName   The unique_name
     */
    public function __construct($friendlyName = Values::NONE, $logQueries = Values::NONE, $ttl = Values::NONE, $uniqueName = Values::NONE)
    {
        $this->options['friendlyName'] = $friendlyName;
        $this->options['logQueries'] = $logQueries;
        $this->options['ttl'] = $ttl;
        $this->options['uniqueName'] = $uniqueName;
    }

    /**
     * The friendly_name
     *
     * @param string $friendlyName The friendly_name
     *
     * @return $this Fluent Builder
     */
    public function setFriendlyName($friendlyName)
    {
        $this->options['friendlyName'] = $friendlyName;
        return $this;
    }

    /**
     * The log_queries
     *
     * @param boolean $logQueries The log_queries
     *
     * @return $this Fluent Builder
     */
    public function setLogQueries($logQueries)
    {
        $this->options['logQueries'] = $logQueries;
        return $this;
    }

    /**
     * The ttl
     *
     * @param integer $ttl The ttl
     *
     * @return $this Fluent Builder
     */
    public function setTtl($ttl)
    {
        $this->options['ttl'] = $ttl;
        return $this;
    }

    /**
     * The unique_name
     *
     * @param string $uniqueName The unique_name
     *
     * @return $this Fluent Builder
     */
    public function setUniqueName($uniqueName)
    {
        $this->options['uniqueName'] = $uniqueName;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString()
    {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Preview.Understand.UpdateServiceOptions '.implode(' ', $options).']';
    }
}