<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

$mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
$diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
$shared_secret = "addthis";

$public_key = "";
$path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

if ($this->config->get('addthis_license_code')) {
    $license_key = $this->config->get('addthis_license_code');
    $license = new License($path_to_phpseclib);
    $license_manager = $license->getManager();
    if (stripos($license_key, 'mc-') !== false) {
        $server_url = $mc_server_url;
    } else {
        $server_url = $diy_server_url;
    }
    $license_manager->setLicenseServerUrl($server_url);
    $license_manager->setKeys($license_key, "", $shared_secret);
    $public_key = $license_manager->requestKey();
    $this->load->model('extension/addthis_license_info');

    $store_id = (int)$this->config->get('config_store_id');

    $license_manager->setKeys($license_key, $public_key, $shared_secret);
    $custom_data = ['version' => '1.3.3'];
    $license_data = $license_manager->requestData($custom_data);
    if (!is_null($license_data)) {
        $ttl = 1209600;
        $validate = $license_manager->validate($license_data, $ttl);

        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
            $data['public_key'] = $public_key;
            $data['license_data'] = $license_data;
            $data['license_key'] = $license_key;
            $data['store_id'] = $store_id;
            $data['last_check'] = time();
            $this->load->model('extension/addthis_license_info');
            $this->model_extension_addthis_license_info->saveLicenseData($data);
        }
    }
}

$sql = "UPDATE ".$this->db->table('language_definitions')." set language_value='
This is a WHY2 extension.  All support and updates are managed from WHY2. <br>
        Read about WHY2\'s 12 months support <a href=\"https://why2central.net/knowledgebase/why2-support-and-updates-policy/\" target=\"_blank\" style=\"font-weight:bold;\">here</a> and how WHY2 updates are delivered <a href=\"https://why2central.net/knowledgebase/extension-updater/\" target=\"_blank\" style=\"font-weight:bold;\">here</a>.<br>
        You can safely ignore Support expired notification within the Admin Dashboard.<br><br>
Easy to implement social tools that help increase your social media followers.  Easily added to every product page.<br><br>
<strong>Notes: There are two ways to obtain the license key. <br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;a. Use this <a href=\"https://wehearyou2.com/clientarea/reg/register.php\" target=\"_blank\" style=\"font-weight:bold;\">form</a> to register to our Support system and generate your license key.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;b. Already registered -  click <a href=\"https://wehearyou2.com/clientarea/reg/index.php\" target=\"_blank\" style=\"font-weight:bold;\">here</a> to log into your account to obtain license key.<br>
        Refer to our <a href=\"https://why2central.net/faq/license-key/\" target=\"_BLANK\">F.A.Q</a> for more information on how to obtain the license key.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;c. If you already have an account in our support system and you are using multiple extensions from WHY2,  you do NOT need to create another account in the support system.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;d. Updating extension in same location does NOT require a new key.<br> Refer to our <a href=\"https://why2central.net/faq/license-key/\" target=\"_BLANK\">F.A.Q</a> for more information on how to Update extension in same location.</strong><br><br>
1.&nbsp;Enter your WHY2 license key here.<br>
        <strong>Notes for number 2 and 3, please refer to our manual <a href=\"http://why2central.net/v1/addthis/#176\" target=\"_BLANK\">here</a> for how to get the codes.</strong><br>
         2.&nbsp;Look for instructions that tell you to \"Paste the above code right above the closing</body> of the HTML.\", copy and paste it here.<br>
3.&nbsp;Look for instructions that tell you to \"Copy and paste the code below to the places on your page where you want the tools to appear.\", copy and paste it here.<br>
' WHERE language_key='addthis_note';";
$this->db->query($sql);

$sql1 = "UPDATE ".$this->db->table('language_definitions')." set language_value='Enter your WHY2 license key:' WHERE language_key='addthis_license_code';";
$this->db->query($sql1);

$sql2 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("addthis_updater_notification") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql2);

$sql3 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("addthis_license_info") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `public_key` TEXT NOT NULL,
  `license_data` TEXT NOT NULL,
  `license_key` TEXT NOT NULL,
  `store_id` int(11) NOT NULL,
  `last_check` int(11),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql3);
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='addthis_addthis' AND `language_key`='addthis_headJSCode'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='addthis_addthis' AND `language_key`='addthis_divTag'");

$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='addthis_addthis' AND `language_key`='text_new_addthis_version_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='addthis_addthis' AND `language_key`='text_new_addthis_version_description'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='addthis_addthis' AND `language_key`='text_update_success'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='addthis_addthis' AND `language_key`='text_update_failed'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='addthis_addthis' AND `language_key`='button_start_update'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='addthis_addthis' AND `language_key`='button_cancel_update'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='addthis_addthis' AND `language_key`='text_update_addthis_note'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='addthis_addthis' AND `language_key`='text_addthis_updater_heading_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='addthis_addthis' AND `language_key`='text_changelog'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='addthis_addthis' AND `language_key`='text_no_updates'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='addthis_addthis' AND `language_key`='button_go_back'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='addthis_addthis' AND `language_key`='text_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='addthis_addthis' AND `language_key`='button_diy_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='addthis_addthis' AND `language_key`='button_mc_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='addthis_addthis' AND `language_key`='text_update_addthis_available'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='addthis_addthis' AND `language_key`='addthis_license_expired'");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','addthis_addthis','addthis_headJSCode','Paste the javascript tags here:<br><span class=\"help\">Please refer to the quick notes number 2.</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','addthis_addthis','addthis_divTag','Paste the generated HTML div tags here:<br><span class=\"help\">Please refer to the quick notes number 3.</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','addthis_addthis','text_new_addthis_version_title','New version (v[new_version]) of AddThis Integration Extension',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','addthis_addthis','text_new_addthis_version_description','There is a new version of AddThis Extension. Please open -->#admin#rt=extension/addthis_updater&version=[version_number] to update the extension. <br><br>
                        The update will replace existing files with the update files.<br><br>Make sure that you have made a backup of your store prior to updating. Use your normal backup method or Softaculous to make a backup prior to updating your site. Need help on how to backup an installation by using Softaculous click <a href=\"https://why2central.net/knowledgebase/how-to-backup-an-installation/\" target=\"_BLANK\"><b>here</b></a>.<br><br>
                        Do not delete this message until you have updated.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','addthis_addthis','text_update_success','The AddThis extension has been successfully updated.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','addthis_addthis','text_update_failed','We are unable to update the AddThis extension, please check <a target=\"_BLANK\" href=\"#admin#rt=tool/error_log\">error log</a> for more information.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','addthis_addthis','button_start_update','Start Update',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','addthis_addthis','button_cancel_update','Cancel Update',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','addthis_addthis','text_update_addthis_note','Note:<br>We are going to update AddThis extension. The update will replace existing files with the update files.<br><br>Make sure that you have made a backup of your store prior to updating. Use your normal backup method or Softaculous to make a backup prior to updating your site. Need help on how to backup an installation by using Softaculous click <a href=\"https://why2central.net/knowledgebase/how-to-backup-an-installation/\" target=\"_BLANK\"><b>here</b></a>.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','addthis_addthis','text_addthis_updater_heading_title','AddThis Updater',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','addthis_addthis','text_changelog','Changelog:',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','addthis_addthis','text_no_updates','There are no new updates for this extension.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','addthis_addthis','button_go_back','Go Back',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','addthis_addthis','text_support_by_why2','Support and updates from WHY2.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','addthis_addthis','button_diy_support_by_why2','If you are self-managed users click here for support. Support and updates from WHY2.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','addthis_addthis','button_mc_support_by_why2','If you are a WHY2 Managed Client click here for support. Updates are part of the Managed Services.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','addthis_addthis','text_update_addthis_available','New version (%s) is available. <a href=\"%s\" target=\"_BLANK\"><strong>Click to update now.</strong></a>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','addthis_addthis','addthis_license_expired','Your license key is expired. Possibly due to inactive with the extension for more than 14 days. Please click on the SAVE button at the bottom of this page.',now(),now())");

$this->db->query("UPDATE ".$this->db->table("language_definitions")." SET `language_value`='Cancel' WHERE `language_key`='button_cancel' AND `block`='addthis_addthis'");

$exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('addthis_license') . "'");
if ($exist->num_rows === 1) {
    $this->db->query("DROP TABLE ".$this->db->table("addthis_license"));
}

if (file_exists(DIR_EXT.'addthis/admin/view/default/template/pages/extension/extensions_edit.tpl')) {
    unlink(DIR_EXT.'addthis/admin/view/default/template/pages/extension/extensions_edit.tpl');
}

if (!file_exists(DIR_SYSTEM.'lib/license.php')) {
    /**
     *  Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return array
     */
    function custom_copy($src, $dst) {
        $error = [];
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function
                    // for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                        $error['error_copy'][] = "Failed to copy $file";
                    }
                }
            }
        }
        if (sizeof($error)>0) {
            $log=new ALog(DIR_SYSTEM.'logs/error.txt');
            $log->write(var_export($error,true));
        }
        closedir($dir);
        return $error;
    }

    $copy = custom_copy(DIR_EXT . 'addthis' . DIR_EXT_CORE . 'lib', DIR_SYSTEM.'lib');
}