<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\TwiML\Voice;

use Twilio\TwiML\TwiML;

class Conference extends TwiML
{
    /**
     * Conference constructor.
     *
     * @param string $name       Conference name
     * @param array  $attributes Optional attributes
     */
    public function __construct($name, $attributes = array())
    {
        parent::__construct('Conference', $name, $attributes);
    }

    /**
     * Add Muted attribute.
     *
     * @param boolean $muted Join the conference muted
     *
     * @return TwiML $this.
     */
    public function setMuted($muted)
    {
        return $this->setAttribute('muted', $muted);
    }

    /**
     * Add Beep attribute.
     *
     * @param conference :Enum:Beep $beep Play beep when joining
     *
     * @return TwiML $this.
     */
    public function setBeep($beep)
    {
        return $this->setAttribute('beep', $beep);
    }

    /**
     * Add StartConferenceOnEnter attribute.
     *
     * @param boolean $startConferenceOnEnter Start the conference on enter
     *
     * @return TwiML $this.
     */
    public function setStartConferenceOnEnter($startConferenceOnEnter)
    {
        return $this->setAttribute('startConferenceOnEnter', $startConferenceOnEnter);
    }

    /**
     * Add EndConferenceOnExit attribute.
     *
     * @param boolean $endConferenceOnExit End the conferenceon exit
     *
     * @return TwiML $this.
     */
    public function setEndConferenceOnExit($endConferenceOnExit)
    {
        return $this->setAttribute('endConferenceOnExit', $endConferenceOnExit);
    }

    /**
     * Add WaitUrl attribute.
     *
     * @param url $waitUrl Wait URL
     *
     * @return TwiML $this.
     */
    public function setWaitUrl($waitUrl)
    {
        return $this->setAttribute('waitUrl', $waitUrl);
    }

    /**
     * Add WaitMethod attribute.
     *
     * @param httpMethod $waitMethod Wait URL method
     *
     * @return TwiML $this.
     */
    public function setWaitMethod($waitMethod)
    {
        return $this->setAttribute('waitMethod', $waitMethod);
    }

    /**
     * Add MaxParticipants attribute.
     *
     * @param integer $maxParticipants Maximum number of participants
     *
     * @return TwiML $this.
     */
    public function setMaxParticipants($maxParticipants)
    {
        return $this->setAttribute('maxParticipants', $maxParticipants);
    }

    /**
     * Add Record attribute.
     *
     * @param conference :Enum:Record $record Record the conference
     *
     * @return TwiML $this.
     */
    public function setRecord($record)
    {
        return $this->setAttribute('record', $record);
    }

    /**
     * Add Region attribute.
     *
     * @param conference :Enum:Region $region Conference region
     *
     * @return TwiML $this.
     */
    public function setRegion($region)
    {
        return $this->setAttribute('region', $region);
    }

    /**
     * Add Whisper attribute.
     *
     * @param sid $whisper Call whisper
     *
     * @return TwiML $this.
     */
    public function setWhisper($whisper)
    {
        return $this->setAttribute('whisper', $whisper);
    }

    /**
     * Add Trim attribute.
     *
     * @param conference :Enum:Trim $trim Trim the conference recording
     *
     * @return TwiML $this.
     */
    public function setTrim($trim)
    {
        return $this->setAttribute('trim', $trim);
    }

    /**
     * Add StatusCallbackEvent attribute.
     *
     * @param conference                                 :Enum:Event $statusCallbackEvent Events to call status
     *                                                   callback URL
     *
     * @return TwiML $this.
     */
    public function setStatusCallbackEvent($statusCallbackEvent)
    {
        return $this->setAttribute('statusCallbackEvent', $statusCallbackEvent);
    }

    /**
     * Add StatusCallback attribute.
     *
     * @param url $statusCallback Status callback URL
     *
     * @return TwiML $this.
     */
    public function setStatusCallback($statusCallback)
    {
        return $this->setAttribute('statusCallback', $statusCallback);
    }

    /**
     * Add StatusCallbackMethod attribute.
     *
     * @param httpMethod $statusCallbackMethod Status callback URL method
     *
     * @return TwiML $this.
     */
    public function setStatusCallbackMethod($statusCallbackMethod)
    {
        return $this->setAttribute('statusCallbackMethod', $statusCallbackMethod);
    }

    /**
     * Add RecordingStatusCallback attribute.
     *
     * @param url $recordingStatusCallback Recording status callback URL
     *
     * @return TwiML $this.
     */
    public function setRecordingStatusCallback($recordingStatusCallback)
    {
        return $this->setAttribute('recordingStatusCallback', $recordingStatusCallback);
    }

    /**
     * Add RecordingStatusCallbackMethod attribute.
     *
     * @param httpMethod $recordingStatusCallbackMethod Recording status callback
     *                                                  URL method
     *
     * @return TwiML $this.
     */
    public function setRecordingStatusCallbackMethod($recordingStatusCallbackMethod)
    {
        return $this->setAttribute('recordingStatusCallbackMethod', $recordingStatusCallbackMethod);
    }

    /**
     * Add RecordingStatusCallbackEvent attribute.
     *
     * @param conference :Enum:RecordingEvent $recordingStatusCallbackEvent Recording status callback events
     *
     * @return TwiML $this.
     */
    public function setRecordingStatusCallbackEvent($recordingStatusCallbackEvent)
    {
        return $this->setAttribute('recordingStatusCallbackEvent', $recordingStatusCallbackEvent);
    }

    /**
     * Add EventCallbackUrl attribute.
     *
     * @param url $eventCallbackUrl Event callback URL
     *
     * @return TwiML $this.
     */
    public function setEventCallbackUrl($eventCallbackUrl)
    {
        return $this->setAttribute('eventCallbackUrl', $eventCallbackUrl);
    }
}