<?php

/** @noinspection PhpMultipleClassDeclarationsInspection */
if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelProductFeaturesProductFeatures extends Model
{
    /**
     * @param array $filter
     *
     * @return array
     * @throws AException
     */
    public function getProductFeatures($filter = [])
    {
        $sql = "SELECT pf.*, pfd.name, pfvd.product_feature_value_id, pfvd.name as value_name
                FROM ".$this->db->table('product_features')." pf
                LEFT JOIN ".$this->db->table('products')." p 
                    ON p.product_id = pf.product_id
                LEFT JOIN ".$this->db->table('product_feature_descriptions')." pfd
                    ON (pf.product_feature_id = pfd.product_feature_id 
                        AND pfd.language_id = '".(int) $this->config->get('storefront_language_id')."')
                LEFT JOIN ".$this->db->table('product_feature_values')." pfv 
                    ON pf.product_feature_id = pfv.product_feature_id
                LEFT JOIN ".$this->db->table('product_feature_value_descriptions')." pfvd
                    ON (pfv.product_feature_value_id = pfvd.product_feature_value_id 
                        AND pfvd.language_id = '".(int) $this->config->get('storefront_language_id')."')";

        if ($filter['category_id']) {
            if (strpos($filter['category_id'], '_') !== false) {
                $category_ids = explode('_', $filter['category_id']);
            } else {
                if (strpos($filter['category_id'], ',') !== false) {
                    $category_ids = explode(',', $filter['category_id']);
                } else {
                    $category_ids = (array) $filter['category_id'];
                }
            }
            if (sizeof($category_ids) > 1) {
                unset($category_ids[0]);
            }

            foreach ($category_ids as &$id) {
                $id = (int) $id;
            }
            unset($id);

            $sql .= " RIGHT JOIN ".$this->db->table('products_to_categories')." ptc 
            ON (ptc.product_id = pf.product_id 
                AND ptc.category_id IN ( ".implode(',', $category_ids).")) ";
        }

        if ((int) $filter['manufacturer_id']) {
            $sql .= " RIGHT JOIN ".$this->db->table('products')." p2 
                        ON (p2.product_id = pf.product_id 
                            AND p2.manufacturer_id = '".(int) $filter['manufacturer_id']."') ";
        }

        if ($filter['keyword']) {
            $sql .= " LEFT JOIN ".$this->db->table("product_descriptions")." pd
                        ON (pf.product_id = pd.product_id 
                                AND pd.language_id = '".(int) $this->config->get('storefront_language_id')."')
                    LEFT JOIN ".$this->db->table("product_tags")." pt 
                        ON (pf.product_id = pt.product_id)";
        }

        if (!$filter['category_id'] && !$filter['manufacturer_id'] && !$filter['keyword'] && !$filter['description']) {
            $sql .= " LEFT JOIN ".$this->db->table("global_attributes")." ga
                            ON (ga.attribute_id = pf.global_attribute_id)";
        }

        $sql .= " WHERE pf.status = 1 
                    AND p.date_available <= NOW() 
                    AND p.status = 1 ";

        if ($filter['keyword']) {
            $keyword = $filter['keyword'];
            $tags = explode(' ', trim($keyword));
            $tags_str = [];
            if (sizeof($tags) > 1) {
                $tags_str[] = " LCASE(pt.tag) = '".$this->db->escape(trim($keyword))."' ";
            }
            foreach ($tags as $tag) {
                $tags_str[] = " LCASE(pt.tag) = '".$this->db->escape(mb_strtolower($tag))."' ";
            }

            if (!$filter['description']) {
                $sql .= " AND (LCASE(pd.name) LIKE '%".$this->db->escape(mb_strtolower($keyword))."%' OR ".implode(
                        ' OR ', $tags_str
                    );
            } else {
                $sql .= " AND (LCASE(pd.description) LIKE '%".$this->db->escape(mb_strtolower($keyword))."%'  
                                OR LCASE(pd.name) LIKE '%".$this->db->escape(mb_strtolower($keyword))."%' 
                                OR ".implode(' OR ', $tags_str)." 
                                OR LCASE(pd.description) LIKE '%".$this->db->escape(mb_strtolower($keyword))."%'";
            }

            $sql .= ")";
        }

        if (!$filter['category_id'] && !$filter['manufacturer_id'] && !$filter['keyword'] && !$filter['description']) {
            $sql .= " ORDER BY ga.sort_order";
        } else {
            $sql .= " ORDER BY pf.sort_order, pfv.sort_order ";
        }

        $product_features = $this->db->query($sql);
        if ($product_features->num_rows) {
            $output = [];
            foreach ($product_features->rows as $row) {
                if (!isset($output[$row['global_attribute_id']])) {
                    $row['values'][$row['product_feature_value_id']] = $row['value_name'];
                    unset($row['value_name'], $row['product_feature_value_id']);
                    $output[$row['global_attribute_id']] = $row;
                } else {
                    if (!in_array($row['value_name'], $output[$row['global_attribute_id']]['values'])) {
                        $output[$row['global_attribute_id']]['values'][$row['product_feature_value_id']] =
                            $row['value_name'];
                    }
                }
            }
            return $output;
        }

        return [];
    }

    /**
     * @param int $product_id
     * @param int $feature_id
     *
     * @return array
     * @throws AException
     */
    public function getProductFeature($product_id, $feature_id = 0)
    {
        $row = [];

        $product_feature = $this->db->query(
            "SELECT * 
            FROM ".$this->db->table('product_features')."
            WHERE product_id = '".(int) $product_id."'
                AND product_feature_id = '".(int) $feature_id."'
                AND status = 1
            ORDER BY sort_order"
        );

        $product_feature_description = $this->db->query(
            "SELECT *
            FROM ".$this->db->table('product_feature_descriptions')."
            WHERE product_feature_id = '".(int) $feature_id."'"
        );
        $product_feature_description_data = [];
        foreach ($product_feature_description->rows as $result) {
            $product_feature_description_data[$result['language_id']] = ['name' => $result['name']];
        }

        if ($product_feature->num_rows) {
            $row = $product_feature->row;
            $row['language'] = $product_feature_description_data;
        }

        return $row;
    }

    /**
     * @param int $product_id
     * @param int $feature_id
     *
     * @return array
     * @throws AException
     */
    public function getProductFeatureValues($product_id, $feature_id)
    {
        $result = [];

        $product_feature_values = $this->db->query(
            "SELECT *
                FROM ".$this->db->table('product_feature_values')."
                WHERE
                    product_id = '".(int) $product_id."'
                    AND product_feature_id = '".(int) $feature_id."'
                ORDER BY sort_order"
        );

        foreach ($product_feature_values->rows as $feature_value) {
            $value_description_data = [];
            $value_description = $this->db->query(
                "SELECT * 
                    FROM ".$this->db->table('product_feature_value_descriptions')."
                    WHERE product_feature_value_id = '".(int) $feature_value['product_feature_value_id']."'"
            );

            foreach ($value_description->rows as $description) {
                $value_description_data[$description['language_id']] = $description['name'];
            }

            $result[] = [
                'product_feature_value_id' => $feature_value['product_feature_value_id'],
                'language'                 => $value_description_data,
                'sort_order'               => $feature_value['sort_order'],
            ];
        }
        return $result;
    }

    /**
     * @param int $product_feature_value_id
     * @param int $language_id
     *
     * @return array
     * @throws AException
     */
    public function getFeatureValue($product_feature_value_id, $language_id = 0)
    {
        $product_feature_value_id = (int) $product_feature_value_id;
        if (!$product_feature_value_id) {
            return [];
        }
        $language_id = (int) $language_id;
        if (!$language_id) {
            $language_id = (int) $this->config->get('storefront_language_id');
        }

        $result = $this->db->query(
            "SELECT pfvd.*, pfv.*
            FROM ".$this->db->table('product_feature_value_descriptions')." pfvd
            LEFT JOIN ".$this->db->table('product_feature_values')." pfv
                ON pfv.product_feature_value_id = pfvd.product_feature_value_id
            WHERE pfvd.product_feature_value_id = '".(int) $product_feature_value_id."'
                AND pfvd.language_id = '".(int) $language_id."'"
        );
        return $result->row;
    }

    public function getProductFeatureValueDescriptions($product_id, $product_feature_value_id, $language_id)
    {
        if (empty($product_id) || empty($product_feature_value_id) || empty($language_id)) {
            return false;
        }
        return $this->db->query(
            "SELECT *
            FROM ".$this->db->table('product_feature_value_descriptions')."
            WHERE
                product_feature_value_id = '".(int) $product_feature_value_id."'
                AND product_id = '".(int) $product_id."'
                AND language_id = '".(int) $language_id."'"
        );
    }

    public function getProductFeaturesOfProduct($product_id)
    {
        $product_feature_data = [];
        $limit = $this->config->get('product_features_list_amount') ? : 10;
        $product_features = $this->db->query(
            "SELECT *
            FROM ".$this->db->table('product_features')."
            WHERE product_id ='".(int) $product_id."'
                AND status = 1
            GROUP BY global_attribute_id
            ORDER BY sort_order
            LIMIT ".(int) $limit
        );

        foreach ($product_features->rows as $product_feature) {
            $product_feature_value_data = [];

            $product_feature_value = $this->db->query(
                "SELECT *
                FROM ".$this->db->table('product_feature_values')."
                WHERE product_feature_id = '".(int) $product_feature['product_feature_id']."'
                ORDER BY sort_order"
            );

            foreach ($product_feature_value->rows as $product_feature_value) {
                $product_feature_value_description_data = [];

                $product_feature_value_description = $this->db->query(
                    "SELECT *
                    FROM ".$this->db->table('product_feature_value_descriptions')."
                    WHERE product_feature_value_id = '".(int) $product_feature_value['product_feature_value_id']."'"
                );

                foreach ($product_feature_value_description->rows as $result) {
                    $product_feature_value_description_data[$result['language_id']] = ['name' => $result['name']];
                }

                $product_feature_value_data[] = [
                    'product_feature_value_id' => $product_feature_value['product_feature_value_id'],
                    'language'                 => $product_feature_value_description_data,
                    'sort_order'               => $product_feature_value['sort_order'],
                ];
            }

            $product_feature_description_data = [];

            $product_feature_description = $this->db->query(
                "SELECT *
                    FROM ".$this->db->table('product_feature_descriptions')."
                    WHERE product_feature_id = '".(int) $product_feature['product_feature_id']."'"
            );

            foreach ($product_feature_description->rows as $result) {
                $product_feature_description_data[$result['language_id']] = ['name' => $result['name']];
            }

            $product_feature_data[] = [
                'product_feature_id'    => $product_feature['product_feature_id'],
                'global_attribute_id'   => $product_feature['global_attribute_id'],
                'language'              => $product_feature_description_data,
                'product_feature_value' => $product_feature_value_data,
                'sort_order'            => $product_feature['sort_order'],
                'status'                => $product_feature['status'],
            ];
        }

        return $product_feature_data;
    }

    /**
     * @param string $keyword
     * @param int $feature_id
     * @param int $feature_value_id
     * @param int $category_id
     *
     * @return array|int
     * @throws AException
     */
    public function getTotalProducts($keyword, $feature_id, $feature_value_id = 0, $category_id = 0)
    {
        return $this->getProducts(
            [
                'keyword'          => $keyword,
                'feature_id'       => $feature_id,
                'feature_value_id' => $feature_value_id,
                'category_id'      => $category_id,
            ],
            'total_only'
        );
    }

    /**
     * @param array $filter_data
     * @param string $mode
     *
     * @return array|int
     * @throws AException
     */
    public function getProducts($filter_data = [], $mode = '')
    {
        $filter_data['feature_id'] = (int) $filter_data['feature_id'];
        $filter_data['feature_value_id'] = (int) $filter_data['feature_value_id'];
        $filter_data['category_id'] = (int) $filter_data['category_id'];

        $filter_data['sort'] = $filter_data['sort'] ?? 'p.sort_order';
        $filter_data['order'] = $filter_data['order'] ?? 'ASC';
        $filter_data['start'] = $filter_data['start'] ?? 0;
        $filter_data['limit'] = $filter_data['limit'] ? : 20;

        if (!$mode) {
            $sql = "SELECT  *, p.product_id, pd.name AS name, m.name AS manufacturer, ss.name AS stock,
                        (SELECT AVG(r.rating)
                        FROM ".$this->db->table('reviews')." r
                        WHERE p.product_id = r.product_id
                        GROUP BY r.product_id) AS rating ";
        } else {
            $sql = "SELECT COUNT(*) as total ";
        }

        $sql .= $this->_sql_join_string()."\n";
        if ( $filter_data['feature_value_id']) {
            $sql .= " RIGHT JOIN ".$this->db->table('product_feature_values')." pfv
                        ON (pfv.product_feature_id = pf.product_feature_id
                            AND 
                            pfv.product_feature_value_id IN
                            (SELECT product_feature_value_id
                            FROM ".$this->db->table('product_feature_value_descriptions')."
                            WHERE language_id = '".(int) $this->config->get('storefront_language_id')."'
                            AND name = (SELECT name
                                        FROM ".$this->db->table('product_feature_value_descriptions')."
                                        WHERE product_feature_value_id = '". $filter_data['feature_value_id']."'
                                            AND language_id = '".(int) $this->config->get('storefront_language_id')."'
                                        LIMIT 1)
                            ))";
        }

        $sql .= " LEFT JOIN ".$this->db->table('product_tags')." pt 
                        ON (p.product_id = pt.product_id)
                   WHERE p2s.store_id = '".(int) $this->config->get('config_store_id')."'";
        // if value id given - do not limit result by feature_value_id.. and otherwise
        if (!(int) $filter_data['feature_value_id']) {
            $sql .= " AND pf.global_attribute_id = '".(int) $filter_data['feature_id']."'";
        }

        if ($filter_data['keyword']) {
            $tags = explode(' ', trim($filter_data['keyword']));
            $tags_str = [];
            if (sizeof($tags) > 1) {
                $tags_str[] = " LCASE(pt.tag) = '".$this->db->escape(trim($filter_data['keyword']))."' ";
            }
            foreach ($tags as $tag) {
                $tags_str[] = " LCASE(pt.tag) = '".$this->db->escape(mb_strtolower($tag))."' ";
            }
            $sql .= " AND (LCASE(pd.name) LIKE '%".$this->db->escape(mb_strtolower($filter_data['keyword']))."%' 
                            OR ".implode(' OR ', $tags_str).') ';
        }

        if ($filter_data['category_id']) {
            $this->load->model('catalog/category');

            $category_ids = explode('_', $filter_data['category_id']);

            foreach ($category_ids as $category_id) {
                $data[] = "'".(int) $category_id."'";
            }

            $sql .= " AND p.product_id IN (SELECT product_id
                                            FROM ".$this->db->table('products_to_categories')."
                                            WHERE category_id IN (".implode(", ", $data)."))";
        }

        $sql .= " AND pf.status = 1 
                    AND p.status = '1' 
                    AND p.date_available <= NOW()
                 GROUP BY p.product_id";

        if (!$mode) {
            $sort_data = [
                'pd.name',
                'p.price',
                'p.sort_order',
                'special',
                'rating',
            ];

            if (in_array($filter_data['sort'], $sort_data)) {
                if ($filter_data['sort'] == 'pd.name') {
                    $sql .= " ORDER BY LCASE(".$filter_data['sort'].")";
                } else {
                    $sql .= " ORDER BY ".$filter_data['sort'];
                }
            } else {
                $sql .= " ORDER BY p.sort_order";
            }

            if ($filter_data['order'] == 'DESC') {
                $sql .= " DESC";
            } else {
                $sql .= " ASC";
            }

            if ($filter_data['start'] < 0) {
                $filter_data['start'] = 0;
            }

            $sql .= " LIMIT ".(int) $filter_data['start'];

            if (!is_null($filter_data['limit'])) {
                $sql .= ",".(int) $filter_data['limit'];
            }
        }

        $query = $this->db->query($sql);
        if ($mode) {
            return (int) $query->row['total'];
        }
        $products = [];
        if ($query->num_rows) {
            foreach ($query->rows as $value) {
                $products[$value['product_id']] = $value;
            }
        }
        return $products;
    }

    /**
     * @param $category_id
     *
     * @return string
     * @throws AException
     */
    public function getPath($category_id)
    {
        $string = $category_id.',';

        $results = $this->model_catalog_category->getCategories($category_id);

        foreach ($results as $result) {
            $string .= $this->getPath($result['category_id']);
        }

        return $string;
    }

    private function _sql_join_string()
    {
        return " FROM ".$this->db->table('products')." p
                INNER JOIN ".$this->db->table('product_features')." pf 
                    ON p.product_id = pf.product_id
                LEFT JOIN ".$this->db->table('product_feature_descriptions')." pfd 
                    ON (pf.product_feature_id = pfd.product_feature_id 
                        AND pfd.language_id = '".(int) $this->config->get('storefront_language_id')."')
                LEFT JOIN ".$this->db->table('product_descriptions')." pd 
                    ON (p.product_id = pd.product_id 
                        AND pd.language_id = '".(int) $this->config->get('storefront_language_id')."')
                LEFT JOIN ".$this->db->table('products_to_stores')." p2s 
                    ON (p.product_id = p2s.product_id)
                LEFT JOIN ".$this->db->table('manufacturers')." m 
                    ON (p.manufacturer_id = m.manufacturer_id)
                LEFT JOIN ".$this->db->table('stock_statuses')." ss 
                    ON (p.stock_status_id = ss.stock_status_id 
                        AND ss.language_id = '".(int) $this->config->get('storefront_language_id')."')";
    }

    /**
     * @param int $attribute_id
     * @param int $language_id
     *
     * @return array
     * @throws AException
     */
    public function getAttribute($attribute_id, $language_id = 0)
    {
        if (!$language_id) {
            $language_id = $this->config->get('storefront_language_id');
        }

        $query = $this->db->query(
            "SELECT ga.*, gad.name, gad.error_text
            FROM ".$this->db->table('global_attributes')." ga
            LEFT JOIN ".$this->db->table('global_attributes_descriptions')." gad
                ON ( ga.attribute_id = gad.attribute_id 
                    AND gad.language_id = '".(int) $language_id."' )
            WHERE ga.attribute_id = '".$this->db->escape($attribute_id)."'"
        );

        return $query->row;
    }

    /**
     * @param string $keyword
     * @param int $category_id
     * @param bool $description
     * @param bool $model
     *
     * @return array
     * @throws AException
     */
    public function getProductFeaturesOfSearch($keyword, $category_id = 0, $description = false, $model = false)
    {
        if (!$keyword) {
            return [];
        }
        $sql = "SELECT pf.product_feature_id, pf.global_attribute_id, pf.sort_order, pfd.name "
            .$this->_sql_join_string()."
                LEFT JOIN ".$this->db->table('product_tags')." pt 
                    ON (p.product_id = pt.product_id)
                WHERE p2s.store_id = '".(int) $this->config->get('config_store_id')."' ";

        $tags = explode(' ', trim($keyword));
        $tags_str = [];
        if (sizeof($tags) > 1) {
            $tags_str[] = " LCASE(pt.tag) = '".$this->db->escape(trim($keyword))."' ";
        }
        foreach ($tags as $tag) {
            $tags_str[] = " LCASE(pt.tag) = '".$this->db->escape(mb_strtolower($tag))."' ";
        }

        if (!$description) {
            $sql .= " AND (LCASE(pd.name) LIKE '%".$this->db->escape(mb_strtolower($keyword))."%' 
                            OR ".implode(' OR ', $tags_str);
        } else {
            $sql .= " AND (LCASE(pd.name) LIKE '%".$this->db->escape(mb_strtolower($keyword))."%'
                            OR ".implode(' OR ', $tags_str)."
                            OR LCASE(pd.description) LIKE '%".$this->db->escape(mb_strtolower($keyword))."%'";
        }

        if (!$model) {
            $sql .= ")";
        } else {
            $sql .= " OR LCASE(p.model) LIKE '%".$this->db->escape(mb_strtolower($keyword))."%')";
        }

        if ($category_id) {
            $data = [];
            $this->load->model('catalog/category');
            $category_ids = explode('_', $category_id);
            foreach ($category_ids as $category_id) {
                $data[] = "'".(int) $category_id."'";
            }

            $sql .= " AND p.product_id IN (SELECT product_id
                                            FROM ".$this->db->table('products_to_categories')."
                                            WHERE category_id IN (".implode(", ", $data)."))";
        }

        $sql .= " AND p.status = '1' AND p.date_available <= NOW()";
        $sql .= " GROUP BY pf.global_attribute_id";
        $sql .= " ORDER BY pf.sort_order";

        $filter_data['limit'] = $this->config->get('product_features_list_amount') ? : 10;
        $sql .= " LIMIT ".(int) $filter_data['limit'];

        $query = $this->db->query($sql);
        return $query->rows;
    }

}