<?php
/**
 * ------------------------------------------------------------------------------
  $Id$

  For AbanteCart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2011 - 2021 AlgoZone, Inc

------------------------------------------------------------------------------

 * @var $this AController
 */

if (! defined ( 'DIR_CORE' )) {
	header ( 'Location: static_pages/' );
}

$block_info['block_txt_id'] = 'product_features';
$block_info['controller'] = 'blocks/product_features/product_features';

$block_info['templates'] = [
    [
        'parent_block_txt_id' =>'column_left',
        'template'            =>'blocks/product_features_block.tpl'
    ],
    [
        'parent_block_txt_id' =>'column_right',
        'template'            =>'blocks/product_features_block.tpl'
    ]
];

$block_info['descriptions'] = [
    [
        'language_name' => 'english',
        'name'          => 'Product Features'
    ],
    [
        'language_name' => 'espanol',
        'name'          => 'Características del Producto'
    ]
];

$layout = new ALayoutManager();
$layout->saveBlock($block_info);

$this->db->query(
    "INSERT INTO ".$this->db->table('global_attributes_types')." 
        (type_key, controller, sort_order, status)
    VALUES ('product_feature', 'responses/product_features/features/getProductFeatureSubform', 3, 1)"
);
$attribute_type_id = $this->db->getLastId();
$this->language->replaceDescriptions(
    'global_attributes_type_descriptions',
     [
         'attribute_type_id' => (int)$attribute_type_id
     ],
     [
         (int)$this->language->getDefaultLanguageID() => [
            'type_name' => 'Product Feature'
         ]
     ]
);

$this->cache->remove('*');