<?php

/** @noinspection PhpMultipleClassDeclarationsInspection */
if (!defined('DIR_CORE') || !IS_ADMIN) {
    header('Location: static_pages/');
}

class ModelProductFeaturesProductFeatures extends Model
{

    public function getProductFeatures($product_id)
    {
        $product_feature_data = [];
        $product_features = $this->db->query(
            "SELECT pf.*, pfd.name
            FROM ".$this->db->table('product_features')." pf
            LEFT JOIN ".$this->db->table('product_feature_descriptions')." pfd
                ON pfd.product_feature_id = pf.product_feature_id 
                    AND pfd.language_id = '".(int) $this->language->getContentLanguageID()."'
            WHERE pf.product_id = '".(int) $product_id."'
            ORDER BY pf.sort_order"
        );

        foreach ($product_features->rows as $product_feature) {
            $product_feature_value_data = [];
            $product_feature_value = $this->db->query(
                "SELECT *
                FROM ".$this->db->table('product_feature_values')."
                WHERE product_feature_id = '".(int) $product_feature['product_feature_id']."'
                ORDER BY sort_order"
            );

            foreach ($product_feature_value->rows as $product_feature_value) {
                $product_feature_value_description_data = [];
                $product_feature_value_description = $this->db->query(
                    "SELECT *
                    FROM ".$this->db->table('product_feature_value_descriptions')."
                    WHERE product_feature_value_id = '".(int) $product_feature_value['product_feature_value_id']."'"
                );

                foreach ($product_feature_value_description->rows as $result) {
                    $product_feature_value_description_data[$result['language_id']] = [
                        'name' => $result['name']
                    ];
                }

                $product_feature_value_data[] = [
                    'product_feature_value_id' => $product_feature_value['product_feature_value_id'],
                    'language'                 => $product_feature_value_description_data,
                    'sort_order'               => $product_feature_value['sort_order'],
                ];
            }

            $product_feature_data[] = [
                'product_feature_id'    => $product_feature['product_feature_id'],
                'global_attribute_id'   => $product_feature['global_attribute_id'],
                'name'                  => $product_feature['name'],
                'product_feature_value' => $product_feature_value_data,
                'sort_order'            => $product_feature['sort_order'],
                'status'                => $product_feature['status'],
            ];
        }

        return $product_feature_data;
    }

    public function getProductFeature($product_id, $feature_id = 0)
    {
        $product_feature = $this->db->query(
            "SELECT pf.*, pfd.name
            FROM ".$this->db->table('product_features')." pf
            LEFT JOIN ".$this->db->table('product_feature_descriptions')." pfd
                ON pfd.product_feature_id = pf.product_feature_id 
                    AND pfd.language_id = '".(int) $this->language->getContentLanguageID()."'
            WHERE pf.product_id = '".(int) $product_id."' 
                AND pf.product_feature_id = '".(int) $feature_id."'
            ORDER BY pf.sort_order"
        );
        return $product_feature->row;
    }

    public function getProductFeatureValues($feature_id)
    {
        $result = [];

        $product_feature_values = $this->db->query(
            "SELECT * 
            FROM ".$this->db->table('product_feature_values')."
            WHERE product_feature_id = '".(int) $feature_id."'
            ORDER BY sort_order"
        );

        foreach ($product_feature_values->rows as $feature_value) {
            $value_description = $this->db->query(
                "SELECT * 
                FROM ".$this->db->table('product_feature_value_descriptions')."
                WHERE product_feature_value_id = '".(int) $feature_value['product_feature_value_id']."'"
            );

            $result[] = [
                'product_feature_value_id' => $feature_value['product_feature_value_id'],
                'language'                 => array_column($value_description->rows, 'name', 'language_id'),
                'sort_order'               => $feature_value['sort_order'],
            ];
        }

        return $result;
    }

    public function addProductFeature($product_id, $data)
    {
        $am = new AAttribute_Manager();
        $attribute = $am->getAttribute((int) $data['attribute_id']);
        $global_values = [];

        if ($attribute) {
            $content_language_id = $this->language->getContentLanguageID();
            $data['name'] = [];
            $data['element_type'] = $attribute['element_type'];
            $data['required'] = $attribute['required'];
            $data['name'][$content_language_id] = ['name' => $attribute['name']];

            $all_languages = $this->language->getActiveLanguages();
            foreach ($all_languages as $language) {
                if ($language['language_id'] == $content_language_id) {
                    continue;
                }
                $tmp = $am->getAttribute((int) $data['attribute_id'], (int) $language['language_id']);
                $data['name'][$language['language_id']] = ['name' => $tmp['name']];
            }
            unset($tmp);

            $data['sort_order'] = $attribute['sort_order'];
            $global_values = $this->getGlobalAttributeValues($data['attribute_id']);

            foreach ($global_values as $key => $value) {
                $global_values[$key]['descriptions'] = $am->getAttributeValueDescriptions($value['attribute_value_id']);
            }
        } else {
            $data['attribute_type_id'] = $am->getAttributeTypeID('product_feature');
            $data['attribute_id'] = $am->addAttribute($data);
        }

        $this->db->query(
            "INSERT INTO ".$this->db->table('product_features')."
            SET global_attribute_id = '".(int) $data['attribute_id']."',
                product_id = '".(int) $product_id."',
                sort_order = '".(int) $data['sort_order']."',
                status = '".(int) $data['status']."',
                element_type = '".$this->db->escape($data['element_type'])."',
                required = '".(int) $data['required']."'"
        );

        $product_feature_id = $this->db->getLastId();
        $language_id = $this->language->getContentLanguageID();
        if (!empty($data['name'])) {
            // insert descriptions for used content language and translate
            if (!$attribute) {
                $this->language->replaceDescriptions(
                    'product_feature_descriptions',
                    ['product_feature_id' => (int) $product_feature_id],
                    [
                        $language_id => [
                            'name' => $data['name'],
                        ],
                    ]
                );
            } else {
                $this->language->replaceDescriptions(
                    'product_feature_descriptions',
                    [
                        'product_feature_id' => (int) $product_feature_id
                    ],
                    $data['name']
                );
            }
        }

        if (!empty($global_values)) {
            foreach ($global_values as $value) {
                $product_feature_value_id = $this->insertProductFeatureValue($product_id, $product_feature_id, $value);

                foreach ($value['descriptions'] as $language_id => $descr) {
                    $this->insertProductFeatureValueDescriptions(
                        $product_id, $product_feature_value_id, $descr, $language_id
                    );
                }
            }
        } else {
            //add empty option value for single value attributes
            $elements_with_options = HtmlElementFactory::getElementsWithOptions();
            if (!in_array($data['element_type'], $elements_with_options)) {
                $this->insertProductFeatureValue($product_id, $product_feature_id, []);
            }
        }

        $this->cache->remove('product');
        return $product_feature_id;
    }

    public function insertProductFeatureValue($product_id, $feature_id, $data)
    {
        if (empty($product_id) || empty($feature_id)) {
            return null;
        }
        $this->db->query(
            "INSERT INTO ".$this->db->table('product_feature_values')."
            SET
                product_feature_id = '".(int) $feature_id."',
                product_id = '".(int) $product_id."',
                sort_order = '".(int) $data['sort_order']."'"
        );

        return $this->db->getLastId();
    }

    /**
     * @param array $data
     *
     * @throws AException
     */
    public function updateProductFeature($data)
    {
        $fields = ["sort_order", "status"];

        $update = [];
        foreach ($fields as $f) {
            if (isset($data[$f])) {
                $update[] = $f ." = '".$this->db->escape($data[$f])."'";
            }
        }
        if (!empty($update)) {
            $this->db->query(
                "UPDATE `".$this->db->table('product_features')."`
                SET ".implode(',', $update)."
                WHERE product_feature_id = '".(int) $data['feature_id']."'"
            );
        }

        if (!empty($data['name'])) {
            $language_id = $this->language->getContentLanguageID();
            $this->language->replaceDescriptions(
                'product_feature_descriptions',
                [
                    'product_feature_id' => (int) $data['feature_id']
                ],
                [
                    $language_id => [
                        'name' => $data['name'],
                    ],
                ]
            );
        }

        $this->cache->remove('product');
    }

    //Update product option value
    public function updateProductFeatureValue($product_feature_value_id, $data)
    {
        if (empty($product_feature_value_id) || empty($data)) {
            return null;
        }
        $this->db->query(
            "UPDATE ".$this->db->table('product_feature_values')."
            SET sort_order = '".(int) $data['sort_order']."'
            WHERE product_feature_value_id = '".(int) $product_feature_value_id."'  "
        );
        return $product_feature_value_id;
    }

    public function updateProductFeatureValues($product_id, $feature_id, $data)
    {
        $language_id = $this->language->getContentLanguageID();
        foreach ($data['product_feature_value_id'] as $f_val_id => $status) {
            $option_value_data = [
                'value'      => $data['name'][$f_val_id],
                'sort_order' => $data['sort_order'][$f_val_id],
            ];

            //Check if new, delete or update
            if ($status == 'delete' && strpos($f_val_id, 'new') === false) {
                //delete this feature value for all languages
                $this->deleteProductFeatureValue($f_val_id);
            } else {
                if ($status == 'new') {
                    // Need to create new feature value
                    $this->addProductFeatureValueAndDescription($product_id, $feature_id, $option_value_data);
                } else {
                    //Existing need to update
                    $this->updateProductFeatureValueAndDescription(
                        $product_id, $f_val_id, $option_value_data, $language_id
                    );
                }
            }
        }

        $this->cache->remove('product');
    }

    //Update product feature value and value descriptions for all set langauges
    public function updateProductFeatureValueAndDescription($product_id, $product_feature_value_id, $data, $language_id)
    {
        $this->updateProductFeatureValue($product_feature_value_id, $data);

        $exist = $this->getProductFeatureValueDescriptions($product_id, $product_feature_value_id, $language_id);
        if ($exist->num_rows) {
            $this->updateProductFeatureValueDescriptions(
                $product_id, $product_feature_value_id, $data['value'], $language_id
            );
        } else {
            $this->insertProductFeatureValueDescriptions(
                $product_id, $product_feature_value_id, $data['value'], $language_id
            );
        }

        $this->cache->remove('product');
    }

    //Add new product feature value and value descriptions for all global attributes languages or current language

    /**
     * @param int $product_id
     * @param int $feature_id
     * @param array $data
     * @param int $language_id
     *
     * @return int|null
     */
    public function addProductFeatureValueAndDescription($product_id, $feature_id, $data, $language_id = 0)
    {
        if (empty($product_id) || empty($feature_id) || empty($data)) {
            return null;
        }

        if (!$language_id) {
            $language_id = $this->language->getContentLanguageID();
        }

        $product_feature_value_id = $this->insertProductFeatureValue($product_id, $feature_id, $data);

        $this->insertProductFeatureValueDescriptions(
            $product_id,
            $product_feature_value_id,
            $data['value'],
            $language_id
        );

        $this->cache->remove('product');
        return $product_feature_value_id;
    }

    /**
     * @param int $product_id
     * @param int $product_feature_value_id
     * @param int $language_id
     *
     * @return bool|stdClass|null
     * @throws AException
     */
    public function getProductFeatureValueDescriptions($product_id, $product_feature_value_id, $language_id)
    {
        if (empty($product_id) || empty($product_feature_value_id) || empty($language_id)) {
            return null;
        }
        return $this->db->query(
            "SELECT *
            FROM ".$this->db->table('product_feature_value_descriptions')."
            WHERE
                product_feature_value_id = '".(int) $product_feature_value_id."'
                AND product_id = '".(int) $product_id."'
                AND language_id = '".(int) $language_id."'"
        );
    }

    /**
     * @param int $product_id
     * @param int $product_feature_value_id
     * @param string $name
     * @param int $language_id
     *
     * @return false|int
     * @throws AException
     */
    public function insertProductFeatureValueDescriptions($product_id, $product_feature_value_id, $name, $language_id)
    {
        if (empty($product_id) || empty($product_feature_value_id) || empty($language_id)) {
            return false;
        }

        $this->db->query(
            "INSERT INTO ".$this->db->table('product_feature_value_descriptions')."
            SET
                product_feature_value_id = '".(int) $product_feature_value_id."',
                language_id = '".(int) $language_id."',
                product_id = '".(int) $product_id."',
                name = '".$this->db->escape($name)."'"
        );
        return $this->db->getLastId();
    }

    /**
     * @param int $product_id
     * @param int $product_feature_value_id
     * @param string $name
     * @param int $language_id
     *
     * @return int|false
     * @throws AException
     */
    public function updateProductFeatureValueDescriptions($product_id, $product_feature_value_id, $name, $language_id)
    {
        if (empty($product_id) || empty($product_feature_value_id) || empty($language_id)) {
            return false;
        }
        $this->db->query(
            "UPDATE ".$this->db->table('product_feature_value_descriptions')."
            SET name = '".$this->db->escape($name)."'
            WHERE
                product_feature_value_id = '".(int) $product_feature_value_id."'
                AND product_id = '".(int) $product_id."'
                AND language_id = '".(int) $language_id."' "
        );
        return $product_feature_value_id;
    }

    public function deleteProductFeature($feature_id)
    {
        $values = $this->getProductFeatureValues($feature_id);
        foreach ($values as $v) {
            $this->deleteProductFeatureValue($v['product_feature_value_id']);
        }

        $this->db->query(
            "DELETE FROM ".$this->db->table('product_features')."
            WHERE product_feature_id = '".(int) $feature_id."'"
        );
        $this->db->query(
            "DELETE FROM ".$this->db->table('product_feature_descriptions')."
            WHERE product_feature_id = '".(int) $feature_id."'"
        );

        $this->cache->remove('product');
    }

    public function deleteProductFeatureValue($product_feature_value_id, $language_id = 0)
    {
        if (empty($product_feature_value_id)) {
            return false;
        }

        $this->_deleteProductFeatureValue($product_feature_value_id, $language_id);
        $this->cache->remove('product');
    }

    public function _deleteProductFeatureValue($product_feature_value_id, $language_id)
    {
        if (empty($product_feature_value_id)) {
            return false;
        }

        $add_language = '';
        if ($language_id) {
            $add_language = " AND language_id = '".(int) $language_id."'";
        }

        $this->db->query(
            "DELETE FROM ".$this->db->table('product_feature_value_descriptions')."
            WHERE product_feature_value_id = '".(int) $product_feature_value_id."'".$add_language
        );

        //Delete product_feature_values that have no values left in descriptions
        $sql = "DELETE FROM ".$this->db->table('product_feature_values')."
                WHERE product_feature_value_id = '".(int) $product_feature_value_id."' 
                    AND product_feature_value_id 
                        NOT IN ( SELECT product_feature_value_id 
                                 FROM ".$this->db->table('product_feature_value_descriptions')."
                                 WHERE product_feature_value_id = '".(int) $product_feature_value_id."')";
        $this->db->query($sql);
    }

    public function deleteProductFeatureValueDescriptions($product_id, $product_feature_value_id, $language_id = '')
    {
        if (empty($product_id) || empty($product_feature_value_id)) {
            return null;
        }
        $add_language = '';
        if ($language_id) {
            $add_language = " AND language_id = '".(int) $language_id."'";
        }
        $this->db->query(
            "DELETE FROM ".$this->db->table('product_feature_value_descriptions')."
            WHERE
                product_id = '".(int) $product_id."'
                AND product_feature_value_id = '".(int) $product_feature_value_id."' ".$add_language
        );
    }

    public function getGlobalAttributeValues($attribute_id)
    {
        $query = $this->db->query(
            "SELECT attribute_value_id, sort_order
                FROM ".$this->db->table('global_attributes_values')."
                WHERE attribute_id = '".$this->db->escape($attribute_id)."'
                ORDER BY sort_order"
        );
        return $query->rows;
    }

    public function getProductFeaturesByGlobalAttributeId($attribute_id)
    {
        $result = $this->db->query(
            "SELECT *
             FROM ".$this->db->table('product_features')."
             WHERE global_attribute_id = ".(int) $attribute_id
        );

        return $result->rows;
    }

    public function getGlobalAttributeTypeInfo()
    {
        $am = new AAttribute_Manager('product_feature');
        return $am->getAttributeTypeInfo('product_feature');
    }

    public function deleteProductFeatureByGlobalAttributeId($attribute_id)
    {
        $features = $this->getProductFeaturesByGlobalAttributeId($attribute_id);
        foreach ($features as $feature) {
            $this->deleteProductFeature($feature['product_feature_id']);
        }
    }

    public function updateGlobalProductFeature($attribute_id, $data)
    {
        $update_data = [
            'name'       => $data['name'],
            'status'     => $data['status'],
            'sort_order' => $data['sort_order'],
            'required'   => $data['required'],
        ];

        $features = $this->getProductFeaturesByGlobalAttributeId($attribute_id);

        foreach ($features as $feature) {
            $update_data['feature_id'] = $feature['product_feature_id'];
            $this->updateProductFeature($update_data);
        }
    }

}