<?php if ($license_status===true) { ?>
<?php if ($universal_code !== '' && $inline_code!=='') { ?>
<?php echo $universal_code; ?>
<?php echo $inline_code; ?>
<?php } else { ?>
<h2><?php echo $text_subscribe; ?></h2>
<div>
   <form class="cmxform" id="newsletter" name="newsletter">
       <?php if ($topContent != "") { ?>
       <div>
           <?php echo html_entity_decode($topContent); ?>
       </div>
       <?php } ?>
       <div>
        <?php if($first_name=='yes' || $first_name=='') { ?>
        <div class="form-group">
            <label for="firstname" class="control-label"><?php echo $entry_firstname; ?><sup>*</sup></label>
            <div class="controls">
                <input title="<?php echo $error_firstname; ?>" id="firstname" required type="text" placeholder="" value="" name="firstname">
            </div>
        </div>
        <?php } ?>
        <?php if($last_name=='yes' || $last_name=='') { ?>
        <div class="form-group">
            <label for="lastname" class="control-label"><?php echo $entry_lastname; ?><sup>*</sup></label>
            <div class="controls">
                <input title="<?php echo $error_lastname; ?>" id="lastname" required type="text" placeholder="" value="" name="lastname">
            </div>
        </div>
        <?php } ?>
        <div class="form-group">
            <label for="email" class="control-label"><?php echo $entry_email; ?><sup>*</sup></label>
            <div class="controls">
                <input title="<?php echo $error_email; ?>" id="email" required type="email" placeholder="" value="" name="email">
            </div>
        </div>
          </div>

    <div class="form-group">
            <div class="mb20">
                <input type="submit" class="btn btn-orange" name="submit" value="<?php echo $submit;?>">
            </div>
    </div>
       <?php if ($bottomContent != "") { ?>
       <div>
           <?php echo html_entity_decode($bottomContent); ?>
       </div>
       <?php } ?>
       <div class="error"></div>
       <div class="overlay">
           <div class="message processing">
           </div>
           <div class="message error">
           </div>
           <div class="message success">
           </div>
       </div>
    </form>
</div>

<script>
    var settings = {
        form 	 : ".cmxform",
        firstname : ".cmxform input[name=firstname]",
        lastname : ".cmxform input[name=lastname]",
        email : ".cmxform input[name=email]",
        overlay	 : ".cmxform .overlay",
        success	 : ".cmxform .overlay .success",
        error	 : ".cmxform .overlay .error",
        process	 : ".cmxform .overlay .processing"
    };

    function overlayDisplay(elem, type){
        if( type == "hide" ){
            $(elem).fadeOut(1000, function(){
                $(settings.overlay).hide();
                $('.error').html('');
                $('.success').html('');
            });
        }else{
            $(settings.overlay).css('display','inline-block');
            $(elem).fadeIn(1000);

            /* Auto fade the error overlay and clear the password field after 3 seconds */
            if( elem == settings.error ){
                $(settings.firstname).val("");
                $(settings.lastname).val("");
                $(settings.email).val("");
                setTimeout(function(){
                    overlayDisplay(settings.error, "hide");
                }, 3000);
            }
            else if( elem == settings.success ){
                $(settings.firstname).val("");
                $(settings.lastname).val("");
                $(settings.email).val("");
                setTimeout(function(){
                    overlayDisplay(settings.success, "hide");
                }, 3000);
            }
        }
    }

    $().ready(function() {
        // validate signup form on keyup and submit
        $("#newsletter").validate({
            errorLabelContainer: $("#newsletter div.error"),
            submitHandler: function() {
                overlayDisplay(settings.overlay);
                var dataArray = $("#newsletter input").serializeArray(),
                        dataObj = { };
                $(dataArray).each(function(i, field){
                    dataObj[field.name] = field.value;
                });
                $('.processing').html('<?php echo $process; ?>');

                $.ajax({
                    type: "POST",
                    url: '<?php echo $url; ?>',
                    data: { 'data': JSON.stringify(dataObj)},
                    dataType: 'json',
                    beforeSend:function() {
                        $(settings.process).fadeIn(1000);
                    },
                    complete:function()
                    {

                    },
                    success: function (data) {
                        $(settings.overlay).children().hide();
                        //alert(data.status);
                        if (data.status=='Error')
                        {
                            $(settings.process).hide();
                            $('.error').html(data.err);
                            overlayDisplay(settings.error);
                        }
                        else if (data.status=='Success'){
                            $(settings.process).hide();
                            $('.success').html(data.sccs);
                            overlayDisplay(settings.success);
                        }
                    },
                    error:function(status,data)
                    {
                        console.log(status);
                    }
                });
            }
        });
    });
</script>
<?php } ?>
<?php } ?>