<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

require DIR_EXT.'constantcontact_integration'.DIR_EXT_CORE.'src/Ctct/autoload.php';

use Ctct\ConstantContact;
use Ctct\Components\Contacts\Contact;
use Ctct\Components\Contacts\EmailAddress;
use Ctct\Exceptions\CtctException;

class ModelExtensionCtct extends Model{
    public $data = [];
    private $error = [];
    private $api='9u2zpz9pyxwreaqrhg9bu7ng';

    public function addContact($id,$email)
    {
        $sql="INSERT INTO " . $this->db->table("constantcontact_integration"). "
				(`contactId`,`email`)
				VALUES ('" . $id . "',
				        '" . $email . "')";
        $this->db->query($sql);
        $contact_id = $this->db->getLastId();
        return $contact_id;
    }

    public function updateNewsletter($newsletter,$email) {
        $this->db->query("UPDATE " . $this->db->table("customers") . " SET newsletter = '" . (int)$newsletter . "' WHERE email = '" . $email . "'");
    }

    public function getContent($position) {
        $store_id = $this->getStoreId();
        $sql="SELECT * FROM " . $this->db->table("constantcontact_integration_content"). " WHERE positions='" . $position . "' AND `store_id`=".$store_id;
        $results=$this->db->query($sql);
        return $results->row;
    }

    public  function getNewsletterStatus($email)
    {
        $sql="SELECT newsletter FROM " . $this->db->table("customers")." WHERE email='" . $email . "'";
        $results=$this->db->query($sql);
        return $results->row;
    }

    /**
     * @param $email
     * @param $first_name
     * @param $last_name
     * @param $action - subscribe for new, resubscribe for existing
     * @param string $id
     * @param string $opt_in
     */

    public function Subscribe($email,$first_name,$last_name,$action,$id='',$opt_in='') {
        $cc = new ConstantContact($this->api);
	    $store_id = $this->getStoreId();
        $settings = $this->getSetting('constantcontact_integration',$store_id);
        $token = $settings["constantcontact_integration_access_token"];
        $list_id = $settings['constantcontact_integration_list'];

        $contact = new Contact();
        if ($opt_in==='ACTION_BY_VISITOR') {
            $contact->id=$id;
            $emailAddress = new EmailAddress();
            $emailAddress->opt_in_source='ACTION_BY_VISITOR';
            $emailAddress->email_address=$email;
            $contact->addEmail($emailAddress);
        } else {
            $contact->addEmail($email);
        }

        $contact->addList($list_id);
        $contact->first_name = $first_name;
        $contact->last_name = $last_name;
        if ($action==0) {
            try {
                $cc->addContact($token, $contact, true);
            } catch (CtctException $ex) {
                $rpt = $ex->getErrors();
                $this->log->write('Constant Contact Subscribe Error:'.var_export($rpt,true));
                //$this->log->write('Constant Contact Error '.$rpt[0]['error_message']);
            }
        } elseif ($action==1) {
            try{
                $cc->updateContact($token, $contact, true);
            } catch(CtctException $ex) {
                $rpt = $ex->getErrors();
                $this->log->write('Constant Contact Subscribe Error:'.var_export($rpt,true));
                //$this->log->write('Constant Contact Error '.$rpt[0]['error_message']);
            }
        }
    }

    /**
     * @param string $email
     */
    public function Unsubscribe($email) {
        $cc = new ConstantContact($this->api);
	    $store_id = $this->getStoreId();
        $settings = $this->getSetting('constantcontact_integration',$store_id);
        $token=$settings["constantcontact_integration_access_token"];
        
        try {
            $acc = $cc->getContactByEmail($token, $email);
            $id=$acc->results[0]->id;
            if ($id) {
                $cc->deleteContact($token, $id);
            }
        } catch(CtctException $ex) {
            $err=$ex->getErrors();
            $this->log->write('Constant Contact Unsubscribe Error:'.var_export($err,true));
            //$this->log->write('Constant Contact Error '.$err[0]['error_message']);
        }
    }

    /**
     * @param $email
     * @return array
     */
    public function getContact($email) {
        $cc = new ConstantContact($this->api);
        $store_id = $this->getStoreId();
        $settings = $this->getSetting('constantcontact_integration',$store_id);
        $token=$settings["constantcontact_integration_access_token"];
        $contacts=$cc->getContactByEmail($token, $email)->results;
        return $contacts;
    }

    public function getStoreId() {
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }

    /**
     * @param string $group
     * @param int    $store_id
     *
     * @return array
     */
    public function getSetting($group, $store_id = 0) {
        $data = [];

        $query = $this->db->query(
            "SELECT *
            FROM ".$this->db->table("settings")." 
            WHERE `group` = '".$this->db->escape($group)."'
                AND store_id = '".(int)$store_id."'"
        );
        foreach ($query->rows as $result) {
            $value = $result['value'];
            if (is_serialized($value)) {
                $value = unserialize($value);
            }
            $data[$result['key']] = $value;
        }
        return $data;
    }
}