<?php
/*------------------------------------------------------------------------------
  
  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
header ( 'Location: static_pages/' );
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ControllerPagesExtensionConstantContactIntegration
 * @property ModelExtensionCtct $model_extension_ctct
 */

class ControllerBlocksConstantContactIntegration extends AController {

    public $data = [];

    public function verify() {
        $this->load->model('extension/constantcontact_integration_license_info');
        $license_key = $this->config->get('constantcontact_integration_license_code');
        if ($license_key) {
            $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('constantcontact_integration_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $this->model_extension_constantcontact_integration_license_info->getStoreId();
                $license_key = $this->model_extension_constantcontact_integration_license_info->getLicenseCode($store_id);
                $license_info = $this->model_extension_constantcontact_integration_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], 'constantcontact_integration');
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $this->model_extension_constantcontact_integration_license_info->getLicensedStoreStatus();
                if ($validate['status'] === 'valid' && $store_status == 1) {
                    return true;
                } else {
                    return false;
                }
            }
        } else {
            return false;
        }
    }

    public function main() {
        $this->loadModel('account/customer');
        $this->loadModel('extension/ctct');
        $this->loadLanguage('account/create');
        $this->loadLanguage('account/newsletter');
        $this->loadLanguage('blocks/newsletter_signup');
        $this->loadLanguage('blocks/constantcontact_integration');
        $this->view->assign('text_subscribe',$this->language->get('text_subscribe'));
        $this->view->assign('submit',$this->language->get('newsletter_subscribe'));
        $this->view->assign('process',$this->language->get('newsletter_submit'));
        $this->view->assign('success',$this->language->get('newsletter_success'));
        $this->view->assign('error_firstname',$this->language->get('error_firstname'));
        $this->view->assign('error_email',$this->language->get('error_email'));
        $this->view->assign('entry_name',$this->language->get('entry_name'));
        $this->view->assign('entry_email',$this->language->get('entry_email'));
        $this->view->assign('url',$this->html->getURL('r/blocks/ctct/addContact'));
        $store_id = $this->getStoreId();
        $settings = $this->getSetting('constantcontact_integration',$store_id);
        $this->view->assign('first_name',$settings['constantcontact_integration_firstname']);
        $this->view->assign('last_name',$settings['constantcontact_integration_lastname']);
        $this->view->assign('head_text',$settings['constantcontact_integration_head']);
        $this->view->assign('foot_text',$settings['constantcontact_integration_footer']);
        $this->view->assign('universal_code',html_entity_decode($settings['constantcontact_integration_universal_code']));
        $this->view->assign('inline_code',html_entity_decode($settings['constantcontact_integration_inline_code']));
        $topContent=$this->model_extension_ctct->getContent('top');
        $bottomContent=$this->model_extension_ctct->getContent('bottom');
        $this->view->assign('topContent',$topContent['content']);
        $this->view->assign('bottomContent',$bottomContent['content']);
        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/styles.css'),
                'rel' => 'stylesheet',
            ]
        );
        $this->document->addScript($this->view->templateResource('/javascript/jquery.validate.min.js'));
        $this->data['license_status'] = $this->verify();
        $this->view->batchAssign($this->data);
        $this->processTemplate('blocks/constantcontact_integration.tpl');
    }

    public function getStoreId() {
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }

    /**
     * @param string $group
     * @param int    $store_id
     *
     * @return array
     */
    public function getSetting($group, $store_id = 0) {
        $data = [];

        $query = $this->db->query(
            "SELECT *
            FROM ".$this->db->table("settings")." 
            WHERE `group` = '".$this->db->escape($group)."'
                AND store_id = '".(int)$store_id."'"
        );
        foreach ($query->rows as $result) {
            $value = $result['value'];
            if (is_serialized($value)) {
                $value = unserialize($value);
            }
            $data[$result['key']] = $value;
        }
        return $data;
    }
 }