<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

require DIR_EXT.'constantcontact_integration'.DIR_EXT_CORE.'src/Ctct/autoload.php';

use Ctct\ConstantContact;
use Ctct\Components\Contacts\Contact;
use Ctct\Components\Contacts\EmailAddress;
use Ctct\Exceptions\CtctException;

class ModelExtensionConstantContactIntegration extends Model{
    public $data = [];
    private $error = [];
    private $api='9u2zpz9pyxwreaqrhg9bu7ng';

    public function syncNewsletter($newsletter,$email) {
      $this->db->query("UPDATE " . $this->db->table("customers") . " SET newsletter = '" . (int)$newsletter . "' WHERE email = '" . $email . "'");
    }

    public function getContent($position) {
        $store_id = $this->getStoreId();
        $sql="SELECT * FROM " . $this->db->table("constantcontact_integration_content")." WHERE positions='" . $position . "' AND `store_id`=".$store_id;
        $results=$this->db->query($sql);
        return $results->row;
    }

    public function updateContent($position,$data) {
        $store_id = $this->getStoreId();
        $fields=[
            'content'
        ];
        $query = $this->db->query("SELECT COUNT(*) as total FROM ".$this->db->table("constantcontact_integration_content")." WHERE `store_id`=".$store_id);
        $result = $query->row['total'];
        if ($result === '0') {
            $this->addPositions();
        }
        $update=[];
        foreach ($fields as $f) {
            if (isset($data[$f])) {
                $update[] = "$f = '" . $this->db->escape($data[$f]) . "'";
            }
        }

        if (!empty($update)) {
            if ($this->db->query("UPDATE " . $this->db->table("constantcontact_integration_content")." SET " . implode(',', $update) . " WHERE positions = '" . $position . "' AND `store_id`=".$store_id)) {
                return true;
            };
        }
    }

    public function addPositions() {
        $store_id = $this->getStoreId();

        $this->db->query("INSERT INTO " . $this->db->table('onstantcontact_integration_content') . " ( `content`, `positions`,`store_id` ) VALUES
             ('', 'top','" . $store_id . "'),
             ('', 'bottom','" . $store_id . "')");
    }

    public function getCustomerByEmail($email) {
        $sql="SELECT * FROM " . $this->db->table("customers") . " WHERE email='" . $email . "'";
        $results=$this->db->query($sql);
        return $results->row;
    }

    public function getSubscribersCustomerGroupId() {
        $query = $this->db->query("SELECT customer_group_id	FROM `" . $this->db->table("customer_groups") . "` WHERE `name` = 'Newsletter Subscribers' LIMIT 0,1");
        $result = !$query->row['customer_group_id'] ? (int)$this->config->get('config_customer_group_id') :  $query->row['customer_group_id'];
        return $result;
    }

    /**
     * @param $email
     * @param $first_name
     * @param $last_name
     * @param $action - subscribe for new, resubscribe for existing
     * @param string $id
     * @param string $opt_in
     */

    public function Subscribe($email,$first_name,$last_name,$action,$id='',$opt_in='') {
        $store_id = $this->getStoreId();
        $this->load->model('setting/setting');
        $settings = $this->model_setting_setting->getSetting('constantcontact_integration', $store_id);
        $cc = new ConstantContact($this->api);
        $token = $settings['constantcontact_integration_access_token'];
        $list_id = $settings['constantcontact_integration_list'];

        $contact = new Contact();
        if ($opt_in==='ACTION_BY_VISITOR') {
            $contact->id=$id;
            $emailAddress = new EmailAddress();
            $emailAddress->opt_in_source='ACTION_BY_VISITOR';
            $emailAddress->email_address=$email;
            $contact->addEmail($emailAddress);
        } else {
            $contact->addEmail($email);
        }
        
        $contact->addList($list_id);
        $contact->first_name = $first_name;
        $contact->last_name = $last_name;
        if ($action==0) {
            try {
                $cc->addContact($token, $contact, true);
            } catch (CtctException $ex) {
                $rpt = $ex->getErrors();
                $this->log->write('Constant Contact Error '.$rpt[0]['error_message']);
            }
        } elseif ($action==1) {
            try{
                $cc->updateContact($token, $contact, true);
            } catch(CtctException $ex) {
                $rpt = $ex->getErrors();
                $this->log->write('Constant Contact Error this one'.$rpt[0]['error_message']);
            }
        }
    }

    /**
     * @param string $email
     */
    public function Unsubscribe($email) {
        $cc = new ConstantContact($this->api);
        $store_id = $this->getStoreId();
        $this->load->model('setting/setting');
        $settings = $this->model_setting_setting->getSetting('constantcontact_integration', $store_id);
        $token = $settings['constantcontact_integration_access_token'];
        try {
            $acc = $cc->getContactByEmail($token, $email);
            $id=$acc->results[0]->id;
            if ($id) {
                $cc->deleteContact($token, $id);
            }
        } catch(CtctException $ex) {
            $err=$ex->getErrors();
            $this->log->write('Constant Contact Error '.$err[0]['error_message']);
        }
    }

    /**
     * @param $email
     * @return array
     */
    public function getContact($email) {
        $cc = new ConstantContact($this->api);
        $store_id = $this->getStoreId();
        $this->load->model('setting/setting');
        $settings = $this->model_setting_setting->getSetting('constantcontact_integration', $store_id);
        $token = $settings['constantcontact_integration_access_token'];
        $contacts=$cc->getContactByEmail($token, $email)->results;
        return $contacts;
    }
    
    public function getStoreId() {
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
}