<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

require DIR_EXT.'constantcontact_integration'.DIR_EXT_CORE.'src/Ctct/autoload.php';

use Ctct\ConstantContact;

/**
 * Class ControllerPagesExtensionConstantContactIntegration
 * @property ModelExtensionConstantContactIntegration $model_extension_constantcontact_integration
 */

class ControllerResponsesExtensionConstantContactIntegration extends AController {
    public $data=[];
    private $api='9u2zpz9pyxwreaqrhg9bu7ng';

    public function main(){}

    public function addTop() {
        $this->loadModel('extension/constantcontact_integration');
        $contents=$this->_prepareData();
        $this->data['result']=$this->model_extension_constantcontact_integration->updateContent('top',$contents);
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($this->data));

    }

    public function addBottom() {
        $this->loadModel('extension/constantcontact_integration');
        $contents=$this->_prepareData();
        $this->data['result']=$this->model_extension_constantcontact_integration->updateContent('bottom',$contents);
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($this->data));
    }

    public function _prepareData() {
        if (isset($this->request->post['data'])) {
            $this->load->library('json');
            $obj = AJson::decode(html_entity_decode($this->request->post['data']));
            $data['content']=$obj->content;
            return $data;
        }
    }

    public function getList() {
        $cc = new ConstantContact($this->api);
        $token=$this->request->get['access_token'];
        $obj=$cc->getLists($token);
        $lists=[];

        foreach ($obj as $key){
            $lists[]=['id'=>$key->id,'name'=>$key->name];
        }
        array_unshift($lists,['id'=>'NONE','name'=>'NONE']);
        $this->data['lists']=$lists;
        $store_id = $this->getStoreId();
        $this->load->model('setting/setting');
        $settings = $this->model_setting_setting->getSetting('constantcontact_integration', $store_id);
        $this->data['selectedList' ] = $settings['constantcontact_integration_list'];
        $this->view->batchAssign($this->data);
        $this->processTemplate('responses/extension/ctct_list.tpl');
    }

    public function getStoreId() {
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
}