<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( !defined ( 'DIR_CORE' )) {
	header ( 'Location: static_pages/' );
}

if(!class_exists('')){
    include_once('core/usps_integration_hook.php');
}

const USPS_CLASSES = [
    'domestic' => [
        0 => 'First-Class', //deprecated
        1 => 'Priority Mail',
        2 => 'Priority Mail Express 1-Day Hold For Pickup',
        3 => 'Priority Mail Express 1-Day',
        4 => 'Parcel Post',
        5 => 'Bound Printed Matter',
        6 => 'Media Mail Parcel',
        7 => 'Library Mail Parcel',
        12 => 'First-Class Postcard Stamped',
        13 => 'Priority Mail Express 1-Day Flat Rate Envelope',
        15 => 'First-Class Mail Large Postcards',
        16 => 'Priority Mail Flat Rate Envelope',
        17 => 'Priority Mail Medium Flat Rate Box',
        18 => 'Priority Mail Keys and IDs',
        19 => 'First-Class Keys and IDs',
        22 => 'Priority Mail Large Flat Rate Box',
        23 => 'Express Mail Sunday/Holiday',
        25 => 'Express Mail Flat-Rate Envelope Sunday/Holiday',
        27 => 'Priority Mail Express 1-Day Flat Rate Envelope Hold For Pickup',
        28 => 'Priority Mail Small Flat Rate Box',
        77 => 'Parcel Select Ground',
        1058 => 'USPS Ground Advantage',
        2058 => 'USPS Ground Advantage Hold For Pickup',
        6058 => 'USPS Ground Advantage Parcel Locker',
        4058 => 'USPS Ground Advantage HAZMAT',
        4096 => 'USPS Ground Advantage Cubic HAZMAT',
        1096 => 'USPS Ground Advantage Cubic',
        2096 => 'USPS Ground Advantage Cubic Hold For Pickup',
        6096 => 'USPS Ground Advantage Cubic Parcel Locker',
        4001 => 'Priority Mail Express 2-Day HAZMAT',
        6001 => 'Priority Mail Express 2-Day Parcel Locker',
        4010 => 'Priority Mail HAZMAT',
        4012 => 'Priority Mail Large Flat Rate Box HAZMAT',
        4013 => 'Priority Mail Medium Flat Rate Box HAZMAT',
        4014 => 'Priority Mail Small Flat Rate Box HAZMAT',
        6010 => 'Priority Mail Parcel Locker',
        6012 => 'Priority Mail Large Flat Rate Box Parcel Locker',
        6013 => 'Priority Mail Medium Flat Rate Box Parcel Locker',
        4084 => 'Priority Mail Cubic HAZMAT',
        6084 => 'Priority Mail Cubic Parcel Locker',
        6076 => 'Media Mail Parcel Parcel Locker',
        6075 => 'Library Mail Parcel Parcel Locker',
        2020 => 'Bound Printed Matter Flats Hold For Pickup',
        2077 => 'Bound Printed Matter Parcels Hold For Pickup',
        6077 => 'Bound Printed Matter Parcels Parcel Locker',
    ],
    'international' => [
        1 => 'Priority Mail Express International',
        2 => 'Priority Mail International',
        4 => 'Global Express Guaranteed (GXG)',
        5 => 'Global Express Guaranteed Document used',
        6 => 'Global Express Guaranteed Non-Document Rectangular shape',
        7 => 'Global Express Guaranteed Non-Document Non-Rectangular',
        8 => 'Priority Mail International Flat Rate Envelope',
        9 => 'Priority Mail International Medium Flat Rate Box',
        10 => 'Priority Mail Express International Flat Rate Envelope',
        11 => 'Priority Mail International Large Flat Rate Box',
        12 => 'USPS GXG Envelopes',
        13 => 'First Class Mail International Letters',
        14 => 'First Class Mail International Flats',
        15 => 'First-Class Package International Service',
        16 => 'Priority Mail International Small Flat Rate Box',
        21 => 'Postcards',
    ]
];

$controllers = [
    'storefront' => [],
    'admin' => [ 'pages/extension/usps_integration',
                     'pages/extension/usps_integration_updater',
		              'responses/extension/usps_test',
                      'responses/extension/usps_integration_save'
    ],
];

$models = [
    'storefront' => [ 'extension/usps_integration',
        'extension/usps_order',
        'extension/usps_verify',
        'extension/usps_integration_license_info'
        ],
    'admin' => [
        'extension/usps_integration_updater',
	    'extension/usps_order',
	     'extension/usps_verify',
        'extension/usps_integration_license_info'
    ],
];

$languages = [
    'storefront' => [
	    'usps_integration/usps_integration'],
    'admin' => [
        'usps_integration/usps_integration']
];

$templates = [
    'storefront' => [
        'common/head.post.tpl',
        'embed/head.post.tpl'
    ],
    'admin' => [
        'pages/extension/usps_integration.tpl',
        'pages/extension/usps_integration_updater.tpl',
        'pages/extension/usps_integration_manual.tpl',
        'pages/extension/extension_summary_button.tpl',
        'pages/extension/extensions.post.tpl',
        'pages/extension/extensions_edit.post.tpl',
    ]
];