<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( !defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

$mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
$diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
$shared_secret = "ups_integration";

$public_key = "";
$path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

if ($this->config->get('ups_integration_license_code')) {
    $license_key = $this->config->get('ups_integration_license_code');
    $license = new License($path_to_phpseclib);
    $license_manager = $license->getManager();
    if (stripos($license_key, 'mc-') !== false) {
        $server_url = $mc_server_url;
    } else {
        $server_url = $diy_server_url;
    }
    $license_manager->setLicenseServerUrl($server_url);
    $license_manager->setKeys($license_key, "", $shared_secret);
    $public_key = $license_manager->requestKey();
    $this->load->model('extension/ups_integration_license_info');

    $store_id = (int)$this->config->get('config_store_id');

    $license_manager->setKeys($license_key, $public_key, $shared_secret);
    $custom_data = ['version' => '1.3.4.1'];
    $license_data = $license_manager->requestData($custom_data);
    if (!is_null($license_data)) {
        $ttl = 1209600;
        $validate = $license_manager->validate($license_data, $ttl);

        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
            $data['public_key'] = $public_key;
            $data['license_data'] = $license_data;
            $data['license_key'] = $license_key;
            $data['store_id'] = $store_id;
            $data['last_check'] = time();
            $this->load->model('extension/ups_integration_license_info');
            $this->model_extension_ups_integration_license_info->saveLicenseData($data);
        }
    }
}
$sql = "UPDATE ".$this->db->table('language_definitions')." set language_value='
This is a WHY2 extension.  All support and updates are managed from WHY2. <br>
        Read about WHY2\'s 12 months support <a href=\"https://why2central.net/knowledgebase/why2-support-and-updates-policy/\" target=\"_blank\" style=\"font-weight:bold;\">here</a> and how WHY2 updates are delivered <a href=\"https://why2central.net/knowledgebase/extension-updater/\" target=\"_blank\" style=\"font-weight:bold;\">here</a>.<br>
        You can safely ignore Support expired notification within the Admin Dashboard.<br><br>
     <strong>Notes: There are two ways to obtain the license key. <br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;a. Use this <a href=\"https://wehearyou2.com/clientarea/reg/register.php\" target=\"_blank\" style=\"font-weight:bold;\">form</a> to register to our Support system and generate your license key.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;b. Already registered -  click <a href=\"https://wehearyou2.com/clientarea/reg/index.php\" target=\"_blank\" style=\"font-weight:bold;\">here</a> to log into your account to obtain license key.<br>
         Refer to our <a href=\"https://why2central.net/faq/license-key/\" target=\"_BLANK\">F.A.Q</a> for more information on how to obtain the license key.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;c. If you already have an account in our support system and you are using multiple extensions from WHY2,  you do NOT need to create another account in the support system.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;d. Updating extension in same location does NOT require a new key.<br>Refer to our <a href=\"https://why2central.net/faq/license-key/\" target=\"_BLANK\">F.A.Q</a> for more information on how to Update extension in same location.</strong><br><br>
        1.&nbsp;Enter your WHY2 license key here.<br>
        2.&nbsp;Click the additional settings tab for setup.' WHERE language_key='ups_integration_note';";
$this->db->query($sql);

$sql1 = "UPDATE ".$this->db->table('language_definitions')." set language_value='<section>
        <strong>Important Note: Weight and Length class in System > Settings > Details fields must be either Pound/Inch OR Kilogram/Centimeter.</strong><br><br>
    	<p>1.&nbsp;Debug API response: Turn ON if you want to get the API response for debugging purpose. The API response will be written to System -> Logs -> Error Logs.</p>
    	<p>2.&nbsp;Test Mode: Use this extension in test(On) or production mode(Off).</p>
        &nbsp;&nbsp;&nbsp;&nbsp;Notes for number 3-4: Follow the steps <a href=\"https://why2central.net/docs/ups-integration-obtain-oauth-creds/\" target=\"_blank\" style=\"font-weight:bold;\">here</a> to obtain UPS developer client id, and client secret.</p>
        <p>3.&nbsp;Client ID: Enter your UPS Apps Client ID here.<br>
        <p>4.&nbsp;Client secret: Enter your UPS Apps Password here.</p>
        <p>5.&nbsp;Account Number: Enter your UPS Account Number here.</p>
        <p>6.&nbsp;Pickup Method: Select your pickup method.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;How do you give packages to UPS (only used when origin is US)</p>
        <p>7.&nbsp;Packaging Type: Select your packaging type.</p>
        <p>8.&nbsp;Customer Classification Code: Select the rate type that you want to show to customer <br>
         &nbsp;&nbsp;&nbsp;&nbsp;00 - Rates Associated with Shipper Number.<br>
         &nbsp;&nbsp;&nbsp;&nbsp;01 - Daily Rates.<br>
         &nbsp;&nbsp;&nbsp;&nbsp;04 - Retail Rates.<br>
         &nbsp;&nbsp;&nbsp;&nbsp;06 - General List Rates.<br>
         &nbsp;&nbsp;&nbsp;&nbsp;53 - Standard List Rates.</p>
        <p>9.&nbsp;Use Residential Rate As Default: Turn On if you want to use Residential Rate as the default instead of Commercial Rate on the view cart page.</p>
		<p>10.&nbsp;Negotiated Rates: Turn On if you have the negotiated rates enabled on your UPS Account.<br>
                                &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Negotiated rates will be used - your shipper account must have negotiated rates activated AND you must use 00 in the Customer Classification code field.</p>
        <p>11.&nbsp;Shipping Origin Code: What origin point should be used (this setting affects only what UPS product names are shown to the user).</p>
        <p>12.&nbsp;Origin City: Enter the name of the origin city. <br>
		&nbsp;&nbsp;&nbsp;&nbsp;e.g. Montevallo</p>
		<p>13.&nbsp;Origin Zip/Postal Code: Enter your origin zip/postal code.</p>
		<p>14.&nbsp;Origin State/Province: Enter your (two/three letters) State/Province code.</p>
		<p>15.&nbsp;Origin Country: Enter your (two letters) Country code.</p>
		<p>16.&nbsp;Test Your Connection: You can test if API credentials that you\'ve entered are correct after you saved the credentials.</p>
        <p>17.&nbsp;Services: Select the UPS Services to be offered.</p>
        <p><strong>Notes for number 18-21: If you are offering Local Delivery Services AND using more than one shipper you must enable Local Delivery Services on only ONE shipper.  e.g.  you offer FedEx, UPS and ups, and also Local Delivery – you must enable Local Delivery on only ONE shipper:  FedEx, UPS or ups.</strong></p>
        <p>18.&nbsp;Enter Zip/Postal Code(s) eligible to use Local Delivery Service: Use commas(,) without space as the multi Zip/Postal code(s) separator, and no spaces within the Zip/Postal code(s). To define areas use asterisk (*) replacement - eg 351*,350*.</p>
        <p>19.&nbsp;Local delivery fee: Enter the local delivery fee if you want to charge customer or leave blank if it is a free delivery.</p>
        <p>20.&nbsp;Turn ON to show ONLY Local Delivery Services: Turn OFF if you want to show all shipping options including Local Delivery services.</p>
        <p>21.&nbsp;Insert your desired text to be shown on cart page to let customers know about local delivery schedule or services: Insert your desired message.</p>
        <p><strong>Notes for number 22: If you are using more than ONE shipper and are offering any Free Shipping service, you must choose only ONE shipper for the Free Shipping.  e.g.  if using UPS , ups and FedEx,  Free Shipping can only be offered from one.</strong></p>
        <p>22.&nbsp;If using a Free Shipping option within your cart select which service you are using for the United States Free Shipping: Select the UPS Services to be offered for free shipping.</p>
        <p>23.&nbsp;If using a Free Shipping option within your cart select which service you are using for the International Free Shipping: Select the UPS Services to be offered for free shipping.</p>
        <p>24.&nbsp;Display Delivery Weight: Do you want to display the shipping weight? (e.g. (Weight: 0.15lb) )</p>
        <p><strong>Notes for number 25-27:  We set a Default of 5 x 5 x 5 which works for most businesses.  You can input your normal size if different. <br>
		Also, input on a product page will be used for that individual product rate look up. (You need to input individual product size and turn on the Ship Product Individually flag on product page.)</strong></p>
        <p>25.&nbsp;Dimensions Length (Optional): Insert your Box Length here.</p>
        <p>26.&nbsp;Dimensions Width (Optional): Insert your Box Width here.</p>
        <p>27.&nbsp;Dimensions Height (Optional): Insert your Box Height here.</p>
        <p>28.&nbsp;Max Box Weight (Optional): Specifies the maximum box size (just the number). Once the maximum weight is met, the system will calculate shipping for 2(or more) boxes.</p>
        <p>29.&nbsp;Tax Class: Choose your Tax Class. The tax is shown in a separate line on invoice.</p>
		<p>30.&nbsp;Location: Choose your Zone. Please refer to our <a href=\"https://why2central.net/faq/settings/\" target=\"_blank\" style=\"font-weight:bold;\">F.A.Q</a> about how to manage the shipping location.</p>
		<p>31.&nbsp;Additional Fee Type: Choose the type that you want to use for the additional Fee. Fixed amount or Rate Percentage based.</p>
		<p>32.&nbsp;Additional Fee: Insert your desired Additional Fee value that you want to charge to your customer.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;e.g. The rate is $5.00, your fixed additional fee is $3.00, the rate shown to customer is $8. Or if you\'re using the percentage instead of fixed rate, and it is 10% from the rate, the rate will be $5.5. To use either fixed or percentage based additional fee, just enter the digits without the % or currency symbol.</p>
        <p>33.&nbsp;Additional Weight: Insert your desired additional weight that you want to charge to your customer.<br>
        &nbsp;&nbsp;&nbsp;&nbsp; e.g. The weight is 0.26 lb and your additional weight is 0.50 lb, the weight rate will be 0.76 lb. And if showing shipping wt. in cart 0.26 lb is shown to customer.</p>
		<p>34.&nbsp;Declared Value: Do you want to Declare Package Value? Yes(On) or No(Off)<br>
		&nbsp;&nbsp;&nbsp;&nbsp;The declared value of a package represents UPS\'s maximum liability for the package in the case of loss or damage. If no value is declared, UPS\'s maximum liability for loss or damage to a package or international shipment is US$100 (or the equivalent in local currency).<br>
		&nbsp;&nbsp;&nbsp;&nbsp;For more information, visit <a href=\"https://www.ups.com/us/en/help-center/sri/glo-decval.page\" target=\"_blank\" style=\"font-weight:bold;\">UPS Declared Value Q&A.</a><p>
		<p>35.&nbsp;Declared Value Nominal: Enter the minimum nominal that will be used to enable the Declared Value. (If you leave it blank, it will use USD $100 by default)<p>
        <p>36.&nbsp;Estimate Message: Insert your desired text to be shown to customers to inform them that rate on cart page was using residential/commercial address based rate and not actual, the actual rate will be shown on checkout page based on their address.</p></section>' WHERE language_key='ups_integration_addition_note';";
$this->db->query($sql1);

$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='text_ca_origin_13'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='text_ca_origin_65'");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','ups_integration_ups_integration','text_ca_origin_13','UPS Express Saver',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','text_ca_origin_65','UPS Worldwide Express Saver',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','ups_integration_ups_integration','text_ca_origin_65','UPS Express Saver',now(),now())");

$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='entry_debug'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='text_weight'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='text_ship_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='ups_integration_ups_integration' AND `language_key`='ups_integration_license_code'");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','entry_debug','Debug API response: <span class=\"help\">Turn ON if you want to get the API response for debugging purpose. </span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','text_weight','Weight: ',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','text_ship_title','UPS',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','ups_integration_license_code','Enter your WHY2 license key:',now(),now())");

$sql2 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("ups_integration_updater_notification") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql2);

$sql4 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("ups_integration_license_info") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `public_key` TEXT NOT NULL,
  `license_data` TEXT NOT NULL,
  `license_key` TEXT NOT NULL,
  `store_id` int(11) NOT NULL,
  `last_check` int(11),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql4);

$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='entry_client_id'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='entry_client_secret'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='error_client_id'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='error_client_secret'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='error_account'");

$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='text_new_ups_integration_version_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='text_new_ups_integration_version_description'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='text_update_success'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='text_update_failed'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='button_start_update'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='button_cancel_update'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='text_update_ups_integration_note'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='text_ups_integration_updater_heading_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='text_changelog'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='text_no_updates'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='button_go_back'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='text_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='button_diy_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='button_mc_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='text_update_ups_integration_available'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='ups_integration_ext_man'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='ups_integration_ups_integration' AND `language_key`='ups_integration_license_expired'");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','error_client_id','UPS Apps Client ID Required!',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','error_client_secret','UPS Apps Client Secret Required!',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','error_account','UPS Account Number Required!',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','entry_client_id','Client ID:<span class=\"help\">Enter your UPS Apps Client ID here.</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','entry_client_secret','Client Secret:<span class=\"help\">Enter your UPS Apps Client Secret here.</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','text_new_ups_integration_version_title','New version (v[new_version]) of UPS Integration Extension',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','text_new_ups_integration_version_description','There is a new version of UPS Integration Extension. Please open -->#admin#rt=extension/ups_integration_updater&version=[version_number] to update the extension. <br><br>
                        The update will replace existing files with the update files.<br><br>Make sure that you have made a backup of your store prior to updating. Use your normal backup method or Softaculous to make a backup prior to updating your site. Need help on how to backup an installation by using Softaculous click <a href=\"https://why2central.net/knowledgebase/how-to-backup-an-installation/\" target=\"_BLANK\"><b>here</b></a>.<br><br>
                        Do not delete this message until you have updated.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','text_update_success','The UPS Integration extension has been successfully updated.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','text_update_failed','We are unable to update the UPS Integration extension, please check <a target=\"_BLANK\" href=\"#admin#rt=tool/error_log\">error log</a> for more information.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','button_start_update','Start Update',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','button_cancel_update','Cancel Update',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','text_update_ups_integration_note','Note:<br>We are going to update UPS Integration extension. The update will replace existing files with the update files.<br><br>Make sure that you have made a backup of your store prior to updating. Use your normal backup method or Softaculous to make a backup prior to updating your site. Need help on how to backup an installation by using Softaculous click <a href=\"https://why2central.net/knowledgebase/how-to-backup-an-installation/\" target=\"_BLANK\"><b>here</b></a>.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','text_ups_integration_updater_heading_title', 'UPS Integration Updater',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','text_changelog','Changelog:',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','text_no_updates','There are no new updates for this extension.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','button_go_back','Go Back',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','entry_free_us_international_method','If using a Free Shipping option within your cart select which service you are using for the International Free Shipping <span class=\"help\">Please select what method will chosen for case when cart contains only products with free shipping</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','entry_free_us_international_method','If using a Free Shipping option within your cart select which service you are using for the International Free Shipping <span class=\"help\">Please select what method will chosen for case when cart contains only products with free shipping</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','entry_free_pr_international_method','If using a Free Shipping option within your cart select which service you are using for the International Free Shipping <span class=\"help\">Please select what method will chosen for case when cart contains only products with free shipping</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','entry_free_ca_international_method','If using a Free Shipping option within your cart select which service you are using for the International Free Shipping <span class=\"help\">Please select what method will chosen for case when cart contains only products with free shipping</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','entry_free_mx_international_method','If using a Free Shipping option within your cart select which service you are using for the International Free Shipping <span class=\"help\">Please select what method will chosen for case when cart contains only products with free shipping</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','entry_free_eu_international_method','If using a Free Shipping option within your cart select which service you are using for the International Free Shipping <span class=\"help\">Please select what method will chosen for case when cart contains only products with free shipping</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','entry_free_pl_international_method','If using a Free Shipping option within your cart select which service you are using for the International Free Shipping <span class=\"help\">Please select what method will chosen for case when cart contains only products with free shipping</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','entry_free_other_international_method','If using a Free Shipping option within your cart select which service you are using for the International Free Shipping <span class=\"help\">Please select what method will chosen for case when cart contains only products with free shipping</span>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','text_support_by_why2','Support and updates from WHY2.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','button_diy_support_by_why2','If you are self-managed users click here for support. Support and updates from WHY2.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','button_mc_support_by_why2','If you are a WHY2 Managed Client click here for support. Updates are part of the Managed Services.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','text_update_ups_integration_available','New version (%s) is available. <a href=\"%s\" target=\"_BLANK\"><strong>Click to update now.</strong></a>',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','ups_integration_ext_man','UPS Integration Manual',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','ups_integration_ups_integration','ups_integration_license_expired','Your license key is expired. Possibly due to inactive with the extension for more than 14 days. Please click on the SAVE button at the bottom of this page.',now(),now())");


$this->load->model( 'setting/setting' );

$free_us = $this->config->get('ups_integration_free_us_method');

if ($free_us!=='NONE') {
    $us_code = $free_us;
    switch ($free_us) {
        case 'next_day_air':
            $us_code = '01';
            break;
        case	'2nd_day_air':
            $us_code = '02';
            break;
        case	'ground':
            $us_code = '03';
            break;
        case	'3_day_select':
            $us_code = '12';
            break;
        case	'next_day_air_saver':
            $us_code = '13';
            break;
        case	'next_day_air_early_am':
            $us_code = '14';
            break;
        case	'2nd_day_air_am':
            $us_code = '59';
            break;
    }

    $data['ups_integration_free_us_method'] = $us_code;
    $this->model_setting_setting->editSetting( 'ups_integration', $data );
}

$free_pr = $this->config->get('ups_integration_free_pr_method');

if ($free_pr!=='NONE') {
    $pr_code = $free_pr;
    switch ($free_pr) {
        case 'next_day_air':
            $pr_code = '01';
            break;
        case '2nd_day_air':
            $pr_code = '02';
            break;
        case 'ground':
            $pr_code = '03';
            break;
        case 'worldwide_express':
            $pr_code = '07';
            break;
        case 'worldwide_expedited':
            $pr_code = '08';
            break;
        case 'next_day_air_early_am':
            $pr_code = '14';
            break;
        case 'worldwide_express_plus':
            $pr_code = '54';
            break;
        case 'saver':
            $pr_code = '65';
            break;
    }
    $data['ups_integration_free_pr_method'] = $pr_code;
    $this->model_setting_setting->editSetting( 'ups_integration', $data );
}

$free_ca = $this->config->get('ups_integration_free_ca_method');

if ($free_ca!=='NONE') {
    $ca_code = $free_ca;
    switch ($free_ca) {
        case 'express':
            $ca_code = '01';
            break;
        case 'expedited':
            $ca_code = '02';
            break;
        case '3_day_select':
            $ca_code = '12';
            break;
        case 'express_early_am':
            $ca_code = '14';
            break;
        case 'next_day_air_saver':
            $ca_code = '13';
            break;
    }
    $data['ups_integration_free_ca_method'] = $ca_code;
    $this->model_setting_setting->editSetting( 'ups_integration', $data );
}

$free_mx = $this->config->get('ups_integration_free_mx_method');

if ($free_mx!=='NONE') {
    $mx_code = $free_mx;
    switch ($free_mx) {
        case 'express':
            $mx_code = '07';
            break;
        case 'expedited':
            $mx_code = '08';
            break;
        case 'standard':
            $mx_code = '11';
            break;
        case 'worldwide_express_plus':
            $mx_code = '54';
            break;
        case 'saver':
            $mx_code = '65';
            break;
    }
    $data['ups_integration_free_mx_method'] = $mx_code;
    $this->model_setting_setting->editSetting( 'ups_integration', $data );
}

$free_eu = $this->config->get('ups_integration_free_eu_method');

if ($free_eu!=='NONE') {
    $eu_code = $free_eu;
    switch ($free_eu) {
        case 'express':
            $eu_code = '07';
            break;
        case 'expedited':
            $eu_code = '08';
            break;
        case 'standard':
            $eu_code = '11';
            break;
        case 'express_plus':
            $eu_code = '54';
            break;
        case 'saver':
            $eu_code = '65';
            break;
    }
    $data['ups_integration_free_eu_method'] = $eu_code;
    $this->model_setting_setting->editSetting( 'ups_integration', $data );
}

$free_pl = $this->config->get('ups_integration_free_pl_method');

if ($free_pl!=='NONE') {
    $pl_code = $free_pl;
    switch ($free_pl) {
        case 'today_standard':
            $pl_code = '82';
            break;
        case 'today_dedicated_courier':
            $pl_code = '83';
            break;
        case 'today_express':
            $pl_code = '85';
            break;
        case 'today_express_saver':
            $pl_code = '86';
            break;
    }

    $data['ups_integration_free_pl_method'] = $pl_code;
    $this->model_setting_setting->editSetting( 'ups_integration', $data );
}

$free_other = $this->config->get('ups_integration_free_other_method');

if ($free_other!=='NONE') {
    $other_code = $free_other;
    switch ($free_other) {
        case 'express':
            $other_code = '07';
            break;
        case 'expedited':
            $other_code = '08';
            break;
        case 'standard':
            $other_code = '11';
            break;
        case 'worldwide_express_plus':
            $other_code = '54';
            break;
        case 'saver':
            $other_code = '65';
            break;
    }
    $data['ups_integration_free_other_method'] = $other_code;
    $this->model_setting_setting->editSetting( 'ups_integration', $data );
}

$exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('ups_integration_license') . "'");
if ($exist->num_rows === 1) {
    $this->db->query("DROP TABLE ".$this->db->table("ups_integration_license"));
}

if (file_exists(DIR_EXT.'ups_integration/admin/view/default/template/pages/extension/extensions_edit.tpl')) {
    unlink(DIR_EXT.'ups_integration/admin/view/default/template/pages/extension/extensions_edit.tpl');
}


if (!file_exists(DIR_SYSTEM.'lib/license.php')) {
    /**
     *  Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return array
     */
    function custom_copy($src, $dst) {
        $error = array();
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function
                    // for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                        $error['error_copy'][] = "Failed to copy $file";
                    }
                }
            }
        }
        if (sizeof($error)>0) {
            $log=new ALog(DIR_SYSTEM.'logs/error.txt');
            $log->write(var_export($error,true));
        }
        closedir($dir);
        return $error;
    }

    $copy = custom_copy(DIR_EXT . 'ups_integration' . DIR_EXT_CORE . 'lib/license', DIR_SYSTEM.'lib');
}