<?php

if (!IS_ADMIN || !defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ControllerResponsesExtensionTrackShipments extends AController
{
    public $data = [];

    public function tracksave()
    {
        $json = [];

        if (has_value($this->request->get['order_id'])) {
            $order = (int) $this->request->get['order_id'];
            //$this->log->write(json_encode($_REQUEST));

            $trcname = $_REQUEST['name'];
            $trcode = $_REQUEST['trackcode'];
            $trurl = $_REQUEST['urlcom'];
            $orderdata = $trcode . '|' . $trcname . '|' . $trurl;
            if ($order > 0) {
                $this->loadModel('sale/order');
                $order_info = $this->model_sale_order->getOrder($this->request->get['order_id']);

                // $this->log->write('controllerr+++'. serialize($order_info));
                $this->loadModel('extension/track_shipments');
                $this->loadLanguage('track_shipments/track_shipments');
                $sqlordr = $this->model_extension_track_shipments->processUpdateOrderData($this->request->get['order_id'], $orderdata);
                $notifydata = [];
                $notifydata['order_status_id'] = (int) $order_info['order_status_id'];
                $notifydata['comment'] = $this->language->get('tracking_number') . ': ' . $trcode . '
' . $this->language->get('shipping_company') . ': ' . $trcname . '
' . $this->language->get('url_shipping_company') . ': ' . urldecode($trurl);
                if ($this->config->get('notify_customer')) {
                    $notifydata['notify'] = '1';
                } else {
                    $notifydata['notify'] = '0';
                }
                if ($this->config->get('append_comments')) {
                    $notifydata['append'] = '1';
                }

                
                try {
                    $this->model_sale_order->addOrderHistory($this->request->get['order_id'], $notifydata);
                } catch (Exception $e) {
                    //
                }
            } else {
                // no data
                $this->session->data['error'] = $this->language->get('error_empty_data');
            }
        } else {
            // no order_id
            $this->session->data['error'] = $this->language->get('error_no_order_id');
        }

        $json['href'] = $this->html->getSecureURL('sale/order/details', '&order_id=' . (int) $this->request->get['order_id']);

        $this->load->library('json');
        $this->response->setOutput(AJson::encode($json));
    }
}
