<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

$mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
$diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
$shared_secret = "taxid_option";

$public_key = "";
$path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

if ($this->config->get('taxid_option_license_code')) {
    $license_key = $this->config->get('taxid_option_license_code');
    $license = new License($path_to_phpseclib);
    $license_manager = $license->getManager();
    if (stripos($license_key, 'mc-') !== false) {
        $server_url = $mc_server_url;
    } else {
        $server_url = $diy_server_url;
    }
    $license_manager->setLicenseServerUrl($server_url);
    $license_manager->setKeys($license_key, "", $shared_secret);
    $public_key = $license_manager->requestKey();
    $this->load->model('extension/taxid_option_license_info');

    $store_id = (int)$this->config->get('config_store_id');

    $license_manager->setKeys($license_key, $public_key, $shared_secret);
    $custom_data = ['version' => '1.3.3.2'];
    $license_data = $license_manager->requestData($custom_data);
    if (!is_null($license_data)) {
        $ttl = 1209600;
        $validate = $license_manager->validate($license_data, $ttl);

        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
            $data['public_key'] = $public_key;
            $data['license_data'] = $license_data;
            $data['license_key'] = $license_key;
            $data['store_id'] = $store_id;
            $data['last_check'] = time();
            $this->load->model('extension/taxid_option_license_info');
            $this->model_extension_taxid_option_license_info->saveLicenseData($data);
        }
    }
}

if (!file_exists(DIR_ROOT.'/taxid_option_email_template_backup')) {
    mkdir(DIR_ROOT . '/taxid_option_email_template_backup', 0755);
}

$language = Registry::getInstance()->get('language');

$languageId = $language->getContentLanguageID();

$emailTemplate1 = $this->db->query("SELECT * FROM ".$this->db->table('email_templates') ." WHERE text_id='storefront_order_confirm' and language_id=".$languageId." And status=1 LIMIT 1");
$query1 = $emailTemplate1->row;
$html_body1 = $query1['html_body'];
$text_body1 = $query1['text_body'];
$allowed_placeholders1 = $query1['allowed_placeholders'];

$current_date = ' '.date("Y-m-d H-i-s");

$sf_html_body = fopen(DIR_ROOT . '/taxid_option_email_template_backup/storefront_order_confirm_html_body'.$current_date.'.txt', "w") or die("Unable to open file!");
$sf_html_body_content = html_entity_decode($html_body1);
fwrite($sf_html_body, $sf_html_body_content);
fclose($sf_html_body);

$sf_text_body = fopen(DIR_ROOT . '/taxid_option_email_template_backup/storefront_order_confirm_text_body'.$current_date.'.txt', "w") or die("Unable to open file!");
$sf_text_body_content = html_entity_decode($text_body1);
fwrite($sf_text_body, $sf_text_body_content);
fclose($sf_text_body);

$sf_allowed_placeholders = fopen(DIR_ROOT . '/taxid_option_email_template_backup/storefront_order_confirm_allowed_placeholders'.$current_date.'.txt', "w") or die("Unable to open file!");
$sf_allowed_placeholders_content = $allowed_placeholders1;
fwrite($sf_allowed_placeholders, $sf_allowed_placeholders_content);
fclose($sf_allowed_placeholders);

$emailTemplate2 = $this->db->query("SELECT * FROM ".$this->db->table('email_templates') ." WHERE text_id='storefront_order_confirm_admin_notify' and language_id=".$languageId." And status=1 LIMIT 1");
$query2 = $emailTemplate2->row;
$html_body2 = $query2['html_body'];
$text_body2 = $query2['text_body'];
$allowed_placeholders2 = $query2['allowed_placeholders'];

$admin_html_body = fopen(DIR_ROOT . '/taxid_option_email_template_backup/storefront_order_confirm_admin_notify_html_body'.$current_date.'.txt', "w") or die("Unable to open file!");
$admin_html_body_content = html_entity_decode($html_body2);
fwrite($admin_html_body, $admin_html_body_content);
fclose($admin_html_body);

$admin_text_body = fopen(DIR_ROOT . '/taxid_option_email_template_backup/storefront_order_confirm_admin_notify_text_body'.$current_date.'.txt', "w") or die("Unable to open file!");
$admin_text_body_content = html_entity_decode($text_body2);
fwrite($admin_text_body, $admin_text_body_content);
fclose($admin_text_body);

$admin_allowed_placeholders = fopen(DIR_ROOT . '/taxid_option_email_template_backup/storefront_order_confirm_admin_notify_allowed_placeholders'.$current_date.'.txt', "w") or die("Unable to open file!");
$admin_allowed_placeholders_content = $allowed_placeholders2;
fwrite($admin_allowed_placeholders, $admin_allowed_placeholders_content);
fclose($admin_allowed_placeholders);

$sql = "UPDATE ".$this->db->table('language_definitions')." set language_value='
    This is a WHY2 extension.  All support and updates are managed from WHY2. <br>
        Read about WHY2\'s 12 months support <a href=\"https://why2central.net/knowledgebase/why2-support-and-updates-policy/\" target=\"_blank\" style=\"font-weight:bold;\">here</a> and how WHY2 updates are delivered <a href=\"https://why2central.net/knowledgebase/extension-updater/\" target=\"_blank\" style=\"font-weight:bold;\">here</a>.<br>
        You can safely ignore Support expired notification within the Admin Dashboard.<br><br>
This extension helps you to change telephone, fax, company or VAT/Tax ID field become a mandatory field. Both storefront and admin are changed.<br>
     <strong>Notes: There are two ways to obtain the license key. <br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;a. Use this <a href=\"https://wehearyou2.com/clientarea/reg/register.php\" target=\"_blank\" style=\"font-weight:bold;\">form</a> to register to our Support system and generate your license key.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;b. Already registered -  click <a href=\"https://wehearyou2.com/clientarea/reg/index.php\" target=\"_blank\" style=\"font-weight:bold;\">here</a> to log into your account to obtain license key.<br>
        Refer to our <a href=\"https://why2central.net/faq/license-key/\" target=\"_BLANK\">F.A.Q</a> for more information on how to obtain the license key.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;c. If you already have an account in our support system and you are using multiple extensions from WHY2,  you do NOT need to create another account in the support system.<br>
        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;d. Updating extension in same location does NOT require a new key .<br > Refer to our <a href=\"https://why2central.net/faq/license-key/\" target=\"_BLANK\">F.A.Q</a> for more information on how to Update extension in same location .</strong ><br><br>
        1.&nbsp;Enter your WHY2 license key here.<br>
     2.&nbsp;Turn ON if you require customer or guest to enter their phone number.<br>
     3.&nbsp;Turn ON if you require customer or guest to enter their fax number.<br>
     4.&nbsp;Enter the text that will be used for the fax field information.<br>
     5.&nbsp;Turn ON if you require customer or guest to enter their company name.<br>
     6.&nbsp;Enter the text that will be used for the company field information.<br>
     7.&nbsp;Turn ON if you require customer or guest to enter their VAT/Tax ID.<br>
     8.&nbsp;Enter the text that will be used for the VAT/Tax ID field information.<br>
     9.&nbsp;Turn ON to add the registration number field.<br>
     10.&nbsp;Turn ON if you require customer or guest to enter their Company/Personal registration number.<br>
     11.&nbsp;Enter the text that will be used for the Company/Personal field information.<br>
     12.&nbsp;Turn ON to add the Bank Name field.<br>
     13.&nbsp;Turn ON if you require customer or guest to enter their Bank Name.<br>
     14.&nbsp;Enter the text that will be used for the Bank Name field information.<br>
     15.&nbsp;Turn ON to add the Bank Address field.<br>
     16.&nbsp;Turn ON if you require customer or guest to enter their Bank Address.<br>
     17.&nbsp;Enter the text that will be used for the Bank Address field information.<br>
     18.&nbsp;Turn ON to add the IBAN Code field.<br>
     19.&nbsp;Turn ON if you require customer or guest to enter their IBAN Code.<br>
     20.&nbsp;Enter the text that will be used for the IBAN Code field information.<br>
     21.&nbsp;Turn ON to add the SWIFT Code field.<br>
     22.&nbsp;Turn ON if you require customer or guest to enter their SWIFT Code.<br>
     23.&nbsp;Enter the text that will be used for the SWIFT Code field information.<br>
     24.&nbsp;Turn ON to show the VAT/Tax ID text in the order confirmation email / invoice page.<br>
     25.&nbsp;Enter your desired text, if any, to precede the VAT/Tax ID number on the order confirmation email to customer.<br>
     26.&nbsp;Turn ON to show the Registration Number text in the order confirmation email / invoice page.<br>
     27.&nbsp;Enter your desired text, if any, to precede the Registration Number on the order confirmation email to customer.<br>
     28.&nbsp;Turn ON to show the Bank Name text in the order confirmation email / invoice page.<br>
     29.&nbsp;Enter your desired text, if any, to precede the Bank Name on the order confirmation email to customer.<br>
     30.&nbsp;Turn ON to show the Bank Address text in the order confirmation email / invoice page.<br>
     31.&nbsp;Enter your desired text, if any, to precede the Bank Address on the order confirmation email to customer.<br>
     32.&nbsp;Turn ON to show the IBAN text in the order confirmation email / invoice page.<br>
     33.&nbsp;Enter your desired text, if any, to precede the IBAN code on the order confirmation email to customer.<br>
     34.&nbsp;Turn ON to show the SWIFT text in the order confirmation email / invoice page.<br>
     35.&nbsp;Enter your desired text, if any, to precede the SWIFT code on the order confirmation email to customer.<br>
     36.&nbsp;Turn ON if you want to show your company information in order confirmation email.<br>
     37.&nbsp;Enter your company info (name, address, phone, VAT/Tax ID, etc.) you want to be shown in the order confirmation email and admin invoice page.' WHERE language_key='taxid_option_note';";
$this->db->query($sql);

if (file_exists(DIR_EXT.'build_a_gift')) {
    $this->db->query("UPDATE ".$this->db->table("email_templates")." SET `html_body`='<html>
<head>
    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">
    <title> {{store_name}} - Order {{ order_id }} </title>
</head>
<body>
<table style=\"font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;\">
    <tr>
        <td class=\"align_left\">
            <a href=\"{{ store_url }}\" title=\"{{ store_name }}\">
                {{# logo_uri}}
                <img src=\"{{ logo_uri }}\" alt=\"{{store_name}}\" style=\"border: none;\">
                {{/ logo_uri}}
                {{^ logo_uri}}
                {{# logo_html}}
                {{logo_html}}
                {{/ logo_html}}
                {{/ logo_uri}}
            </a>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">Thank you for your interest in {{store_name}} products. Your order has been received and
            will be processed after payment is confirmed.
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color:#FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">Order
            Details
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">
            <table style=\"width: 100%;\">
                <tr>
                    <td style=\"width: 60%;\">
                        Order ID: <span
                            style=\"color: #069; font-weight: bold;\">{{ order_id }}</span><br/>
                        Date Ordered: {{ date_added }}<br>
                        Payment Method: <strong>{{ payment_method }}</strong><br/>
                        Shipping Method: <strong>{{{ shipping_method }}}</strong><br/>
                        <br/>
                    </td>
                    <td style=\"width: 40%;\">
                        {{# seller_info }}
                        <strong>Ordered From:<br> {{{ seller_info }}}</strong>
                        {{/ seller_info }}
                    </td>
                </tr>
            </table>
            <table style=\"width: 100%;\">
                <tr>
                    <td style=\"width: 60%;\">
                        Email: <strong>{{ customer_email }}</strong><br/>
                        Telephone: <strong>{{ customer_telephone }}</strong><br/>
                        {{# customer_mobile_phone }}
                        Telephone: <strong>{{ customer_mobile_phone }}</strong><br/>
                        {{/ customer_mobile_phone }}
                        {{# customer_fax }}
                        Fax: <strong>{{ customer_fax }}</strong><br/>
                        {{/ customer_fax }}
                        IP Address:<strong>{{ customer_ip }}</strong>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td>
            <table style=\"width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #FFFFFF;\">
                <tr style=\"background-color: #CCCCCC; text-transform: uppercase;\">
                    <th style=\"text-align: left; padding: 0.3em;\">Shipping Address</th>
                    <th style=\"text-align: left; padding: 0.3em;\">Payment Address</th>
                </tr>
                <tr>
                    <td style=\"padding: 0.3em; background-color: #EEEEEE; color: #000;\">
                        {{# shipping_data }}
                        {{ firstname }} {{lastname}} <br/>
                        {{# company }}
                        {{{ company }}} <br/>
                        {{/ company }}
                        {{# address_1 }}
                        {{{ address_1 }}} <br/>
                        {{/ address_1 }}
                        {{# address_2 }}
                        {{{ address_2 }}} <br/>
                        {{/ address_2 }}
                        {{{ city }}} {{{ postcode }}} <br/>
                        {{# zone }}
                        {{{ zone }}} <br/>
                        {{/ zone }}
                        {{{ country }}}
                        {{/ shipping_data }}
                    </td>
                    <td style=\"padding: 0.3em; background-color: #EEEEEE; color: #000;\">
                        {{# payment_data }}
                        {{ firstname }} {{lastname}} <br/>
                        {{# company }}
                        {{{ company }}} <br/>
                        {{/ company }}
                        {{# taxid }}
                        {{{ taxid }}} <br/>
                        {{/ taxid }}
                        {{# address_1 }}
                        {{{ address_1 }}} <br/>
                        {{/ address_1 }}
                        {{# address_2 }}
                        {{{ address_2 }}} <br/>
                        {{/ address_2 }}
                        {{{ city }}} {{{ postcode }}} <br/>
                        {{# zone }}
                        {{{ zone }}} <br/>
                        {{/ zone }}
                        {{{ country }}}<br/>
                        {{# registration }}
                        {{ registration }} <br/>
                        {{/ registration }}
                        {{# bank_name }}
                        {{ bank_name }} <br/>
                        {{/ bank_name }}
                        {{# bank_address }}
                        {{ bank_address }} <br/>
                        {{/ bank_address }}
                        {{# iban }}
                        {{ iban }} <br/>
                        {{/ iban }}
                        {{# swift }}
                        {{ swift }} <br/>
                        {{/ swift }}
                        {{/ payment_data }}
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">
            <table style=\"width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #000000;\">
                <tr style=\"background-color: #CCCCCC;\">
                    <th style=\"width: 40%; padding: 0.3em; color: #FFFFFF;\">Product</th>
                    <th class=\"align_left\" style=\"color: #FFFFFF;\">Model</th>
                    <th class=\"align_right\"
                        style=\"width: 10%; padding: 0.3em; color: #FFFFFF;\">Price
                    </th>
                    <th class=\"align_right\"
                        style=\"width: 15%; padding: 0.3em; color: #FFFFFF;\">Quantity
                    </th>
                    <th class=\"align_right\"
                        style=\"width: 20%; padding: 0.3em; color: #FFFFFF;\">Total
                    </th>
                </tr>
                {{# products }}
                <tr style=\"background-color: #EEEEEE; text-align: center;\">
                    <td class=\"align_left\" style=\"text-align: left;\">{{ name }}
                        {{# option }}
                        <br/>
                        &nbsp;&nbsp;- {{ name}} {{ value }}
                        {{# link }}
                        <br> &nbsp;&nbsp;{{{ link }}}
                        {{/ link}}
                        {{/ option }}
                        {{# message }} <br><br> <strong>Gift Message: </strong><br> {{ message }} {{/ message }}
                    <td class=\"align_left\"> {{ model }}</td>
                    <td class=\"align_right\"> {{ price }}</td>
                    <td class=\"align_right\"> {{ quantity }}</td>
                    <td class=\"align_right\"> {{ total }}</td>
                </tr>
                {{# child_products }}
                {{{ child_products }}}
                {{/ child_products }}
                {{/ products }}
                {{# totals }}
                <tr style=\"text-align: right;\">
                    <td colspan=\"3\">&nbsp;</td>
                    <td style=\"background-color: #EEEEEE; font-weight: bold; padding: 0.3em;\">{{{ title }}}</td>
                    <td style=\"background-color: #EEEEEE; padding: 0.3em;\"> {{ text }}</td>
                </tr>
                {{/ totals }}
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\"></td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{# comment }}
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">The
            comments for your order are:
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"> {{{ comment }}}</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{/ comment }}
    {{# invoice }}
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">To view
            your order click on the link below:
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"><a href=\"{{ invoice }}\"> {{ invoice }}</a></td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{/ invoice }}
    <tr>
        <td class=\"align_center\"
            style=\"font-size: 10px; border-top: 1px solid #069; text-decoration: none; color: #374953;\">
            <a href=\"{{ store_url }}\"
               style=\"color: #069; font-weight: bold; text-decoration: none;\">{{ store_name }}</a>
            {{{ text_project_label }}}
        </td>
    </tr>
</table>
</body>
</html>',
`text_body`='Thank you for your interest in {{store_name}} products. Your order has been received and will be processed after payment is confirmed.\r\n\r\nOrder Details\r\n\r\nOrder ID: {{ order_id }}\r\nDate Ordered: {{ date_added }}\r\nPayment Method: {{ payment_method }}\r\nShipping Method: {{{ shipping_method }}}\r\n\r\nEmail: {{ customer_email }}\r\nTelephone: {{ customer_telephone }}\r\n{{# customer_mobile_phone }}\r\nTelephone: {{ customer_mobile_phone }}\r\n{{/ customer_mobile_phone }}\r\n{{# customer_fax }}\r\nFax: {{ customer_fax }}\r\n{{/ customer_fax }}\r\nIP Address: {{ customer_ip }}\r\n{{# seller_info }}\r\nOrdered From: {{{ seller_info }}}\r\n{{/ seller_info }}\r\n\r\n{{# shipping_data }}\r\nShipping Address:\r\n{{{ firstname }}} {{{lastname}}}\r\n{{{ company }}} \r\n{{{ address_1 }}} \r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{/ shipping_data }}\r\n\r\n{{# payment_data }}\r\nPayment Address:\r\n{{{ firstname }}} {{{lastname}}}\r\n{{{ company }}} \r\n{{# taxid }}\r\n{{{ taxid }}}\r\n{{/ taxid }}\r\n{{{ address_1 }}} \r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{# registration }}\r\n{{ registration }}  \r\n{{/ registration }}\r\n{{# bank_name }}\r\n{{ bank_name }}  \r\n{{/ bank_name }}\r\n{{# bank_address }}\r\n{{ bank_address }}  \r\n{{/ bank_address }}\r\n{{# iban }}\r\n{{ iban }}  \r\n{{/ iban }}\r\n{{# swift }}\r\n{{ swift }}  \r\n{{/ swift }}\r\n{{/ payment_data }}\r\n\r\n\r\nProduct                                                 Model                             Price                  Quantity              Total\r\n{{# products }}\r\n					\r\n{{ name }}                                               {{ model }}                       {{ price }}            {{ quantity }}        {{ total }}\r\n   {{# option }}\r\n    - {{ name}} {{ value }}\r\n{{# link }}\r\n{{{ link }}}\r\n                        {{/ link}}\r\n{{/ option }}\r\n {{# message }} \r\n<strong>Gift Message: </strong>\r\n {{ message }}\r\n {{/ message }}\r\n\r\n\r\n{{# child_products }} \r\n {{{ child_products }}} \r\n {{/ child_products }} \r\n {{/ products }}\r\n{{# totals }}\r\n  {{{ title }}}  {{ text }}\r\n{{/ totals }}\r\n\r\n\r\n{{# comment }}\r\n	The comments for your order are:\r\n {{{ comment }}} \r\n{{/ comment }}\r\n\r\n{{# invoice }}\r\nTo view your order click on the link below:\r\n{{ invoice }}\r\n{{/ invoice }}\r\n\r\n{{ store_name }}\r\n{{ text_project_label }}',
`allowed_placeholders`='store_name, order_id, store_url, logo_uri, logo_html, date_added, payment_method, shipping_method, customer_email, customer_telephone, customer_mobile_phone, customer_fax, customer_ip, shipping_data, payment_data, products, totals, comment, invoice,  text_project_label, seller_info' WHERE `text_id`='storefront_order_confirm'");

    $this->db->query("UPDATE ".$this->db->table("email_templates")." SET
    `html_body`='<html>
<head>
    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">
    <title> {{store_name}} - Order {{ order_id }} </title>
</head>
<body>
<table style=\"font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;\">
    <tr>
        <td class=\"align_left\">
            <a href=\"{{ store_url }}\" title=\"{{ store_name }}\">
                {{# logo_uri}}
                <img src=\"{{ logo_uri }}\" alt=\"{{store_name}}\" style=\"border: none;\">
                {{/ logo_uri}}
                {{^ logo_uri}}
                {{# logo_html}}
                {{logo_html}}
                {{/ logo_html}}
                {{/ logo_uri}}
            </a>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">You have received an order.</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color:#FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">Order Details</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td>
            <table style=\"width: 100%;\">
                <tr>
                    <td style=\"width: 60%;\">
                        Order ID: <span
                            style=\"color: #069; font-weight: bold;\">{{ order_id }}</span><br/>
                        Date Ordered: {{ date_added }}<br>
                        Payment Method: <strong>{{ payment_method }}</strong><br/>
                        Shipping Method: <strong>{{{ shipping_method }}}</strong><br/>
                        <br/>
                    </td>
                    <td style=\"width: 40%;\">
                        {{# seller_info }}
                        <strong>Ordered From:<br> {{{ seller_info }}}</strong>
                        {{/ seller_info }}
                    </td>
                </tr>
            </table>
            <table style=\"width: 100%;\">
                <tr>
                    <td style=\"width: 60%;\">
                        Email: <strong>{{ customer_email }}</strong><br/>
                        Telephone: <strong>{{ customer_telephone }}</strong><br/>
                        {{# customer_mobile_phone }}
                        Telephone: <strong>{{ customer_mobile_phone }}</strong><br/>
                        {{/ customer_mobile_phone }}
                        {{# customer_fax }}
                        Fax: <strong>{{ customer_fax }}</strong><br/>
                        {{/ customer_fax }}
                        IP Address:<strong>{{ customer_ip }}</strong>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td>
            <table style=\"width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #FFFFFF;\">
                <tr style=\"background-color: #CCCCCC; text-transform: uppercase;\">
                    <th style=\"text-align: left; padding: 0.3em;\">Shipping Address</th>
                    <th style=\"text-align: left; padding: 0.3em;\">Payment Address</th>
                </tr>
                <tr>
                    <td style=\"padding: 0.3em; background-color: #EEEEEE; color: #000;\">
                        {{# shipping_data }}
                        {{ firstname }} {{lastname}} <br/>
                        {{# company }}
                        {{{ company }}} <br/>
                        {{/ company }}
                        {{# address_1 }}
                        {{{ address_1 }}} <br/>
                        {{/ address_1 }}
                        {{# address_2 }}
                        {{{ address_2 }}} <br/>
                        {{/ address_2 }}
                        {{{ city }}} {{{ postcode }}} <br/>
                        {{# zone }}
                        {{{ zone }}} <br/>
                        {{/ zone }}
                        {{{ country }}}
                        {{/ shipping_data }}
                    </td>
                    <td style=\"padding: 0.3em; background-color: #EEEEEE; color: #000;\">
                        {{# payment_data }}
                        {{ firstname }} {{lastname}} <br/>
                        {{# company }}
                        {{{ company }}} <br/>
                        {{/ company }}
                        {{# taxid }}
                        {{{ taxid }}} <br/>
                        {{/ taxid }}
                        {{# address_1 }}
                        {{{ address_1 }}} <br/>
                        {{/ address_1 }}
                        {{# address_2 }}
                        {{{ address_2 }}} <br/>
                        {{/ address_2 }}
                        {{{ city }}} {{{ postcode }}} <br/>
                        {{# zone }}
                        {{{ zone }}} <br/>
                        {{/ zone }}
                        {{{ country }}}<br/>
                        {{# registration }}
                        {{ registration }} <br/>
                        {{/ registration }}
                        {{# bank_name }}
                        {{ bank_name }} <br/>
                        {{/ bank_name }}
                        {{# bank_address }}
                        {{ bank_address }} <br/>
                        {{/ bank_address }}
                        {{# iban }}
                        {{ iban }} <br/>
                        {{/ iban }}
                        {{# swift }}
                        {{ swift }} <br/>
                        {{/ swift }}
                        {{/ payment_data }}
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">
            <table style=\"width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #000000;\">
                <tr style=\"background-color: #CCCCCC;\">
                    <th style=\"width: 40%; padding: 0.3em; color: #FFFFFF;\">Product</th>
                    <th class=\"align_left\" style=\"color: #FFFFFF;\">Model</th>
                    <th class=\"align_right\"
                        style=\"width: 10%; padding: 0.3em; color: #FFFFFF;\">Price</th>
                    <th class=\"align_right\"
                        style=\"width: 15%; padding: 0.3em; color: #FFFFFF;\">Quantity</th>
                    <th class=\"align_right\"
                        style=\"width: 20%; padding: 0.3em; color: #FFFFFF;\">Total</th>
                </tr>
                {{# products }}
                <tr style=\"background-color: #EEEEEE; text-align: center;\">
                    <td class=\"align_left\" style=\"text-align: left;\">{{ name }}
                        {{# option }}
                        <br/>
                        &nbsp;&nbsp;- {{ name}} {{ value }}
                        {{# link }}
                        <br> &nbsp;&nbsp;{{{ link }}}
                        {{/ link}}
                        {{/ option }}
                        {{# message }} <br><br> <strong>Gift Message: </strong><br> {{ message }} {{/ message }}
                    <td class=\"align_left\"> {{ model }} </td>
                    <td class=\"align_right\"> {{ price }} </td>
                    <td class=\"align_right\"> {{ quantity }} </td>
                    <td class=\"align_right\"> {{ total }}</td>
                </tr>
                {{# child_products }}
                {{{ child_products }}}
                {{/ child_products }}
                {{/ products }}
                {{# totals }}
                <tr style=\"text-align: right;\">
                    <td colspan=\"3\">&nbsp;</td>
                    <td style=\"background-color: #EEEEEE; font-weight: bold; padding: 0.3em;\">{{{ title }}} </td>
                    <td style=\"background-color: #EEEEEE; padding: 0.3em;\"> {{ text }}</td>
                </tr>
                {{/ totals }}
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\"></td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{# comment }}
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">The comments for your order are:</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"> {{{ comment }}} </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{/ comment }}
    {{# invoice }}
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">To view your order click on the link below:</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"><a href=\"{{ invoice }}\"> {{ invoice }}</a></td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{/ invoice }}
    <tr>
        <td class=\"align_center\"
            style=\"font-size: 10px; border-top: 1px solid #069; text-decoration: none; color: #374953;\">
            <a href=\"{{ store_url }}\"
               style=\"color: #069; font-weight: bold; text-decoration: none;\">{{ store_name }}</a>
            {{{ text_project_label }}}
        </td>
    </tr>
</table>
</body>
</html>',
`text_body`='You have received an order.\r\n\r\nOrder Details\r\n\r\nOrder ID: {{ order_id }}\r\nDate Ordered: {{ date_added }}\r\nPayment Method: {{ payment_method }}\r\nShipping Method: {{{ shipping_method }}}\r\n\r\nEmail: {{ customer_email }}\r\nTelephone: {{ customer_telephone }}\r\n{{# customer_mobile_phone }}\r\nTelephone: {{ customer_mobile_phone }}\r\n{{/ customer_mobile_phone }}\r\n{{# customer_fax }}\r\nFax: {{ customer_fax }}\r\n{{/ customer_fax }}\r\nIP Address: {{ customer_ip }}\r\n{{# seller_info }}\r\nOrdered From: {{{ seller_info }}}\r\n{{/ seller_info }}\r\n\r\n{{# shipping_data }}\r\nShipping Address:\r\n{{{ firstname }}} {{{lastname}}}\r\n{{{ company }}}\r\n\r\n{{{ address_1 }}} \r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{/ shipping_data }}\r\n\r\n{{# payment_data }}\r\nPayment Address:\r\n{{{ firstname }}} {{{lastname}}} \r\n{{{ company }}}\r\n{{# taxid }}\r\n{{{ taxid }}}\r\n{{/ taxid }}\r\n{{{ address_1 }}}\r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{# registration }}\r\n{{ registration }}  \r\n{{/ registration }}\r\n{{# bank_name }}\r\n{{ bank_name }}  \r\n{{/ bank_name }}\r\n{{# bank_address }}\r\n{{ bank_address }}  \r\n{{/ bank_address }}\r\n{{# iban }}\r\n{{ iban }}  \r\n{{/ iban }}\r\n{{# swift }}\r\n{{ swift }}  \r\n{{/ swift }}\r\n{{/ payment_data }}\r\n\r\n\r\nProduct                                                 Model                             Price                  Quantity              Total\r\n{{# products }}\r\n					\r\n{{ name }}                                               {{ model }}                       {{ price }}            {{ quantity }}        {{ total }}\r\n   {{# option }}\r\n    - {{ name}} {{ value }} \r\n{{# link }} \r\n  {{{ link }}} \r\n {{/ link}}\r\n   {{/ option }} \r\n\r\n {{# message }} \r\n Gift Message: \r\n {{ message }} \r\n {{/ message }} \r\n \r\n\ {{# child_products }} \r\n {{{ child_products }}} \r\n {{/ child_products }} \r\n {{/ products }}\r\n{{# totals }}\r\n  {{{ title }}}  {{ text }}\r\n{{/ totals }}\r\n\r\n\r\n{{# comment }}\r\n	The comments for your order are:\r\n {{{ comment }}} \r\n{{/ comment }}\r\n\r\n{{# invoice }}\r\nTo view your order click on the link below:\r\n{{ invoice }}\r\n{{/ invoice }}\r\n\r\n{{ store_name }}\r\n{{ text_project_label }}',
`allowed_placeholders`='store_name, order_id, store_url, logo_uri, logo_html, date_added, payment_method, shipping_method, customer_email, customer_telephone, customer_mobile_phone, customer_fax, customer_ip, shipping_data, payment_data, products, totals, comment, invoice,  text_project_label, order_total, seller_info' WHERE `text_id`='storefront_order_confirm_admin_notify'");
} else {
    $this->db->query("UPDATE ".$this->db->table("email_templates")." SET `html_body`='<html>
<head>
    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">
    <title> {{store_name}} - Order {{ order_id }} </title>
</head>
<body>
<table style=\"font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;\">
    <tr>
        <td class=\"align_left\">
            <a href=\"{{ store_url }}\" title=\"{{ store_name }}\">
                {{# logo_uri}}
                <img src=\"{{ logo_uri }}\" alt=\"{{store_name}}\" style=\"border: none;\">
                {{/ logo_uri}}
                {{^ logo_uri}}
                {{# logo_html}}
                {{logo_html}}
                {{/ logo_html}}
                {{/ logo_uri}}
            </a>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">Thank you for your interest in {{store_name}} products. Your order has been received and
            will be processed after payment is confirmed.
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color:#FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">Order
            Details
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">
            <table style=\"width: 100%;\">
                <tr>
                    <td style=\"width: 60%;\">
                        Order ID: <span
                            style=\"color: #069; font-weight: bold;\">{{ order_id }}</span><br/>
                        Date Ordered: {{ date_added }}<br>
                        Payment Method: <strong>{{ payment_method }}</strong><br/>
                        Shipping Method: <strong>{{{ shipping_method }}}</strong><br/>
                        <br/>
                    </td>
                    <td style=\"width: 40%;\">
                        {{# seller_info }}
                        <strong>Ordered From:<br> {{{ seller_info }}}</strong>
                        {{/ seller_info }}
                    </td>
                </tr>
            </table>
            <table style=\"width: 100%;\">
                <tr>
                    <td style=\"width: 60%;\">
                        Email: <strong>{{ customer_email }}</strong><br/>
                        Telephone: <strong>{{ customer_telephone }}</strong><br/>
                        {{# customer_mobile_phone }}
                        Telephone: <strong>{{ customer_mobile_phone }}</strong><br/>
                        {{/ customer_mobile_phone }}
                        {{# customer_fax }}
                        Fax: <strong>{{ customer_fax }}</strong><br/>
                        {{/ customer_fax }}
                        IP Address:<strong>{{ customer_ip }}</strong>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td>
            <table style=\"width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #FFFFFF;\">
                <tr style=\"background-color: #CCCCCC; text-transform: uppercase;\">
                    <th style=\"text-align: left; padding: 0.3em;\">Shipping Address</th>
                    <th style=\"text-align: left; padding: 0.3em;\">Payment Address</th>
                </tr>
                <tr>
                    <td style=\"padding: 0.3em; background-color: #EEEEEE; color: #000;\">
                        {{# shipping_data }}
                        {{ firstname }} {{lastname}} <br/>
                        {{# company }}
                        {{{ company }}} <br/>
                        {{/ company }}
                        {{# address_1 }}
                        {{{ address_1 }}} <br/>
                        {{/ address_1 }}
                        {{# address_2 }}
                        {{{ address_2 }}} <br/>
                        {{/ address_2 }}
                        {{{ city }}} {{{ postcode }}} <br/>
                        {{# zone }}
                        {{{ zone }}} <br/>
                        {{/ zone }}
                        {{{ country }}}
                        {{/ shipping_data }}
                    </td>
                    <td style=\"padding: 0.3em; background-color: #EEEEEE; color: #000;\">
                        {{# payment_data }}
                        {{ firstname }} {{lastname}} <br/>
                        {{# company }}
                        {{{ company }}} <br/>
                        {{/ company }}
                        {{# taxid }}
                        {{{ taxid }}} <br/>
                        {{/ taxid }}
                        {{# address_1 }}
                        {{{ address_1 }}} <br/>
                        {{/ address_1 }}
                        {{# address_2 }}
                        {{{ address_2 }}} <br/>
                        {{/ address_2 }}
                        {{{ city }}} {{{ postcode }}} <br/>
                        {{# zone }}
                        {{{ zone }}} <br/>
                        {{/ zone }}
                        {{{ country }}}<br/>
                        {{# registration }}
                        {{ registration }} <br/>
                        {{/ registration }}
                        {{# bank_name }}
                        {{ bank_name }} <br/>
                        {{/ bank_name }}
                        {{# bank_address }}
                        {{ bank_address }} <br/>
                        {{/ bank_address }}
                        {{# iban }}
                        {{ iban }} <br/>
                        {{/ iban }}
                        {{# swift }}
                        {{ swift }} <br/>
                        {{/ swift }}
                        {{/ payment_data }}
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">
            <table style=\"width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #000000;\">
                <tr style=\"background-color: #CCCCCC;\">
                    <th style=\"width: 40%; padding: 0.3em; color: #FFFFFF;\">Product</th>
                    <th class=\"align_left\" style=\"color: #FFFFFF;\">Model</th>
                    <th class=\"align_right\"
                        style=\"width: 10%; padding: 0.3em; color: #FFFFFF;\">Price
                    </th>
                    <th class=\"align_right\"
                        style=\"width: 15%; padding: 0.3em; color: #FFFFFF;\">Quantity
                    </th>
                    <th class=\"align_right\"
                        style=\"width: 20%; padding: 0.3em; color: #FFFFFF;\">Total
                    </th>
                </tr>
                {{# products }}
                <tr style=\"background-color: #EEEEEE; text-align: center;\">
                    <td class=\"align_left\" style=\"text-align: left;\">{{ name }}
                        {{# option }}
                        <br/>
                        &nbsp;&nbsp;- {{ name}} {{ value }}
                        {{# link }}
                        <br> &nbsp;&nbsp;{{{ link }}}
                        {{/ link}}
                        {{/ option }}
                    <td class=\"align_left\"> {{ model }}</td>
                    <td class=\"align_right\"> {{ price }}</td>
                    <td class=\"align_right\"> {{ quantity }}</td>
                    <td class=\"align_right\"> {{ total }}</td>
                </tr>
                {{/ products }}
                {{# totals }}
                <tr style=\"text-align: right;\">
                    <td colspan=\"3\">&nbsp;</td>
                    <td style=\"background-color: #EEEEEE; font-weight: bold; padding: 0.3em;\">{{{ title }}}</td>
                    <td style=\"background-color: #EEEEEE; padding: 0.3em;\"> {{ text }}</td>
                </tr>
                {{/ totals }}
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\"></td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{# comment }}
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">The
            comments for your order are:
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"> {{{ comment }}}</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{/ comment }}
    {{# invoice }}
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">To view
            your order click on the link below:
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"><a href=\"{{ invoice }}\"> {{ invoice }}</a></td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{/ invoice }}
    <tr>
        <td class=\"align_center\"
            style=\"font-size: 10px; border-top: 1px solid #069; text-decoration: none; color: #374953;\">
            <a href=\"{{ store_url }}\"
               style=\"color: #069; font-weight: bold; text-decoration: none;\">{{ store_name }}</a>
            {{{ text_project_label }}}
        </td>
    </tr>
</table>
</body>
</html>',
`text_body`='Thank you for your interest in {{store_name}} products. Your order has been received and will be processed after payment is confirmed.\r\n\r\nOrder Details\r\n\r\nOrder ID: {{ order_id }}\r\nDate Ordered: {{ date_added }}\r\nPayment Method: {{ payment_method }}\r\nShipping Method: {{{ shipping_method }}}\r\n\r\nEmail: {{ customer_email }}\r\nTelephone: {{ customer_telephone }}\r\n{{# customer_mobile_phone }}\r\nTelephone: {{ customer_mobile_phone }}\r\n{{/ customer_mobile_phone }}\r\n{{# customer_fax }}\r\nFax: {{ customer_fax }}\r\n{{/ customer_fax }}\r\nIP Address: {{ customer_ip }}\r\n{{# seller_info }}\r\nOrdered From: {{{ seller_info }}}\r\n{{/ seller_info }}\r\n\r\n{{# shipping_data }}\r\nShipping Address:\r\n{{{ firstname }}} {{{lastname}}}\r\n{{{ company }}} \r\n{{{ address_1 }}} \r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{/ shipping_data }}\r\n\r\n{{# payment_data }}\r\nPayment Address:\r\n{{{ firstname }}} {{{lastname}}}\r\n{{{ company }}} \r\n{{# taxid }}\r\n{{{ taxid }}}\r\n{{/ taxid }}\r\n{{{ address_1 }}} \r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{# registration }}\r\n{{ registration }}  \r\n{{/ registration }}\r\n{{# bank_name }}\r\n{{ bank_name }}  \r\n{{/ bank_name }}\r\n{{# bank_address }}\r\n{{ bank_address }}  \r\n{{/ bank_address }}\r\n{{# iban }}\r\n{{ iban }}  \r\n{{/ iban }}\r\n{{# swift }}\r\n{{ swift }}  \r\n{{/ swift }}\r\n{{/ payment_data }}\r\n\r\n\r\nProduct                                                 Model                             Price                  Quantity              Total\r\n{{# products }}\r\n					\r\n{{ name }}                                               {{ model }}                       {{ price }}            {{ quantity }}        {{ total }}\r\n   {{# option }}\r\n    - {{ name}} {{ value }}\r\n{{# link }} \r\n  {{{ link }}} \r\n{{/ link}}\r\n   {{/ option }}\r\n\r\n\r\n{{/ products }}\r\n{{# totals }}\r\n  {{{ title }}}  {{ text }}\r\n{{/ totals }}\r\n\r\n\r\n{{# comment }}\r\n	The comments for your order are:\r\n {{{ comment }}} \r\n{{/ comment }}\r\n\r\n{{# invoice }}\r\nTo view your order click on the link below:\r\n{{ invoice }}\r\n{{/ invoice }}\r\n\r\n{{ store_name }}\r\n{{ text_project_label }}',
`allowed_placeholders`='store_name, order_id, store_url, logo_uri, logo_html, date_added, payment_method, shipping_method, customer_email, customer_telephone, customer_mobile_phone, customer_fax, customer_ip, shipping_data, payment_data, products, totals, comment, invoice,  text_project_label, seller_info' WHERE `text_id`='storefront_order_confirm'");

    $this->db->query("UPDATE ".$this->db->table("email_templates")." SET `html_body`='<html>
<head>
    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">
    <title> {{store_name}} - Order {{ order_id }} </title>
</head>
<body>
<table style=\"font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;\">
    <tr>
        <td class=\"align_left\">
            <a href=\"{{ store_url }}\" title=\"{{ store_name }}\">
                {{# logo_uri}}
                <img src=\"{{ logo_uri }}\" alt=\"{{store_name}}\" style=\"border: none;\">
                {{/ logo_uri}}
                {{^ logo_uri}}
                {{# logo_html}}
                {{logo_html}}
                {{/ logo_html}}
                {{/ logo_uri}}
            </a>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">You have received an order.</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color:#FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">Order Details</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td>
            <table style=\"width: 100%;\">
                <tr>
                    <td style=\"width: 60%;\">
                        Order ID: <span
                            style=\"color: #069; font-weight: bold;\">{{ order_id }}</span><br/>
                        Date Ordered: {{ date_added }}<br>
                        Payment Method: <strong>{{ payment_method }}</strong><br/>
                        Shipping Method: <strong>{{{ shipping_method }}}</strong><br/>
                        <br/>
                    </td>
                    <td style=\"width: 40%;\">
                        {{# seller_info }}
                        <strong>Ordered From:<br> {{{ seller_info }}}</strong>
                        {{/ seller_info }}
                    </td>
                </tr>
            </table>
            <table style=\"width: 100%;\">
                <tr>
                    <td style=\"width: 60%;\">
                        Email: <strong>{{ customer_email }}</strong><br/>
                        Telephone: <strong>{{ customer_telephone }}</strong><br/>
                        {{# customer_mobile_phone }}
                        Telephone: <strong>{{ customer_mobile_phone }}</strong><br/>
                        {{/ customer_mobile_phone }}
                        {{# customer_fax }}
                        Fax: <strong>{{ customer_fax }}</strong><br/>
                        {{/ customer_fax }}
                        IP Address:<strong>{{ customer_ip }}</strong>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td>
            <table style=\"width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #FFFFFF;\">
                <tr style=\"background-color: #CCCCCC; text-transform: uppercase;\">
                    <th style=\"text-align: left; padding: 0.3em;\">Shipping Address</th>
                    <th style=\"text-align: left; padding: 0.3em;\">Payment Address</th>
                </tr>
                <tr>
                    <td style=\"padding: 0.3em; background-color: #EEEEEE; color: #000;\">
                        {{# shipping_data }}
                        {{ firstname }} {{lastname}} <br/>
                        {{# company }}
                        {{{ company }}} <br/>
                        {{/ company }}
                        {{# address_1 }}
                        {{{ address_1 }}} <br/>
                        {{/ address_1 }}
                        {{# address_2 }}
                        {{{ address_2 }}} <br/>
                        {{/ address_2 }}
                        {{{ city }}} {{{ postcode }}} <br/>
                        {{# zone }}
                        {{{ zone }}} <br/>
                        {{/ zone }}
                        {{{ country }}}
                        {{/ shipping_data }}
                    </td>
                    <td style=\"padding: 0.3em; background-color: #EEEEEE; color: #000;\">
                        {{# payment_data }}
                        {{ firstname }} {{lastname}} <br/>
                        {{# company }}
                        {{{ company }}} <br/>
                        {{/ company }}
                        {{# taxid }}
                        {{{ taxid }}} <br/>
                        {{/ taxid }}
                        {{# address_1 }}
                        {{{ address_1 }}} <br/>
                        {{/ address_1 }}
                        {{# address_2 }}
                        {{{ address_2 }}} <br/>
                        {{/ address_2 }}
                        {{{ city }}} {{{ postcode }}} <br/>
                        {{# zone }}
                        {{{ zone }}} <br/>
                        {{/ zone }}
                        {{{ country }}}<br/>
                        {{# registration }}
                        {{ registration }} <br/>
                        {{/ registration }}
                        {{# bank_name }}
                        {{ bank_name }} <br/>
                        {{/ bank_name }}
                        {{# bank_address }}
                        {{ bank_address }} <br/>
                        {{/ bank_address }}
                        {{# iban }}
                        {{ iban }} <br/>
                        {{/ iban }}
                        {{# swift }}
                        {{ swift }} <br/>
                        {{/ swift }}
                        {{/ payment_data }}
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">
            <table style=\"width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #000000;\">
                <tr style=\"background-color: #CCCCCC;\">
                    <th style=\"width: 40%; padding: 0.3em; color: #FFFFFF;\">Product</th>
                    <th class=\"align_left\" style=\"color: #FFFFFF;\">Model</th>
                    <th class=\"align_right\"
                        style=\"width: 10%; padding: 0.3em; color: #FFFFFF;\">Price</th>
                    <th class=\"align_right\"
                        style=\"width: 15%; padding: 0.3em; color: #FFFFFF;\">Quantity</th>
                    <th class=\"align_right\"
                        style=\"width: 20%; padding: 0.3em; color: #FFFFFF;\">Total</th>
                </tr>
                {{# products }}
                <tr style=\"background-color: #EEEEEE; text-align: center;\">
                    <td class=\"align_left\" style=\"text-align: left;\">{{ name }}
                        {{# option }}
                        <br/>
                        &nbsp;&nbsp;- {{ name}} {{ value }}
                        {{# link }}
                        <br> &nbsp;&nbsp;{{{ link }}}
                        {{/ link}}
                        {{/ option }}
                    <td class=\"align_left\"> {{ model }} </td>
                    <td class=\"align_right\"> {{ price }} </td>
                    <td class=\"align_right\"> {{ quantity }} </td>
                    <td class=\"align_right\"> {{ total }}</td>
                </tr>
                {{/ products }}
                {{# totals }}
                <tr style=\"text-align: right;\">
                    <td colspan=\"3\">&nbsp;</td>
                    <td style=\"background-color: #EEEEEE; font-weight: bold; padding: 0.3em;\">{{{ title }}} </td>
                    <td style=\"background-color: #EEEEEE; padding: 0.3em;\"> {{ text }}</td>
                </tr>
                {{/ totals }}
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\"></td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{# comment }}
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">The comments for your order are:</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"> {{{ comment }}} </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{/ comment }}
    {{# invoice }}
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">To view your order click on the link below:</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"><a href=\"{{ invoice }}\"> {{ invoice }}</a></td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{/ invoice }}
    <tr>
        <td class=\"align_center\"
            style=\"font-size: 10px; border-top: 1px solid #069; text-decoration: none; color: #374953;\">
            <a href=\"{{ store_url }}\"
               style=\"color: #069; font-weight: bold; text-decoration: none;\">{{ store_name }}</a>
            {{{ text_project_label }}}
        </td>
    </tr>
</table>
</body>
</html>', 
`text_body`='You have received an order.\r\n\r\nOrder Details\r\n\r\nOrder ID: {{ order_id }}\r\nDate Ordered: {{ date_added }}\r\nPayment Method: {{ payment_method }}\r\nShipping Method: {{{ shipping_method }}}\r\n\r\nEmail: {{ customer_email }}\r\nTelephone: {{ customer_telephone }}\r\n{{# customer_mobile_phone }}\r\nTelephone: {{ customer_mobile_phone }}\r\n{{/ customer_mobile_phone }}\r\n{{# customer_fax }}\r\nFax: {{ customer_fax }}\r\n{{/ customer_fax }}\r\nIP Address: {{ customer_ip }}\r\n{{# seller_info }}\r\nOrdered From: {{{ seller_info }}}\r\n{{/ seller_info }}\r\n\r\n{{# shipping_data }}\r\nShipping Address:\r\n{{{ firstname }}} {{{lastname}}}\r\n{{{ company }}}\r\n\r\n{{{ address_1 }}} \r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{/ shipping_data }}\r\n\r\n{{# payment_data }}\r\nPayment Address:\r\n{{{ firstname }}} {{{lastname}}} \r\n{{{ company }}}\r\n{{# taxid }}\r\n{{{ taxid }}}\r\n{{/ taxid }}\r\n{{{ address_1 }}}\r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{# registration }}\r\n{{ registration }}  \r\n{{/ registration }}\r\n{{# bank_name }}\r\n{{ bank_name }}  \r\n{{/ bank_name }}\r\n{{# bank_address }}\r\n{{ bank_address }}  \r\n{{/ bank_address }}\r\n{{# iban }}\r\n{{ iban }}  \r\n{{/ iban }}\r\n{{# swift }}\r\n{{ swift }}  \r\n{{/ swift }}\r\n{{/ payment_data }}\r\n\r\n\r\nProduct                                                 Model                             Price                  Quantity              Total\r\n{{# products }}\r\n					\r\n{{ name }}                                               {{ model }}                       {{ price }}            {{ quantity }}        {{ total }}\r\n   {{# option }}\r\n    - {{ name}} {{ value }} \r\n{{# link }} \r\n  {{{ link }}} \r\n{{/ link}}\r\n   {{/ option }}\r\n\r\n\r\n{{/ products }}\r\n{{# totals }}\r\n  {{{ title }}}  {{ text }}\r\n{{/ totals }}\r\n\r\n\r\n{{# comment }}\r\n	The comments for your order are:\r\n {{{ comment }}} \r\n{{/ comment }}\r\n\r\n{{# invoice }}\r\nTo view your order click on the link below:\r\n{{ invoice }}\r\n{{/ invoice }}\r\n\r\n{{ store_name }}\r\n{{ text_project_label }}', 
`allowed_placeholders`='store_name, order_id, store_url, logo_uri, logo_html, date_added, payment_method, shipping_method, customer_email, customer_telephone, customer_mobile_phone, customer_fax, customer_ip, shipping_data, payment_data, products, totals, comment, invoice,  text_project_label, order_total, seller_info' WHERE `text_id`='storefront_order_confirm_admin_notify'");
}

if (file_exists(DIR_EXT.'delivery_scheduler')) {
    $language = Registry::getInstance()->get('language');

    $languageId = $language->getContentLanguageID();

    $emailTemplate1 = $this->db->query("SELECT * FROM ".$this->db->table('email_templates') ." WHERE text_id='storefront_order_confirm' and language_id=".$languageId." And status=1 LIMIT 1");
    $query1 = $emailTemplate1->row;
    $html_body1 = $query1['html_body'];
    $text_body1 = $query1['text_body'];

    $emailTemplate2 = $this->db->query("SELECT * FROM ".$this->db->table('email_templates') ." WHERE text_id='storefront_order_confirm_admin_notify' and language_id=".$languageId." And status=1 LIMIT 1");
    $query2 = $emailTemplate2->row;
    $html_body2 = $query2['html_body'];
    $text_body2 = $query2['text_body'];

    $replace_html_body1=$replace_text_body1=$allowed_placeholders1=$replace_html_body2=$replace_text_body2=$allowed_placeholders1='';
    if (stripos($html_body1,'{{# delivery_date }}') === false) {
        $search = ["IP Address:<strong>{{ customer_ip }}</strong>", "The comments for your order are:"];
        $replace = ["IP Address:<strong>{{ customer_ip }}</strong>
        </td>
        <td style=\"width: 40%\">
        {{# delivery_date }}
        Delivery Date: <strong>{{{ delivery_date }}}</strong> <br/>
        {{/ delivery_date }}
        {{# delivery_time }}
        Delivery Time: <strong>{{{ delivery_time }}}</strong> <br/>
        {{/ delivery_time }}
        {{# extra_details }}
        Extra Details: <strong>{{{ extra_details }}}</strong> <br/>
        {{/ extra_details }}",
            "The comments or special delivery instructions for your order are:"];
    }
    $replace_html_body1 = str_replace($search, $replace, $html_body1);
    if (stripos($text_body1, '{{# delivery_date }}') === false) {
        $search = ["{{/ seller_info }}"];
        $replace = ["{{/ seller_info }}
         {{# delivery_date }}
    Delivery Date: {{{ delivery_date }}}\r\n {{/ delivery_date}}
    {{# delivery_time }}\r\n Delivery Time: {{{ delivery_time }}} \r\n {{/ delivery_time}}
    {{# extra_details }}\r\n Extra Details: {{{ extra_details }}} \r\n {{/ extra_details}}\r\n",
            "The comments or special delivery instructions for your order are:"];
        $replace_text_body1 = str_replace($search, $replace, $text_body1);
    } else {
        $replace_text_body1 = $text_body1;
    }

    $allowed_placeholders1 = $query1['allowed_placeholders'];

    if (stripos($allowed_placeholders1, 'delivery_date') === false) {
        $laststring = substr("$allowed_placeholders1", -1);
        if ($laststring===',') {
            $allowed_placeholders1 .= ' delivery_date, delivery_time, extra_details, ';
        } else {
            $allowed_placeholders1 .= ' ,delivery_date, delivery_time, extra_details, ';
        }
    }
    if (stripos($html_body2,'{{# delivery_date }}') === false) {
        $search = ["IP Address:<strong>{{ customer_ip }}</strong>", "The comments for your order are:"];
        $replace = ["IP Address:<strong>{{ customer_ip }}</strong>
        </td>
        <td style=\"width: 40%\">
        {{# delivery_date }}
        Delivery Date: <strong>{{{ delivery_date }}}</strong> <br/>
        {{/ delivery_date }}
        {{# delivery_time }}
        Delivery Time: <strong>{{{ delivery_time }}}</strong> <br/>
        {{/ delivery_time }}
        {{# extra_details }}
        Extra Details: <strong>{{{ extra_details }}}</strong> <br/>
        {{/ extra_details }}",
            "The comments or special delivery instructions for your order are:"];
    }

    $replace_html_body2 = str_replace($search, $replace, $html_body2);
    if (stripos($text_body2, '{{# delivery_date }}') === false) {
        $search = ["{{/ seller_info }}"];
        $replace = ["{{/ seller_info }}
        {{# delivery_date }}
    Delivery Date: {{{ delivery_date }}}\r\n {{/ delivery_date}}
    {{# delivery_time }}\r\n Delivery Time: {{{ delivery_time }}} \r\n {{/ delivery_time}}
    {{# extra_details }}\r\n Extra Details: {{{ extra_details }}} \r\n {{/ extra_details}}\r\n",
            "The comments or special delivery instructions for your order are:"];
        $replace_text_body2 = str_replace($search, $replace, $text_body2);
    } else {
        $replace_text_body2 = $text_body2;
    }

    $allowed_placeholders2 = $query2['allowed_placeholders'];

    if (stripos($allowed_placeholders2, 'delivery_date') === false) {
        $laststring = substr($allowed_placeholders2, -1);
        if ($laststring===',') {
            $allowed_placeholders2 .= ' delivery_date, delivery_time, extra_details, ';
        } else {
            $allowed_placeholders2 .= ' ,delivery_date, delivery_time, extra_details, ';
        }
    }

    $this->db->query("UPDATE " . $this->db->table('email_templates') . " SET html_body='" . $replace_html_body1 . "',text_body='" . $replace_text_body1 . "',allowed_placeholders='" . $allowed_placeholders1 . "'  WHERE text_id='storefront_order_confirm' and language_id=" . $languageId);
    $this->db->query("UPDATE " . $this->db->table('email_templates') . " SET html_body='" . $replace_html_body2 . "',text_body='" . $replace_text_body2 . "',allowed_placeholders='" . $allowed_placeholders2 . "' WHERE text_id='storefront_order_confirm_admin_notify' and language_id=" . $languageId);

}

$sql1 = "UPDATE ".$this->db->table('language_definitions')." set language_value='Enter your WHY2 license key:' WHERE language_key='taxid_option_license_code';";
$this->db->query($sql1);

$this->db->query("UPDATE ".$this->db->table('language_definitions')." set language_value='Ordered From:' WHERE language_key='text_ordered' AND block='account_taxid_option' AND section=0 AND language_id=1");

$sql2 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("taxid_option_updater_notification") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql2);

$sql3 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("taxid_option_license_info") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `public_key` TEXT NOT NULL,
  `license_data` TEXT NOT NULL,
  `license_key` TEXT NOT NULL,
  `store_id` int(11) NOT NULL,
  `last_check` int(11),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql3);
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='taxid_option_taxid_option' AND `language_key`='text_new_taxid_option_version_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='taxid_option_taxid_option' AND `language_key`='text_new_taxid_option_version_description'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='taxid_option_taxid_option' AND `language_key`='text_update_success'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='taxid_option_taxid_option' AND `language_key`='text_update_failed'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='taxid_option_taxid_option' AND `language_key`='button_start_update'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='taxid_option_taxid_option' AND `language_key`='button_cancel_update'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='taxid_option_taxid_option' AND `language_key`='text_update_taxid_option_note'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='taxid_option_taxid_option' AND `language_key`='text_taxid_option_updater_heading_title'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='taxid_option_taxid_option' AND `language_key`='text_changelog'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='taxid_option_taxid_option' AND `language_key`='text_no_updates'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='taxid_option_taxid_option' AND `language_key`='button_go_back'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='taxid_option_taxid_option' AND `language_key`='text_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='taxid_option_taxid_option' AND `language_key`='button_diy_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='taxid_option_taxid_option' AND `language_key`='button_mc_support_by_why2'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='taxid_option_taxid_option' AND `language_key`='text_update_taxid_option_available'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='taxid_option_taxid_option' AND `language_key`='taxid_option_license_expired'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE  `block`='taxid_option_taxid_option' AND `language_key`='text_company_name'");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','taxid_option_taxid_option','text_new_taxid_option_version_title','New version (v[new_version]) of Mandatory Tax ID Option Extension',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','taxid_option_taxid_option','text_new_taxid_option_version_description','There is a new version of Mandatory Tax ID Option Extension. Please open -->#admin#rt=extension/taxid_option_updater&version=[version_number] to update the extension. <br><br>
                        The update will replace existing files with the update files.<br><br>Make sure that you have made a backup of your store prior to updating. Use your normal backup method or Softaculous to make a backup prior to updating your site. Need help on how to backup an installation by using Softaculous click <a href=\"https://why2central.net/knowledgebase/how-to-backup-an-installation/\" target=\"_BLANK\"><b>here</b></a>.<br><br>
                        Do not delete this message until you have updated.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','taxid_option_taxid_option','text_update_success','The Mandatory Tax ID Option extension has been successfully updated.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','taxid_option_taxid_option','text_update_failed','We are unable to update the Mandatory Tax ID Option extension, please check <a target=\"_BLANK\" href=\"#admin#rt=tool/error_log\">error log</a> for more information.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','taxid_option_taxid_option','button_start_update','Start Update',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','taxid_option_taxid_option','button_cancel_update','Cancel Update',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','taxid_option_taxid_option','text_update_taxid_option_note','Note:<br>We are going to update Mandatory Tax ID Option extension. The update will replace existing files with the update files.<br><br>Make sure that you have made a backup of your store prior to updating. Use your normal backup method or Softaculous to make a backup prior to updating your site. Need help on how to backup an installation by using Softaculous click <a href=\"https://why2central.net/knowledgebase/how-to-backup-an-installation/\" target=\"_BLANK\"><b>here</b></a>.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','taxid_option_taxid_option','text_taxid_option_updater_heading_title', 'Mandatory Tax ID Option Updater',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','taxid_option_taxid_option','text_changelog','Changelog:',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','taxid_option_taxid_option','text_no_updates','There are no new updates for this extension.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','taxid_option_taxid_option','button_go_back','Go Back',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','taxid_option_taxid_option','text_support_by_why2','Support and updates from WHY2.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','taxid_option_taxid_option','text_company_name','Company Name: ',now(),now())");

$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='fc_fax_placeholder'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='fc_taxid_placeholder'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='fc_company_placeholder'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='fc_registration_placeholder'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='fc_bank_name_placeholder'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='fc_bank_address_placeholder'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='fc_iban_placeholder'");
$this->db->query("DELETE FROM ".$this->db->table("language_definitions")." WHERE `block`='fc_swift_placeholder'");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','account_taxid_option','fc_fax_placeholder','Your Fax Number',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','account_taxid_option','fc_taxid_placeholder','Your Tax ID',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','account_taxid_option','fc_company_placeholder','Your Company',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','account_taxid_option','fc_registration_placeholder','Your Registration Number',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','account_taxid_option','fc_bank_name_placeholder','Your Bank Account Name',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','account_taxid_option','fc_bank_address_placeholder','Your Bank Address',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','account_taxid_option','fc_iban_placeholder','Your IBAN Number',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','0','account_taxid_option','fc_swift_placeholder','Your Bank Swift Number',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','taxid_option_taxid_option','text_support_by_why2','Support and updates from WHY2.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','taxid_option_taxid_option','button_diy_support_by_why2','If you are self-managed users click here for support. Support and updates from WHY2.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','taxid_option_taxid_option','button_mc_support_by_why2','If you are a WHY2 Managed Client click here for support. Updates are part of the Managed Services.',now(),now())");

$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','taxid_option_taxid_option','text_update_taxid_option_available','New version (%s) is available. <a href=\"%s\" target=\"_BLANK\"><strong>Click to update now.</strong></a>',now(),now())");


$this->db->query("UPDATE ".$this->db->table("language_definitions")." SET `language_value`='Cancel' WHERE `language_key`='button_cancel' AND `block`='taxid_option_taxid_option'");
$this->db->query("INSERT INTO ".$this->db->table("language_definitions")." (`language_id`, `section`, `block`, `language_key`, `language_value`, `date_added`, `date_modified`)
        VALUES ('1','1','taxid_option_taxid_option','taxid_option_license_expired','Your license key is expired. Possibly due to inactive with the extension for more than 14 days. Please click on the SAVE button at the bottom of this page.',now(),now())");

if (file_exists(DIR_EXT.'taxid_option/core/lib/cart.php')) {
    unlink(DIR_EXT.'taxid_option/core/lib/cart.php');
}

if (file_exists(DIR_EXT.'taxid_option/core/lib/order.php')) {
    unlink(DIR_EXT.'taxid_option/core/lib/order.php');
}

if (file_exists(DIR_EXT.'taxid_option/core/lib/order_invoice.tpl')) {
    unlink(DIR_EXT.'taxid_option/core/lib/order_invoice.tpl');
}

if (file_exists(DIR_EXT.'taxid_option/admin/view/default/template/responses/sale/order_invoice.tpl')) {
    unlink(DIR_EXT.'taxid_option/admin/view/default/template/responses/sale/order_invoice.tpl');
}

if (file_exists(DIR_EXT.'taxid_option/admin/view/default/template/responses/sale')) {
    rmdir(DIR_EXT.'taxid_option/admin/view/default/template/responses/sale');
}

if (file_exists(DIR_EXT.'taxid_option/admin/view/default/template/responses')) {
    rmdir(DIR_EXT.'taxid_option/admin/view/default/template/responses');
}

if (file_exists(DIR_EXT.'taxid_option/admin/view/default/template/pages/sale/order_details.tpl')) {
    unlink(DIR_EXT . 'taxid_option/admin/view/default/template/pages/sale/order_details.tpl');
}
if (file_exists(DIR_EXT.'taxid_option/storefront/view/default/template/embed/account/create.tpl')) {
    unlink(DIR_EXT . 'taxid_option/storefront/view/default/template/embed/account/create.tpl');
}
if (file_exists(DIR_EXT.'taxid_option/storefront/view/default/template/embed/account/edit.tpl')) {
    unlink(DIR_EXT . 'taxid_option/storefront/view/default/template/embed/account/edit.tpl');
}
if (file_exists(DIR_EXT.'taxid_option/storefront/view/default/template/embed/account/invoice.tpl')) {
    unlink(DIR_EXT . 'taxid_option/storefront/view/default/template/embed/account/invoice.tpl');
}
if (file_exists(DIR_EXT.'taxid_option/storefront/view/default/template/embed/checkout/address.tpl')) {
    unlink(DIR_EXT . 'taxid_option/storefront/view/default/template/embed/checkout/address.tpl');
}
if (file_exists(DIR_EXT.'taxid_option/storefront/view/default/template/embed/checkout/confirm.tpl')) {
    unlink(DIR_EXT . 'taxid_option/storefront/view/default/template/embed/checkout/confirm.tpl');
}
if (file_exists(DIR_EXT.'taxid_option/storefront/view/default/template/embed/checkout/guest_step_1.tpl')) {
    unlink(DIR_EXT . 'taxid_option/storefront/view/default/template/embed/checkout/guest_step_1.tpl');
}
if (file_exists(DIR_EXT.'taxid_option/storefront/view/default/template/embed/checkout/guest_step_2.tpl')) {
    unlink(DIR_EXT . 'taxid_option/storefront/view/default/template/embed/checkout/guest_step_2.tpl');
}
if (file_exists(DIR_EXT.'taxid_option/storefront/view/default/template/pages/account/create.tpl')) {
    unlink(DIR_EXT . 'taxid_option/storefront/view/default/template/pages/account/create.tpl');
}
if (file_exists(DIR_EXT.'taxid_option/storefront/view/default/template/pages/account/edit.tpl')) {
    unlink(DIR_EXT . 'taxid_option/storefront/view/default/template/pages/account/edit.tpl');
}
if (file_exists(DIR_EXT.'taxid_option/storefront/view/default/template/pages/account/invoice.tpl')) {
    unlink(DIR_EXT . 'taxid_option/storefront/view/default/template/pages/account/invoice.tpl');
}
if (file_exists(DIR_EXT.'taxid_option/storefront/view/default/template/pages/checkout/address.tpl')) {
    unlink(DIR_EXT . 'taxid_option/storefront/view/default/template/pages/checkout/address.tpl');
}
if (file_exists(DIR_EXT.'taxid_option/storefront/view/default/template/pages/checkout/confirm.tpl')) {
    unlink(DIR_EXT . 'taxid_option/storefront/view/default/template/pages/checkout/confirm.tpl');
}
if (file_exists(DIR_EXT.'taxid_option/storefront/view/default/template/pages/checkout/guest_step_1.tpl')) {
    unlink(DIR_EXT . 'taxid_option/storefront/view/default/template/pages/checkout/guest_step_1.tpl');
}

$exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('taxid_license') . "'");
if ($exist->num_rows === 1) {
    $this->db->query("DROP TABLE ".$this->db->table("taxid_license"));
}

if (file_exists(DIR_EXT.'taxid_option/admin/view/default/template/pages/extension/taxid_extensions_edit.tpl')) {
    unlink(DIR_EXT.'taxid_option/admin/view/default/template/pages/extension/taxid_extensions_edit.tpl');
}

if (!file_exists(DIR_SYSTEM.'lib/license.php')) {
    /**
     *  Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return array
     */
    function custom_copy($src, $dst) {
        $error = array();
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function
                    // for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                        $error['error_copy'][] = "Failed to copy $file";
                    }
                }
            }
        }
        if (sizeof($error)>0) {
            $log=new ALog(DIR_SYSTEM.'logs/error.txt');
            $log->write(var_export($error,true));
        }
        closedir($dir);
        return $error;
    }

    $copy = custom_copy(DIR_EXT . 'taxid_option' . DIR_EXT_CORE . 'lib', DIR_SYSTEM.'lib');
}