<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

class ModelExtensionTaxidOptionVerify extends Model {

    public function verifyAdvancedReportsStatus() {
        if ( $this->config->get( 'advanced_reports_status' ) === '1' ) {
            $this->load->model('extension/advanced_reports_license_info');
            $license_key = $this->config->get('advanced_reports_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('advanced_reports_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_advanced_reports_license_info->getStoreId();
                    $license_key = $this->model_extension_advanced_reports_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_advanced_reports_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'advanced_reports');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_advanced_reports_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyPricingCalc() {
        if ($this->config->get('pricing_calculator_status')==='1') {
            $this->load->model('extension/pricing_calculator_license_info');
            $license_key = $this->config->get('pricing_calculator_license_code');
            $shared_secret = 'pricing_calculator';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('pricing_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_pricing_calculator_license_info->getStoreId();
                    $license_key = $this->model_extension_pricing_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_pricing_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_pricing_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyOptionLink() {
        if ($this->config->get('option_price_link_pro_status')==='1') {
            $this->load->model('extension/option_price_link_pro_license_info');
            $license_key = $this->config->get('option_price_link_pro_license_code');
            $shared_secret = 'option_price_link_pro';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('option_price_link_pro_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_option_price_link_pro_license_info->getStoreId();
                    $license_key = $this->model_extension_option_price_link_pro_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_option_price_link_pro_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_option_price_link_pro_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyQuickCheckout() {
        if ($this->config->get('quick_checkout_status')==='1') {
            $this->load->model('extension/quick_checkout_license_info');
            $license_key = $this->config->get('quick_checkout_license_code');
            $shared_secret = 'quick_checkout';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('quick_checkout_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_quick_checkout_license_info->getStoreId();
                    $license_key = $this->model_extension_quick_checkout_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_quick_checkout_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_quick_checkout_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyUpsPlus() {
        if ($this->config->get('ups_integration_plus_status')==='1') {
            $this->load->model('extension/ups_integration_plus_license_info');
            $license_key = $this->config->get('ups_integration_plus_license_code');
            $shared_secret = 'ups_integration_plus';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('ups_integration_plus_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_ups_integration_plus_license_info->getStoreId();
                    $license_key = $this->model_extension_ups_integration_plus_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_ups_integration_plus_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_ups_integration_plus_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyMailchimp() {
        if ($this->config->get('integration_mailchimp_status')==='1') {
            $this->load->model('extension/integration_mailchimp_license_info');
            $license_key = $this->config->get('integration_mailchimp_license_code');
            $shared_secret = 'integration_mailchimp';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('integration_mailchimp_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_integration_mailchimp_license_info->getStoreId();
                    $license_key = $this->model_extension_integration_mailchimp_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_integration_mailchimp_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_integration_mailchimp_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyMailchimpPlus() {
        if ($this->config->get('integration_mailchimp_plus_status')==='1') {
            $this->load->model('extension/integration_mailchimp_plus_license_info');
            $license_key = $this->config->get('integration_mailchimp_plus_license_code');
            $shared_secret = 'integration_mailchimp_plus';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('integration_mailchimp_plus_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_integration_mailchimp_plus_license_info->getStoreId();
                    $license_key = $this->model_extension_integration_mailchimp_plus_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_integration_mailchimp_plus_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_integration_mailchimp_plus_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyCtct() {
        if ($this->config->get('constantcontact_integration_status')==='1') {
            $this->load->model('extension/constantcontact_integration_license_info');
            $license_key = $this->config->get('constantcontact_integration_license_code');
            $shared_secret = 'constantcontact_integration';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('constantcontact_integration_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_constantcontact_integration_license_info->getStoreId();
                    $license_key = $this->model_extension_constantcontact_integration_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_constantcontact_integration_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_constantcontact_integration_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyEmailEditor() {
        if ( $this->config->get( 'email_editor_status' ) === '1' ) {
            $this->load->model('extension/email_editor_license_info');
            $license_key = $this->config->get('email_editor_license_code');
            $shared_secret = 'email_editor';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('email_editor_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_email_editor_license_info->getStoreId();
                    $license_key = $this->model_extension_email_editor_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_email_editor_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_email_editor_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

}