<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ModelAccountTaxidOrder
 * @property ModelAccountTaxidOption $model_account_taxid_option
 */
class ModelAccountTaxidOrder extends Model
{
    /**
     * @param array $data
     * @param int|string $set_order_id
     * @return bool|int
     */
    public function create($data, $set_order_id = ''){
        $set_order_id = (int)$set_order_id;
        //reuse same order_id or unused one order_status_id = 0
		if ($set_order_id) {
			$query = $this->db->query( "SELECT order_id
										FROM `" . $this->db->table("orders") . "`
										WHERE order_id = " . $set_order_id . " AND order_status_id = '0'");

			if (!$query->num_rows) { // for already processed orders do redirect
				$query = $this->db->query("SELECT order_id
											FROM `" . $this->db->table("orders") . "`
											WHERE order_id = " . $set_order_id . " AND order_status_id > '0'");
				if ($query->num_rows) {
					return false;
				}
			//remove
			}else{
				$this->_remove_order($query->row['order_id']);
			}
		}

		//clean up based on setting (remove already created or abandoned orders)
		if((int)$this->config->get('config_expire_order_days')){
			$query = $this->db->query(
					"SELECT order_id
					FROM " . $this->db->table("orders") . "
					WHERE date_modified < '" . date('Y-m-d', strtotime('-'.(int)$this->config->get('config_expire_order_days').' days')) . "'
						AND order_status_id = '0'");
			foreach ($query->rows as $result){
				$this->_remove_order($result['order_id']);
			}
		}

		if(!$set_order_id && (int)$this->config->get('config_start_order_id')){
			$query = $this->db->query("SELECT MAX(order_id) AS order_id
										FROM `" . $this->db->table("orders") . "`");
			if($query->row['order_id'] && $query->row['order_id'] >= $this->config->get('config_start_order_id')){
				$set_order_id = (int)$query->row['order_id'] + 1;
			} elseif($this->config->get('config_start_order_id')){
				$set_order_id = (int)$this->config->get('config_start_order_id');
			} else{
				$set_order_id = 0;
			}
		}

        if($set_order_id){
            $set_order_id = "order_id = '" . (int)($set_order_id) . "', ";
        }else{
            $set_order_id = '';
        }
        
        $key_sql = '';
        if ($this->dcrypt->active) {
            $data = $this->dcrypt->encrypt_data($data, 'orders');
            $key_sql = ", key_id = '" . (int)$data['key_id'] . "'";
        }

        $this->db->query("INSERT INTO `" . $this->db->table("orders") . "`
							SET " . $set_order_id . " store_id = '" . (int)$data['store_id'] . "',
								store_name = '" . $this->db->escape($data['store_name']) . "',
								store_url = '" . $this->db->escape($data['store_url']) . "',
								customer_id = '" . (int)$data['customer_id'] . "',
								customer_group_id = '" . (int)$data['customer_group_id'] . "',
								firstname = '" . $this->db->escape($data['firstname']) . "',
								lastname = '" . $this->db->escape($data['lastname']) . "',
								email = '" . $this->db->escape($data['email']) . "',
								telephone = '" . $this->db->escape($data['telephone']) . "',
								fax = '" . $this->db->escape($data['fax']) . "',
								taxid = '" . $this->db->escape($data['payment_taxid']) . "',
								registration = '" . $this->db->escape($data['registration']) . "',
								bank_name = '" . $this->db->escape($data['bank_name']) . "',
								bank_address = '" . $this->db->escape($data['bank_address']) . "',
								iban = '" . $this->db->escape($data['iban']) . "',
								swift = '" . $this->db->escape($data['swift']) . "',
								total = '" . (float)$data['total'] . "',
								language_id = '" . (int)$data['language_id'] . "',
								currency = '" . $this->db->escape($data['currency']) . "',
								currency_id = '" . (int)$data['currency_id'] . "',
								value = '" . (float)$data['value'] . "',
								coupon_id = '" . (int)$data['coupon_id'] . "',
								ip = '" . $this->db->escape($data['ip']) . "',
								shipping_firstname = '" . $this->db->escape($data['shipping_firstname']) . "',
								shipping_lastname = '" . $this->db->escape($data['shipping_lastname']) . "',
								shipping_company = '" . $this->db->escape($data['shipping_company']) . "',
								shipping_address_1 = '" . $this->db->escape($data['shipping_address_1']) . "',
								shipping_address_2 = '" . $this->db->escape($data['shipping_address_2']) . "',
								shipping_city = '" . $this->db->escape($data['shipping_city']) . "',
								shipping_postcode = '" . $this->db->escape($data['shipping_postcode']) . "',
								shipping_zone = '" . $this->db->escape($data['shipping_zone']) . "',
								shipping_zone_id = '" . (int)$data['shipping_zone_id'] . "',
								shipping_country = '" . $this->db->escape($data['shipping_country']) . "',
								shipping_country_id = '" . (int)$data['shipping_country_id'] . "',
								shipping_address_format = '" . $this->db->escape($data['shipping_address_format']) . "',
								shipping_method = '" . $this->db->escape($data['shipping_method']) . "',
								shipping_method_key = '" . $this->db->escape($data['shipping_method_key']) . "',
								payment_firstname = '" . $this->db->escape($data['payment_firstname']) . "',
								payment_lastname = '" . $this->db->escape($data['payment_lastname']) . "',
								payment_company = '" . $this->db->escape($data['payment_company']) . "',
								payment_address_1 = '" . $this->db->escape($data['payment_address_1']) . "',
								payment_address_2 = '" . $this->db->escape($data['payment_address_2']) . "',
								payment_city = '" . $this->db->escape($data['payment_city']) . "',
								payment_postcode = '" . $this->db->escape($data['payment_postcode']) . "',
								payment_zone = '" . $this->db->escape($data['payment_zone']) . "',
								payment_zone_id = '" . (int)$data['payment_zone_id'] . "',
								payment_country = '" . $this->db->escape($data['payment_country']) . "',
								payment_country_id = '" . (int)$data['payment_country_id'] . "',
								payment_address_format = '" . $this->db->escape($data['payment_address_format']) . "',
								payment_method = '" . $this->db->escape($data['payment_method']) . "',
								payment_method_key = '" . $this->db->escape($data['payment_method_key']) . "',
								comment = '" . $this->db->escape($data['comment']) . "'"
                                . $key_sql . ",
								date_modified = NOW(),
								date_added = NOW()");

        $order_id = $this->db->getLastId();
        foreach ($data['products'] as $product) {
            if ($this->config->get('advanced_reports_status')=='1'){
                $sql="cost = '" . (float)$product['cost'] . "',
								discount ='". (float)$product['discount']."',
								product_coupon ='".$product['product_coupon']."',
								certain_product ='".$product['certain_product']."',";
            } else {
                $sql='';
            }
            $this->db->query("INSERT INTO " . $this->db->table("order_products") . "
								SET order_id = '" . (int)$order_id . "',
								product_id = '" . (int)$product['product_id'] . "',
								name = '" . $this->db->escape($product['name']) . "',
								model = '" . $this->db->escape($product['model']) . "',
								sku = '" . $this->db->escape($product['sku']) . "',
								price = '" . (float)$product['price'] . "',
								".$sql."
								total = '" . (float)$product['total'] . "',
								tax = '" . (float)$product['tax'] . "',
								quantity = '" . (int)$product['quantity'] . "',
								subtract = '" . (int)$product['stock'] . "'");

            $order_product_id = $this->db->getLastId();

            foreach ($product['option'] as $option) {
                if ($this->config->get('option_price_link_pro_status')=='1' && $this->config->get('advanced_reports_status')=='1') {
                    $this->db->query("INSERT INTO " . $this->db->table("order_options") . "
									SET order_id = '" . (int)$order_id . "',
										order_product_id = '" . (int)$order_product_id . "',
										product_option_value_id = '" . (int)$option['product_option_value_id'] . "',
										name = '" . $this->db->escape($option['name']) . "',
										sku = '" . $this->db->escape($option['sku']) . "',
										`value` = '" . $this->db->escape($option['value']) . "',
										price = '" . (float)$option['price'] . "',
										cost = '" . (float)$option['cost'] . "',
										prefix = '" . $this->db->escape($option['prefix']) . "',
										link = '" . $this->db->escape($option['link']) . "',
										settings = '" . $this->db->escape($option['settings']) . "'");
                } elseif ($this->config->get('advanced_reports_status')=='1') {
                     $this->db->query("INSERT INTO " . $this->db->table("order_options") . "
									SET order_id = '" . (int)$order_id . "',
										order_product_id = '" . (int)$order_product_id . "',
										product_option_value_id = '" . (int)$option['product_option_value_id'] . "',
										name = '" . $this->db->escape($option['name']) . "',
										sku = '" . $this->db->escape($option['sku']) . "',
										value = '" . $this->db->escape($option['value']) . "',
										price = '" . (float)$option['price'] . "',
										cost = '" . (float)$option['cost'] . "',
										prefix = '" . $this->db->escape($option['prefix']) . "',
										settings = '" . $this->db->escape($option['settings']) . "'");
                 } elseif ($this->config->get('option_price_link_pro_status')=='1') {
                    $this->db->query("INSERT INTO " . $this->db->table("order_options") . "
									SET order_id = '" . (int)$order_id . "',
										order_product_id = '" . (int)$order_product_id . "',
										product_option_value_id = '" . (int)$option['product_option_value_id'] . "',
										name = '" . $this->db->escape($option['name']) . "',
										sku = '" . $this->db->escape($option['sku']) . "',
										`value` = '" . $this->db->escape($option['value']) . "',
										price = '" . (float)$option['price'] . "',
										prefix = '" . $this->db->escape($option['prefix']) . "',
										link = '" . $this->db->escape($option['link']) . "',
										settings = '" . $this->db->escape($option['settings']) . "'");
                } else {
                    $this->db->query("INSERT INTO " . $this->db->table("order_options") . "
									SET order_id = '" . (int)$order_id . "',
										order_product_id = '" . (int)$order_product_id . "',
										product_option_value_id = '" . (int)$option['product_option_value_id'] . "',
										name = '" . $this->db->escape($option['name']) . "',
										sku = '" . $this->db->escape($option['sku']) . "',
										value = '" . $this->db->escape($option['value']) . "',
										price = '" . (float)$option['price'] . "',
										prefix = '" . $this->db->escape($option['prefix']) . "',
										settings = '" . $this->db->escape($option['settings']) . "'");
                }
            }

            foreach ($product['download'] as $download) {
                // if expire days not set - 0  as unexpired
				$download['expire_days'] = (int)$download['expire_days'] > 0 ? $download['expire_days'] : 0; // if expire days not setted - set 20 years as "unexpired"
                $download['max_downloads'] = ((int)$download['max_downloads'] ? (int)$download['max_downloads'] * $product['quantity'] : '');
                $download['status'] = $download['activate'] == 'manually' ? 0 : 1; //disable download for manual mode for customer
                $download['attributes_data'] = serialize($this->download->getDownloadAttributesValues($download['download_id']));
                $this->download->addProductDownloadToOrder($order_product_id, $order_id, $download);
            }
        }

        foreach ($data['totals'] as $total) {
            $this->db->query("INSERT INTO " . $this->db->table("order_totals") . "
								SET `order_id` = '" . (int)$order_id . "',
									`title` = '" . $this->db->escape($total['title']) . "',
									`text` = '" . $this->db->escape($total['text']) . "',
									`value` = '" . (float)$total['value'] . "',
									`sort_order` = '" . (int)$total['sort_order'] . "',
									`type` = '" . $this->db->escape($total['total_type']) . "',
									`key` = '" . $this->db->escape($total['id']) . "'"
									);
        }

        $this->saveIMOrderData($order_id, $data);
        return $order_id;
    }

    protected function saveIMOrderData($order_id, $data){
        $protocols = $this->im->getProtocols();
        $p = array ();
        foreach ($protocols as $protocol){
            $p[] = $this->db->escape($protocol);
        }

        $sql = "SELECT DISTINCT `type_id`, `name` as protocol
				FROM " . $this->db->table('order_data_types') . "
				WHERE `name` IN ('" . implode("', '", $p) . "')";
        $result = $this->db->query($sql);
        if(!$result->num_rows){
            return null;
        }

        foreach ($result->rows as $row){
            $type_id = (int)$row['type_id'];
            if($data['customer_id']){
                $uri = $this->im->getCustomerURI($row['protocol'], $data['customer_id']);
            }else{
                $uri = $data[$row['protocol']];
            }
            if ($uri){
                $im_data = serialize(
                    array (
                        'uri' => $uri,
                        'status' => $this->config->get('config_im_guest_' . $row['protocol'] . '_status')
                    )
                );

                $sql = "REPLACE INTO " . $this->db->table('order_data') . "
						(`order_id`, `type_id`, `data`, `date_added`)
						VALUES (" . (int)$order_id . ", " . (int)$type_id . ", '" . $this->db->escape($im_data) . "', NOW() )";

                $this->db->query($sql);
            }
        }
    }

    /**
     * @param $order_id
     * @return array|bool
     * @throws AException
     */
    public function getOrder($order_id) {
        $ups_plus_status=$this->config->get('ups_integration_plus_status');
        if ($ups_plus_status==='1') {
            $order_query = $this->db->query(
                "SELECT o.*, ap.location_phone
                FROM `".$this->db->table("orders")."` o
                LEFT JOIN `".$this->db->table("ap_address_phone")."` ap ON ap.order_id=o.order_id
                WHERE o.order_id = '".(int)$order_id."'"
            );
        } else {
            $order_query = $this->db->query(
                "SELECT *
                FROM `" . $this->db->table("orders") . "`
                WHERE order_id = '" . (int)$order_id . "'"
            );
        }

        if ($order_query->num_rows) {

            $this->load->model('localisation/country');
            $this->load->model('localisation/zone');
            $country_row = $this->model_localisation_country->getCountry($order_query->row['shipping_country_id']);
            if ($country_row) {
                $shipping_iso_code_2 = $country_row['iso_code_2'];
                $shipping_iso_code_3 = $country_row['iso_code_3'];
            } else {
                $shipping_iso_code_2 = '';
                $shipping_iso_code_3 = '';
            }

            $zone_row = $this->model_localisation_zone->getZone($order_query->row['shipping_zone_id']);
            if ($zone_row) {
                $shipping_zone_code = $zone_row['code'];
            } else {
                $shipping_zone_code = '';
            }

            $country_row = $this->model_localisation_country->getCountry($order_query->row['payment_country_id']);
            if ($country_row) {
                $payment_iso_code_2 = $country_row['iso_code_2'];
                $payment_iso_code_3 = $country_row['iso_code_3'];
            } else {
                $payment_iso_code_2 = '';
                $payment_iso_code_3 = '';
            }

            $zone_row = $this->model_localisation_zone->getZone($order_query->row['payment_zone_id']);
            if ($zone_row) {
                $payment_zone_code = $zone_row['code'];
            } else {
                $payment_zone_code = '';
            }

            $order_data = $this->dcrypt->decrypt_data($order_query->row, 'orders');

            $order_data['shipping_zone_code'] = $shipping_zone_code;
            $order_data['shipping_iso_code_2'] = $shipping_iso_code_2;
            $order_data['shipping_iso_code_3'] = $shipping_iso_code_3;
            $order_data['payment_zone_code'] = $payment_zone_code;
            $order_data['payment_iso_code_2'] = $payment_iso_code_2;
            $order_data['payment_iso_code_3'] = $payment_iso_code_3;

            return $order_data;
        } else {
            return false;
        }
    }

    /**
     * @param $order_id
     * @return bool
     */
    private function _remove_order($order_id){
        $order_id = (int)$order_id;
        if(!$order_id){
            return false;
        }

        $this->db->query("DELETE FROM `" . $this->db->table("orders") . "` WHERE order_id = '" . $order_id . "'");
        $this->db->query("DELETE FROM `" . $this->db->table("order_history") . "` WHERE order_id = '" . $order_id . "'");
        $this->db->query("DELETE FROM `" . $this->db->table("order_products") . "` WHERE order_id = '" . $order_id . "'");
        $this->db->query("DELETE FROM `" . $this->db->table("order_options") . "` WHERE order_id = '" . $order_id . "'");
        $this->db->query("DELETE FROM `" . $this->db->table("order_downloads") . "` WHERE order_id = '" . $order_id . "'");
        $this->db->query("DELETE FROM `" . $this->db->table("order_totals") . "` WHERE order_id = '" . $order_id . "'");
        $this->db->query("DELETE FROM `" . $this->db->table("order_data") . "` WHERE order_id = '" . $order_id . "'");

        return true;
    }

    public function updateTaxIDInfo($order_id,$data) {
        $fields = ['fax','telephone','payment_company','taxid','registration','bank_name','bank_address','iban','swift'];

        foreach ( $fields as $f ) {
            if ( isset( $data[ $f ] ) && $data[$f]!=='') {
                $update[] = $f . " = '" . $this->db->escape( $data[ $f ] ) . "'";
            }
        }
        if ( ! empty( $update ) ) {
            $this->db->query( "UPDATE " . $this->db->table( "orders" ) . "
								SET " . implode( ',', $update ) . "
								WHERE order_id = '" . (int) $order_id . "'" );
        }
    }

    public function updateCustomerAdditionalInfo($order_id) {
        $this->load->model('account/taxid_option');
        $taxid_info = $this->db->query("SELECT customer_id,email,telephone,fax,payment_company as company,taxid,registration,bank_name,bank_address,iban,swift FROM ".$this->db->table("orders")." WHERE order_id=".(int)$order_id);
        $result = $taxid_info->row;
        $data =[];
        if ($result['customer_id'] > 0) {
            $data['email'] = $result['email'];
            $data['telephone'] = $result['telephone'];
			$data['fax'] = $result['fax'];
			$data['company'] = $result['company'];
			$data['taxid'] = $result['taxid'];
			$data['registration'] = $result['registration'];
			$data['bank_name'] = $result['bank_name'];
			$data['bank_address'] = $result['bank_address'];
			$data['iban'] = $result['iban'];
			$data['swift'] = $result['swift'];
            $sql = "SELECT COUNT(*) as exist FROM ".$this->db->table("customer_additional_values")." WHERE`customer_id`= ".$result['customer_id'];
            $query = $this->db->query($sql);
            $exist = $query->row['exist'];
            if ($exist==='0') {
                $this->model_account_taxid_option->addCustomerAdditionalValues($result['customer_id'], $data);
                $this->db->query("UPDATE " . $this->db->table('addresses') . " SET `taxid`='" . $result['taxid'] . "' WHERE customer_id=" . (int)$result['customer_id']);
            }
        }
    }

}