<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

if (!file_exists(DIR_ROOT.'/taxid_option_email_template_backup')) {
    mkdir(DIR_ROOT . '/taxid_option_email_template_backup', 0755);
}

$language = Registry::getInstance()->get('language');

$languageId = $language->getContentLanguageID();

$emailTemplate1 = $this->db->query("SELECT * FROM ".$this->db->table('email_templates') ." WHERE text_id='storefront_order_confirm' and language_id=".$languageId." And status=1 LIMIT 1");
$query1 = $emailTemplate1->row;
$html_body1 = $query1['html_body'];
$text_body1 = $query1['text_body'];
$allowed_placeholders1 = $query1['allowed_placeholders'];

$current_date = ' '.date("Y-m-d H-i-s");

$sf_html_body = fopen(DIR_ROOT . '/taxid_option_email_template_backup/storefront_order_confirm_html_body'.$current_date.'.txt', "w") or die("Unable to open file!");
$sf_html_body_content = html_entity_decode($html_body1);
fwrite($sf_html_body, $sf_html_body_content);
fclose($sf_html_body);

$sf_text_body = fopen(DIR_ROOT . '/taxid_option_email_template_backup/storefront_order_confirm_text_body'.$current_date.'.txt', "w") or die("Unable to open file!");
$sf_text_body_content = html_entity_decode($text_body1);
fwrite($sf_text_body, $sf_text_body_content);
fclose($sf_text_body);

$sf_allowed_placeholders = fopen(DIR_ROOT . '/taxid_option_email_template_backup/storefront_order_confirm_allowed_placeholders'.$current_date.'.txt', "w") or die("Unable to open file!");
$sf_allowed_placeholders_content = $allowed_placeholders1;
fwrite($sf_allowed_placeholders, $sf_allowed_placeholders_content);
fclose($sf_allowed_placeholders);

$emailTemplate2 = $this->db->query("SELECT * FROM ".$this->db->table('email_templates') ." WHERE text_id='storefront_order_confirm_admin_notify' and language_id=".$languageId." And status=1 LIMIT 1");
$query2 = $emailTemplate2->row;
$html_body2 = $query2['html_body'];
$text_body2 = $query2['text_body'];
$allowed_placeholders2 = $query2['allowed_placeholders'];

$admin_html_body = fopen(DIR_ROOT . '/taxid_option_email_template_backup/storefront_order_confirm_admin_notify_html_body'.$current_date.'.txt', "w") or die("Unable to open file!");
$admin_html_body_content = html_entity_decode($html_body2);
fwrite($admin_html_body, $admin_html_body_content);
fclose($admin_html_body);

$admin_text_body = fopen(DIR_ROOT . '/taxid_option_email_template_backup/storefront_order_confirm_admin_notify_text_body'.$current_date.'.txt', "w") or die("Unable to open file!");
$admin_text_body_content = html_entity_decode($text_body2);
fwrite($admin_text_body, $admin_text_body_content);
fclose($admin_text_body);

$admin_allowed_placeholders = fopen(DIR_ROOT . '/taxid_option_email_template_backup/storefront_order_confirm_admin_notify_allowed_placeholders'.$current_date.'.txt', "w") or die("Unable to open file!");
$admin_allowed_placeholders_content = $allowed_placeholders2;
fwrite($admin_allowed_placeholders, $admin_allowed_placeholders_content);
fclose($admin_allowed_placeholders);

$check= "SHOW columns from ".$this->db->table('orders')." where field='taxid'";
$q=$this->db->query($check);
$exist=count($q->rows);
if ($exist==0) {
    $sql = "ALTER TABLE ".$this->db->table('orders')." ADD `taxid` VARCHAR(32) NOT NULL DEFAULT '' AFTER `fax`";
    $this->db->query($sql);
}

$check1= "SHOW columns from ".$this->db->table('orders')." where field='registration'";
$q1=$this->db->query($check1);
$exist1=count($q1->rows);
if ($exist1==0) {
    $sql1 = "ALTER TABLE ".$this->db->table('orders')." ADD `registration` VARCHAR(32) NOT NULL DEFAULT '' AFTER `taxid`";
    $this->db->query($sql1);
}

$check2= "SHOW columns from ".$this->db->table('orders')." where field='bank_name'";
$q2=$this->db->query($check2);
$exist2=count($q2->rows);
if ($exist2==0) {
    $sql2 = "ALTER TABLE ".$this->db->table('orders')." ADD `bank_name` VARCHAR(32) NOT NULL DEFAULT '' AFTER `registration`";
    $this->db->query($sql2);
}

$check3= "SHOW columns from ".$this->db->table('orders')." where field='bank_address'";
$q3=$this->db->query($check3);
$exist3=count($q3->rows);
if ($exist3==0) {
    $sql3 = "ALTER TABLE ".$this->db->table('orders')." ADD `bank_address` VARCHAR(32) NOT NULL DEFAULT '' AFTER `bank_name`";
    $this->db->query($sql3);
}

$check4= "SHOW columns from ".$this->db->table('orders')." where field='iban'";
$q4=$this->db->query($check4);
$exist4=count($q4->rows);
if ($exist4==0) {
    $sql4 = "ALTER TABLE ".$this->db->table('orders')." ADD `iban` VARCHAR(32) NOT NULL DEFAULT '' AFTER `bank_address`";
    $this->db->query($sql4);
}

$check5= "SHOW columns from ".$this->db->table('orders')." where field='swift'";
$q5=$this->db->query($check5);
$exist5=count($q5->rows);
if ($exist5==0) {
    $sql5 = "ALTER TABLE ".$this->db->table('orders')." ADD `swift` VARCHAR(32) NOT NULL DEFAULT '' AFTER `iban`";
    $this->db->query($sql5);
}

$check6= "SHOW columns from ".$this->db->table('addresses')." where field='taxid'";
$q6=$this->db->query($check6);
$exist6=count($q6->rows);
if ($exist6==0) {
    $sql6 = "ALTER TABLE ".$this->db->table('addresses')." ADD `taxid` VARCHAR(32) NOT NULL DEFAULT '' AFTER `company`";
    $this->db->query($sql6);
}

$sql7="CREATE TABLE IF NOT EXISTS " .$this->db->table('customer_additional_values') . " (
	`customer_additional_value_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `email` varchar(32) NOT NULL,
	`telephone` varchar(32) NOT NULL,
	`fax` varchar(32) NOT NULL,
	`company` varchar(32) NOT NULL,
	`taxid` varchar(32) NOT NULL,
	`registration` varchar(32) NOT NULL,
	`bank_name` varchar(32) NOT NULL,
	`bank_address` varchar(32) NOT NULL,
	`iban` varchar(32) NOT NULL,
	`swift` varchar(32) NOT NULL,
	PRIMARY KEY (`customer_additional_value_id`,`customer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;";
$this->db->query($sql7);

if (file_exists(DIR_EXT.'build_a_gift')) {
    $this->db->query("UPDATE ".$this->db->table("email_templates")." SET `html_body`='<html>
<head>
    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">
    <title> {{store_name}} - Order {{ order_id }} </title>
</head>
<body>
<table style=\"font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;\">
    <tr>
        <td class=\"align_left\">
            <a href=\"{{ store_url }}\" title=\"{{ store_name }}\">
                {{# logo_uri}}
                <img src=\"{{ logo_uri }}\" alt=\"{{store_name}}\" style=\"border: none;\">
                {{/ logo_uri}}
                {{^ logo_uri}}
                {{# logo_html}}
                {{logo_html}}
                {{/ logo_html}}
                {{/ logo_uri}}
            </a>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">Thank you for your interest in {{store_name}} products. Your order has been received and
            will be processed after payment is confirmed.
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color:#FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">Order
            Details
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">
            <table style=\"width: 100%;\">
                <tr>
                    <td style=\"width: 60%;\">
                        Order ID: <span
                            style=\"color: #069; font-weight: bold;\">{{ order_id }}</span><br/>
                        Date Ordered: {{ date_added }}<br>
                        Payment Method: <strong>{{ payment_method }}</strong><br/>
                        Shipping Method: <strong>{{{ shipping_method }}}</strong><br/>
                        <br/>
                    </td>
                    <td style=\"width: 40%;\">
                        {{# seller_info }}
                        <strong>Ordered From:<br> {{{ seller_info }}}</strong>
                        {{/ seller_info }}
                    </td>
                </tr>
            </table>
            <table style=\"width: 100%;\">
                <tr>
                    <td style=\"width: 60%;\">
                        Email: <strong>{{ customer_email }}</strong><br/>
                        Telephone: <strong>{{ customer_telephone }}</strong><br/>
                        {{# customer_mobile_phone }}
                        Telephone: <strong>{{ customer_mobile_phone }}</strong><br/>
                        {{/ customer_mobile_phone }}
                        {{# customer_fax }}
                        Fax: <strong>{{ customer_fax }}</strong><br/>
                        {{/ customer_fax }}
                        IP Address:<strong>{{ customer_ip }}</strong>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td>
            <table style=\"width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #FFFFFF;\">
                <tr style=\"background-color: #CCCCCC; text-transform: uppercase;\">
                    <th style=\"text-align: left; padding: 0.3em;\">Shipping Address</th>
                    <th style=\"text-align: left; padding: 0.3em;\">Payment Address</th>
                </tr>
                <tr>
                    <td style=\"padding: 0.3em; background-color: #EEEEEE; color: #000;\">
                        {{# shipping_data }}
                        {{ firstname }} {{lastname}} <br/>
                        {{# company }}
                        {{{ company }}} <br/>
                        {{/ company }}
                        {{# address_1 }}
                        {{{ address_1 }}} <br/>
                        {{/ address_1 }}
                        {{# address_2 }}
                        {{{ address_2 }}} <br/>
                        {{/ address_2 }}
                        {{{ city }}} {{{ postcode }}} <br/>
                        {{# zone }}
                        {{{ zone }}} <br/>
                        {{/ zone }}
                        {{{ country }}}
                        {{/ shipping_data }}
                    </td>
                    <td style=\"padding: 0.3em; background-color: #EEEEEE; color: #000;\">
                        {{# payment_data }}
                        {{ firstname }} {{lastname}} <br/>
                        {{# company }}
                        {{{ company }}} <br/>
                        {{/ company }}
                        {{# taxid }}
                        {{{ taxid }}} <br/>
                        {{/ taxid }}
                        {{# address_1 }}
                        {{{ address_1 }}} <br/>
                        {{/ address_1 }}
                        {{# address_2 }}
                        {{{ address_2 }}} <br/>
                        {{/ address_2 }}
                        {{{ city }}} {{{ postcode }}} <br/>
                        {{# zone }}
                        {{{ zone }}} <br/>
                        {{/ zone }}
                        {{{ country }}}<br/>
                        {{# registration }}
                        {{ registration }} <br/>
                        {{/ registration }}
                        {{# bank_name }}
                        {{ bank_name }} <br/>
                        {{/ bank_name }}
                        {{# bank_address }}
                        {{ bank_address }} <br/>
                        {{/ bank_address }}
                        {{# iban }}
                        {{ iban }} <br/>
                        {{/ iban }}
                        {{# swift }}
                        {{ swift }} <br/>
                        {{/ swift }}
                        {{/ payment_data }}
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">
            <table style=\"width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #000000;\">
                <tr style=\"background-color: #CCCCCC;\">
                    <th style=\"width: 40%; padding: 0.3em; color: #FFFFFF;\">Product</th>
                    <th class=\"align_left\" style=\"color: #FFFFFF;\">Model</th>
                    <th class=\"align_right\"
                        style=\"width: 10%; padding: 0.3em; color: #FFFFFF;\">Price
                    </th>
                    <th class=\"align_right\"
                        style=\"width: 15%; padding: 0.3em; color: #FFFFFF;\">Quantity
                    </th>
                    <th class=\"align_right\"
                        style=\"width: 20%; padding: 0.3em; color: #FFFFFF;\">Total
                    </th>
                </tr>
                {{# products }}
                <tr style=\"background-color: #EEEEEE; text-align: center;\">
                    <td class=\"align_left\" style=\"text-align: left;\">{{ name }}
                        {{# option }}
                        <br/>
                        &nbsp;&nbsp;- {{ name}} {{ value }}
                        {{# link }}
                        <br> &nbsp;&nbsp;{{{ link }}}
                        {{/ link}}
                        {{/ option }}
                        {{# message }} <br><br> <strong>Gift Message: </strong><br> {{ message }} {{/ message }}
                    <td class=\"align_left\"> {{ model }}</td>
                    <td class=\"align_right\"> {{ price }}</td>
                    <td class=\"align_right\"> {{ quantity }}</td>
                    <td class=\"align_right\"> {{ total }}</td>
                </tr>
                {{# child_products }}
                {{{ child_products }}}
                {{/ child_products }}
                {{/ products }}
                {{# totals }}
                <tr style=\"text-align: right;\">
                    <td colspan=\"3\">&nbsp;</td>
                    <td style=\"background-color: #EEEEEE; font-weight: bold; padding: 0.3em;\">{{{ title }}}</td>
                    <td style=\"background-color: #EEEEEE; padding: 0.3em;\"> {{ text }}</td>
                </tr>
                {{/ totals }}
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\"></td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{# comment }}
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">The
            comments for your order are:
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"> {{{ comment }}}</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{/ comment }}
    {{# invoice }}
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">To view
            your order click on the link below:
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"><a href=\"{{ invoice }}\"> {{ invoice }}</a></td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{/ invoice }}
    <tr>
        <td class=\"align_center\"
            style=\"font-size: 10px; border-top: 1px solid #069; text-decoration: none; color: #374953;\">
            <a href=\"{{ store_url }}\"
               style=\"color: #069; font-weight: bold; text-decoration: none;\">{{ store_name }}</a>
            {{{ text_project_label }}}
        </td>
    </tr>
</table>
</body>
</html>',
`text_body`='Thank you for your interest in {{store_name}} products. Your order has been received and will be processed after payment is confirmed.\r\n\r\nOrder Details\r\n\r\nOrder ID: {{ order_id }}\r\nDate Ordered: {{ date_added }}\r\nPayment Method: {{ payment_method }}\r\nShipping Method: {{{ shipping_method }}}\r\n\r\nEmail: {{ customer_email }}\r\nTelephone: {{ customer_telephone }}\r\n{{# customer_mobile_phone }}\r\nTelephone: {{ customer_mobile_phone }}\r\n{{/ customer_mobile_phone }}\r\n{{# customer_fax }}\r\nFax: {{ customer_fax }}\r\n{{/ customer_fax }}\r\nIP Address: {{ customer_ip }}\r\n{{# seller_info }}\r\nOrdered From: {{{ seller_info }}}\r\n{{/ seller_info }}\r\n\r\n{{# shipping_data }}\r\nShipping Address:\r\n{{{ firstname }}} {{{lastname}}}\r\n{{{ company }}} \r\n{{{ address_1 }}} \r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{/ shipping_data }}\r\n\r\n{{# payment_data }}\r\nPayment Address:\r\n{{{ firstname }}} {{{lastname}}}\r\n{{{ company }}} \r\n{{# taxid }}\r\n{{{ taxid }}}\r\n{{/ taxid }}\r\n{{{ address_1 }}} \r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{# registration }}\r\n{{ registration }}  \r\n{{/ registration }}\r\n{{# bank_name }}\r\n{{ bank_name }}  \r\n{{/ bank_name }}\r\n{{# bank_address }}\r\n{{ bank_address }}  \r\n{{/ bank_address }}\r\n{{# iban }}\r\n{{ iban }}  \r\n{{/ iban }}\r\n{{# swift }}\r\n{{ swift }}  \r\n{{/ swift }}\r\n{{/ payment_data }}\r\n\r\n\r\nProduct                                                 Model                             Price                  Quantity              Total\r\n{{# products }}\r\n					\r\n{{ name }}                                               {{ model }}                       {{ price }}            {{ quantity }}        {{ total }}\r\n   {{# option }}\r\n    - {{ name}} {{ value }}\r\n{{# link }}\r\n{{{ link }}}\r\n                        {{/ link}}\r\n{{/ option }}\r\n {{# message }} \r\n<strong>Gift Message: </strong>\r\n {{ message }}\r\n {{/ message }}\r\n\r\n\r\n{{# child_products }} \r\n {{{ child_products }}} \r\n {{/ child_products }} \r\n {{/ products }}\r\n{{# totals }}\r\n  {{{ title }}}  {{ text }}\r\n{{/ totals }}\r\n\r\n\r\n{{# comment }}\r\n	The comments for your order are:\r\n {{{ comment }}} \r\n{{/ comment }}\r\n\r\n{{# invoice }}\r\nTo view your order click on the link below:\r\n{{ invoice }}\r\n{{/ invoice }}\r\n\r\n{{ store_name }}\r\n{{ text_project_label }}',
`allowed_placeholders`='store_name, order_id, store_url, logo_uri, logo_html, date_added, payment_method, shipping_method, customer_email, customer_telephone, customer_mobile_phone, customer_fax, customer_ip, shipping_data, payment_data, products, totals, comment, invoice,  text_project_label, seller_info' WHERE `text_id`='storefront_order_confirm'");

    $this->db->query("UPDATE ".$this->db->table("email_templates")." SET
    `html_body`='<html>
<head>
    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">
    <title> {{store_name}} - Order {{ order_id }} </title>
</head>
<body>
<table style=\"font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;\">
    <tr>
        <td class=\"align_left\">
            <a href=\"{{ store_url }}\" title=\"{{ store_name }}\">
                {{# logo_uri}}
                <img src=\"{{ logo_uri }}\" alt=\"{{store_name}}\" style=\"border: none;\">
                {{/ logo_uri}}
                {{^ logo_uri}}
                {{# logo_html}}
                {{logo_html}}
                {{/ logo_html}}
                {{/ logo_uri}}
            </a>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">You have received an order.</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color:#FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">Order Details</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td>
            <table style=\"width: 100%;\">
                <tr>
                    <td style=\"width: 60%;\">
                        Order ID: <span
                            style=\"color: #069; font-weight: bold;\">{{ order_id }}</span><br/>
                        Date Ordered: {{ date_added }}<br>
                        Payment Method: <strong>{{ payment_method }}</strong><br/>
                        Shipping Method: <strong>{{{ shipping_method }}}</strong><br/>
                        <br/>
                    </td>
                    <td style=\"width: 40%;\">
                        {{# seller_info }}
                        <strong>Ordered From:<br> {{{ seller_info }}}</strong>
                        {{/ seller_info }}
                    </td>
                </tr>
            </table>
            <table style=\"width: 100%;\">
                <tr>
                    <td style=\"width: 60%;\">
                        Email: <strong>{{ customer_email }}</strong><br/>
                        Telephone: <strong>{{ customer_telephone }}</strong><br/>
                        {{# customer_mobile_phone }}
                        Telephone: <strong>{{ customer_mobile_phone }}</strong><br/>
                        {{/ customer_mobile_phone }}
                        {{# customer_fax }}
                        Fax: <strong>{{ customer_fax }}</strong><br/>
                        {{/ customer_fax }}
                        IP Address:<strong>{{ customer_ip }}</strong>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td>
            <table style=\"width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #FFFFFF;\">
                <tr style=\"background-color: #CCCCCC; text-transform: uppercase;\">
                    <th style=\"text-align: left; padding: 0.3em;\">Shipping Address</th>
                    <th style=\"text-align: left; padding: 0.3em;\">Payment Address</th>
                </tr>
                <tr>
                    <td style=\"padding: 0.3em; background-color: #EEEEEE; color: #000;\">
                        {{# shipping_data }}
                        {{ firstname }} {{lastname}} <br/>
                        {{# company }}
                        {{{ company }}} <br/>
                        {{/ company }}
                        {{# address_1 }}
                        {{{ address_1 }}} <br/>
                        {{/ address_1 }}
                        {{# address_2 }}
                        {{{ address_2 }}} <br/>
                        {{/ address_2 }}
                        {{{ city }}} {{{ postcode }}} <br/>
                        {{# zone }}
                        {{{ zone }}} <br/>
                        {{/ zone }}
                        {{{ country }}}
                        {{/ shipping_data }}
                    </td>
                    <td style=\"padding: 0.3em; background-color: #EEEEEE; color: #000;\">
                        {{# payment_data }}
                        {{ firstname }} {{lastname}} <br/>
                        {{# company }}
                        {{{ company }}} <br/>
                        {{/ company }}
                        {{# taxid }}
                        {{{ taxid }}} <br/>
                        {{/ taxid }}
                        {{# address_1 }}
                        {{{ address_1 }}} <br/>
                        {{/ address_1 }}
                        {{# address_2 }}
                        {{{ address_2 }}} <br/>
                        {{/ address_2 }}
                        {{{ city }}} {{{ postcode }}} <br/>
                        {{# zone }}
                        {{{ zone }}} <br/>
                        {{/ zone }}
                        {{{ country }}}<br/>
                        {{# registration }}
                        {{ registration }} <br/>
                        {{/ registration }}
                        {{# bank_name }}
                        {{ bank_name }} <br/>
                        {{/ bank_name }}
                        {{# bank_address }}
                        {{ bank_address }} <br/>
                        {{/ bank_address }}
                        {{# iban }}
                        {{ iban }} <br/>
                        {{/ iban }}
                        {{# swift }}
                        {{ swift }} <br/>
                        {{/ swift }}
                        {{/ payment_data }}
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">
            <table style=\"width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #000000;\">
                <tr style=\"background-color: #CCCCCC;\">
                    <th style=\"width: 40%; padding: 0.3em; color: #FFFFFF;\">Product</th>
                    <th class=\"align_left\" style=\"color: #FFFFFF;\">Model</th>
                    <th class=\"align_right\"
                        style=\"width: 10%; padding: 0.3em; color: #FFFFFF;\">Price</th>
                    <th class=\"align_right\"
                        style=\"width: 15%; padding: 0.3em; color: #FFFFFF;\">Quantity</th>
                    <th class=\"align_right\"
                        style=\"width: 20%; padding: 0.3em; color: #FFFFFF;\">Total</th>
                </tr>
                {{# products }}
                <tr style=\"background-color: #EEEEEE; text-align: center;\">
                    <td class=\"align_left\" style=\"text-align: left;\">{{ name }}
                        {{# option }}
                        <br/>
                        &nbsp;&nbsp;- {{ name}} {{ value }}
                        {{# link }}
                        <br> &nbsp;&nbsp;{{{ link }}}
                        {{/ link}}
                        {{/ option }}
                        {{# message }} <br><br> <strong>Gift Message: </strong><br> {{ message }} {{/ message }}
                    <td class=\"align_left\"> {{ model }} </td>
                    <td class=\"align_right\"> {{ price }} </td>
                    <td class=\"align_right\"> {{ quantity }} </td>
                    <td class=\"align_right\"> {{ total }}</td>
                </tr>
                {{# child_products }}
                {{{ child_products }}}
                {{/ child_products }}
                {{/ products }}
                {{# totals }}
                <tr style=\"text-align: right;\">
                    <td colspan=\"3\">&nbsp;</td>
                    <td style=\"background-color: #EEEEEE; font-weight: bold; padding: 0.3em;\">{{{ title }}} </td>
                    <td style=\"background-color: #EEEEEE; padding: 0.3em;\"> {{ text }}</td>
                </tr>
                {{/ totals }}
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\"></td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{# comment }}
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">The comments for your order are:</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"> {{{ comment }}} </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{/ comment }}
    {{# invoice }}
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">To view your order click on the link below:</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"><a href=\"{{ invoice }}\"> {{ invoice }}</a></td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{/ invoice }}
    <tr>
        <td class=\"align_center\"
            style=\"font-size: 10px; border-top: 1px solid #069; text-decoration: none; color: #374953;\">
            <a href=\"{{ store_url }}\"
               style=\"color: #069; font-weight: bold; text-decoration: none;\">{{ store_name }}</a>
            {{{ text_project_label }}}
        </td>
    </tr>
</table>
</body>
</html>',
`text_body`='You have received an order.\r\n\r\nOrder Details\r\n\r\nOrder ID: {{ order_id }}\r\nDate Ordered: {{ date_added }}\r\nPayment Method: {{ payment_method }}\r\nShipping Method: {{{ shipping_method }}}\r\n\r\nEmail: {{ customer_email }}\r\nTelephone: {{ customer_telephone }}\r\n{{# customer_mobile_phone }}\r\nTelephone: {{ customer_mobile_phone }}\r\n{{/ customer_mobile_phone }}\r\n{{# customer_fax }}\r\nFax: {{ customer_fax }}\r\n{{/ customer_fax }}\r\nIP Address: {{ customer_ip }}\r\n{{# seller_info }}\r\nOrdered From: {{{ seller_info }}}\r\n{{/ seller_info }}\r\n\r\n{{# shipping_data }}\r\nShipping Address:\r\n{{{ firstname }}} {{{lastname}}}\r\n{{{ company }}}\r\n\r\n{{{ address_1 }}} \r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{/ shipping_data }}\r\n\r\n{{# payment_data }}\r\nPayment Address:\r\n{{{ firstname }}} {{{lastname}}} \r\n{{{ company }}}\r\n{{# taxid }}\r\n{{{ taxid }}}\r\n{{/ taxid }}\r\n{{{ address_1 }}}\r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{# registration }}\r\n{{ registration }}  \r\n{{/ registration }}\r\n{{# bank_name }}\r\n{{ bank_name }}  \r\n{{/ bank_name }}\r\n{{# bank_address }}\r\n{{ bank_address }}  \r\n{{/ bank_address }}\r\n{{# iban }}\r\n{{ iban }}  \r\n{{/ iban }}\r\n{{# swift }}\r\n{{ swift }}  \r\n{{/ swift }}\r\n{{/ payment_data }}\r\n\r\n\r\nProduct                                                 Model                             Price                  Quantity              Total\r\n{{# products }}\r\n					\r\n{{ name }}                                               {{ model }}                       {{ price }}            {{ quantity }}        {{ total }}\r\n   {{# option }}\r\n    - {{ name}} {{ value }} \r\n{{# link }} \r\n  {{{ link }}} \r\n {{/ link}}\r\n   {{/ option }} \r\n\r\n {{# message }} \r\n Gift Message: \r\n {{ message }} \r\n {{/ message }} \r\n \r\n\ {{# child_products }} \r\n {{{ child_products }}} \r\n {{/ child_products }} \r\n {{/ products }}\r\n{{# totals }}\r\n  {{{ title }}}  {{ text }}\r\n{{/ totals }}\r\n\r\n\r\n{{# comment }}\r\n	The comments for your order are:\r\n {{{ comment }}} \r\n{{/ comment }}\r\n\r\n{{# invoice }}\r\nTo view your order click on the link below:\r\n{{ invoice }}\r\n{{/ invoice }}\r\n\r\n{{ store_name }}\r\n{{ text_project_label }}',
`allowed_placeholders`='store_name, order_id, store_url, logo_uri, logo_html, date_added, payment_method, shipping_method, customer_email, customer_telephone, customer_mobile_phone, customer_fax, customer_ip, shipping_data, payment_data, products, totals, comment, invoice,  text_project_label, order_total, seller_info' WHERE `text_id`='storefront_order_confirm_admin_notify'");
} else {
    $this->db->query("UPDATE ".$this->db->table("email_templates")." SET `html_body`='<html>
<head>
    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">
    <title> {{store_name}} - Order {{ order_id }} </title>
</head>
<body>
<table style=\"font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;\">
    <tr>
        <td class=\"align_left\">
            <a href=\"{{ store_url }}\" title=\"{{ store_name }}\">
                {{# logo_uri}}
                <img src=\"{{ logo_uri }}\" alt=\"{{store_name}}\" style=\"border: none;\">
                {{/ logo_uri}}
                {{^ logo_uri}}
                {{# logo_html}}
                {{logo_html}}
                {{/ logo_html}}
                {{/ logo_uri}}
            </a>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">Thank you for your interest in {{store_name}} products. Your order has been received and
            will be processed after payment is confirmed.
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color:#FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">Order
            Details
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">
            <table style=\"width: 100%;\">
                <tr>
                    <td style=\"width: 60%;\">
                        Order ID: <span
                            style=\"color: #069; font-weight: bold;\">{{ order_id }}</span><br/>
                        Date Ordered: {{ date_added }}<br>
                        Payment Method: <strong>{{ payment_method }}</strong><br/>
                        Shipping Method: <strong>{{{ shipping_method }}}</strong><br/>
                        <br/>
                    </td>
                    <td style=\"width: 40%;\">
                        {{# seller_info }}
                        <strong>Ordered From:<br> {{{ seller_info }}}</strong>
                        {{/ seller_info }}
                    </td>
                </tr>
            </table>
            <table style=\"width: 100%;\">
                <tr>
                    <td style=\"width: 60%;\">
                        Email: <strong>{{ customer_email }}</strong><br/>
                        Telephone: <strong>{{ customer_telephone }}</strong><br/>
                        {{# customer_mobile_phone }}
                        Telephone: <strong>{{ customer_mobile_phone }}</strong><br/>
                        {{/ customer_mobile_phone }}
                        {{# customer_fax }}
                        Fax: <strong>{{ customer_fax }}</strong><br/>
                        {{/ customer_fax }}
                        IP Address:<strong>{{ customer_ip }}</strong>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td>
            <table style=\"width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #FFFFFF;\">
                <tr style=\"background-color: #CCCCCC; text-transform: uppercase;\">
                    <th style=\"text-align: left; padding: 0.3em;\">Shipping Address</th>
                    <th style=\"text-align: left; padding: 0.3em;\">Payment Address</th>
                </tr>
                <tr>
                    <td style=\"padding: 0.3em; background-color: #EEEEEE; color: #000;\">
                        {{# shipping_data }}
                        {{ firstname }} {{lastname}} <br/>
                        {{# company }}
                        {{{ company }}} <br/>
                        {{/ company }}
                        {{# address_1 }}
                        {{{ address_1 }}} <br/>
                        {{/ address_1 }}
                        {{# address_2 }}
                        {{{ address_2 }}} <br/>
                        {{/ address_2 }}
                        {{{ city }}} {{{ postcode }}} <br/>
                        {{# zone }}
                        {{{ zone }}} <br/>
                        {{/ zone }}
                        {{{ country }}}
                        {{/ shipping_data }}
                    </td>
                    <td style=\"padding: 0.3em; background-color: #EEEEEE; color: #000;\">
                        {{# payment_data }}
                        {{ firstname }} {{lastname}} <br/>
                        {{# company }}
                        {{{ company }}} <br/>
                        {{/ company }}
                        {{# taxid }}
                        {{{ taxid }}} <br/>
                        {{/ taxid }}
                        {{# address_1 }}
                        {{{ address_1 }}} <br/>
                        {{/ address_1 }}
                        {{# address_2 }}
                        {{{ address_2 }}} <br/>
                        {{/ address_2 }}
                        {{{ city }}} {{{ postcode }}} <br/>
                        {{# zone }}
                        {{{ zone }}} <br/>
                        {{/ zone }}
                        {{{ country }}}<br/>
                        {{# registration }}
                        {{ registration }} <br/>
                        {{/ registration }}
                        {{# bank_name }}
                        {{ bank_name }} <br/>
                        {{/ bank_name }}
                        {{# bank_address }}
                        {{ bank_address }} <br/>
                        {{/ bank_address }}
                        {{# iban }}
                        {{ iban }} <br/>
                        {{/ iban }}
                        {{# swift }}
                        {{ swift }} <br/>
                        {{/ swift }}
                        {{/ payment_data }}
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">
            <table style=\"width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #000000;\">
                <tr style=\"background-color: #CCCCCC;\">
                    <th style=\"width: 40%; padding: 0.3em; color: #FFFFFF;\">Product</th>
                    <th class=\"align_left\" style=\"color: #FFFFFF;\">Model</th>
                    <th class=\"align_right\"
                        style=\"width: 10%; padding: 0.3em; color: #FFFFFF;\">Price
                    </th>
                    <th class=\"align_right\"
                        style=\"width: 15%; padding: 0.3em; color: #FFFFFF;\">Quantity
                    </th>
                    <th class=\"align_right\"
                        style=\"width: 20%; padding: 0.3em; color: #FFFFFF;\">Total
                    </th>
                </tr>
                {{# products }}
                <tr style=\"background-color: #EEEEEE; text-align: center;\">
                    <td class=\"align_left\" style=\"text-align: left;\">{{ name }}
                        {{# option }}
                        <br/>
                        &nbsp;&nbsp;- {{ name}} {{ value }}
                        {{# link }}
                        <br> &nbsp;&nbsp;{{{ link }}}
                        {{/ link}}
                        {{/ option }}
                    <td class=\"align_left\"> {{ model }}</td>
                    <td class=\"align_right\"> {{ price }}</td>
                    <td class=\"align_right\"> {{ quantity }}</td>
                    <td class=\"align_right\"> {{ total }}</td>
                </tr>
                {{/ products }}
                {{# totals }}
                <tr style=\"text-align: right;\">
                    <td colspan=\"3\">&nbsp;</td>
                    <td style=\"background-color: #EEEEEE; font-weight: bold; padding: 0.3em;\">{{{ title }}}</td>
                    <td style=\"background-color: #EEEEEE; padding: 0.3em;\"> {{ text }}</td>
                </tr>
                {{/ totals }}
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\"></td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{# comment }}
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">The
            comments for your order are:
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"> {{{ comment }}}</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{/ comment }}
    {{# invoice }}
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">To view
            your order click on the link below:
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"><a href=\"{{ invoice }}\"> {{ invoice }}</a></td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{/ invoice }}
    <tr>
        <td class=\"align_center\"
            style=\"font-size: 10px; border-top: 1px solid #069; text-decoration: none; color: #374953;\">
            <a href=\"{{ store_url }}\"
               style=\"color: #069; font-weight: bold; text-decoration: none;\">{{ store_name }}</a>
            {{{ text_project_label }}}
        </td>
    </tr>
</table>
</body>
</html>',
`text_body`='Thank you for your interest in {{store_name}} products. Your order has been received and will be processed after payment is confirmed.\r\n\r\nOrder Details\r\n\r\nOrder ID: {{ order_id }}\r\nDate Ordered: {{ date_added }}\r\nPayment Method: {{ payment_method }}\r\nShipping Method: {{{ shipping_method }}}\r\n\r\nEmail: {{ customer_email }}\r\nTelephone: {{ customer_telephone }}\r\n{{# customer_mobile_phone }}\r\nTelephone: {{ customer_mobile_phone }}\r\n{{/ customer_mobile_phone }}\r\n{{# customer_fax }}\r\nFax: {{ customer_fax }}\r\n{{/ customer_fax }}\r\nIP Address: {{ customer_ip }}\r\n{{# seller_info }}\r\nOrdered From: {{{ seller_info }}}\r\n{{/ seller_info }}\r\n\r\n{{# shipping_data }}\r\nShipping Address:\r\n{{{ firstname }}} {{{lastname}}}\r\n{{{ company }}} \r\n{{{ address_1 }}} \r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{/ shipping_data }}\r\n\r\n{{# payment_data }}\r\nPayment Address:\r\n{{{ firstname }}} {{{lastname}}}\r\n{{{ company }}} \r\n{{# taxid }}\r\n{{{ taxid }}}\r\n{{/ taxid }}\r\n{{{ address_1 }}} \r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{# registration }}\r\n{{ registration }}  \r\n{{/ registration }}\r\n{{# bank_name }}\r\n{{ bank_name }}  \r\n{{/ bank_name }}\r\n{{# bank_address }}\r\n{{ bank_address }}  \r\n{{/ bank_address }}\r\n{{# iban }}\r\n{{ iban }}  \r\n{{/ iban }}\r\n{{# swift }}\r\n{{ swift }}  \r\n{{/ swift }}\r\n{{/ payment_data }}\r\n\r\n\r\nProduct                                                 Model                             Price                  Quantity              Total\r\n{{# products }}\r\n					\r\n{{ name }}                                               {{ model }}                       {{ price }}            {{ quantity }}        {{ total }}\r\n   {{# option }}\r\n    - {{ name}} {{ value }}\r\n{{# link }} \r\n  {{{ link }}} \r\n{{/ link}}\r\n   {{/ option }}\r\n\r\n\r\n{{/ products }}\r\n{{# totals }}\r\n  {{{ title }}}  {{ text }}\r\n{{/ totals }}\r\n\r\n\r\n{{# comment }}\r\n	The comments for your order are:\r\n {{{ comment }}} \r\n{{/ comment }}\r\n\r\n{{# invoice }}\r\nTo view your order click on the link below:\r\n{{ invoice }}\r\n{{/ invoice }}\r\n\r\n{{ store_name }}\r\n{{ text_project_label }}',
`allowed_placeholders`='store_name, order_id, store_url, logo_uri, logo_html, date_added, payment_method, shipping_method, customer_email, customer_telephone, customer_mobile_phone, customer_fax, customer_ip, shipping_data, payment_data, products, totals, comment, invoice,  text_project_label, seller_info' WHERE `text_id`='storefront_order_confirm'");

    $this->db->query("UPDATE ".$this->db->table("email_templates")." SET `html_body`='<html>
<head>
    <meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">
    <title> {{store_name}} - Order {{ order_id }} </title>
</head>
<body>
<table style=\"font-family: Verdana,sans-serif; font-size: 11px; color: #374953; width: 600px;\">
    <tr>
        <td class=\"align_left\">
            <a href=\"{{ store_url }}\" title=\"{{ store_name }}\">
                {{# logo_uri}}
                <img src=\"{{ logo_uri }}\" alt=\"{{store_name}}\" style=\"border: none;\">
                {{/ logo_uri}}
                {{^ logo_uri}}
                {{# logo_html}}
                {{logo_html}}
                {{/ logo_html}}
                {{/ logo_uri}}
            </a>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">You have received an order.</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color:#FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">Order Details</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td>
            <table style=\"width: 100%;\">
                <tr>
                    <td style=\"width: 60%;\">
                        Order ID: <span
                            style=\"color: #069; font-weight: bold;\">{{ order_id }}</span><br/>
                        Date Ordered: {{ date_added }}<br>
                        Payment Method: <strong>{{ payment_method }}</strong><br/>
                        Shipping Method: <strong>{{{ shipping_method }}}</strong><br/>
                        <br/>
                    </td>
                    <td style=\"width: 40%;\">
                        {{# seller_info }}
                        <strong>Ordered From:<br> {{{ seller_info }}}</strong>
                        {{/ seller_info }}
                    </td>
                </tr>
            </table>
            <table style=\"width: 100%;\">
                <tr>
                    <td style=\"width: 60%;\">
                        Email: <strong>{{ customer_email }}</strong><br/>
                        Telephone: <strong>{{ customer_telephone }}</strong><br/>
                        {{# customer_mobile_phone }}
                        Telephone: <strong>{{ customer_mobile_phone }}</strong><br/>
                        {{/ customer_mobile_phone }}
                        {{# customer_fax }}
                        Fax: <strong>{{ customer_fax }}</strong><br/>
                        {{/ customer_fax }}
                        IP Address:<strong>{{ customer_ip }}</strong>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td>
            <table style=\"width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #FFFFFF;\">
                <tr style=\"background-color: #CCCCCC; text-transform: uppercase;\">
                    <th style=\"text-align: left; padding: 0.3em;\">Shipping Address</th>
                    <th style=\"text-align: left; padding: 0.3em;\">Payment Address</th>
                </tr>
                <tr>
                    <td style=\"padding: 0.3em; background-color: #EEEEEE; color: #000;\">
                        {{# shipping_data }}
                        {{ firstname }} {{lastname}} <br/>
                        {{# company }}
                        {{{ company }}} <br/>
                        {{/ company }}
                        {{# address_1 }}
                        {{{ address_1 }}} <br/>
                        {{/ address_1 }}
                        {{# address_2 }}
                        {{{ address_2 }}} <br/>
                        {{/ address_2 }}
                        {{{ city }}} {{{ postcode }}} <br/>
                        {{# zone }}
                        {{{ zone }}} <br/>
                        {{/ zone }}
                        {{{ country }}}
                        {{/ shipping_data }}
                    </td>
                    <td style=\"padding: 0.3em; background-color: #EEEEEE; color: #000;\">
                        {{# payment_data }}
                        {{ firstname }} {{lastname}} <br/>
                        {{# company }}
                        {{{ company }}} <br/>
                        {{/ company }}
                        {{# taxid }}
                        {{{ taxid }}} <br/>
                        {{/ taxid }}
                        {{# address_1 }}
                        {{{ address_1 }}} <br/>
                        {{/ address_1 }}
                        {{# address_2 }}
                        {{{ address_2 }}} <br/>
                        {{/ address_2 }}
                        {{{ city }}} {{{ postcode }}} <br/>
                        {{# zone }}
                        {{{ zone }}} <br/>
                        {{/ zone }}
                        {{{ country }}}<br/>
                        {{# registration }}
                        {{ registration }} <br/>
                        {{/ registration }}
                        {{# bank_name }}
                        {{ bank_name }} <br/>
                        {{/ bank_name }}
                        {{# bank_address }}
                        {{ bank_address }} <br/>
                        {{/ bank_address }}
                        {{# iban }}
                        {{ iban }} <br/>
                        {{/ iban }}
                        {{# swift }}
                        {{ swift }} <br/>
                        {{/ swift }}
                        {{/ payment_data }}
                    </td>
                </tr>
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\">
            <table style=\"width: 100%; font-family: Verdana,sans-serif; font-size: 11px; color: #000000;\">
                <tr style=\"background-color: #CCCCCC;\">
                    <th style=\"width: 40%; padding: 0.3em; color: #FFFFFF;\">Product</th>
                    <th class=\"align_left\" style=\"color: #FFFFFF;\">Model</th>
                    <th class=\"align_right\"
                        style=\"width: 10%; padding: 0.3em; color: #FFFFFF;\">Price</th>
                    <th class=\"align_right\"
                        style=\"width: 15%; padding: 0.3em; color: #FFFFFF;\">Quantity</th>
                    <th class=\"align_right\"
                        style=\"width: 20%; padding: 0.3em; color: #FFFFFF;\">Total</th>
                </tr>
                {{# products }}
                <tr style=\"background-color: #EEEEEE; text-align: center;\">
                    <td class=\"align_left\" style=\"text-align: left;\">{{ name }}
                        {{# option }}
                        <br/>
                        &nbsp;&nbsp;- {{ name}} {{ value }}
                        {{# link }}
                        <br> &nbsp;&nbsp;{{{ link }}}
                        {{/ link}}
                        {{/ option }}
                    <td class=\"align_left\"> {{ model }} </td>
                    <td class=\"align_right\"> {{ price }} </td>
                    <td class=\"align_right\"> {{ quantity }} </td>
                    <td class=\"align_right\"> {{ total }}</td>
                </tr>
                {{/ products }}
                {{# totals }}
                <tr style=\"text-align: right;\">
                    <td colspan=\"3\">&nbsp;</td>
                    <td style=\"background-color: #EEEEEE; font-weight: bold; padding: 0.3em;\">{{{ title }}} </td>
                    <td style=\"background-color: #EEEEEE; padding: 0.3em;\"> {{ text }}</td>
                </tr>
                {{/ totals }}
            </table>
        </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\"></td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{# comment }}
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">The comments for your order are:</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"> {{{ comment }}} </td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{/ comment }}
    {{# invoice }}
    <tr>
        <td class=\"align_left\"
            style=\"background-color: #069; color: #FFF; font-size: 12px; font-weight: bold; padding: 0.5em 1em;\">To view your order click on the link below:</td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    <tr>
        <td class=\"align_left\"><a href=\"{{ invoice }}\"> {{ invoice }}</a></td>
    </tr>
    <tr>
        <td>&nbsp;</td>
    </tr>
    {{/ invoice }}
    <tr>
        <td class=\"align_center\"
            style=\"font-size: 10px; border-top: 1px solid #069; text-decoration: none; color: #374953;\">
            <a href=\"{{ store_url }}\"
               style=\"color: #069; font-weight: bold; text-decoration: none;\">{{ store_name }}</a>
            {{{ text_project_label }}}
        </td>
    </tr>
</table>
</body>
</html>', 
`text_body`='You have received an order.\r\n\r\nOrder Details\r\n\r\nOrder ID: {{ order_id }}\r\nDate Ordered: {{ date_added }}\r\nPayment Method: {{ payment_method }}\r\nShipping Method: {{{ shipping_method }}}\r\n\r\nEmail: {{ customer_email }}\r\nTelephone: {{ customer_telephone }}\r\n{{# customer_mobile_phone }}\r\nTelephone: {{ customer_mobile_phone }}\r\n{{/ customer_mobile_phone }}\r\n{{# customer_fax }}\r\nFax: {{ customer_fax }}\r\n{{/ customer_fax }}\r\nIP Address: {{ customer_ip }}\r\n{{# seller_info }}\r\nOrdered From: {{{ seller_info }}}\r\n{{/ seller_info }}\r\n\r\n{{# shipping_data }}\r\nShipping Address:\r\n{{{ firstname }}} {{{lastname}}}\r\n{{{ company }}}\r\n\r\n{{{ address_1 }}} \r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{/ shipping_data }}\r\n\r\n{{# payment_data }}\r\nPayment Address:\r\n{{{ firstname }}} {{{lastname}}} \r\n{{{ company }}}\r\n{{# taxid }}\r\n{{{ taxid }}}\r\n{{/ taxid }}\r\n{{{ address_1 }}}\r\n{{{ address_2 }}}\r\n{{{ city }}} {{{ postcode }}}\r\n{{{ zone }}}\r\n{{{ country }}}\r\n{{# registration }}\r\n{{ registration }}  \r\n{{/ registration }}\r\n{{# bank_name }}\r\n{{ bank_name }}  \r\n{{/ bank_name }}\r\n{{# bank_address }}\r\n{{ bank_address }}  \r\n{{/ bank_address }}\r\n{{# iban }}\r\n{{ iban }}  \r\n{{/ iban }}\r\n{{# swift }}\r\n{{ swift }}  \r\n{{/ swift }}\r\n{{/ payment_data }}\r\n\r\n\r\nProduct                                                 Model                             Price                  Quantity              Total\r\n{{# products }}\r\n					\r\n{{ name }}                                               {{ model }}                       {{ price }}            {{ quantity }}        {{ total }}\r\n   {{# option }}\r\n    - {{ name}} {{ value }} \r\n{{# link }} \r\n  {{{ link }}} \r\n{{/ link}}\r\n   {{/ option }}\r\n\r\n\r\n{{/ products }}\r\n{{# totals }}\r\n  {{{ title }}}  {{ text }}\r\n{{/ totals }}\r\n\r\n\r\n{{# comment }}\r\n	The comments for your order are:\r\n {{{ comment }}} \r\n{{/ comment }}\r\n\r\n{{# invoice }}\r\nTo view your order click on the link below:\r\n{{ invoice }}\r\n{{/ invoice }}\r\n\r\n{{ store_name }}\r\n{{ text_project_label }}', 
`allowed_placeholders`='store_name, order_id, store_url, logo_uri, logo_html, date_added, payment_method, shipping_method, customer_email, customer_telephone, customer_mobile_phone, customer_fax, customer_ip, shipping_data, payment_data, products, totals, comment, invoice,  text_project_label, order_total, seller_info' WHERE `text_id`='storefront_order_confirm_admin_notify'");
}

if (file_exists(DIR_EXT.'delivery_scheduler')) {
    $language = Registry::getInstance()->get('language');

    $languageId = $language->getContentLanguageID();

    $emailTemplate1 = $this->db->query("SELECT * FROM ".$this->db->table('email_templates') ." WHERE text_id='storefront_order_confirm' and language_id=".$languageId." And status=1 LIMIT 1");
    $query1 = $emailTemplate1->row;
    $html_body1 = $query1['html_body'];
    $text_body1 = $query1['text_body'];

    $emailTemplate2 = $this->db->query("SELECT * FROM ".$this->db->table('email_templates') ." WHERE text_id='storefront_order_confirm_admin_notify' and language_id=".$languageId." And status=1 LIMIT 1");
    $query2 = $emailTemplate2->row;
    $html_body2 = $query2['html_body'];
    $text_body2 = $query2['text_body'];

    $replace_html_body1=$replace_text_body1=$allowed_placeholders1=$replace_html_body2=$replace_text_body2=$allowed_placeholders1='';
    if (stripos($html_body1,'{{# delivery_date }}') === false) {
        $search = ["IP Address:<strong>{{ customer_ip }}</strong>", "The comments for your order are:"];
        $replace = ["IP Address:<strong>{{ customer_ip }}</strong>
        </td>
        <td style=\"width: 40%\">
        {{# delivery_date }}
        Delivery Date: <strong>{{{ delivery_date }}}</strong> <br/>
        {{/ delivery_date }}
        {{# delivery_time }}
        Delivery Time: <strong>{{{ delivery_time }}}</strong> <br/>
        {{/ delivery_time }}
        {{# extra_details }}
        Extra Details: <strong>{{{ extra_details }}}</strong> <br/>
        {{/ extra_details }}",
            "The comments or special delivery instructions for your order are:"];
    }
    $replace_html_body1 = str_replace($search, $replace, $html_body1);
    if (stripos($text_body1, '{{# delivery_date }}') === false) {
        $search = ["{{/ seller_info }}"];
        $replace = ["{{/ seller_info }}
         {{# delivery_date }}
    Delivery Date: {{{ delivery_date }}}\r\n {{/ delivery_date}}
    {{# delivery_time }}\r\n Delivery Time: {{{ delivery_time }}} \r\n {{/ delivery_time}}
    {{# extra_details }}\r\n Extra Details: {{{ extra_details }}} \r\n {{/ extra_details}}\r\n",
            "The comments or special delivery instructions for your order are:"];
        $replace_text_body1 = str_replace($search, $replace, $text_body1);
    } else {
        $replace_text_body1 = $text_body1;
    }

    $allowed_placeholders1 = $query1['allowed_placeholders'];

    if (stripos($allowed_placeholders1, 'delivery_date') === false) {
        $laststring = substr("$allowed_placeholders1", -1);
        if ($laststring===',') {
            $allowed_placeholders1 .= ' delivery_date, delivery_time, extra_details, ';
        } else {
            $allowed_placeholders1 .= ' ,delivery_date, delivery_time, extra_details, ';
        }
    }
    if (stripos($html_body2,'{{# delivery_date }}') === false) {
        $search = ["IP Address:<strong>{{ customer_ip }}</strong>", "The comments for your order are:"];
        $replace = ["IP Address:<strong>{{ customer_ip }}</strong>
        </td>
        <td style=\"width: 40%\">
        {{# delivery_date }}
        Delivery Date: <strong>{{{ delivery_date }}}</strong> <br/>
        {{/ delivery_date }}
        {{# delivery_time }}
        Delivery Time: <strong>{{{ delivery_time }}}</strong> <br/>
        {{/ delivery_time }}
        {{# extra_details }}
        Extra Details: <strong>{{{ extra_details }}}</strong> <br/>
        {{/ extra_details }}",
            "The comments or special delivery instructions for your order are:"];
    }

    $replace_html_body2 = str_replace($search, $replace, $html_body2);
    if (stripos($text_body2, '{{# delivery_date }}') === false) {
        $search = ["{{/ seller_info }}"];
        $replace = ["{{/ seller_info }}
        {{# delivery_date }}
    Delivery Date: {{{ delivery_date }}}\r\n {{/ delivery_date}}
    {{# delivery_time }}\r\n Delivery Time: {{{ delivery_time }}} \r\n {{/ delivery_time}}
    {{# extra_details }}\r\n Extra Details: {{{ extra_details }}} \r\n {{/ extra_details}}\r\n",
            "The comments or special delivery instructions for your order are:"];
        $replace_text_body2 = str_replace($search, $replace, $text_body2);
    } else {
        $replace_text_body2 = $text_body2;
    }

    $allowed_placeholders2 = $query2['allowed_placeholders'];

    if (stripos($allowed_placeholders2, 'delivery_date') === false) {
        $laststring = substr($allowed_placeholders2, -1);
        if ($laststring===',') {
            $allowed_placeholders2 .= ' delivery_date, delivery_time, extra_details, ';
        } else {
            $allowed_placeholders2 .= ' ,delivery_date, delivery_time, extra_details, ';
        }
    }

    $this->db->query("UPDATE " . $this->db->table('email_templates') . " SET html_body='" . $replace_html_body1 . "',text_body='" . $replace_text_body1 . "',allowed_placeholders='" . $allowed_placeholders1 . "'  WHERE text_id='storefront_order_confirm' and language_id=" . $languageId);
    $this->db->query("UPDATE " . $this->db->table('email_templates') . " SET html_body='" . $replace_html_body2 . "',text_body='" . $replace_text_body2 . "',allowed_placeholders='" . $allowed_placeholders2 . "' WHERE text_id='storefront_order_confirm_admin_notify' and language_id=" . $languageId);

}

$sql8 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("taxid_option_license_info") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `public_key` TEXT NOT NULL,
  `license_data` TEXT NOT NULL,
  `license_key` TEXT NOT NULL,
  `store_id` int(11) NOT NULL,
  `last_check` int(11),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql8);

$sql9 = "CREATE TABLE IF NOT EXISTS ".$this->db->table("taxid_option_updater_notification") ."(
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) NOT NULL,
  `cart_version` VARCHAR(10),
  `extension_version` VARCHAR(10),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci";

$this->db->query($sql9);

if (!file_exists(DIR_SYSTEM.'lib/license.php')) {
    /**
     *  Function to Copy folders and files
     * @param $src
     * @param $dst
     * @return array
     */
    function custom_copy($src, $dst) {
        $error = array();
        // open the source directory
        $dir = opendir($src);
        if (!is_dir($dst)) {
            @mkdir($dst);
        }
        // Loop through the files in source directory
        foreach (scandir($src) as $file) {
            if (($file != '.') && ($file != '..')) {
                if (is_dir($src . '/' . $file)) {
                    // Recursively calling custom copy function
                    // for sub directory
                    custom_copy($src . '/' . $file, $dst . '/' . $file);
                } else {
                    if (!copy($src . '/' . $file, $dst . '/' . $file)) {
                        $error['error_copy'][] = "Failed to copy $file";
                    }
                }
            }
        }
        if (sizeof($error)>0) {
            $log=new ALog(DIR_SYSTEM.'logs/error.txt');
            $log->write(var_export($error,true));
        }
        closedir($dir);
        return $error;
    }

    $copy = custom_copy(DIR_EXT . 'taxid_option' . DIR_EXT_CORE . 'lib', DIR_SYSTEM.'lib');
}
