<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ModelSaleTaxidOption
 */
/** @noinspection PhpUndefinedClassInspection */
class ModelSaleTaxidOption extends Model {

	/**
	 * @param $order_id
	 * @return array|bool
	 * @throws AException
	 */
	public function getOrder($order_id){
	    $ups_plus_status=$this->config->get('ups_integration_plus_status');
	    if ($ups_plus_status==='1') {
            $order_query = $this->db->query("SELECT o.*, ap.location_phone
										 FROM `" . $this->db->table("orders") . "` o
										 LEFT JOIN `" . $this->db->table("ap_address_phone") . "` ap ON ap.order_id=o.order_id
										 WHERE o.order_id = '" . (int)$order_id . "'");
        } else {
            $order_query = $this->db->query("SELECT *
										 FROM `" . $this->db->table("orders") . "`
										 WHERE order_id = '" . (int)$order_id . "'");
        }

        if($order_query->num_rows){
			//Decrypt order data
			$order_row = $this->dcrypt->decrypt_data($order_query->row, 'orders');

			$this->load->model('localisation/country');
			$this->load->model('localisation/zone');
			$country_row = $this->model_localisation_country->getCountry($order_row['shipping_country_id']);
			if($country_row){
				$shipping_iso_code_2 = $country_row['iso_code_2'];
				$shipping_iso_code_3 = $country_row['iso_code_3'];
			} else{
				$shipping_iso_code_2 = '';
				$shipping_iso_code_3 = '';
			}

			$zone_row = $this->model_localisation_zone->getZone($order_row['shipping_zone_id']);
			if($zone_row){
				$shipping_zone_code = $zone_row['code'];
			} else{
				$shipping_zone_code = '';
			}

			$country_row = $this->model_localisation_country->getCountry($order_row['payment_country_id']);
			if($country_row){
				$payment_iso_code_2 = $country_row['iso_code_2'];
				$payment_iso_code_3 = $country_row['iso_code_3'];
			} else{
				$payment_iso_code_2 = '';
				$payment_iso_code_3 = '';
			}

			$zone_row = $this->model_localisation_zone->getZone($order_row['payment_zone_id']);
			if($zone_row){
				$payment_zone_code = $zone_row['code'];
			} else{
				$payment_zone_code = '';
			}

			$order_data = [
				'order_id'                => $order_row['order_id'],
				'invoice_id'              => $order_row['invoice_id'],
				'invoice_prefix'          => $order_row['invoice_prefix'],
				'store_id'                => $order_row['store_id'],
				'store_name'              => $order_row['store_name'],
				'store_url'               => $order_row['store_url'],
				'customer_id'             => $order_row['customer_id'],
				'customer_group_id'       => $order_row['customer_group_id'],
				'firstname'               => $order_row['firstname'],
				'lastname'                => $order_row['lastname'],
				'telephone'               => $order_row['telephone'],
				'fax'                     => $order_row['fax'],
				'taxid'                   => $order_row['taxid'],
				'registration'            => $order_row['registration'],
				'bank_name'               => $order_row['bank_name'],
				'bank_address'            => $order_row['bank_address'],
				'iban'                    => $order_row['iban'],
				'swift'                   => $order_row['swift'],
				'email'                   => $order_row['email'],
				'shipping_firstname'      => $order_row['shipping_firstname'],
				'shipping_lastname'       => $order_row['shipping_lastname'],
				'shipping_company'        => $order_row['shipping_company'],
				'shipping_address_1'      => $order_row['shipping_address_1'],
				'shipping_address_2'      => $order_row['shipping_address_2'],
				'shipping_postcode'       => $order_row['shipping_postcode'],
				'shipping_city'           => $order_row['shipping_city'],
				'shipping_zone_id'        => $order_row['shipping_zone_id'],
				'shipping_zone'           => $order_row['shipping_zone'],
				'shipping_zone_code'      => $shipping_zone_code,
				'shipping_country_id'     => $order_row['shipping_country_id'],
				'shipping_country'        => $order_row['shipping_country'],
				'shipping_iso_code_2'     => $shipping_iso_code_2,
				'shipping_iso_code_3'     => $shipping_iso_code_3,
				'shipping_address_format' => $order_row['shipping_address_format'],
				'shipping_method'         => $order_row['shipping_method'],
				'shipping_method_key'     => $order_row['shipping_method_key'],
				'payment_firstname'       => $order_row['payment_firstname'],
				'payment_lastname'        => $order_row['payment_lastname'],
				'payment_company'         => $order_row['payment_company'],
				'payment_address_1'       => $order_row['payment_address_1'],
				'payment_address_2'       => $order_row['payment_address_2'],
				'payment_postcode'        => $order_row['payment_postcode'],
				'payment_city'            => $order_row['payment_city'],
				'payment_zone_id'         => $order_row['payment_zone_id'],
				'payment_zone'            => $order_row['payment_zone'],
				'payment_zone_code'       => $payment_zone_code,
				'payment_country_id'      => $order_row['payment_country_id'],
				'payment_country'         => $order_row['payment_country'],
				'payment_iso_code_2'      => $payment_iso_code_2,
				'payment_iso_code_3'      => $payment_iso_code_3,
				'payment_address_format'  => $order_row['payment_address_format'],
				'payment_method'          => $order_row['payment_method'],
				'payment_method_key'      => $order_row['payment_method_key'],
				'comment'                 => $order_row['comment'],
				'total'                   => $order_row['total'],
				'order_status_id'         => $order_row['order_status_id'],
				'language_id'             => $order_row['language_id'],
				'currency_id'             => $order_row['currency_id'],
				'currency'                => $order_row['currency'],
				'value'                   => $order_row['value'],
				'coupon_id'               => $order_row['coupon_id'],
				'date_modified'           => $order_row['date_modified'],
				'date_added'              => $order_row['date_added'],
				'ip'                      => $order_row['ip'],
                'location_phone'          => $order_row['location_phone']
			];

			if(has_value($order_row['payment_method_data'])){
				$order_data['payment_method_data'] = $order_row['payment_method_data'];
			}

            $order_data['im'] = $this->getImFromOrderData((int)$order_id, (int)$order_data['customer_id']);

			return $order_data;
		} else{
			return false;
		}
	}

    /**
     * @param int $order_id
     * @param int $customer_id
     * @return array
     */
    public function getImFromOrderData($order_id, $customer_id){
        $order_id = (int)$order_id;
        if(!$order_id){
            return [];
        }
        $protocols = $this->im->getProtocols();
        if(!$protocols){
            return [];
        }
        $output = $p = array ();
        foreach ($protocols as $protocol){
            $p[] = $this->db->escape($protocol);
        }
        $sql = "SELECT od.*, odt.name as type_name
				FROM " . $this->db->table('order_data') . " od
				LEFT JOIN " . $this->db->table('order_data_types') . " odt ON odt.type_id = od.type_id
				WHERE od.order_id = " . (int)$order_id . "
						AND od.type_id IN (
									SELECT DISTINCT `type_id`
									FROM " . $this->db->table('order_data_types') . "
									WHERE `name` IN ('" . implode("', '", $p) . "')) ";
        $result = $this->db->query($sql);
        foreach ($result->rows as $row){
            if ($row['type_name'] == 'email'){
                continue;
            }
            $output[$row['type_name']] = unserialize($row['data']);
        }

        if( $customer_id ){
            foreach ($protocols as $protocol){
                if ($protocol == 'email' || $output[$protocol]){
                    continue;
                }
                $uri = $this->im->getCustomerURI($protocol, $customer_id, $order_id);
                $output[$protocol] = array ('uri' => $uri);
            }
        }

        return $output;
    }

	public function updateOrder($order_id,$data){
		$fields = [
			'taxid',
			'registration',
			'bank_name',
			'bank_address',
			'iban',
			'swift',
			'key_id'
		];
		$update = ['date_modified = NOW()'];

		if($this->dcrypt->active){
			//encrypt order data
			//check key_id to use from existing record
			$query_key = $this->db->query("select key_id from " . $this->db->table("orders") . "
							  WHERE order_id = '" . (int)$order_id . "'");
			$data['key_id'] = $query_key->rows[0]['key_id'];
			$data = $this->dcrypt->encrypt_data($data, 'orders');
			$fields[] = 'key_id';
		}

		foreach($fields as $f){
			if(isset($data[$f]) && $data[$f]!==''){
				$update[] = $f . " = '" . $this->db->escape($data[$f]) . "'";
			}
		}

		$this->db->query("UPDATE `" . $this->db->table("orders") . "`
						  SET " . implode(',', $update) . "
						  WHERE order_id = '" . (int)$order_id . "'");
	}

	public function updateOrderTaxIdInfo($order_id,$data) {
        if (is_array($data['value'])) {
            $value = current($data['value']);
            $this->db->query("UPDATE " . $this->db->table("orders") . " SET `".$data['column']."`='".$value."' WHERE order_id = " . (int)$order_id);
        } else {
            $this->db->query("UPDATE " . $this->db->table("orders") . " SET `".$data['column']."`='".$this->db->escape($data['value'])."' WHERE order_id = " . (int)$order_id);
        }

    }

	/**
	 * @param $customer_id
	 * @return mixed
	 */
	public function getCustomerAdditionalValues($customer_id) {
		$sql = "SELECT *
				FROM " . $this->db->table('customer_additional_values') . "
				WHERE customer_id = " . (int)$customer_id;
		$query = $this->db->query($sql);

		return $query->row;
	}

	public function getCustomerAdditionalValuesByEmail($email) {
		$sql = "SELECT *
				FROM " . $this->db->table('customer_additional_values') . "
				WHERE email = '" . $this->db->escape($email)."'";
		$query = $this->db->query($sql);
		return $query->row;
	}

    /**
     * @param $data
     * @return array
     */
    public function validateAdditionalValuesForCreate($data) {
        $errors = [];
        //$this->load->model('localisation/country');
        $this->load->model('account/customer');
        $this->load->model('catalog/content');
        $this->load->language('account/taxid_option');
        //$country=$this->model_localisation_country->getCountry($data['country_id']);
        if($this->config->get('config_account_create_captcha')) {
            if($this->config->get('config_recaptcha_secret_key')) {
                require_once DIR_VENDORS . '/google_recaptcha/autoload.php';
                $recaptcha = new \ReCaptcha\ReCaptcha($this->config->get('config_recaptcha_secret_key'));
                $resp = $recaptcha->verify(	$data['g-recaptcha-response'],
                    $this->request->getRemoteIP());
                if (!$resp->isSuccess() && $resp->getErrorCodes()) {
                    $errors['captcha'] = $this->language->get('error_captcha');
                }
            } else {
                if (!isset($this->session->data['captcha']) || ($this->session->data['captcha'] != $data['captcha'])) {
                    $errors['captcha'] = $this->language->get('error_captcha');
                }
            }
        }

        if ( $this->config->get('prevent_email_as_login')) {
            //validate only if email login is not allowed
            $login_name_pattern = '/^[\w._-]+$/i';
            if ( mb_strlen($data['loginname']) < 5
                || mb_strlen($data['loginname']) > 64
                || !preg_match($login_name_pattern, $data['loginname'])
            ) {
                $errors['loginname'] = $this->language->get('error_loginname');
                //validate uniqueness of login name
            } else if ( !$this->model_account_customer->is_unique_loginname($data['loginname']) ) {
                $errors['loginname'] = $this->language->get('error_loginname_notunique');
            }
        }

        if ((mb_strlen($data['firstname']) < 1) || (mb_strlen($data['firstname']) > 32)) {
            $errors['firstname'] = $this->language->get('error_firstname');
        }

        if ((mb_strlen($data['lastname']) < 1) || (mb_strlen($data['lastname']) > 32)) {
            $errors['lastname'] = $this->language->get('error_lastname');
        }

        $pattern=EMAIL_REGEX_PATTERN;

        if ((mb_strlen($data['email']) > 96) || (!preg_match($pattern, $data['email']))) {
            $errors['email'] = $this->language->get('error_email');
        }

        if ($this->model_account_customer->getTotalCustomersByEmail($data['email'])) {
            $errors['email'] = $this->language->get('error_exists');
        }

        if ($this->config->get('telephone_option_mandatory_status') == '1') {
            if (empty($data['telephone']) || (mb_strlen($data['telephone']) < 3) || (mb_strlen($data['telephone']) > 32)) {
                $errors['telephone'] = $this->language->get('telephone_error');
            }
        }

        if ($this->config->get('fax_option_mandatory_status') == '1') {
            if (empty($data['fax']) || (mb_strlen($data['fax']) > 32)) {
                $errors['fax'] = $this->language->get('fax_error');
            }
        }

        if ($this->config->get('company_option_mandatory_status') == '1') {
            if (empty($data['company'])) {
                $errors['company'] = $this->language->get('company_error');
            }
        }

        //$str=strtolower($v);
        if ($this->config->get('taxid_option_mandatory_status') == '1') {
            if (empty($data['taxid']) && strtolower($data['taxid']) !== 'na' && strtolower($data['taxid']) !== 'none') {
                $errors['taxid'] = $this->language->get('taxid_error');
            }
        }

        if ($this->config->get('registration_option_mandatory_status') == '1') {
            if (empty($data['registration'])) {
                $errors['registration'] = $this->language->get('registration_error');
            }
        }

        if ($this->config->get('bank_name_option_mandatory_status') == '1') {
            if (empty($data['bank_name'])) {
                $errors['bank_name'] = $this->language->get('bank_name_error');
            }
        }

        if ($this->config->get('bank_address_option_mandatory_status') == '1') {
            if (empty($data['bank_address'])) {
                $errors['bank_address'] = $this->language->get('bank_address_error');
            }
        }

        if ($this->config->get('iban_option_mandatory_status') == '1') {
            if (empty($data['iban']) && strtolower($data['iban']) !== 'na' && strtolower($data['iban']) !== 'none') {
                $errors['iban'] = $this->language->get('iban_error');
            }
        }

        if ($this->config->get('swift_option_mandatory_status') == '1') {
            if (empty($data['swift']) && strtolower($data['swift']) !== 'na' && strtolower($data['swift']) !== 'none') {
                $errors['swift'] = $this->language->get('swift_error');
            }
        }

        if ((mb_strlen($data['address_1']) < 3) || (mb_strlen($data['address_1']) > 128)) {
            $errors['address_1'] = $this->language->get('error_address_1');
        }

        if ((mb_strlen($data['city']) < 3) || (mb_strlen($data['city']) > 128)) {
            $errors['city'] = $this->language->get('error_city');
        }

        if ((mb_strlen($data['postcode']) < 3) || (mb_strlen($data['postcode']) > 128)) {
            $errors['postcode'] = $this->language->get('error_postcode');
        }

        if ($data['country_id'] == 'FALSE') {
            $errors['country'] = $this->language->get('error_country');
        }

        if ($data['zone_id'] == 'FALSE') {
            $errors['zone'] = $this->language->get('error_zone');
        }

        //check password length considering html entities (special case for characters " > < & )
        $pass_len = mb_strlen(htmlspecialchars_decode($data['password']));
        if ($pass_len < 4 || $pass_len > 20){
            $errors['password'] = $this->language->get('error_password');
        }

        if ($data['confirm'] != $data['password']) {
            $errors['confirm'] = $this->language->get('error_confirm');
        }

        if ($this->config->get('config_account_id')) {
            $this->load->model('catalog/content');

            $content_info = $this->model_catalog_content->getContent($this->config->get('config_account_id'));

            if ($content_info) {
                if (!isset($data['agree'])) {
                    $errors['warning'] = sprintf($this->language->get('error_agree'), $content_info['title']);
                }
            }
        }

        //validate IM URIs
        //get only active IM drivers
        $im_drivers = $this->im->getIMDriverObjects();
        if ($im_drivers) {
            foreach ($im_drivers as $protocol => $driver_obj) {
                /**
                 * @var AMailIM $driver_obj
                 */
                if (!is_object($driver_obj) || $protocol == 'email') {
                    continue;
                }
                $result = $driver_obj->validateURI($data[$protocol]);
                if (!$result) {
                    $errors[$protocol] = implode('<br>', $driver_obj->errors);
                }
            }
        }

        if (sizeof((array)$errors) && empty( $errors['warning'])) {
            $errors['warning'] = $this->language->get('gen_data_entry_error');
        }

        return $errors;
    }

    /**
     * @param array $data
     * @return array
     */
    public function validateAdditionalValuesForEdit($data) {
        $data = $data;
        $errors = [];
        //$this->load->model('localisation/country');
        $this->load->model('account/customer');
        $this->load->language('account/taxid_option');

        if ( $this->config->get('prevent_email_as_login') && isset($data['loginname']) ) {
            //validate only if email login is not allowed
            $login_name_pattern = '/^[\w._-]+$/i';
            if ((mb_strlen($data['loginname']) < 5) || (mb_strlen($data['loginname']) > 64)
                || (!preg_match($login_name_pattern, $data['loginname'])) ) {
                $errors['loginname'] = $this->language->get('error_loginname');
                //validate uniqueness of login name
            } else if ( !$this->model_account_customer->is_unique_loginname($data['loginname']) ) {
                $errors['loginname'] = $this->language->get('error_loginname_notunique');
            }
        }

        if ((mb_strlen($data['firstname']) < 1) || (mb_strlen($data['firstname']) > 32)) {
            $errors['firstname'] = $this->language->get('error_firstname');
        }

        if ((mb_strlen($data['lastname']) < 1) || (mb_strlen($data['lastname']) > 32)) {
            $errors['lastname'] = $this->language->get('error_lastname');
        }

        $pattern=EMAIL_REGEX_PATTERN;

        if ((mb_strlen($data['email']) > 96) || (!preg_match($pattern, $data['email']))) {
            $errors['email'] = $this->language->get('error_email');
        }

        if (($this->customer->getEmail() != $data['email']) && $this->model_account_customer->getTotalCustomersByEmail($data['email'])) {
            $errors['email'] = $this->language->get('error_exists');
        }

        if ($this->config->get('telephone_option_mandatory_status') == '1') {
            if (empty($data['telephone']) || (mb_strlen($data['telephone']) < 3) || (mb_strlen($data['telephone']) > 32)) {
                $errors['telephone'] = $this->language->get('telephone_error');
            }
        }

        if ($this->config->get('fax_option_mandatory_status') == '1') {
            if (empty($data['fax']) || (mb_strlen($data['fax']) > 32)) {
                $errors['fax'] = $this->language->get('fax_error');
            }
        }

        if ($this->config->get('registration_option_mandatory_status') == '1') {
            if (empty($data['registration'])) {
                $errors['registration'] = $this->language->get('registration_error');
            }
        }

        if ($this->config->get('bank_name_option_mandatory_status') == '1') {
            if (empty($data['bank_name'])) {
                $errors['bank_name'] = $this->language->get('bank_name_error');
            }
        }

        if ($this->config->get('bank_address_option_mandatory_status') == '1') {
            if (empty($data['bank_address'])) {
                $errors['bank_address'] = $this->language->get('bank_address_error');
            }
        }

        if ($this->config->get('iban_option_mandatory_status') == '1') {
            if (empty($data['iban'])) {
                $errors['iban'] = $this->language->get('iban_error');
            }
        }

        if ($this->config->get('swift_option_mandatory_status') == '1') {
            if (empty($data['swift'])) {
                $errors['swift'] = $this->language->get('swift_error');
            }
        }

        if ( sizeof((array)$errors) && empty( $errors['warning'] ) ) {
            $errors['warning'] = $this->language->get('gen_data_entry_error');
        }

        //validate IM URIs
        //get only active IM drivers
        $im_drivers = $this->im->getIMDriverObjects();
        if ($im_drivers) {
            foreach ($im_drivers as $protocol => $driver_obj) {
                /**
                 * @var AMailIM $driver_obj
                 */
                if (!is_object($driver_obj) || $protocol == 'email') {
                    continue;
                }
                $result = $driver_obj->validateURI($data[$protocol]);
                if (!$result) {
                    $errors[$protocol] = implode('<br>', $driver_obj->errors);
                }
            }
        }


        if (sizeof((array)$errors) && empty( $errors['warning'])) {
            $errors['warning'] = $this->language->get('gen_data_entry_error');
        }

        return $errors;
    }

	/**
	 * @param int $customer_id
	 * @param array $data
	 * @return bool
	 */
	public function addCustomerAdditionalValues($customer_id, $data = []) {
		if (!is_array($data) || !(int)$customer_id) {
			return false;
		}
		foreach ($data as $k => $val) {
			$this->db->query("DELETE FROM " . $this->db->table('customer_additional_values') . "
								WHERE customer_id = '" . (int)$customer_id . "'");

			$this->db->query("INSERT INTO " . $this->db->table('customer_additional_values') . "
												(customer_id, email, telephone, fax, company, taxid, registration, bank_name, bank_address, iban, swift)
								  VALUES (" . (int)$customer_id . ", '" . $this->db->escape($data['email']) . "',
								   		  '" . $this->db->escape($data['telephone']) . "',
								          '" . $this->db->escape($data['fax']) . "',
								          '" . $this->db->escape($data['company']) . "',
								          '" . $this->db->escape($data['taxid']) . "',
								          '" . $this->db->escape($data['registration']) . "',
								          '" . $this->db->escape($data['bank_name']) . "',
								          '" . $this->db->escape($data['bank_address']) . "',
								          '" . $this->db->escape($data['iban']) . "',
								          '" . $this->db->escape($data['swift']) . "');");
		}
		return true;
	}

	/**
	 * @param int $customer_id
	 * @param array $data
	 * @return bool
	 */
	public function updateCustomerAdditionalValues($customer_id, $data)
	{

		if (!has_value($data)) {
			return false;
		}

		foreach ($data as $key => $item) {
			$this->db->query("UPDATE  " . $this->db->table('customer_additional_values') . "
								  SET email='" . $this->db->escape($data['email']) . "',
								  	  telephone='" . $this->db->escape($data['telephone']) . "',
								      fax='" . $this->db->escape($data['fax']) . "',
								      company='" . $this->db->escape($data['company']) . "',
								      taxid='" . $this->db->escape($data['taxid']) . "',
								      registration='" . $this->db->escape($data['registration']) . "',
								      bank_name='" . $this->db->escape($data['bank_name']) . "',
								      bank_address='" . $this->db->escape($data['bank_address']) . "',
								      iban='" . $this->db->escape($data['iban']) . "',
								      swift='" . $this->db->escape($data['swift']) . "' WHERE customer_id='".$customer_id."'");
		}
		return true;
	}

	/**
	 * @param $customer_id
	 * @return mixed
	 */
	public function getCustomerId($customer_id) {
		$sql='SELECT customer_id FROM '. $this->db->table('customer_additional_values') . "
				WHERE customer_id = " . (int)$customer_id;
		$query = $this->db->query($sql);

		return $query->row['customer_id'];
	}

	/**
	 * @param $customer_id
	 * @return bool|stdClass
	 */
	public function deleteCustomer($customer_id){
		$sql='DELETE FROM '. $this->db->table('customer_additional_values') . " WHERE customer_id = " . (int)$customer_id;
		$query = $this->db->query($sql);
		return $query;
	}

	/**
	 * @param int $customer_id
	 * @return array
	 */
	public function getAddressesByCustomerId($customer_id) {
		$address_data = [];
		$query = $this->db->query("SELECT *
									FROM " . $this->db->table("addresses") . "
									WHERE customer_id = '" . (int)$customer_id . "'");

		foreach ($query->rows as $result) {
			$result = $this->dcrypt->decrypt_data($result, 'addresses');

			$this->load->model('localisation/country');
			$this->load->model('localisation/zone');

			$country_row = $this->model_localisation_country->getCountry($result['country_id']);
			if ( $country_row ) {
				$country = $country_row['name'];
				$iso_code_2 = $country_row['iso_code_2'];
				$iso_code_3 = $country_row['iso_code_3'];
				$address_format = $country_row['address_format'];
			} else {
				$country = '';
				$iso_code_2 = '';
				$iso_code_3 = '';
				$address_format = '';
			}

			$zone_row = $this->model_localisation_zone->getZone($result['zone_id']);
			if ( $zone_row ) {
				$zone = $zone_row['name'];
				$code = $zone_row['code'];
			} else {
				$zone = '';
				$code = '';
			}

			$address_data[$result['address_id']] = [
				'address_id'     => $result['address_id'],
				'firstname'      => $result['firstname'],
				'lastname'       => $result['lastname'],
				'company'        => $result['company'],
				'taxid'			 => $result['taxid'],
				'address_1'      => $result['address_1'],
				'address_2'      => $result['address_2'],
				'postcode'       => $result['postcode'],
				'city'           => $result['city'],
				'zone_id'        => $result['zone_id'],
				'zone'           => $zone,
				'zone_code'      => $code,
				'country_id'     => $result['country_id'],
				'country'        => $country,
				'iso_code_2'     => $iso_code_2,
				'iso_code_3'     => $iso_code_3,
				'address_format' => $address_format
			];
		}

		return $address_data;
	}

	/**
	 * @param int $customer_id
	 * @param array $address
	 * @return int
	 */
	public function addAddress($customer_id, $address=[]){
		if(!(int)$customer_id || !$address || !is_array($address)){
			return false;
		}
		//encrypt address data
		$key_sql = '';
		if ( $this->dcrypt->active ) {
			$address = $this->dcrypt->encrypt_data($address, 'addresses');
			$key_sql = ", key_id = '" . (int)$address['key_id'] . "'";
		}
		$this->db->query("INSERT INTO " . $this->db->table("addresses") . "
						  SET customer_id = '" . (int)$customer_id . "',
								firstname = '" . $this->db->escape($address['firstname']) . "',
								lastname = '" . $this->db->escape($address['lastname']) . "',
								company = '" . $this->db->escape($address['company']) . "',
								taxid = '" . $this->db->escape($address['taxid']) . "',
								address_1 = '" . $this->db->escape($address['address_1']) . "',
								address_2 = '" . $this->db->escape($address['address_2']) . "',
								city = '" . $this->db->escape($address['city']) . "',
								postcode = '" . $this->db->escape($address['postcode']) . "',
								country_id = '" . (int)$address['country_id'] . "'"
			.$key_sql . ",
								zone_id = '" . (int)$address['zone_id'] . "'");

		return (int)$this->db->getLastId();
	}

	/**
	 * @param int $customer_id
	 * @param int $address_id
	 * @param array $address
	 * @return bool
	 */
	public function editAddress($customer_id, $address_id, $address){
		if(!(int)$customer_id || !(int)$address_id || !$address || !is_array($address)){
			return false;
		}

		$this->deleteAddress($customer_id, $address_id);
		//encrypt address data
		$key_sql = '';
		if ( $this->dcrypt->active ) {
			$address = $this->dcrypt->encrypt_data($address, 'addresses');
			$key_sql = ", key_id = '" . (int)$address['key_id'] . "'";
		}

       $this->db->query("INSERT INTO " . $this->db->table("addresses"). "
						  SET   address_id = '" . (int)$address_id . "',
						  		customer_id = '" . (int)$customer_id . "',
								firstname = '" . $this->db->escape($address['firstname']) . "',
								lastname = '" . $this->db->escape($address['lastname']) . "',
								company = '" . $this->db->escape($address['company']) . "',
								taxid = '" . $this->db->escape($address['taxid']) . "',
								address_1 = '" . $this->db->escape($address['address_1']) . "',
								address_2 = '" . $this->db->escape($address['address_2']) . "',
								city = '" . $this->db->escape($address['city']) . "',
								postcode = '" . $this->db->escape($address['postcode']) . "',
								country_id = '" . (int)$address['country_id'] . "'"
			.$key_sql . ",
								zone_id = '" . (int)$address['zone_id'] . "'");
	}

    /**
     * @param int $customer_id
     * @param string $field
     * @param mixed $value
     * @return bool
     */
    public function editCustomerAdditionalField($customer_id, $field, $value) {
        if(!$customer_id || !$field){
            return false;
        }

        $data = [
            'registration',
            'bank_name',
            'bank_address',
            'iban',
            'swift'
            ];

        //adds IM fields
        //get only active IM drivers
        $im_protocols = $this->im->getProtocols();
        foreach ($im_protocols as $protocol){
            if(!in_array($protocol, $data)){
                $data[] = $protocol;
            }
        }

        if ( in_array($field, $data) ) {
            $this->db->query("UPDATE " . $this->db->table("customer_additional_values") . "
							  SET " . $field . " = '" . $this->db->escape($value) . "'
							  WHERE customer_id = '" . (int)$customer_id . "'");
        }
        return true;
    }

	/**
	 * @param int $customer_id
	 * @param int $address_id
	 * @return bool
	 */
	public function deleteAddress($customer_id, $address_id){
		if(!(int)$customer_id || !(int)$address_id ){
			return false;
		}

		$this->db->query("DELETE FROM " . $this->db->table("addresses") . " WHERE customer_id = '" . (int)$customer_id . "' AND address_id = '".(int)$address_id."'");
	}

    /**
     * @param $address_id
     * @return mixed
     * @throws AException
     */
    public function getTaxIdByAddressID($customer_id, $address_id) {
        $query = $this->db->query("SELECT `taxid` FROM " . $this->db->table("addresses") . " WHERE customer_id = '" . (int)$customer_id . "' AND address_id = '".(int)$address_id."'");
        return $query->row;
    }

}