<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ControllerResponsesListingGridTaxid
 * @property ModelSaleTaxidOption $model_sale_taxid_option
 */

class ControllerResponsesListingGridTaxid extends AController {
    public $error = '';
   
    private $shared_secret = "taxid_option";

    public function verify() {
        $this->load->model('extension/taxid_option_license_info');
        $license_key = $this->config->get('taxid_option_license_code');
        if ($license_key) {
            $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('taxid_option_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $this->model_extension_taxid_option_license_info->getStoreId();
                $license_key = $this->model_extension_taxid_option_license_info->getLicenseCode($store_id);
                $license_info = $this->model_extension_taxid_option_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $this->model_extension_taxid_option_license_info->getLicensedStoreStatus();
                if ($validate['status'] === 'valid' && $store_status == 1) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    /**
     * update only one field
     *
     * @return null
     */
    public function update_field() {
		if ($this->verify()===true) {
			//init controller data
			$this->extensions->hk_InitData( $this, __FUNCTION__ );

			$this->loadLanguage( 'sale/customer' );
			$this->loadModel( 'sale/customer' );
			$this->loadModel( 'sale/taxid_option' );
			if ( ! $this->user->canModify( 'listing_grid/customer' ) ) {
				$error = new AError( '' );

				return $error->toJSONResponse( 'NO_PERMISSIONS_402',
					[
						'error_text'  => sprintf( $this->language->get( 'error_permission_modify' ), 'listing_grid/customer' ),
						'reset_value' => true
					] );

			}
			$customer_id = $this->request->get['id'];
			$address_id  = $this->request->get['address_id'];
			$post_data   = $this->request->post;

			if ( isset( $customer_id ) ) {
				if ( $post_data['password'] || $post_data['password_confirm'] ) {
					$error = new AError( '' );
					if ( mb_strlen( $post_data['password'] ) < 4 ) {
						return $error->toJSONResponse( 'VALIDATION_ERROR_406',
							[
								'error_text'  => $this->language->get( 'error_password' ),
								'reset_value' => true
							] );
					}
					if ( $post_data['password'] != $post_data['password_confirm'] ) {
						return $error->toJSONResponse( 'VALIDATION_ERROR_406',
							[
								'error_text'  => $this->language->get( 'error_confirm' ),
								'reset_value' => true
							] );
					}
					//paswords do match, save
					$this->model_sale_customer->editCustomerField( $customer_id, 'password', $post_data['password'] );
				} else {
					foreach ( $post_data as $field => $value ) {
						$err = $this->_validateForm( $field, $value, $customer_id );
						if ( ! $err ) {
							if ( $field == 'approved' ) {
								$this->_sendMail( $customer_id, $value );
							}
							if ( $field == 'default' && $address_id ) {
								$this->model_sale_customer->setDefaultAddress( $customer_id, $address_id );
							} elseif ( has_value( $address_id ) ) {
								$this->model_sale_customer->editAddressField( $address_id, $field, $value );
							} elseif ( $field === 'registration' || $field === 'bank_name' || $field === 'bank_address' || $field === 'iban' || $field === 'swift' ) {
								$this->model_sale_taxid_option->editCustomerAdditionalField( $customer_id, $field, $value );
							} else {
								$this->model_sale_customer->editCustomerField( $customer_id, $field, $value );
							}
						} else {
							$error = new AError( '' );

							return $error->toJSONResponse( 'VALIDATION_ERROR_406',
								[
									'error_text'  => $err,
									'reset_value' => false
								] );

						}
					}
				}
				//update controller data
				$this->extensions->hk_UpdateData( $this, __FUNCTION__ );

				return null;
			}

			//request sent from jGrid. ID is key of array
			foreach ( $this->request->post as $field => $value ) {
				foreach ( $value as $k => $v ) {
					$err = $this->_validateForm( $field, $v );
					if ( ! $err ) {
						if ( $field == 'approved' ) {
							$this->_sendMail( key( $value ), current( $value ) );
						}
						$this->model_sale_customer->editCustomerField( $k, $field, $v );
					} else {
						$error = new AError( '' );

						return $error->toJSONResponse( 'VALIDATION_ERROR_406',
							[
								'error_text'  => $err,
								'reset_value' => false
							] );
					}
				}
			}

			//update controller data
			$this->extensions->hk_UpdateData( $this, __FUNCTION__ );
		}
    }

    private function _validateForm($field, $value, $customer_id = '') {
        $this->load->language('taxid_option/taxid_option');
        switch ($field) {
            case 'loginname' :
                $login_name_pattern = '/^[\w._-]+$/i';
                $value = preg_replace('/\s+/', '', $value);
                if ( mb_strlen($value) < 5 || mb_strlen($value) > 64
                    || (!preg_match($login_name_pattern, $value) && $this->config->get('prevent_email_as_login')) ) {
                    $this->error = $this->language->get('error_loginname');
                    //check uniqunes of loginname
                } else if ( !$this->model_sale_customer->is_unique_loginname($value, $customer_id) ) {
                    $this->error = $this->language->get('error_loginname_notunique');
                }
                break;
            case 'firstname' :
                if (mb_strlen($value) < 1 || mb_strlen($value) > 32 ) {
                    $this->error = $this->language->get('error_firstname');
                }
                break;
            case 'lastname':
                if ( mb_strlen($value) < 1 || mb_strlen($value) > 32 ) {
                    $this->error = $this->language->get('error_lastname');
                }
                break;
            case 'email':
                if ( mb_strlen($value) > 96 || !preg_match(EMAIL_REGEX_PATTERN, $value) ) {
                    $this->error = $this->language->get('error_email');
                }
                break;
            case 'company':
                if ($this->config->get('company_option_mandatory_status')) {
                    if (empty($value) || (mb_strlen($value) < 3) || (mb_strlen($value) > 32)) {
                        $this->error = $this->language->get('company_error');
                    }
                }
                break;
            case 'telephone':
                if ($this->config->get('telephone_option_mandatory_status')) {
                    if (empty($value) || (mb_strlen($value) < 3) || (mb_strlen($value) > 32)) {
                        $this->error = $this->language->get('telephone_error');
                    }
                }
                break;
            case 'taxid':
                if ($this->config->get('taxid_option_mandatory_status')) {
                    if (empty($value) && strtolower($value) !== 'na' && strtolower($value) !== 'none') {
                        $this->error = $this->language->get('taxid_error');
                    }
                }
                break;
            case 'fax':
                if ($this->config->get('fax_option_mandatory_status')) {
                    if (empty($value) || ((mb_strlen($value) > 32) && strtolower($value) != 'na' && strtolower($value) != 'none')) {
                        $this->error = $this->language->get('fax_error');
                    }
                }
                break;
            case 'registration':
                if ($this->config->get('registration_option_mandatory_status')) {
                    if (empty($value)) {
                        $this->error = $this->language->get('registration_error');
                    }
                }
                break;
            case 'bank_name':
                if ($this->config->get('bank_name_option_mandatory_status')) {
                    if (empty($value)) {
                        $this->error = $this->language->get('bank_name_error');
                    }
                }
                break;
            case 'bank_address':
                if ($this->config->get('bank_address_option_mandatory_status')) {
                    if (empty($value)) {
                        $this->error = $this->language->get('bank_address_error');
                    }
                }
                break;
            case 'iban':
                if ($this->config->get('iban_option_mandatory_status')) {
                    if (empty($value) && strtolower($value) !== 'na' && strtolower($value) !== 'none') {
                        $this->error = $this->language->get('iban_error');
                    }
                }
                break;
            case 'swift':
                if ($this->config->get('swift_option_mandatory_status')) {
                    if (empty($value) && strtolower($value) !== 'na' && strtolower($value) !== 'none') {
                        $this->error = $this->language->get('swift_error');
                    }
                }
                break;
            case 'address_1':
                if ( mb_strlen($value) < 1 ) {
                    $this->error = $this->language->get('error_address_1');
                }
                break;
            case 'city':
                if ( mb_strlen($value) < 1 ) {
                    $this->error = $this->language->get('error_city');
                }
                break;
            case 'country_id':
                if ( empty($value) || $value=='FALSE' ) {
                    $this->error = $this->language->get('error_country');
                }
                break;
            case 'zone_id':
                if ( empty($value) || $value=='FALSE' ) {
                    $this->error = $this->language->get('error_zone');
                }
                break;
        }

        $this->extensions->hk_ValidateData($this);

        return $this->error;
    }

    private function _sendMail($id, $approved) {

        // send email to customer
        $customer_info = $this->model_sale_customer->getCustomer($id);
        if ($customer_info && !$customer_info[ 'approved' ] && $approved) {

            $this->loadLanguage('mail/customer');
            $this->loadModel('setting/store');

            $store_info = $this->model_setting_store->getStore($customer_info[ 'store_id' ]);

            if ($store_info) {
                $store_name = $store_info[ 'store_name' ];
                $store_url = $store_info[ 'config_url' ] . 'index.php?rt=account/login';
                $store_logo_file = DIR_RESOURCE . $store_info['config_logo'];
                $store_logo = md5(pathinfo($store_info['config_logo'], PATHINFO_FILENAME)) . '.' . pathinfo($store_info['config_logo'], PATHINFO_EXTENSION);
            } else {
                $store_name = $this->config->get('store_name');
                $store_url = $this->config->get('config_url') . 'index.php?rt=account/login';
                $store_logo = md5(pathinfo($this->config->get('config_logo'), PATHINFO_FILENAME)) . '.' . pathinfo($this->config->get('config_logo'), PATHINFO_EXTENSION);
                $store_logo_file = DIR_RESOURCE . $this->config->get('config_logo');
            }

            $plain_text = sprintf($this->language->get('text_welcome'), $store_name) . "\n\n";

            $plain_text .= $this->language->get('text_login') . "\n";
            $plain_text .= $store_url . "\n\n";
            $plain_text .= $this->language->get('text_services') . "\n\n";
            $plain_text .= $this->language->get('text_thanks') . "\n";
            $plain_text .= $store_name;


            //build HTML message with the template
            $template = new ATemplate();
            $template->data['text_welcome'] = sprintf($this->language->get('text_welcome'), $store_name) . "\n\n";

            $template->data['text_login'] = $this->language->get('text_login');
            $template->data['text_login_later'] = '<a href="' . $store_url . '">' . $store_url . '</a>';
            $template->data['text_services'] = $this->language->get('text_services');


            $template->data['logo'] = 'cid:' . $store_logo;
            $template->data['store_name'] = $store_name;
            $template->data['store_url'] = $store_url;
            $template->data['text_thanks'] = $this->language->get('text_thanks');

            $template->data['text_project_label'] = project_base();
            $html_body = $template->fetch('mail/account_create.tpl');

            $mail = new AMail($this->config);
            $mail->setTo($customer_info[ 'email' ]);
            $mail->setFrom($this->config->get('store_main_email'));
            $mail->setSender($store_name);
            $mail->setSubject(sprintf($this->language->get('text_subject'), $store_name));
            $mail->setText(html_entity_decode($plain_text, ENT_QUOTES, 'UTF-8'));
            $mail->setHtml($html_body);
            $mail->addAttachment($store_logo_file, $store_logo);
            $mail->send();
        }
    }

}