<?php

if (!defined('DIR_CORE')) {
	header('Location: static_pages/');
}
/**
 * @property ModelCatalogProduct $model_catalog_product
 * @property ModelCatalogManufacturer $model_catalog_manufacturer
 * @property ModelAccountAddress $model_account_address
 *
 */
class ModelSuperMenuSuperMenu extends Model {

	private $total;
	private $total_data;




	public function _getMenu() {

		//get cache
		$super_menus = $this->cache->get('super_menus');
		if (is_null($super_menus)) {
			$sql = "SELECT p.*, COALESCE(pd.name,'super_menu') as name
					FROM " . $this->db->table('super_menus') . " p
					LEFT JOIN " . $this->db->table('super_menu_descriptions') . " pd
						ON pd.super_menu_id=p.super_menu_id AND pd.language_id = '" . $this->language->getLanguageID() . "'
					WHERE `status` = '1';";

			//$this->log->write(print_r($sql, true).' $sql in model');
			$super_menus = $this->db->query($sql);
			$super_menus = $super_menus->rows;
			//$this->log->write(print_r($super_menus, true).' $super_menus in model');

			foreach ($super_menus as &$menudata) {
				$menudata['items'] = unserialize($menudata['items']);
				//$menudata['items']['relation']['value'] = $menudata['items']['relation']['value'] == 'false' ? false : true;
			}
			//$this->log->write(print_r($menudata, true).' $menudata in model');
			//resort items by sort order
			function sortByOrder($a, $b) { //php 5.2+
		    return $a['sort'] - $b['sort'];
			}

			$itemsbeforesort = $menudata['items']['items'];
			usort($itemsbeforesort, 'sortByOrder');
			//$this->log->write(print_r($itemsbeforesort, true).' sorted in model');
			$menudata['items']['items'] = $itemsbeforesort;
			//$this->log->write(print_r($menudata['items'], true).' sorted $menudata items in model');
			unset($itemsbeforesort);
			$super_menus = $menudata;
			//set cache to do clear cache on settings SAVE
			$this->cache->set('super_menus', $super_menus);
		}
		return $super_menus;
	}

















	public function getTotal(&$total_data, &$total, &$taxes) {
		$status = $this->config->get('super_menu_total_status');

		if(!$this->config->get('super_menu_cart') && in_array($this->request->get['rt'], array('checkout/cart', 'r/checkout/cart/recalc_totals'))){
			$status = 0;
		}
		if(!$this->config->get('super_menu_status')){
			$status = 0;
		}

		if ($status) {
			$this->total_data = $total_data;
			$this->total = $total;
			$this->_getMenu();
			$total_data = $this->total_data;
			$total = $this->total;
		}
	}















	/**
	 * @param array $items
	 * @return bool|null
	 */
	private function _check_items($items) {
		if (!is_array($items['items'])) {
			return null;
		}

		foreach ($items['items'] as $item) {
			$result = $this->_check_item($item);
			if ($items['relation']['if'] == 'any'
					&& $result === $items['relation']['value']
			) {
				return true;
			} elseif ($items['relation']['if'] == 'all'
					&& $result !== $items['relation']['value']
			) {
				return false;
			}
		}


		// if still not returned
		return $items['relation']['if'] == 'any' ? false : true;
	}

	/**
	 * @param array $item
	 * @return bool|null
	 */
	private function _check_item($item) {
		$result = null;

		if (!$item['object']) {
			return null;
		}

		switch ($item['object']) {
			case 'products':
				$products = $this->cart->getProducts();
				foreach ($products as $product) {
					$products_ids[] = $product['product_id'];
				}
				return $this->_run_comparison($products_ids, $item['value'], $item['style']);
				break;

			case 'product_price':
				$products = $this->cart->getProducts();
				foreach ($products as $product) {
					if ($this->_run_comparison($product['price'], $item['value'], $item['style'])) {
						return true;
					}
				}
				return false;
				break;
			case 'categories':
				$products = $this->cart->getProducts();
				$this->load->model('catalog/product');
				$cart_categories = array();
				foreach ($products as $product) {
					$res = $this->model_catalog_product->getCategories($product['product_id']);
					foreach ($res as $row) {
						$cart_categories[] = $row['category_id'];
					}
				}
				$cart_categories = array_unique($cart_categories);
				return $this->_run_comparison($cart_categories, $item['value'], $item['style']);
				break;

			case 'brands':
				$products = $this->cart->getProducts();
				$this->load->model('catalog/manufacturer');
				$cart_brands = array();
				foreach ($products as $product) {
					$res = $this->model_catalog_manufacturer->getManufacturerByProductId($product['product_id']);
					foreach ($res as $row) {
						$cart_brands[] = $row['manufacturer_id'];
					}
				}
				$cart_brands = array_unique($cart_brands);
				return $this->_run_comparison($cart_brands, $item['value'], $item['style']);
				break;

			case 'customers':
				$customer = $this->customer->getId();
				return $this->_run_comparison($customer, $item['value'], $item['style']);
				break;

			case 'customer_groups':
				$customer_group = $this->customer->getCustomerGroupId();
				return $this->_run_comparison($customer_group, $item['value'], $item['style']);
				break;

			case 'customer_country':
			case 'customer_postcode':
				$address_id = $this->session->data['shipping_address_id'];
				$address_id = !$address_id ? $this->customer->getAddressId() : $address_id;

				$this->load->model('account/address');
				$res = $this->model_account_address->getAddress($address_id);
				if ($item['object'] == 'customer_country') {
					$id = (int)$res['country_id'];
				} elseif ($item['object'] == 'customer_postcode') {
					$id = (int)$res['postcode'];
				}

				return $this->_run_comparison($id, $item['value'], $item['style']);
				break;
			case 'order_subtotal':
				$subtotal = $this->cart->getSubtotal();
				if (!in_array($item['style'], array('in', 'notin'))) {
					$item['value'] = (float)$item['value'];
				}else{
					$item['value'] = explode(',',$item['value']);
				}
				return $this->_run_comparison($subtotal, $item['value'], $item['style']);
				break;
			case 'order_product_count':

				$products_count = $this->cart->countProducts();
				if (!in_array($item['style'], array('in', 'notin'))) {
					$item['value'] = (int)$item['value'];
				}else{
					$item['value'] = explode(',',$item['value']);
				}
				return $this->_run_comparison($products_count, $item['value'], $item['style']);
				break;
			case 'order_product_weight':
				$weight = round($this->cart->getWeight(), 2);
				if (!in_array($item['style'], array('in', 'notin'))) {
					$item['value'] = round((float)$item['value'], 2);
				}else{
					$item['value'] = explode(',',$item['value']);
				}
				return $this->_run_comparison($weight, $item['value'], $item['style']);
				break;
			case 'payment_method':
				$payment_method = $this->session->data['payment_method']['id'];
				return $this->_run_comparison($payment_method, $item['value'], $item['style']);
				break;
			case 'shipping_method':
				$shipping_method = $this->session->data['shipping_method']['id'];
				$shipping_method = explode('.', $shipping_method);
				$shipping_method = $shipping_method[0];
				return $this->_run_comparison($shipping_method, $item['value'], $item['style']);
				break;
			case 'coupon_code':
				$coupon_code = $this->session->data['coupon'];
				return $this->_run_comparison($coupon_code, $item['value'], $item['style']);
				break;
		}
		return $result;
	}

	/**
	 * @param mixed $value1
	 * @param mixed $value2
	 * @param string $style
	 * @return bool
	 */
	private function _run_comparison($value1, $value2, $style) {
		switch ($style) {
			case 'eq':
				return ($value1 == $value2);
				break;
			case 'neq':
				return ($value1 != $value2);
				break;
			case 'eqlt':
				return ($value1 <= $value2);
				break;
			case 'eqgt':
				return ($value1 >= $value2);
				break;
			case 'lt':
				return ($value1 < $value2);
				break;
			case 'gt':
				return ($value1 > $value2);
				break;
			case 'in':
				$value2 = (array)$value2;
				if (!is_array($value1)) {
					return in_array($value1, $value2);
				} else {
					return array_intersect($value1, $value2) ? true : false;
				}
				break;
			case 'notin':
				$value2 = (array)$value2;
				if (!is_array($value1)) {
					return !in_array($value1, $value2);
				} else {
					return !array_intersect($value1, $value2) ? true : false;
				}
				break;
			case 'ctn':
				return is_int(strpos((string)$value1, (string)$value2)) ? true : false;
				break;
			case 'nctn':
				return !is_int(strpos((string)$value1, (string)$value2)) ? true : false;
				break;
			default:
				return false;
				break;
		}
	}

	/**
	 * @param string $super_menus_name
	 * @param array $bonuses
	 * @return bool
	 */
	private function _getMenu_bonuses($super_menus_name, $bonuses) {

		$applied = array();
		$discount = 0;

		foreach ($bonuses as $bonus) {
			if (!in_array($bonus['object'], $applied)) {
				$bonus_discount = $this->_process_bonus($bonus);
				if (($discount + $bonus_discount) > $this->total) {
					break; // prevent negative total
				}
				$discount += $bonus_discount;
			}
			$applied[] = $bonus['object'];
		}
		if ($discount) {
			$this->total_data[] = array(
				'id' => 'super_menu',
				'title' => $super_menus_name,
				'text' => ' - ' . $this->currency->format($discount),
				'value' => -$discount,
				'sort_order' => $this->config->get('super_menu_total_sort_order'),
				'total_type' => $this->config->get('super_menu_total_total_type')
			);
			$this->total -= $discount;
			return true;
		}
		return false;
	}

	/**
	 * @param array $bonus
	 * @return bool|float|int|null
	 */
	private function _process_bonus($bonus) {
		$bonus['value'] = !isset($bonus['value']) ? array() : $bonus['value'];
		$discount = 0;
		switch ($bonus['object']) {
			case 'order_discount':
				$subtotal = false;
				foreach ($this->total_data as $item) {
					if ($item['id'] == 'subtotal') {
						$subtotal = $item['value'];
						break;
					}
				}
				if ($subtotal === false) {
					return null;
				}

				$discount = $this->_get_discount($bonus['style'], $subtotal, $bonus['value']);

				break;
			case 'free_shipping':
				$shipping_cost = false;
				foreach ($this->total_data as $item) {
					if ($item['id'] == 'shipping') {
						$shipping_method = $this->session->data['shipping_method']['id'];
						$shipping_method = explode('.', $shipping_method);
						$shipping_method = $shipping_method[0];

						if (in_array($shipping_method, $bonus['value'])) {
							$shipping_cost = $item['value'];
							break;
						}
					}
				}
				if ($shipping_cost === false) {
					return null;
				}
				$discount = $shipping_cost;
				break;
			case 'discount_products':
				$products = $this->cart->getProducts();
				foreach ($products as $product) {
					if (in_array($product['product_id'], array_keys($bonus['products']))) {
						$total = $product['price'] * $bonus['products'][$product['product_id']]['quantity'];
						$discount += $this->_get_discount($bonus['style'], $total, $bonus['value']);
						unset($bonus['products'][$products['product_id']]); // prevent repetition of bonus
					}
				}
				break;
			case 'free_products':
				$products = $this->cart->getProducts();
				foreach ($products as $product) {
					if (in_array($product['product_id'], array_keys($bonus['products']))) {
						$discount += $product['price'] * $bonus['products'][$product['product_id']]['quantity'];
						unset($bonus['products'][$products['product_id']]); // prevent repetition of bonus
					}
				}
				break;
		}
		return $discount;
	}

	private function _get_discount($style, $price, $value) {
		$discount = 0;

		if ($style == 'to_prc') {
			$discount = $price * (100 - $value) / 100;

		} elseif ($style == 'by_prc') {
			$discount = $price * $value / 100;

		} elseif ($style == 'to_fixed') {
			$discount = $price - $value;

		} elseif ($style == 'by_fixed') {
			$discount = $value;
		}

		if ($discount < 0) {
			$discount = 0;
		}

		return $discount;
	}

}
