<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ExtensionSuperMenu extends Extension
{
    //private $registry;
    public $data = array();

    public function __construct()
    {
        $this->registry = Registry::getInstance();
    }

    public function __get($key)
    {
        return $this->registry->get($key);
    }

    /**************************************************/

    public function onControllerCommonPage_UpdateData()
    {
        //if (IS_ADMIN && $this->baseObject->request->get['extension']=='super_menu')
        if (IS_ADMIN && '1' == $this->baseObject->request->get['super_menu_id']) {
            $this->baseObject->document->addScript($this->baseObject->view->templateResource('/javascript/bootstrap-colorpicker.js'));
            $this->baseObject->document->addScript($this->baseObject->view->templateResource('/javascript/colorpicker-connect.js'));

            $this->baseObject->document->addStyle(
                array(
                     'href' => $this->baseObject->view->templateResource('/javascript/bootstrap-colorpicker.css'),
                     'rel' => 'stylesheet',
                     'media' => 'screen',
                )
            );

            $this->baseObject->document->addScript($this->baseObject->view->templateResource('/javascript/jquery.fontselect-2.js'));
            $this->baseObject->document->addStyle(
                array(
                     'href' => $this->baseObject->view->templateResource('/javascript/fontselect-alternate.css'),
                     'rel' => 'stylesheet',
                     'media' => 'screen',
                )
            );
        }

        if (IS_ADMIN && '1' == $this->baseObject->request->get['super_menu_id'] && 'items' == $this->baseObject->request->get['tab']) {
            $this->baseObject->document->addScript($this->baseObject->view->templateResource('/javascript/dist/trumbowyg.min.js'));

            $this->baseObject->document->addStyle(
                array(
                     'href' => $this->baseObject->view->templateResource('/javascript/dist/trumbowyg.min.css'),
                     'rel' => 'stylesheet',
                     'media' => 'screen',
                )
            );

            //plugins
            $this->baseObject->document->addStyle(
                array(
                     'href' => $this->baseObject->view->templateResource('/javascript/dist/ui/trumbowyg.css'),
                     'rel' => 'stylesheet',
                     'media' => 'screen',
                )
            );
            $this->baseObject->document->addStyle(
                array(
                     'href' => $this->baseObject->view->templateResource('/javascript/dist/plugins/colors/ui/trumbowyg.colors.css'),
                     'rel' => 'stylesheet',
                     'media' => 'screen',
                )
            );
            $this->baseObject->document->addScript($this->baseObject->view->templateResource('/javascript/dist/plugins/colors/trumbowyg.colors.js'));
            $this->baseObject->document->addScript($this->baseObject->view->templateResource('/javascript/dist/plugins/template/trumbowyg.template.js'));
            $this->baseObject->document->addScript($this->baseObject->view->templateResource('/javascript/dist/plugins/allowtagsfrompaste/trumbowyg.allowtagsfrompaste.js'));
        }

        if (!IS_ADMIN) {
            $this->baseObject->document->addScript(DIR_EXTENSIONS.'super_menu'.DIR_EXT_STORE.'view/default/js/menu-effects.js');
        }
    }

    public function onControllerCommonHead_UpdateData()
    {
        if (!IS_ADMIN) {
            //style to head
            $this->baseObject->load->model('super_menu/super_menu');
            $getmenu = $this->baseObject->model_super_menu_super_menu->_getMenu();
            $data['menu'] = $getmenu;
            if (isset($_SESSION['language'])) {
                //$lang_load = $this->baseObject->request->get['language'];
                $los = array('yi', 'ur', 'ps', 'ku', 'ks', 'khw', 'he', 'ha', 'fa', 'dv', 'ar', 'arc');
                if (in_array($_SESSION['language'], $los)) {
                    $data['rtl'] = true;
                    //$this->baseObject->log->write(' found+');
                }
            }
            $this->baseObject->view->assign('sconfig', $data);
        }
    }

    /******************/
}
