<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ControllerResponsesItemslistSuperMenu extends AController
{
    public $data = array();
    private $error = array();
    protected $form;

    public function main()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('super_menu/super_menu');
        $this->loadModel('super_menu/super_menu');

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);

        $this->load->library('json');
        $this->response->setOutput(AJson::encode($response));
    }

    public function getFieldsByItemObject($value = [])
    {
        $this->loadLanguage('super_menu/super_menu');

        //$promo = new APromotion();
        //$cond_objects = $promo->getConditionObjects();
        $cond_objects = array(
                'categories',
                'brands',
                'products',
                'wishlist',
                'contents',
                'account',
                'customhtml',
                'home',
                'menu',
                'customurl',
        );

        if (!in_array($this->request->post['item_object'], $cond_objects)) {
            return null;
        }

        $this->form = new AForm('HT');
        $this->form->setForm(
            array(
                'form_name' => 'super_menuFrm',
                'update' => $this->html->getSecureURL('itemslist/super_menu/update_field', '&super_menu_id='.$this->request->get['super_menu_id']),
            )
        );
        $method = '_getFieldsFor'.str_replace(' ', '', ucwords(str_replace('_', ' ', $this->request->post['item_object'])));

        if (method_exists($this, $method)) {
            $response = call_user_func(array($this, $method), $value);
        }
        if ($response['fields']) {
            $value = $this->request->post['item_object'];
            //$response['fields']['ghtml'][0] = (string)$this->form->getFieldHtml(
            $response['fields']['ghtml'][0] = (string) $this->form->getFieldHtml(
                array(
                            'type' => 'hidden',
                            'name' => 'items[items]['.$this->request->post['idx'].'][object]',
                            'value' => $value,
                    )
            );
        }

        $this->load->library('json');
        $this->response->setOutput(AJson::encode($response));
    }

    //custom products menu
    private function _getFieldsForProducts($value = '')
    {
        $k = 0;
        $i = 1;
        if (!is_array($value)) {
            $value = array();
        }
        $listing_data = array();
        if (is_array($value['value']) && $value['value']) {
            $this->loadModel('catalog/product');
            $filter = array('subsql_filter' => 'p.product_id in ('.implode(',', $value['value']).')');

            $results = $this->model_catalog_product->getProducts($filter);
            if ($results) {
                $resource = new AResource('image');
                foreach ($results as $r) {
                    $product_id = $r['product_id'];
                    $thumbnail = $resource->getMainThumb(
                        'products',
                        $product_id,
                        (int) $this->config->get('config_image_grid_width'),
                        (int) $this->config->get('config_image_grid_height'),
                        true
                    );
                    $listing_data[$product_id]['name'] = $r['name'].' ('.$r['model'].')';
                    $listing_data[$product_id]['image'] = $thumbnail['thumb_html'];
                }
            }
        }

        $response['text'] = $this->language->get('super_menu_text_products');
        //$response['fields']['gfldname'][$k++] = '';
        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_name');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                       'name' => 'items[items]['.$this->request->post['idx'].'][name]',
                       'value' => !$value['name'] ? $this->language->get('super_menu_text_name_default') : $value['name'],
                             'required' => true,
                             'placeholder' => $this->language->get('super_menu_text_name'),
                             //'default' => $this->language->get('super_menu_text_name_default'),
                             'attr' => ' style="max-width:135px; float:left" ',
                             //'style' => ' col-sm-1 ',
                             //'multilingual' => true,
                )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_style');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'selectbox',
                       'name' => 'items[items]['.$this->request->post['idx'].'][style]',
                       'options' => array(
                               'style1' => $this->language->get('super_menu_text_style_1'),
                               'style2' => $this->language->get('super_menu_text_style_2'),
                       ),
                             //'style' => ' col-sm-1 ',
                       'value' => $value['style'],
                              'attr' => ' style="float:left" ',
                )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_items');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array(
                        'type' => 'multiselectbox',
                        'name' => 'items[items]['.$this->request->post['idx'].'][value][]',
                        'value' => !$value ? '' : $value['value'],
                        'options' => $listing_data,
                        'style' => 'chosen',
                        'ajax_url' => $this->html->getSecureURL('r/product/product/products'),
                        'placeholder' => $this->language->get('text_select_from_lookup'),
                        'attr' => ' style="float:left" ',
                )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_hideimg');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'checkbox',
          'name' => 'items[items]['.$this->request->post['idx'].'][hide]',
          'value' => isset($value['hide']) ? $value['hide'] : 0,
                'required' => true,
                'style' => 'btn-group btn-toggle btn_switch btn-group-xs',
                //'default' => $this->language->get('super_menu_text_name_default'),
                'attr' => ' style="float:left" ',
                //'multilingual' => true,
   )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_hideprice');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'checkbox',
                       'name' => 'items[items]['.$this->request->post['idx'].'][price]',
                       'value' => isset($value['price']) ? $value['price'] : 0,
                       'required' => true,
                       'style' => 'btn-group btn-toggle btn_switch btn-group-xs',
                       'attr' => ' style="float:left" ',
                      //'default' => $this->language->get('super_menu_text_name_default'),
                      //'attr' => ' style="max-width:135px" ',
                      //'multilingual' => true,
               )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_icon');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'resource',
             'name' => 'items[items]['.$this->request->post['idx'].'][topicon]',
             'resource_id' => $value['topicon'],
             'rl_type' => 'image',
             //'style' => ' col-sm-1 ',
             )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_html');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'textarea',
                               'name' => 'items[items]['.$this->request->post['idx'].'][html]',
                               'value' => !$value ? '' : $value['html'],
                                     'required' => false,
                                     'style' => 'large-field',
                                        'attr' => ' style="max-width: 490px;" rows="2" cols="62" ',
                                        //'placeholder' => 'test '
                                    //'field_id' => '000',
                                    //'wrapper_id'=> '999',
                                     //'multilingual' => true,
                                     //'base_url' => 'cc',
                                     //json_decode(html_entity_decode())
                        )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_sort_order');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
            'name' => 'items[items]['.$this->request->post['idx'].'][sort]',
            'value' => !$value ? '0' : $value['sort'],
            'required' => false,
            'placeholder' => $this->language->get('super_menu_item_sort_order_display'),
            'attr' => ' style="max-width:135px; float:left" ',
          )
        );

        //$this->log->write(print_r($value, true).' $value displayed');

        return $response;
    }

    //pages
    private function _getFieldsForContents($value = '')
    {
        $k = 0;
        $i = 1;
        if (!is_array($value)) {
            $value = array();
        }
        $listing_data = array();
        /*if (is_array($value['value']) && $value['value']){

            $this->loadModel('catalog/content');
            //$filter = array ('subsql_filter' => 'p.product_id in (' . implode(',', $value['value']) . ')');

            $results = $this->model_catalog_content->getContents();
            if ($results){
                //$resource = new AResource('image');
                foreach ($results as $r){
                    $content_id = $r['content_id'];

                    $listing_data[$product_id]['name'] = $r['title'];// . " (" . $r['model'] . ")";
                    //$listing_data[$product_id]['image'] = $thumbnail['thumb_html'];
                }
            }
        } */
        $this->loadModel('catalog/content');
        $results = $this->model_catalog_content->getContents();
        foreach ($results as $r) {
            $pages[$r['content_id']] = $r['title'];
        }

        $response['text'] = $this->language->get('super_menu_text_contents');
        //$response['fields']['gfldname'][$k++] = '';
        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_name');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                       'name' => 'items[items]['.$this->request->post['idx'].'][name]',
                       'value' => !$value['name'] ? $this->language->get('super_menu_text_name_default_contents') : $value['name'],
                             'required' => true,
                             'placeholder' => $this->language->get('super_menu_text_name'),
                             //'default' => $this->language->get('super_menu_text_name_default_wishlist'),
                             'attr' => ' style="max-width:135px; float:left" ',
                             //'style' => ' col-sm-1 ',
                             //'multilingual' => true,
                )
        );

        /*$response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_style');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
                array ('type'    => 'selectbox',
                       'name'    => 'items[items][' . $this->request->post['idx'] . '][style]',
                       'options' => array (
                               'style1'    => $this->language->get('super_menu_text_style_1'),
                               'style2'    => $this->language->get('super_menu_text_style_2'),
                       ),
                             //'style' => ' col-sm-1 ',
                       'value'   => $value['style'],
                              'attr' => ' style="float:left" ',
                ));*/

        /*$response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_items');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
                array (
                        'type'        => 'multiselectbox',
                        'name'        => 'items[items][' . $this->request->post['idx'] . '][value][]',
                        'value'       => !$value ? '' : $value['value'],
                        'options'     => $listing_data,
                        'style'       => 'chosen',
                        'ajax_url'    => $this->html->getSecureURL('r/product/product/products'),
                        'placeholder' => $this->language->get('text_select_from_lookup'),
                        'attr' => ' style="float:left" ',
                ));
        */

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_items');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array(
                            'type' => 'checkboxgroup',
                            'name' => 'items[items]['.$this->request->post['idx'].'][value][]',
                            'value' => !$value ? '' : $value['value'],
                            'options' => $pages,
                            'style' => 'chosen',
                            'scrollbox' => true,
                            'attr' => ' ',
                            'placeholder' => $this->language->get('super_menu_text_select_pages'),
            )
        );

        /*$response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_hideimg');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
                                    array ('type'    => 'checkbox',
                                           'name'    => 'items[items][' . $this->request->post['idx'] . '][hide]',
                                           'value'   => isset( $value['hide'] ) ? $value['hide'] : 0,
        'required'=> true,
        'style'  => 'btn-group btn-toggle btn_switch btn-group-xs',
        //'default' => $this->language->get('super_menu_text_name_default'),
        'attr' => ' style="float:left" ',
        //'multilingual' => true,

                                    ));

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_hideprice');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
                                        array ('type'    => 'checkbox',
               'name'    => 'items[items][' . $this->request->post['idx'] . '][price]',
               'value'   => isset( $value['price'] ) ? $value['price'] : 0,
               'required'=> true,
               'style'  => 'btn-group btn-toggle btn_switch btn-group-xs',
               'attr' => ' style="float:left" ',
              //'default' => $this->language->get('super_menu_text_name_default'),
              //'attr' => ' style="max-width:135px" ',
              //'multilingual' => true,
       ));*/

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_icon');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'resource',
             'name' => 'items[items]['.$this->request->post['idx'].'][topicon]',
             'resource_id' => $value['topicon'],
             'rl_type' => 'image',
             //'style' => ' col-sm-1 ',
             )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_html');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'textarea',
                               'name' => 'items[items]['.$this->request->post['idx'].'][html]',
                               'value' => !$value ? '' : $value['html'],
                                     'required' => false,
                                     'style' => 'large-field',
                                        'attr' => ' style="max-width: 490px;" rows="2" cols="62" ',
                                     //'multilingual' => true,
                                     //'base_url' =>
                                     //json_decode(html_entity_decode())
                        )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_sort_order');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                     'name' => 'items[items]['.$this->request->post['idx'].'][sort]',
                     'value' => !$value ? '0' : $value['sort'],
                     'required' => false,
                     'placeholder' => $this->language->get('super_menu_item_sort_order_display'),
                     'attr' => ' style="max-width:135px; float:left" ',
                 )
        );
        //$this->log->write(print_r($value, true).' $value displayed');

        return $response;
    }

    //abantecart menu
    private function _getFieldsForMenu($value = '')
    {
        $k = 0;
        $i = 1;
        if (!is_array($value)) {
            $value = array();
        }
        $listing_data = array();
        /*if (is_array($value['value']) && $value['value']){

            $this->loadModel('catalog/content');
            //$filter = array ('subsql_filter' => 'p.product_id in (' . implode(',', $value['value']) . ')');

            $results = $this->model_catalog_content->getContents();
            if ($results){
                //$resource = new AResource('image');
                foreach ($results as $r){
                    $content_id = $r['content_id'];

                    $listing_data[$product_id]['name'] = $r['title'];// . " (" . $r['model'] . ")";
                    //$listing_data[$product_id]['image'] = $thumbnail['thumb_html'];
                }
            }
        } */
        //$this->loadModel('catalog/content');
        $this->menu = new AMenu_Storefront();
        $pages = $this->menu->getItemIds();
        //$results = $this->menu->getMenuItems(); //full menu tree data
        //$this->log->write(print_r($pages, true).' results $pages menu items');
        foreach ($pages as $key => $r) {
            $newpages[$r] = $r;
        }
        //$this->log->write(print_r($pages, true).' results menu items AFTER');

        $response['text'] = $this->language->get('super_menu_text_menu');
        //$response['fields']['gfldname'][$k++] = '';
        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_name');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                       'name' => 'items[items]['.$this->request->post['idx'].'][name]',
                       'value' => !$value['name'] ? $this->language->get('super_menu_text_name_default_contents') : $value['name'],
                             'required' => true,
                             'placeholder' => $this->language->get('super_menu_text_name'),
                             //'default' => $this->language->get('super_menu_text_name_default_wishlist'),
                             'attr' => ' style="max-width:135px; float:left" ',
                             //'style' => ' col-sm-1 ',
                             //'multilingual' => true,
                )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_style');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'selectbox',
                       'name' => 'items[items]['.$this->request->post['idx'].'][style]',
                       'options' => array(
                               'style1' => $this->language->get('super_menu_text_style_1'),
                               'style2' => $this->language->get('super_menu_text_style_2'),
                       ),
                             //'style' => ' col-sm-1 ',
                       'value' => $value['style'],
                              'attr' => ' style="float:left" ',
                )
        );

        /*$response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_items');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
                array (
                        'type'        => 'multiselectbox',
                        'name'        => 'items[items][' . $this->request->post['idx'] . '][value][]',
                        'value'       => !$value ? '' : $value['value'],
                        'options'     => $listing_data,
                        'style'       => 'chosen',
                        'ajax_url'    => $this->html->getSecureURL('r/product/product/products'),
                        'placeholder' => $this->language->get('text_select_from_lookup'),
                        'attr' => ' style="float:left" ',
                ));
        */

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_items');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array(
                        'type' => 'checkboxgroup',
                        'name' => 'items[items]['.$this->request->post['idx'].'][value][]',
                        'value' => !$value ? '' : $value['value'],
                        'options' => $newpages,
                        'style' => 'chosen',
                        'scrollbox' => true,
                        'attr' => ' ',
                        'placeholder' => $this->language->get('super_menu_text_select_menu'),
            )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_hideimg');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'checkbox',
                'name' => 'items[items]['.$this->request->post['idx'].'][hide]',
                'value' => isset($value['hide']) ? $value['hide'] : 0,
                'required' => true,
                'style' => 'btn-group btn-toggle btn_switch btn-group-xs',
                //'default' => $this->language->get('super_menu_text_name_default'),
                'attr' => ' style="float:left" ',
                //'multilingual' => true,
   )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_icon');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'resource',
             'name' => 'items[items]['.$this->request->post['idx'].'][topicon]',
             'resource_id' => $value['topicon'],
             'rl_type' => 'image',
             //'style' => ' col-sm-1 ',
             )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_html');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'textarea',
                               'name' => 'items[items]['.$this->request->post['idx'].'][html]',
                               'value' => !$value ? '' : $value['html'],
                                     'required' => false,
                                     'style' => 'large-field',
                                        'attr' => ' style="max-width: 490px;" rows="2" cols="62" ',
                                     //'multilingual' => true,
                                     //'base_url' =>
                                     //json_decode(html_entity_decode())
                        )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_sort_order');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                     'name' => 'items[items]['.$this->request->post['idx'].'][sort]',
                     'value' => !$value ? '0' : $value['sort'],
                     'required' => false,
                     'placeholder' => $this->language->get('super_menu_item_sort_order_display'),
                     'attr' => ' style="max-width:135px; float:left" ',
                 )
        );
        //$this->log->write(print_r($value, true).' $value displayed');

        return $response;
    }

    //account pages
    private function _getFieldsForAccount($value = '')
    {
        $k = 0;
        $i = 1;
        if (!is_array($value)) {
            $value = array();
        }
        $listing_data = array();
        /*if (is_array($value['value']) && $value['value']){

            $this->loadModel('catalog/content');
            //$filter = array ('subsql_filter' => 'p.product_id in (' . implode(',', $value['value']) . ')');

            $results = $this->model_catalog_content->getContents();
            if ($results){
                //$resource = new AResource('image');
                foreach ($results as $r){
                    $content_id = $r['content_id'];

                    $listing_data[$product_id]['name'] = $r['title'];// . " (" . $r['model'] . ")";
                    //$listing_data[$product_id]['image'] = $thumbnail['thumb_html'];
                }
            }
        } */
        //$this->loadModel('catalog/content');
        //$results = $this->model_catalog_content->getContents();
        /*foreach ($results as $r){
            //$pages[$r['content_id']] = $r['title'];
        }    */
        $pages = array(
                'register' => $this->language->get('super_menu_text_item_register'),
                'login' => $this->language->get('super_menu_text_item_login'),
                'account' => $this->language->get('super_menu_text_item_myaccount'),
                'logout' => $this->language->get('super_menu_text_item_logount'),
                'wishlist' => $this->language->get('super_menu_text_item_wishlist'),
                'transactions' => $this->language->get('super_menu_text_item_transaction'),
                'download' => $this->language->get('super_menu_text_item_downloads'),
                'history' => $this->language->get('super_menu_text_item_orders'),
                'information' => $this->language->get('super_menu_text_item_editaccount'),
                'address' => $this->language->get('super_menu_text_item_addressbook'),
                'notification' => $this->language->get('super_menu_text_item_notification'),
                'password' => $this->language->get('super_menu_text_item_changepass'),
                'sitemap' => $this->language->get('super_menu_text_item_sitemap'),
                'contact' => $this->language->get('super_menu_text_item_contact'),
                'special' => $this->language->get('super_menu_text_item_special'),
                'checkout' => $this->language->get('super_menu_text_item_checkout'),
            );
        //$this->log->write(print_r($pages, true).' $pages displayed');

        $response['text'] = $this->language->get('super_menu_text_account');
        //$response['fields']['gfldname'][$k++] = '';
        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_name');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                       'name' => 'items[items]['.$this->request->post['idx'].'][name]',
                       'value' => !$value['name'] ? $this->language->get('super_menu_text_name_default_account') : $value['name'],
                             'required' => true,
                             'placeholder' => $this->language->get('super_menu_text_name'),
                             //'default' => $this->language->get('super_menu_text_name_default_wishlist'),
                             'attr' => ' style="max-width:135px; float:left" ',
                             //'style' => ' col-sm-1 ',
                             //'multilingual' => true,
                )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_url');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                               'name' => 'items[items]['.$this->request->post['idx'].'][url]',
                               'value' => !$value['url'] ? $this->language->get('super_menu_text_name_default_url') : $value['url'],
                                     //'required'=> true,
                                     'placeholder' => $this->language->get('super_menu_text_url'),
                                     //'default' => $this->language->get('super_menu_text_name_default_wishlist'),
                                     'attr' => ' style="max-width:135px; float:left" ',
                                     //'style' => ' col-sm-1 ',
                                     //'multilingual' => true,
                        )
        );

        /*$response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_style');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
                array ('type'    => 'selectbox',
                       'name'    => 'items[items][' . $this->request->post['idx'] . '][style]',
                       'options' => array (
                               'style1'    => $this->language->get('super_menu_text_style_1'),
                               'style2'    => $this->language->get('super_menu_text_style_2'),
                       ),
                             //'style' => ' col-sm-1 ',
                       'value'   => $value['style'],
                              'attr' => ' style="float:left" ',
                ));*/

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_items');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array(
                            'type' => 'checkboxgroup',
                            'name' => 'items[items]['.$this->request->post['idx'].'][value][]',
                            'value' => !$value ? '' : $value['value'],
                            'options' => $pages,
                            'style' => 'chosen',
                            'scrollbox' => true,
                            'attr' => ' ',
                            'placeholder' => $this->language->get('super_menu_text_select_account'),
            )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_icon');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'resource',
             'name' => 'items[items]['.$this->request->post['idx'].'][topicon]',
             'resource_id' => $value['topicon'],
             'rl_type' => 'image',
             //'style' => ' col-sm-1 ',
             )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_html');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'textarea',
                               'name' => 'items[items]['.$this->request->post['idx'].'][html]',
                               'value' => !$value ? '' : $value['html'],
                                     'required' => false,
                                     'style' => 'large-field',
                                        'attr' => ' style="max-width: 490px;" rows="2" cols="62" ',
                                     //'multilingual' => true,
                                     //'base_url' =>
                                     //json_decode(html_entity_decode())
                        )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_sort_order');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                     'name' => 'items[items]['.$this->request->post['idx'].'][sort]',
                     'value' => !$value ? '0' : $value['sort'],
                     'required' => false,
                     'placeholder' => $this->language->get('super_menu_item_sort_order_display'),
                     'attr' => ' style="max-width:135px; float:left" ',
                 )
        );
        //$this->log->write(print_r($value, true).' $value displayed');

        return $response;
    }

    //simple custom html menu
    private function _getFieldsForCustomhtml($value = '')
    {
        $k = 0;
        $i = 1;
        if (!is_array($value)) {
            $value = array();
        }
        $response['text'] = $this->language->get('super_menu_text_customhtml');
        //$response['fields']['gfldname'][$k++] = '';
        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_name');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                       'name' => 'items[items]['.$this->request->post['idx'].'][name]',
                       'value' => !$value['name'] ? $this->language->get('super_menu_text_name_default_customhtml') : $value['name'],
                             'required' => true,
                             'placeholder' => $this->language->get('super_menu_text_name'),
                             //'default' => $this->language->get('super_menu_text_name_default_wishlist'),
                             'attr' => ' style="max-width:135px; float:left" ',
                             //'style' => ' col-sm-1 ',
                             //'multilingual' => true,
                )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_url');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                               'name' => 'items[items]['.$this->request->post['idx'].'][url]',
                               'value' => !$value['url'] ? $this->language->get('super_menu_text_name_default_url') : $value['url'],
                                     //'required'=> true,
                                     'placeholder' => $this->language->get('super_menu_text_url'),
                                     //'default' => $this->language->get('super_menu_text_name_default_wishlist'),
                                     'attr' => ' style="max-width:135px; float:left" ',
                                     //'style' => ' col-sm-1 ',
                                     //'multilingual' => true,
                        )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_icon');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'resource',
             'name' => 'items[items]['.$this->request->post['idx'].'][topicon]',
             'resource_id' => $value['topicon'],
             'rl_type' => 'image',
             //'style' => ' col-sm-1 ',
             )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_html');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'textarea',
                               'name' => 'items[items]['.$this->request->post['idx'].'][html]',
                               'value' => !$value ? '' : $value['html'],
                                     'required' => false,
                                     'style' => 'large-field',
                                        'attr' => ' style="max-width: 490px;" rows="2" cols="62" ',
                                     //'multilingual' => true,
                                     //'base_url' =>
                                     //json_decode(html_entity_decode())
                        )
        );
        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_sort_order');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                     'name' => 'items[items]['.$this->request->post['idx'].'][sort]',
                     'value' => !$value ? '0' : $value['sort'],
                     'required' => false,
                     'placeholder' => $this->language->get('super_menu_item_sort_order_display'),
                     'attr' => ' style="max-width:135px; float:left" ',
                 )
        );
        //$this->log->write(print_r($value, true).' $value displayed');

        return $response;
    }

    //simple custom link no menu
    private function _getFieldsForCustomurl($value = '')
    {
        $k = 0;
        $i = 1;
        if (!is_array($value)) {
            $value = array();
        }
        $response['text'] = $this->language->get('super_menu_text_customurl');
        //$response['fields']['gfldname'][$k++] = '';
        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_name');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                       'name' => 'items[items]['.$this->request->post['idx'].'][name]',
                       'value' => !$value['name'] ? $this->language->get('super_menu_text_name_default_customhtml') : $value['name'],
                             'required' => true,
                             'placeholder' => $this->language->get('super_menu_text_name'),
                             //'default' => $this->language->get('super_menu_text_name_default_wishlist'),
                             'attr' => ' style="max-width:135px; float:left" ',
                             //'style' => ' col-sm-1 ',
                             //'multilingual' => true,
                )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_url');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                               'name' => 'items[items]['.$this->request->post['idx'].'][url]',
                               'value' => !$value['url'] ? $this->language->get('super_menu_text_name_default_url') : $value['url'],
                                     //'required'=> true,
                                     'placeholder' => $this->language->get('super_menu_text_url'),
                                     //'default' => $this->language->get('super_menu_text_name_default_wishlist'),
                                     'attr' => ' style="max-width:365px; float:left" ',
                                     //'style' => ' col-sm-1 ',
                                     //'multilingual' => true,
                        )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_newwindow');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'checkbox',
         'name' => 'items[items]['.$this->request->post['idx'].'][newwindow]',
         'value' => isset($value['newwindow']) ? $value['newwindow'] : 0,
         'required' => true,
         'style' => 'btn-group btn-toggle btn_switch btn-group-xs',
         'attr' => ' style="float:left" ',
                              //'default' => $this->language->get('super_menu_text_name_default'),
                              //'attr' => ' style="max-width:135px" ',
                              //'multilingual' => true,
                       )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_icon');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'resource',
             'name' => 'items[items]['.$this->request->post['idx'].'][topicon]',
             'resource_id' => $value['topicon'],
             'rl_type' => 'image',
             //'style' => ' col-sm-1 ',
             )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_sort_order');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
            'name' => 'items[items]['.$this->request->post['idx'].'][sort]',
            'value' => !$value ? '0' : $value['sort'],
            'required' => false,
            'placeholder' => $this->language->get('super_menu_item_sort_order_display'),
            'attr' => ' style="max-width:135px; float:left" ',
          )
        );

        return $response;
    }

    //simple home menu
    private function _getFieldsForHome($value = '')
    {
        $k = 0;
        $i = 1;
        if (!is_array($value)) {
            $value = array();
        }
        $response['text'] = $this->language->get('super_menu_text_home');
        //$response['fields']['gfldname'][$k++] = '';
        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_name');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                       'name' => 'items[items]['.$this->request->post['idx'].'][name]',
                       'value' => !$value['name'] ? $this->language->get('super_menu_text_name_default_home') : $value['name'],
                             'required' => true,
                             'placeholder' => $this->language->get('super_menu_text_name'),
                             //'default' => $this->language->get('super_menu_text_name_default_'),
                             'attr' => ' style="max-width:135px; float:left" ',
                             //'style' => ' col-sm-1 ',
                             //'multilingual' => true,
                )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_icon');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'resource',
            'name' => 'items[items]['.$this->request->post['idx'].'][topicon]',
            'resource_id' => $value['topicon'],
            'rl_type' => 'image',
            //'style' => ' col-sm-1 ',
          )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_sort_order');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
            'name' => 'items[items]['.$this->request->post['idx'].'][sort]',
            'value' => !$value ? '0' : $value['sort'],
            'required' => false,
            'placeholder' => $this->language->get('super_menu_item_sort_order_display'),
            'attr' => ' style="max-width:135px; float:left"',
          )
        );
        //$this->log->write(print_r($value, true).' $value displayed');

        return $response;
    }

    //wishlist products menu
    private function _getFieldsForWishlist($value = '')
    {
        $k = 0;
        $i = 1;
        if (!is_array($value)) {
            $value = array();
        }
        $listing_data = array();
        if (is_array($value['value']) && $value['value']) {
        }

        $response['text'] = $this->language->get('super_menu_text_wishlist');
        //$response['fields']['gfldname'][$k++] = '';
        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_name');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                       'name' => 'items[items]['.$this->request->post['idx'].'][name]',
                       'value' => !$value['name'] ? $this->language->get('super_menu_text_name_default_wishlist') : $value['name'],
                             'required' => true,
                             'placeholder' => $this->language->get('super_menu_text_name'),
                             //'default' => $this->language->get('super_menu_text_name_default_wishlist'),
                             'attr' => ' style="max-width:135px; float:left" ',
                             //'style' => ' col-sm-1 ',
                             //'multilingual' => true,
                )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_style');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'selectbox',
                       'name' => 'items[items]['.$this->request->post['idx'].'][style]',
                       'options' => array(
                               'style1' => $this->language->get('super_menu_text_style_1'),
                               'style2' => $this->language->get('super_menu_text_style_2'),
                       ),
                             //'style' => ' col-sm-1 ',
                       'value' => $value['style'],
                              'attr' => ' style="float:left" ',
                )
        );

        /*$response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_items');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
                array (
                        'type'        => 'multiselectbox',
                        'name'        => 'items[items][' . $this->request->post['idx'] . '][value][]',
                        'value'       => !$value ? '' : $value['value'],
                        'options'     => $listing_data,
                        'style'       => 'chosen',
                        'ajax_url'    => $this->html->getSecureURL('r/product/product/products'),
                        'placeholder' => $this->language->get('text_select_from_lookup'),
                        'attr' => ' style="float:left" ',
                ));
                */

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_hideimg');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'checkbox',
          'name' => 'items[items]['.$this->request->post['idx'].'][hide]',
          'value' => isset($value['hide']) ? $value['hide'] : 0,
                'required' => true,
                'style' => 'btn-group btn-toggle btn_switch btn-group-xs',
                //'default' => $this->language->get('super_menu_text_name_default'),
                'attr' => ' style="float:left" ',
                //'multilingual' => true,
   )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_hideprice');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'checkbox',
                       'name' => 'items[items]['.$this->request->post['idx'].'][price]',
                       'value' => isset($value['price']) ? $value['price'] : 0,
                       'required' => true,
                       'style' => 'btn-group btn-toggle btn_switch btn-group-xs',
                       'attr' => ' style="float:left" ',
                      //'default' => $this->language->get('super_menu_text_name_default'),
                      //'attr' => ' style="max-width:135px" ',
                      //'multilingual' => true,
               )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_limit');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
        'name' => 'items[items]['.$this->request->post['idx'].'][limit]',
        'value' => !$value['limit'] ? '6' : $value['limit'],
              'required' => true,
              'placeholder' => $this->language->get('super_menu_text_limit'),
              //'default' => $this->language->get('super_menu_text_name_default'),
              'attr' => ' style="max-width:135px; float:left" ',
              //'style' => ' col-sm-1 ',
              //'multilingual' => true,
                       )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_icon');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'resource',
             'name' => 'items[items]['.$this->request->post['idx'].'][topicon]',
             'resource_id' => $value['topicon'],
             'rl_type' => 'image',
             //'style' => ' col-sm-1 ',
             )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_html');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'textarea',
                               'name' => 'items[items]['.$this->request->post['idx'].'][html]',
                               'value' => !$value ? '' : $value['html'],
                                     'required' => false,
                                     'style' => 'large-field',
                                        'attr' => ' style="max-width: 490px;" rows="2" cols="62" ',
                                     //'multilingual' => true,
                                     //'base_url' =>
                                     //json_decode(html_entity_decode())
                        )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_sort_order');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                     'name' => 'items[items]['.$this->request->post['idx'].'][sort]',
                     'value' => !$value ? '0' : $value['sort'],
                     'required' => false,
                     'placeholder' => $this->language->get('super_menu_item_sort_order_display'),
                     'attr' => ' style="max-width:135px; float:left" ',
                 )
        );

        //$this->log->write(print_r($value, true).' $value displayed');

        return $response;
    }

    private function _getFieldsForCategories($value = '')
    {
        $k = 0;
        $i = 1;
        if (!is_array($value)) {
            $value = array();
        }
        $response['text'] = $this->language->get('super_menu_text_categories');

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_name');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                       'name' => 'items[items]['.$this->request->post['idx'].'][name]',
                       'value' => !$value['name'] ? $this->language->get('super_menu_text_name_default_categories') : $value['name'],
                             'required' => true,
                             'placeholder' => $this->language->get('super_menu_text_name'),
                             'default' => $this->language->get('super_menu_text_name_default'),
                             'attr' => ' style="max-width:135px; float:left" ',
                             //'style' => ' col-sm-1 ',
                             //'multilingual' => true,
                )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_style');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'selectbox',
                       'name' => 'items[items]['.$this->request->post['idx'].'][style]',
                       'options' => array(
                               'style1' => $this->language->get('super_menu_text_style_1'),
                               'style2' => $this->language->get('super_menu_text_style_2'),
                                     'style3' => $this->language->get('super_menu_text_style_3'),
                                     'style4' => $this->language->get('super_menu_text_style_4'),
                                     'style5' => $this->language->get('super_menu_text_style_5'),
                       ),
                       'value' => !$value ? '' : $value['style'],
                )
        );
        $this->loadModel('catalog/category');
        $results = $this->model_catalog_category->getCategories(0);
        foreach ($results as $r) {
            $categories[$r['category_id']] = $r['name'];
        }
        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_items');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array(
                'type' => 'checkboxgroup',
                'name' => 'items[items]['.$this->request->post['idx'].'][value][]',
                'value' => !$value ? '' : $value['value'],
                'options' => $categories,
                'style' => 'chosen',
                //'scrollbox' => true,
                'placeholder' => $this->language->get('super_menu_text_select_category'),
            )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_sublevels');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                       'name' => 'items[items]['.$this->request->post['idx'].'][sublevels]',
                       'value' => !$value ? '2' : $value['sublevels'],
                             'required' => true,
                             'placeholder' => $this->language->get('super_menu_text_sublevels'),
                             //'default' => $this->language->get('super_menu_text_name_default'),
                             'attr' => ' style="max-width:135px; float:left" ',
                             //'style' => ' col-sm-1 ',
                             //'multilingual' => true,
                )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_hideimg');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'checkbox',
            'name' => 'items[items]['.$this->request->post['idx'].'][hide]',
  'value' => isset($value['hide']) ? $value['hide'] : 0,
  'required' => true,
  'style' => 'btn-group btn-toggle btn_switch btn-group-xs',
  //'default' => $this->language->get('super_menu_text_name_default'),
  'attr' => ' style="float:left" ',
  //'multilingual' => true,
                    )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_showcount');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'checkbox',
               'name' => 'items[items]['.$this->request->post['idx'].'][showcount]',
               'value' => isset($value['showcount']) ? $value['showcount'] : 0,
               'required' => true,
               'style' => 'btn-group btn-toggle btn_switch btn-group-xs',
               //'default' => $this->language->get('super_menu_text_name_default'),
               'attr' => ' style="float:left" ',
               //'multilingual' => true,
           )
        );

        /* $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_showbrands');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
                                     array ('type'    => 'checkbox',
                                     'name'    => 'items[items][' . $this->request->post['idx'] . '][showbrands]',
                                     'value'   => isset( $value['showbrands'] ) ? $value['showbrands'] : 0,
                                     'required'=> true,
                                     'style'  => 'btn-group btn-toggle btn_switch btn-group-xs',
                                     //'default' => $this->language->get('super_menu_text_name_default'),
                                     'attr' => ' style="float:left" ',
                                     //'multilingual' => true,
                                 ));*/

        /*$response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_flyout');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
                                  array ('type'    => 'checkbox',
        'name'    => 'items[items][' . $this->request->post['idx'] . '][flyout]',
        'value'   => isset( $value['flyout'] ) ? $value['flyout'] : 0,
        'required'=> true,
        'style'  => 'btn-group btn-toggle btn_switch btn-group-xs',
        'attr' => ' style="float:left" ',
                             //'default' => $this->language->get('super_menu_text_name_default'),
                             //'attr' => ' style="max-width:135px" ',
                             //'multilingual' => true,
                                          ));*/

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_icon');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'resource',
                       'name' => 'items[items]['.$this->request->post['idx'].'][topicon]',
                       'resource_id' => $value['topicon'],
                       'rl_type' => 'image',
                       //'style' => ' col-sm-1 ',
                       )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_html');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'textarea',
                          'name' => 'items[items]['.$this->request->post['idx'].'][html]',
                          'value' => !$value ? '' : $value['html'],
                          'required' => false,
                          'style' => 'large-field',
                             'attr' => ' style="max-width: 490px;" rows="2" cols="62" ',
                          //'multilingual' => true,
                          //'base_url' =>
                          //json_decode(html_entity_decode())
             )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_sort_order');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
     'name' => 'items[items]['.$this->request->post['idx'].'][sort]',
     'value' => !$value ? '0' : $value['sort'],
     'required' => false,
     'placeholder' => $this->language->get('super_menu_item_sort_order_display'),
     'attr' => ' style="max-width:135px; float:left" ',
                       )
        );

        //$this->log->write(print_r($value, true).' $value displayed');

        return $response;
    }

    private function _getFieldsForBrands($value = '')
    {
        $k = 0;
        $i = 1;
        if (!is_array($value)) {
            $value = array();
        }
        $response['text'] = $this->language->get('super_menu_text_brands');

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_name');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
                       'name' => 'items[items]['.$this->request->post['idx'].'][name]',
                       'value' => !$value['name'] ? $this->language->get('super_menu_text_name_default_brands') : $value['name'],
                             'required' => true,
                             'placeholder' => $this->language->get('super_menu_text_name'),
                             'default' => $this->language->get('super_menu_text_name_default_brands'),
                             'attr' => ' style="max-width:135px; float:left" ',
                             //'style' => ' col-sm-1 ',
                             //'multilingual' => true,
                )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_style');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'selectbox',
                       'name' => 'items[items]['.$this->request->post['idx'].'][style]',
                       'options' => array(
                               'style1' => $this->language->get('super_menu_text_style_1'),
                               'style2' => $this->language->get('super_menu_text_style_2'),
                       ),
                       'value' => !$value ? '' : $value['style'],
                )
        );
        $this->loadModel('catalog/manufacturer');
        $results = $this->model_catalog_manufacturer->getManufacturers();
        foreach ($results as $r) {
            $manufacturers[$r['manufacturer_id']] = $r['name'];
        }
        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_items');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array(
                'type' => 'checkboxgroup',
                'name' => 'items[items]['.$this->request->post['idx'].'][value][]',
                'value' => !$value ? '' : $value['value'],
                'options' => $manufacturers,
                'style' => 'chosen',
                'scrollbox' => true,
                'attr' => ' ',
                'placeholder' => $this->language->get('super_menu_text_select_manufacturer'),
            )
        );

        /*$response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_columns');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
                array ('type'    => 'input',
                       'name'    => 'items[items][' . $this->request->post['idx'] . '][columns]',
                       'value'   => !$value['columns'] ? '1' : $value['columns'],
                             'required'=> true,
                             'placeholder'=> $this->language->get('super_menu_text_columns'),
                             //'default' => $this->language->get('super_menu_text_name_default'),
                             'attr' => ' style="max-width:135px; float:left" ',
                             //'style' => ' col-sm-1 ',
                             //'multilingual' => true,
                ));*/

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_hideimg');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'checkbox',
                  'name' => 'items[items]['.$this->request->post['idx'].'][hide]',
                  'value' => isset($value['hide']) ? $value['hide'] : 0,
  'required' => true,
  'style' => 'btn-group btn-toggle btn_switch btn-group-xs',
  //'default' => $this->language->get('super_menu_text_name_default'),
  'attr' => ' style="float:left" ',
  //'multilingual' => true,
                    )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_icon');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'resource',
                       'name' => 'items[items]['.$this->request->post['idx'].'][topicon]',
                       'resource_id' => $value['topicon'],
                       'rl_type' => 'image',
                       //'style' => ' col-sm-1 ',
                       )
        );

        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_html');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'textarea',
                    'name' => 'items[items]['.$this->request->post['idx'].'][html]',
                    'value' => !$value ? '' : $value['html'],
                          'required' => false,
                          'style' => 'large-field',
                             'attr' => ' style="max-width: 490px;" rows="2" cols="62" ',
                          //'multilingual' => true,
                          //'base_url' =>
                          //json_decode(html_entity_decode())
             )
        );
        //$this->log->write(print_r($value, true).' $value displayed');
        $response['fields']['gfldname'][$k++] = $this->language->get('super_menu_item_sort_order');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'input',
            'name' => 'items[items]['.$this->request->post['idx'].'][sort]',
               'value' => !$value ? '0' : $value['sort'],
               'required' => false,
               'placeholder' => $this->language->get('super_menu_item_sort_order_display'),
               'attr' => ' style="max-width:135px; float:left" ',
           )
        );

        return $response;
    }

    private function _getFieldsForPaymentMethod($value = '')
    {
        $k = 0;
        $i = 1;
        $response['text'] = $this->language->get('super_menu_text_payment_method');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'selectbox',
                       'name' => 'items[items]['.$this->request->post['idx'].'][style]',
                       'options' => array(
                               'style1' => $this->language->get('super_menu_text_style_1'),
                               'style2' => $this->language->get('super_menu_text_style_2'),
                       ),
                       'value' => $value['style'],
                )
        );
        $exts = new ExtensionsApi();
        $results = $exts->getInstalled('payment');
        foreach ($results as $r) {
            $options[$r] = $exts->getExtensionName($r);
        }

        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array(
                'type' => 'checkboxgroup',
                'name' => 'items[items]['.$this->request->post['idx'].'][value][]',
                'value' => !$value ? '' : $value['value'],
                'options' => $options,
                'scrollbox' => true,
            )
        );

        return $response;
    }

    private function _getFieldsForShippingMethod($value = '')
    {
        $k = 0;
        $i = 1;
        $response['text'] = $this->language->get('super_menu_text_shipping_method');
        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array('type' => 'selectbox',
                       'name' => 'items[items]['.$this->request->post['idx'].'][style]',
                       'options' => array(
                               'style1' => $this->language->get('super_menu_text_style_1'),
                               'style2' => $this->language->get('super_menu_text_style_2'),
                       ),
                       'value' => !$value ? '' : $value['style'],
                )
        );
        $exts = new ExtensionsApi();
        $results = $exts->getInstalled('shipping');
        foreach ($results as $r) {
            $options[$r] = $exts->getExtensionName($r);
        }

        $response['fields']['ghtml'][$i++] = (string) $this->form->getFieldHtml(
            array(
                'type' => 'checkboxgroup',
                'name' => 'items[items]['.$this->request->post['idx'].'][value][]',
                'value' => !$value ? '' : $value['value'],
                'options' => $options,
                'scrollbox' => true,
            )
        );

        return $response;
    }

    public function discount_products($value = '')
    {
        $products = array();
        $products_data = array();

        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadModel('catalog/product');
        if (isset($this->request->post['term'])) {
            $filter = array('limit' => 20,
                             'content_language_id' => $this->session->data['content_language_id'],
                             'filter' => array(
                                     'keyword' => $this->request->post['term'],
                                     'match' => 'begin',
                             ), );
            $products = $this->model_catalog_product->getProducts($filter);
            $resource = new AResource('image');
            foreach ($products as $pdata) {
                $thumbnail = $resource->getMainThumb(
                    'products',
                    $pdata['product_id'],
                    (int) $this->config->get('config_image_grid_width'),
                    (int) $this->config->get('config_image_grid_height'),
                    true
                );

                if ($this->request->get['currency_code']) {
                    $price = round(
                        $this->currency->convert(
                            $pdata['price'],
                            $this->config->get('config_currency'),
                            $this->request->get['currency_code']
                        ),
                        2
                    );
                } else {
                    $price = $pdata['price'];
                }

                $frmt_price = $this->currency->format($price, ($this->request->get['currency_code'] ? $this->request->get['currency_code'] : $this->config->get('config_currency')));

                $products_data[] = array(
                        'image' => $thumbnail['thumb_html'].trim(
                            $this->html->buildInput(
                                array(
                                'name' => 'discount_products_quantity['.$pdata['product_id'].']',
                                'value' => $pdata['quantity'],
                                'style' => 'small-field',
                                'placeholder' => 'quantity',
                                )
                            )
                        ),
                        'id' => $pdata['product_id'],
                        'name' => $pdata['name'].' - '.$frmt_price,
                        'price' => $price,
                        'meta' => $pdata['model'],
                        'sort_order' => (int) $pdata['sort_order'],
                );
            }
        }

        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($products_data));
    }

    /**
     * update only one field.
     */
    public function update_field()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('super_menu/super_menu');
        if (!$this->user->canModify('itemslist/super_menu')) {
            $error = new AError('');

            return $error->toJSONResponse(
                'NO_PERMISSIONS_402',
                array('error_text' => sprintf($this->language->get('error_permission_modify'), 'super_menu/super_menu'),
                           'reset_value' => true,
                    )
            );
        }

        $this->loadModel('super_menu/super_menu');
        $fields_list = array('name', 'status', 'description_short', 'start_date', 'end_date', 'skin', 'maxwidth', 'drop_slide', 'viewtext', 'css', 'hide', 'moretext', 'mname', 'mobminwidth', 'topfont', 'topsize', 'dropfont', 'dropsize', 'dropsize2', 'topcolor', 'topbgcolor', 'toppattern', 'topborder', 'topitemcolor', 'topshadcolor', 'tophovcolor', 'dropbggrad1', 'dropbggrad2', 'dropbgtype', 'dropitemcolor', 'dropshadcolor', 'drophovcolor', 'droptitlecolor', 'droptitlehovcolor', 'pricecolor', 'flycolor', 'flybgcolor', 'round');
        if (isset($this->request->get['super_menu_id'])) {
            //request sent from edit form. ID in url
            foreach ($this->request->post as $field => $value) {
                if (!in_array($field, $fields_list)) {
                    continue;
                }
                $this->model_super_menu_super_menu->editSuperMenu($this->request->get['super_menu_id'], array($field => $value));
            }

            return;
        }

        //request sent from jGrid. ID is key of array
        foreach ($this->request->post as $field => $value) {
            if (!in_array($field, $fields_list)) {
                continue;
            }
            foreach ($value as $k => $v) {
                $this->model_super_menu_super_menu->editSuperMenu($k, array($field => $v));
            }
        }
        //clear menu cache
        $this->registry->get('cache')->remove('super_menus');
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    public function update()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadModel('super_menu/super_menu');
        $this->loadLanguage('super_menu/super_menu');
        if (!$this->user->canModify('itemslist/super_menu')) {
            $error = new AError('');

            return $error->toJSONResponse(
                'NO_PERMISSIONS_402',
                array('error_text' => sprintf($this->language->get('error_permission_modify'), 'itemslist/super_menu'),
                           'reset_value' => true,
                    )
            );
        }

        switch ($this->request->post['oper']) {
        case 'del':
            $ids = explode(',', $this->request->post['id']);
            if (!empty($ids)) {
                foreach ($ids as $id) {
                    $this->model_super_menu_super_menu->deleteSuperMenu($id);
                }
            }
            break;
        case 'save':
            $allowedFields = array('priority');
            $ids = explode(',', $this->request->post['id']);
            if (!empty($ids)) {
                foreach ($ids as $id) {
                    foreach ($allowedFields as $field) {
                        $this->model_super_menu_super_menu->editSuperMenu($id, array($field => $this->request->post[$field][$id]));
                    }
                }
            }
            break;

        default:
        }
        //clear menu cache
        $this->registry->get('cache')->remove('super_menus');
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }
}
