<?php
if (!defined('DIR_CORE')) {
		header('Location: static_pages/');
}


class ControllerSiLoginSiLogin extends AController

{

		public function main()
		{
			$this->extensions->hk_InitData($this);
			$data = array();
			
			 //add CSRF token for Version 1.2.15
			$csrftoken = $this->registry->get('csrftoken');
			if($csrftoken!='')
			{
				$this->view->batchAssign(
					array(
						'csrfinstance' => $csrftoken->setInstance(),
						'csrftoken'    => $csrftoken->setToken(),
					)
				);
			}
			
			$data['login_url'] = $this->html->getSecureURL('account/login'); 
			$data['login_inline'] = $this->config->get('si_login_inline');
			$data['login_header_text'] = $this->config->get('si_login_header');
			$data['login_header_color'] = $this->config->get('si_login_header_colour');
			$data['login_header_align'] = $this->config->get('si_login_header_align');
			$data['login_username_text'] = $this->config->get('si_login_username');
			$data['login_password_text'] = $this->config->get('si_login_password');
			$data['login_button_text'] = $this->config->get('si_login_button');
			$data['login_button_text_color'] = $this->config->get('si_login_button_text_colour');
			$data['login_button_bg_color'] = $this->config->get('si_login_button_bg_colour');
			$data['login_bg_color'] = $this->config->get('si_login_bg_colour');
			$data['login_label_color'] = $this->config->get('si_login_label_colour');
			$data['login_border'] = $this->config->get('si_login_border');
			$data['login_border_color'] = $this->config->get('si_login_border_colour');
			$data['login_border_shadow'] = $this->config->get('si_login_border_shadow');
			$data['login_custom_css'] = $this->config->get('si_login_custom_css');
			if($this->session->data['si_login_error'])
			{
				$data['login_error'] = $this->language->get('text_error_login');
				$this->session->data['si_login_error']=false;
			}	
			
			$this->view->assign('data', $data);
			$this->processTemplate();
			// init controller data
			$this->extensions->hk_UpdateData($this);
		}
		
		public function main_old()

		{

				// init controller data
				$this->extensions->hk_InitData($this);
				$this->document->addStyle(array(
						'href' => $this->view->templateResource('/css/style.css') ,
						'rel' => 'stylesheet',
						'media' => 'screen',
				));
				$this->document->addStyle(array(
						'href' => $this->view->templateResource('/css/ionicons.min.css') ,
						'rel' => 'stylesheet',
						'media' => 'screen',
				));
				$this->loadModel('catalog/category');
				$this->loadModel('tool/seo_url');
				if (isset($this->request->get['path'])) {
						$this->path = explode('_', $this->request->get['path']);
						$this->category_id = end($this->path);
				}
				$data['home'] = $this->config->get('si_vertical_menu_home');
				$data['home_menu'] = $this->config->get('si_vertical_menu_home_menu');
				
				$data['si_vertical_menu_sub_menu_image_shadow'] = $this->config->get('si_vertical_menu_sub_menu_image_shadow');
				$sub_menu_image = $this->config->get('si_vertical_menu_sub_menu_image');
				
				$data['si_vertical_menu_primary_colour'] = $this->config->get('si_vertical_menu_primary_colour');
				$data['si_vertical_menu_secondary_colour'] = $this->config->get('si_vertical_menu_secondary_colour');
				
				$data['si_vertical_menu_bg_colour_1'] = $this->config->get('si_vertical_menu_bg_colour_1');
				$data['si_vertical_menu_bg_colour_2'] = $this->config->get('si_vertical_menu_bg_colour_2');

				$data['si_vertical_menu_bg_drop_colour_1'] = $this->config->get('si_vertical_menu_bg_drop_colour_1');
				$data['si_vertical_menu_bg_drop_colour_2'] = $this->config->get('si_vertical_menu_bg_drop_colour_2');


				$data['si_vertical_menu_txt_colour_3'] = $this->config->get('si_vertical_menu_txt_colour_3');
				$data['si_vertical_menu_txt_colour_4'] = $this->config->get('si_vertical_menu_txt_colour_4');
				$data['si_vertical_menu_txt_colour_4_enable'] = $this->config->get('si_vertical_menu_txt_colour_4_enable');
					
				$count = $this->config->get('si_vertical_menu_product_count');
				$position = $this->request->get['path'];
				$data['categoriesmenu'] = $this->BuildCategoryMenu(0, '', $count, $position,$sub_menu_image);
				
				$this->view->assign('data', $data);
				$this->document->addScriptBottom($this->view->templateResource('/javascript/verticalmenu.js'));
				//$this->processTemplate('blocks/si_vertical_menu/si_vertical_menu.tpl');
				$this->processTemplate();
				// init controller data
				$this->extensions->hk_UpdateData($this);
		}
		
		
		protected function BuildCategoryMenu($parent_id, $path, $count, $position,$sub_menu_image)
		{
				
				if(substr_count($path, '_') < 1) 
					$allcategory = $this->model_catalog_category->getCategories($parent_id);
				
				
				if($allcategory) {
					foreach($allcategory as $key => $category) 
					{
						$category_id = $category['category_id'];
						$category_name = $category['name'];
						$category_description = $category['description'];
						if (!$path AND ($position == $category_id)) {
								$category_menu_html.= '<li>'; // level |
						}
						elseif ($path AND $key == 0) {
								$category_menu_html.= '<li>'; // level ||
						}
						elseif ($path AND $key > 0) {
								$category_menu_html.= '';
						}
						elseif (!$path AND ($position !== $category_id)) {
								$category_menu_html.= '<li class="">';   // level ||
						}
						if ($count) {
								$this->loadModel('catalog/product');
								$products = $this->model_catalog_product->getTotalProductsByCategoryId($category_id);
								$category_name_html = $category_name . '&nbsp;<span class="">(' . $products . ')</span>';
						}
						else {
								$category_name_html = $category_name;
						}
						if ($path) {
								$category_path = $path . '_' . $category_id;
						}
						else {
								$category_path = $category_id;
						}
						$category_href = $this->html->getSEOURL('product/category', '&path=' . $category_path, '&encode');
						if (!$path) {
								$child_categories = $this->model_catalog_category->getCategories($category_id, 2);

								if($child_categories){$category_menu_html.= '<a  href="' . $category_href . '">' . $category_name_html . '</a>
								<!-- Begin submenu -->
									<ul><!-- Begin submenu container -->
									';
										
								}
								else{ $category_menu_html.= '<a  href="' . $category_href . '">' .
									$category_name_html . '</a>
									<!-- Begin submenu Item -->
										<li><!-- Begin submenu container -->
										';
										
								}
						}
						elseif($path) {   // level ||
								
								/*add image to sub menu is enable*/
								if($sub_menu_image)
								{
									$resource = new AResource('image');
									$thumbnail = $resource->getMainThumb('categories', $category_id, '45', '45', true);
									$category_tumbnail = $thumbnail['thumb_url'];
									$child_category_href = $this->html->getSEOURL('product/category', '&path=' . $category_id, '&encode');
									$category_menu_html.= '<img src="' . $category_tumbnail . '" class="img_left imgshadow" alt="" />';
								}
								/* end add image*/
								$category_menu_html.= '<a href="' . $category_href . '">' . $category_name_html . '</a>';
												$draichild = $this->model_catalog_category->getCategories($category_id); // level |||
											if($draichild) {
												$category_menu_html.= '<ul>';
												foreach($draichild as $drai => $draicategory)
												{
												$category_href = $this->html->getSEOURL('product/category', '&path=' . $draicategory['category_id'], '&encode');
													$category_menu_html.= '<li><a href="' . $category_href . '">' . $draicategory['name'] . '</a></li>';
												}
												$category_menu_html.= '</ul>';
											
										}
						}
						$child = $this->BuildCategoryMenu($category_id, $category_path, $count, '',$sub_menu_image);
						if ($child) {
								$category_menu_html.= $child;
						}
						if (!$path) {

								$category_menu_html.= '</ul><!-- End submenu container --></li>';
						}
						
						$category_menu_html.= '</li>
								<li>
								';
					}
				}
				
				return $category_menu_html;
		}
}
