<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelExtensionSharethisIntegrationLicenseInfo extends Model {

    /**
     * @return mixed
     */
    public function getCurrentVersion() {
        $query = $this->db->query("SELECT version FROM ".$this->db->table("extensions")." WHERE `key`='sharethis_integration'");
        return $query->row['version'];
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getLicenseData($store_id) {
        $query = $this->db->query("SELECT * FROM ".$this->db->table("sharethis_integration_license_info")." WHERE `store_id`='".$store_id."'");
        return $query->row;
    }

    /**
     * @param $store_id
     * @return mixed
     * @throws AException
     */
    public function getLicenseCode($store_id) {
        $sql = "SELECT `value` FROM ".$this->db->table("settings")." 
                    WHERE `key` = 'sharethis_integration_license_code'
                            AND `store_id` = '".$this->db->escape($store_id)."'";
        $query = $this->db->query($sql);
        return trim($query->row['value']);
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getStoreId() {
        $store_id = $this->config->get('config_store_id');
        return $store_id;
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getLicensedStoreStatus() {
        $store_id = $this->getStoreId();
        $query = $this->db->query("SELECT `value` FROM ".$this->db->table("settings")." WHERE `key`='sharethis_integration_licensed_store_id_".$store_id."'");
        return $query->row['value'];
    }
}