<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( ! defined( 'DIR_CORE' ) ) {
	header( 'Location: static_pages/' );
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";
require_once DIR_EXT . "sharethis_integration" . DIR_EXT_CORE . "updater.php";

class ExtensionSharethisIntegration extends Extension {

	public $data = [];
	public $error = [];
    private $mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
    private $diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
    private $shared_secret = "sharethis_integration";

    public function __construct() {
        $this->registry = Registry::getInstance();
    }

	private function _is_enabled() {
      	return $this->baseObject->config->get('sharethis_integration_status') && $this->verify();
	}

	public function verify() {
		$that =& $this->baseObject;
        $that->load->model('extension/sharethis_integration_license_info');
        $license_key = $that->config->get('sharethis_integration_license_code');
        if ($license_key) {
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('sharethis_integration_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $that->model_extension_sharethis_integration_license_info->getStoreId();
                $license_key = $that->model_extension_sharethis_integration_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_sharethis_integration_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $that->model_extension_sharethis_integration_license_info->getLicensedStoreStatus();
                if ($validate['status']==='expired') {
                    $that->load->model('extension/sharethis_integration_license_info');
                    $store_id = $that->model_extension_sharethis_integration_license_info->getStoreId();
                    $public_key = "";
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license_key = $that->model_extension_sharethis_integration_license_info->getLicenseCode($store_id);
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }

                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $that->load->model('extension/sharethis_integration_license_info');
                    $current_version = $that->model_extension_sharethis_integration_license_info->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/sharethis_integration_license_info');
                            $that->model_extension_sharethis_integration_license_info->saveLicenseData($data);
                        } elseif ($validate['status'] === 'valid' && $store_status == 1) {
                            return true;
                        } else {
                            return false;
                        }
                    }
                } else {
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
	}

    public function onControllerPagesIndexLogin_InitData() {
        $that =& $this->baseObject;
        if ($that->request->is_POST()) {
            $logged_in = $that->session->data['LAST_ACTIVITY'];
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('sharethis_integration_license_info') . "'");
            if ($exist->num_rows === 1) {
                if (isset($logged_in)) {
                    $that->load->model('extension/sharethis_integration_license_info');
                    $store_id = $that->model_extension_sharethis_integration_license_info->getStoreId();

                    $license_info = $that->model_extension_sharethis_integration_license_info->getLicenseData($store_id);
                    $last_check = $license_info['last_check'];
                    $daily_check = 86400;
                    if (time() > $daily_check + $last_check) {
                        $public_key = "";
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license_key = $that->model_extension_sharethis_integration_license_info->getLicenseCode($store_id);
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        if (stripos($license_key,'mc-')!==false) {
                            $server_url = $this->mc_server_url;
                        } else {
                            $server_url = $this->diy_server_url;
                        }

                        $license_manager->setLicenseServerUrl($server_url);
                        $license_manager->setKeys($license_key, "", $this->shared_secret);
                        $public_key = $license_manager->requestKey();
                        $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                        $that->load->model('extension/sharethis_integration_updater');
                        $current_version = $that->model_extension_sharethis_integration_updater->getCurrentVersion();
                        $custom_data = ['version' => $current_version];
                        $license_data = $license_manager->requestData($custom_data);
                        if (!is_null($license_data)) {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $ttl = 1209600;
                            $validate = $license_manager->validate($license_data, $ttl);
                            if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                                $data['public_key'] = $public_key;
                                $data['license_data'] = $license_data;
                                $data['store_id'] = $store_id;
                                $data['last_check'] = time();
                                $that->load->model('extension/sharethis_integration_license_info');
                                $that->model_extension_sharethis_integration_license_info->saveLicenseData($data);
                            }
                        }
                    }
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensions_InitData() {
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'edit' ) {
            $extension = $that->request->get['extension'];
            if ( $extension === 'sharethis_integration' ) {
                if ( $that->request->is_POST()) {
                    $public_key = "";
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license_key = trim($that->request->post['sharethis_integration_license_code']);
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }
                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $that->load->model('extension/sharethis_integration_license_info');

                    $store_id = (int) $that->config->get('config_store_id');
                    if (has_value($that->request->get_or_post('store_id'))) {
                        $store_id = (int) $that->request->get_or_post('store_id');
                    } else {
                        if ($that->session->data['config_store_id']) {
                            $store_id = (int) $that->session->data['config_store_id'];
                        }
                    }

                    $installed_store_id = $that->model_extension_sharethis_integration_license_info->getInstalledLicense($license_key);

                    if ($installed_store_id!=='' && !is_null($installed_store_id)) {
                        $that->model_extension_sharethis_integration_license_info->deleteLicenseInfo($installed_store_id);
                    }
                    $existing_license_key = $that->model_extension_sharethis_integration_license_info->getLicenseCode($store_id);
                    $data['multi']=false;
                    $split_existing_license_key = explode('-',$existing_license_key);
                    $split_license_key = explode('-',$license_key);
                    if ($existing_license_key && $split_existing_license_key[0] !== $split_license_key[0]) {
                        $data['multi']=true;
                    }

                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $that->load->model('extension/sharethis_integration_updater');
                    $current_version = $that->model_extension_sharethis_integration_updater->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);

                        $that->load->model('setting/setting');
                        $that->load->model('extension/sharethis_integration_license_info');
                        $data['sharethis_integration_licensed_store_id_'.$store_id] = 1;

                        $that->model_setting_setting->editSetting('sharethis_integration', $data);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            if (file_exists(DIR_EXT.'sharethis_integration/core/helpers.php')) {
                                unlink(DIR_EXT.'sharethis_integration/core/helpers.php');
                            }
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['license_key'] = $license_key;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/sharethis_integration_license_info');
                            $that->model_extension_sharethis_integration_license_info->saveLicenseData($data);
                        }
                    } else {
                        $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                    }
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensions_UpdateData() {
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'edit' ) {
            $extension = $that->request->get['extension'];
            $that->load->language('sharethis_integration/sharethis_integration');
            if ( $extension === 'sharethis_integration' ) {
                $latestVersion = $this->getVersion();
                $that->loadLanguage('extension/extensions');
                if (!is_null($latestVersion) && $latestVersion!=='') {
                    $info = sprintf(
                        $that->language->get('text_update_sharethis_integration_available'),
                        $latestVersion,
                        $that->html->getSecureURL('extension/sharethis_integration_updater','&version='.str_replace('.', '-', $latestVersion))
                    );
                    $that->view->assign('info',$info);
                } else {
                    $that->view->assign('info','');
                }
                $view = new AView($this->registry, 0);
                $data['manual_url'] = 'https://why2central.net/v1/sharethis-integration';
                $data['manual_title'] = $that->language->get('sharethis_integration_name').' Manual';
                $view->batchAssign($data);
                $that->view->addHookVar('extension_toolbar_buttons', $view->fetch('pages/extension/sharethis_integration_manual.tpl'));

                $that->load->model('extension/sharethis_integration_license_info');
                $license_key = $that->config->get('sharethis_integration_license_code');
                if ($license_key) {
                    $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('sharethis_integration_license_info') . "'");
                    if ($exist->num_rows === 1) {
                        $store_id = $that->model_extension_sharethis_integration_license_info->getStoreId();
                        $license_key = $that->model_extension_sharethis_integration_license_info->getLicenseCode($store_id);
                        $license_info = $that->model_extension_sharethis_integration_license_info->getLicenseData($store_id);
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_info['license_data'], $ttl);
                        $message = '';
                        if ($validate['status']==='expired') {
                            $message = $that->language->get('sharethis_integration_license_expired');
                        }
                        $that->view->assign('message',$message);
                    }
                }
                $that->processTemplate();
            }
        }
    }

    public function onControllerResponsesListingGridExtension_InitData() {
        if ($this->baseObject_method != 'update') {
            return false;
        }
        $that =& $this->baseObject;
        if ($that->request->get['id'] != 'sharethis_integration') {
            return false;
        }
        if (isset($that->request->post['sharethis_integration_license_code'])) {
            $that->request->post['sharethis_integration_license_code'] = trim($that->request->post['sharethis_integration_license_code']);
        }
    }

    public function onControllerResponsesListingGridExtension_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $store_id = (int)$that->config->get('current_store_id');
            if ($that->request->get_or_post('store_id')) {
                $store_id = $that->request->get_or_post('store_id');
            }
            $that->load->language('sharethis_integration/sharethis_integration');
            $response = json_decode(json_encode($that->data['response']), true);
            $extension_rows = $response['rows'];
            $ext_name = $that->language->get('sharethis_integration_name');
            foreach ($extension_rows as $k => $extensions) {
                if ($extensions['id'] === 'sharethis_integration_' . $store_id) {
                    $cells = $extensions['cell'];
                    foreach ($cells as $key => $cell) {
                        if ($cell===$ext_name || strpos($cell,'<p class="alert-info">'.$ext_name)!==false) {
                            $latestVersion = $this->getVersion();
                            if (!is_null($latestVersion) && $latestVersion !== '') {
                                $update_now_url = $that->html->getSecureURL('extension/sharethis_integration_updater', '&version=' . str_replace('.', '-', $latestVersion));
                                $cells[$key] = '<p class="alert-info">'
                                    .$ext_name.' (WHY2)'
                                    . '<br>'
                                    . sprintf(
                                        $that->language->get('text_update_sharethis_integration_available'),
                                        $latestVersion,
                                        $update_now_url
                                    )
                                    . '</p>';
                                $that->data['response']->rows[$k]['cell'][$key] = $cells[$key];
                            } else {
                                $that->data['response']->rows[$k]['cell'][$key] = $ext_name;
                            }
                        }
                    }
                }
            }
        } elseif ($this->baseObject_method==='update') {
            if ($that->request->post['sharethis_integration_license_code']) {
                $public_key = "";
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

                $license_key = trim($that->request->post['sharethis_integration_license_code']);
                if (stripos($license_key,'mc-')!==false) {
                    $server_url = $this->mc_server_url;
                } else {
                    $server_url = $this->diy_server_url;
                }
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setLicenseServerUrl($server_url);
                $license_manager->setKeys($license_key, "", $this->shared_secret);
                $public_key = $license_manager->requestKey();

                $store_id = (int) $that->config->get('config_store_id');
                if ($that->request->get_or_post('store_id')) {
                    $store_id = $that->request->get_or_post('store_id');
                }

                $that->load->model('extension/sharethis_integration_license_info');

                $installed_store_id = $that->model_extension_sharethis_integration_license_info->getInstalledLicense($license_key);

                if ($installed_store_id!=='' && !is_null($installed_store_id)) {
                    $that->model_extension_sharethis_integration_license_info->deleteLicenseInfo($installed_store_id);
                }

                $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                $that->load->model('extension/sharethis_integration_updater');
                $current_version = $that->model_extension_sharethis_integration_updater->getCurrentVersion();
                $custom_data = ['version' => $current_version];
                $license_data = $license_manager->requestData($custom_data);
                if (!is_null($license_data)) {
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_data, $ttl);

                    $that->load->model('setting/setting');
                    $that->load->model('extension/sharethis_integration_license_info');

                    if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $data['license_key'] = $license_key;
                        $data['store_id'] = $store_id;
                        $data['last_check'] = time();
                        $that->load->model('extension/sharethis_integration_license_info');
                        $that->model_extension_sharethis_integration_license_info->saveLicenseData($data);
                    }
                } else {
                    $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensionSummary_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $extension = $that->request->get['extension'];
            if ($extension==='sharethis_integration') {
                $that->load->language('sharethis_integration/sharethis_integration');
                $extension_info = $that->extensions->getExtensionInfo($extension);
                $support_expiration_int =  strtotime($extension_info['support_expiration']);
                if ($extension_info['support_expiration'] && $support_expiration_int !== 0) {
                    if ($support_expiration_int < time()) {
                        if ($that->data['text_support_expiration']) {
                            $that->view->assign('text_support_expired', $that->language->get('text_support_by_why2'));
                        } else {
                            $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                        }
                    } else {
                        $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                    }
                } else {
                    $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                }
                $that->view->assign('get_support_button', '');
                $data['get_diy_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'diy_support',
                        'target' => "_new",
                        'href'   => 'https://wehearyou2.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_diy_support_by_why2'),
                    ]
                );
                $data['get_mc_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'mc_support',
                        'target' => "_new",
                        'href'   => 'https://abantecartplus.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_mc_support_by_why2'),
                    ]
                );
                $view = new AView(Registry::getInstance(), 0);
                $view->batchAssign($data);
                $that->view->addHookVar('extension_summary_item', $view->fetch('pages/extension/extension_summary_buttons.tpl'));
                $that->view->batchAssign($this->data);
                $that->processTemplate();
            }
        }
    }

	public function onControllerCommonHead_InitData() {
		if ( ! $this->_is_enabled() ) {
			return null;
		}
		$that         = $this->baseObject;
		if ( IS_ADMIN === false ) {
          	$resource     = new AResource( 'image' );
			$request      = $that->request->get;
			$key          = []; //key of product from cart
			$product_page = '0';
			if ( has_value( $request['key'] ) ) {
				$key          = explode( ':', $request['key'] );
				$product_id   = (int) $key[0];
				$product_page = '1';
			} elseif ( has_value( $request['product_id'] ) ) {
				$product_id   = (int) $request['product_id'];
				$product_page = '1';
			} else {
				$product_id = 0;
			}

			$desc = '';
			$that->load->model( 'catalog/product' );
			$product_info = $that->model_catalog_product->getProduct( $product_id );
			if ( $product_info ) {
				$desc = strip_tags( htmlspecialchars_decode( $product_info['description'] ) );
			}
			$sizes   = [
				'thumb' => [
					'width'  => $that->config->get( 'config_image_thumb_width' ),
					'height' => $that->config->get( 'config_image_thumb_height' )
				]
			];
			$array[] = $resource->getResourceAllObjects( 'products', $product_id, $sizes, 1, false );
			if (HTTPS === true) {
                $thumb_url = 'https:' . $array[0]['thumb_url'];
            } else {
                $thumb_url = 'http:' . $array[0]['thumb_url'];
            }
			$this->data['ogImg']    = $thumb_url;
			$this->data['ogWidth']  = $array[0]['thumb_width'];
			$this->data['ogHeight'] = $array[0]['thumb_height'];
			$this->data['ogDesc']   = $desc;
			if ( HTTPS === true ) {
				$url = 'https://';
			} else {
				$url = 'http://';
			}
			$headCode                   = html_entity_decode($that->config->get( 'sharethis_integration_sharethisHeadJSCode' ));
			$this->data['sharethisHeadJSCode']   = $headCode;
			$this->data['product_page'] = $product_page;
			$this->data['ogUrl']        = $url . $_SERVER["SERVER_NAME"] . $_SERVER["REQUEST_URI"];
			$divCode                    = html_entity_decode($that->config->get( 'sharethis_integration_divTag' ));
			$this->data['sharethisSpans']        = $divCode;
			$that->view->batchAssign( $this->data );
			$that->processTemplate( 'common/head.post.tpl' );
		}
	}

	public function onControllerResponsesEmbedHead_InitData() {
		if ( ! $this->_is_enabled() ) {
			return null;
		}
		$that         =& $this->baseObject;
		$resource     = new AResource( 'image' );
		$request      = $that->request->get;
		$key          = []; //key of product from cart
		$product_page = '0';
		if ( has_value( $request['key'] ) ) {
			$key          = explode( ':', $request['key'] );
			$product_id   = (int) $key[0];
			$product_page = '1';
		} elseif ( has_value( $request['product_id'] ) ) {
			$product_id   = (int) $request['product_id'];
			$product_page = '1';
		} else {
			$product_id = 0;
		}

		$desc = '';
		$that->load->model( 'catalog/product' );
		$product_info = $that->model_catalog_product->getProduct( $product_id );
		if ( $product_info ) {
			$desc = strip_tags( htmlspecialchars_decode( $product_info['description'] ) );
		}

		$sizes   = [
			'thumb' => [
				'width'  => $that->config->get( 'config_image_thumb_width' ),
				'height' => $that->config->get( 'config_image_thumb_height' )
			]
		];
		$array[] = $resource->getResourceAllObjects( 'products', $product_id, $sizes, 1, false );

        if (HTTPS === true) {
            $thumb_url = 'https:' . $array[0]['thumb_url'];
        } else {
            $thumb_url = 'http:' . $array[0]['thumb_url'];
        }

		$this->data['ogImg']    = $thumb_url;
		$this->data['ogWidth']  = $array[0]['thumb_width'];
		$this->data['ogHeight'] = $array[0]['thumb_height'];
		$this->data['ogDesc']   = $desc;
		if ( HTTPS === true ) {
			$url = 'https://';
		} else {
			$url = 'http://';
		}
		$headCode                   = html_entity_decode($that->config->get( 'sharethis_integration_sharethisHeadJSCode' ));
		$this->data['sharethisHeadJSCode']   = $headCode;
		$this->data['product_page'] = $product_page;
		$this->data['ogUrl']        = $url . $_SERVER["SERVER_NAME"] . $_SERVER["REQUEST_URI"];
		$divCode                    = html_entity_decode($that->config->get( 'sharethis_integration_divTag' ));
		$this->data['sharethisSpans']        = $divCode;
		$that->view->batchAssign( $this->data );
		$that->processTemplate( 'embed/head.post.tpl' );
	}

    public function onControllerCommonHead_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (IS_ADMIN) {
                $latestVersion = $this->getVersion();
                if ($latestVersion) {
                    $that->load->language('sharethis_integration/sharethis_integration');
                    $that->load->model('extension/sharethis_integration_updater');
                    $total = $that->model_extension_sharethis_integration_updater->getTotalMsgIds();
                    if ($total > '0') {
                        $msg_ids = $that->model_extension_sharethis_integration_updater->getMsgIdsByCartVersions();
                        foreach ($msg_ids as $msg_id) {
                            $that->messages->deleteMessage($msg_id['msg_id']);
                            $that->model_extension_sharethis_integration_updater->deleteMsgID($msg_id['msg_id']);
                        }
                    }
                    $msg_title = str_replace('[new_version]', $latestVersion, $that->language->get('text_new_sharethis_integration_version_title'));
                    $msg = str_replace('[version_number]', str_replace('.', '-', $latestVersion), $that->language->get('text_new_sharethis_integration_version_description'));
                    $that->messages->saveNotice($msg_title, $msg);
                    $msg_info = $that->messages->getLikeMessage($msg_title);
                    $that->model_extension_sharethis_integration_updater->saveMessageId($msg_info['msg_id'], $latestVersion);
                }
            }
        }
    }

    private function getVersion() {
        $that =& $this->baseObject;
        $latestVersion = '';
        $license_key = $that->config->get('sharethis_integration_license_code');
        if ($license_key) {
            $valid = false;
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('sharethis_integration_license_info') . "'");
            if ($exist->num_rows === 1) {
                $that->load->model('extension/sharethis_integration_license_info');
                $store_id = $that->model_extension_sharethis_integration_license_info->getStoreId();

                $license_key = $that->model_extension_sharethis_integration_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_sharethis_integration_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);

                if ($validate['status'] === 'valid') {
                    if (stripos($license_key, 'rent-') !== false || stripos($license_key, 'mc-') !== false) {
                        $valid = true;
                    } elseif (stripos($license_key, 'own-') !== false) {
                        $today = date("Y-m-d H:i:s");
                        $support_date = date('Y-m-d H:i:s', strtotime($validate['updates']));
                        if ($today <= $support_date) {
                            $valid = true;
                        }
                    }
                }
            }
            if ($valid) {
                $that->load->language('sharethis_integration/sharethis_integration');
                $getVersions = sharethisIntegrationUpdaterGetAllVersions();
                $that->load->model('extension/sharethis_integration_updater');
                $current_version = $that->model_extension_sharethis_integration_updater->getCurrentVersion();
                if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                    $versions = $getVersions['notification_data']['product_versions'];
                    if ($versions) {
                        $latestVersions = [];
                        foreach ($versions as $version) {
                            if (strpos($version['version_number'], VERSION) !== false) {
                                $latestVersions[] = $version['version_number'];
                            }
                        }
                        usort($latestVersions, 'version_compare');
                        $latestVersion = end($latestVersions);
                        if (version_compare($current_version, $latestVersion, '<') === true) {
                            $msg_ids = $that->model_extension_sharethis_integration_updater->getMsgIdsByCurrentCartVersion();
                            foreach ($msg_ids as $msg_id) {
                                $that->messages->deleteMessage($msg_id['msg_id']);
                                $that->model_extension_sharethis_integration_updater->deleteMsgID($msg_id['msg_id']);
                            }
                            return $latestVersion;
                        }
                    }
                } else {
                    return '';
                }
            } else {
                return '';
            }
        }
    }
} ?>