<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}
class ControllerResponsesExtensionSeoPackGoogleSitemapXml extends AController
{
    public function main()
    {
        //$this->model_show_weight_show_weight->onControllerPagesProductProduct_InitData ();
        //$this->loadLanguage('google_sitemap_xml/google_sitemap_xml');
        $this->loadModel('seo_pack_google_sitemap_xml/seo_pack_google_sitemap_xml');

        //$storeurl = $this->html->getURL('index/home');
        $storeurl = HTTP_SERVER;
        $path = $_GET['path'];
        $rssurl = $this->html->getURL('extension/seo_pack_google_sitemap_xml');

        //$logo = $this->config->get('config_logo');
        //pathinfo($this->config->get('config_logo'), PATHINFO_FILENAME)
        $store = html_entity_decode($this->config->get('store_name'), ENT_QUOTES, 'UTF-8');
        $feed_type = 'google';
        $changefreq_setting = $this->config->get('changefreq');
        $limit = (int) $this->config->get('display_images_limit');
        switch ($changefreq_setting) {
    case 0:
        $changefreq = 'hourly';
        break;
    case 1:
        $changefreq = 'daily';
        break;

    case 2:
        $changefreq = 'weekly';
        break;

    case 3:
        $changefreq = 'monthly';
        break;

    case 4:
        $changefreq = 'yearly';
        break;

    default:
        $changefreq = 'daily';
        break;
}

        function utf8_compliant($str)
        {
            if (0 == strlen($str)) {
                return true;
            }
            // If even just the first character can be matched, when the /u
            // modifier is used, then it's valid UTF-8. If the UTF-8 is somehow
            // invalid, nothing at all will match, even if the string contains
            // some valid sequences
            return 1 == preg_match('/^.{1}/us', $str, $ar);
        }

        function work_text($string)
        {
            $string = str_replace('\'', ' ', $string);
            $string = str_replace('ô', '', $string);
            $string = str_replace('Æ', '', $string);
            $string = str_replace('ó', '-', $string);
            $string = str_replace('í', '\'', $string);
            $string = str_replace('î', '"', $string);
            $string = str_replace(']]>', '', $string);
            $string = str_replace('<![CDATA[', '', $string);
            $string = str_replace('<![', '', $string);

            if (!utf8_compliant($string)) {
                return htmlspecialchars(utf8_encode(trim(preg_replace(array('/<br>/i', "/\n+/", "/\s+/", '/&reg;/', '/&trade;/'), array("\n", "\n", ' ', '', ''), $string))));
            } else {
                return htmlspecialchars(trim(preg_replace(array('/<br>/i', "/\n+/", "/\s+/", '/&reg;/', '/&trade;/'), array("\n", "\n", ' ', '', ''), $string)));
            }
        }

        $display_image = $this->config->get('display_images');
        $display_manufacturers = $this->config->get('display_manufacturers');
        $display_content_pages = $this->config->get('display_content_pages');
        $display_categories = $this->config->get('display_categories');
        $display_collection_pages = $this->config->get('display_collection_pages');
        //$displaydate = date("Y-m-d");
        $displaydate = date('c');

        if ('google' == $feed_type) { //start
            $RSS_line = '<?xml version="1.0" encoding="UTF-8"?>'.PHP_EOL;

            if ('0' == $display_image) {
                $RSS_line .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">'.PHP_EOL;
            } else {
                $RSS_line .= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"
		xmlns:image="http://www.google.com/schemas/sitemap-image/1.1">'.PHP_EOL;
            }

            $data = $this->model_seo_pack_google_sitemap_xml_seo_pack_google_sitemap_xml->getProductData($path);
            foreach ($data as $data_product) {
                if ('1' == $display_image) {
                    $resource = new AResource('image');
                    $sizes = array('main' => array('width' => $this->config->get('config_image_popup_width'),
                                       'height' => $this->config->get('config_image_popup_height'), ),
                       'thumb' => array('width' => $this->config->get('config_image_thumb_width'),
                                       'height' => $this->config->get('config_image_thumb_height'), ), );

                    if (1 == $limit) {
                        $images = $resource->getMainThumb(
                            'products',
                            $data_product['product_id'],
                            $this->config->get('config_image_thumb_width'),
                            $this->config->get('config_image_thumb_height'),
                            true
                        );
                    } else {
                        if ($this->config->get('google_sitemap_images_type')) {
                            /******START ALL IN MAX SIZE******/

                            $images = $resource->getResources('products', $data_product['product_id']);
                            $images = array_slice($images, 0, $limit);
                            $i = 1;
                            foreach ($images as $key => $image) {
                                if ($image['resource_path']) {
                                    $image_main_url = HTTPS_DIR_RESOURCE.'image/'.$image['resource_path'];
                                    $images[$key]['main_url'] = $image_main_url;
                                }
                                if ($i++ == $limit) {
                                    break;
                                }
                            }
                            /****END***/
                          //$this->log->write(print_r($images, true).'res');
                        } else {
                            /**START THUMBNAILS*******/
                            $images = $resource->getResourceAllObjects('products', $data_product['product_id'], $sizes, $limit, false);
                            /**END***/
                        }
                    }
                }

                if ($_SERVER['HTTPS']) {
                    $protocol = 'https:';
                } else {
                    $protocol = 'http:';
                }

                $RSS_line .= '<url>'.PHP_EOL;
                $RSS_line .= '<loc>'.str_replace('&', '&amp;', $this->html->getSEOURL('product/product', '&product_id='.$data_product['product_id'])).'</loc>'.PHP_EOL;
                if ('1' == $display_image) {
                    if (1 == $limit) {
                        //print_r($images);
                        if (false !== strpos($images['thumb_url'], 'http://')) {
                            $image_th_url = $images['thumb_url'];
                        } else {
                            $image_th_url = $protocol.$images['thumb_url'];
                        }
                        $RSS_line .= '<image:image>
				   <image:loc>'.$image_th_url.'</image:loc>'.PHP_EOL;
                        if (has_value($images['title'])) {
                            $RSS_line .= '<image:title>'.work_text($images['title']).'</image:title>'.PHP_EOL;
                        }
                        $RSS_line .= '</image:image>'.PHP_EOL;
                    } else {
                        //print_r($images);
                        foreach ($images as $images) {
                            if (false !== strpos($images['main_url'], 'http://')) {
                                $image_main_url = $images['main_url'];
                            } else {
                                $image_main_url = $protocol.$images['main_url'];
                            }
                            $RSS_line .= '<image:image>
				   <image:loc>'.$image_main_url.'</image:loc>'.PHP_EOL;
                            if (has_value($images['title'])) {
                                $RSS_line .= '<image:title>'.work_text($images['title']).'</image:title>'.PHP_EOL;
                            }
                            $RSS_line .= '</image:image>'.PHP_EOL;
                        }
                    }
                }

                $RSS_line .= '<lastmod>'.$displaydate.'</lastmod>'.PHP_EOL;
                $RSS_line .= '<changefreq>'.$changefreq.'</changefreq>'.PHP_EOL;
                $RSS_line .= '<priority>0.9</priority>'.PHP_EOL;
                $RSS_line .= '</url>'.PHP_EOL;
            }

            if (1 == $display_categories) {
                $results = $this->model_seo_pack_google_sitemap_xml_seo_pack_google_sitemap_xml->getCategories($parent_id);
                foreach ($results as $result) {
                    $new_path = $result['category_id'];
                    $RSS_line .= '<url>'.PHP_EOL;
                    $RSS_line .= '<loc>'.$this->html->getSEOURL('product/category', '&path='.$new_path, true).'</loc>'.PHP_EOL;
                    $RSS_line .= '<lastmod>'.$displaydate.'</lastmod>'.PHP_EOL;
                    $RSS_line .= '<changefreq>'.$changefreq.'</changefreq>'.PHP_EOL;
                    $RSS_line .= '<priority>0.9</priority>'.PHP_EOL;
                    $RSS_line .= '</url>'.PHP_EOL;

                    $results_parent = $this->model_seo_pack_google_sitemap_xml_seo_pack_google_sitemap_xml->getCategories($new_path);
                    foreach ($results_parent as $results_parent) {
                        $current_path = $new_path;
                        $new_path_parent = $current_path.'_'.$results_parent['category_id'];
                        $RSS_line .= '<url>'.PHP_EOL;
                        $RSS_line .= '<loc>'.$this->html->getSEOURL('product/category', '&path='.$new_path_parent, true).'</loc>'.PHP_EOL;
                        $RSS_line .= '<lastmod>'.$displaydate.'</lastmod>'.PHP_EOL;
                        $RSS_line .= '<changefreq>'.$changefreq.'</changefreq>'.PHP_EOL;
                        $RSS_line .= '<priority>0.8</priority>'.PHP_EOL;
                        $RSS_line .= '</url>'.PHP_EOL;
                    }
                }
            }



            if (1 == $display_collection_pages) {
                $results = $this->model_seo_pack_google_sitemap_xml_seo_pack_google_sitemap_xml->getCollections();
                foreach ($results as $result) {
                    //$this->log->write(print_r($result, true).' $resultCOllec');
                    if ($result['id'] > 0) {
                        $collection_id = $result['id'];
                        $RSS_line .= '<url>'.PHP_EOL;
                        $RSS_line .= '<loc>'.$this->html->getSecureSEOURL('product/collection', '&collection_id='.$collection_id, true).'</loc>'.PHP_EOL;
                        $displaydate = date('Y-m-d');
                        //abantecart do not have date added for collection
                        $RSS_line .= '<lastmod>'.$displaydate.'</lastmod>'.PHP_EOL;
                        $RSS_line .= '<changefreq>'.$changefreq.'</changefreq>'.PHP_EOL;
                        $RSS_line .= '<priority>0.7</priority>'.PHP_EOL;
                        $RSS_line .= '</url>'.PHP_EOL;
                    }
                }
            }

            if (1 == $display_manufacturers) {
                $results = $this->model_seo_pack_google_sitemap_xml_seo_pack_google_sitemap_xml->getManufacturers();
                foreach ($results as $result) {
                    $manufacturer_id = $result['manufacturer_id'];
                    $RSS_line .= '<url>'.PHP_EOL;
                    $RSS_line .= '<loc>'.$this->html->getSEOURL('product/manufacturer', '&manufacturer_id='.$manufacturer_id, true).'</loc>'.PHP_EOL;
                    $RSS_line .= '<lastmod>'.$displaydate.'</lastmod>'.PHP_EOL;
                    $RSS_line .= '<changefreq>'.$changefreq.'</changefreq>'.PHP_EOL;
                    $RSS_line .= '<priority>0.7</priority>'.PHP_EOL;
                    $RSS_line .= '</url>'.PHP_EOL;
                }
            }

            if (1 == $display_content_pages) {
                $results = $this->model_seo_pack_google_sitemap_xml_seo_pack_google_sitemap_xml->getContents();
                foreach ($results as $result) {
                    $content_id = $result['content_id'];
                    $RSS_line .= '<url>'.PHP_EOL;
                    $RSS_line .= '<loc>'.$this->html->getSEOURL('content/content', '&content_id='.$content_id, true).'</loc>'.PHP_EOL;
                    $RSS_line .= '<lastmod>'.$displaydate.'</lastmod>'.PHP_EOL;
                    $RSS_line .= '<changefreq>'.$changefreq.'</changefreq>'.PHP_EOL;
                    $RSS_line .= '<priority>0.6</priority>'.PHP_EOL;
                    $RSS_line .= '</url>'.PHP_EOL;
                }
            }

            $RSS_line .= '<url>'.PHP_EOL;
            $RSS_line .= '<loc>'.$storeurl.'</loc>'.PHP_EOL;
            $RSS_line .= '<lastmod>'.$displaydate.'</lastmod>'.PHP_EOL;
            $RSS_line .= '<changefreq>'.$changefreq.'</changefreq>'.PHP_EOL;
            $RSS_line .= '<priority>0.9</priority>'.PHP_EOL;
            $RSS_line .= '</url>'.PHP_EOL;

            $RSS_line .= '</urlset>';
            $this->response->addHeader('Content-Type: text/xml');
            $this->response->setOutput($RSS_line);
        } //end
    }
}
