<?php

if (!defined('DIR_CORE') || !IS_ADMIN) {
    header('Location: static_pages/');
}

class ModelSeoPackProduct extends Model
{
    public function getProduct($product_id)
    {
        $query = $this->db->query('SELECT DISTINCT *, p.product_id, COALESCE(pf.product_id, 0) as featured,
										(SELECT keyword
										 FROM '.DB_PREFIX."url_aliases
										 WHERE query = 'product_id=".(int) $product_id."'
										 	AND language_id='".(int) $this->language->getContentLanguageID()."' ) AS keyword
									FROM ".DB_PREFIX.'products p
									LEFT JOIN '.DB_PREFIX.'products_featured pf ON pf.product_id = p.product_id
									LEFT JOIN '.DB_PREFIX."product_descriptions pd
											ON (p.product_id = pd.product_id
													AND pd.language_id = '".(int) $this->config->get('storefront_language_id')."')
									WHERE p.product_id = '".(int) $product_id."'");

        return $query->row;
    }

    public function getUniKeywordDu($seo_key, $object_key_name = '', $object_id = 0)
    {
        // SELECT `keyword` FROM ac_url_aliases WHERE query like '%' AND `keyword` like 'face%'
        // SELECT * FROM ac_url_aliases WHERE query like '%' AND `keyword` like 'face%' AND query<>'product_id=71'
        $object_id = (int) $object_id;

        $registry = Registry::getInstance();
        $db = $registry->get('db');
        $sql = 'SELECT `keyword`
				FROM '.$db->table('url_aliases')."
				WHERE query like '%'
						AND `keyword` like '".$db->escape($seo_key)."%'";
        if ($object_id) {
            // exclude keyword of given object (product, category, content etc)
            $sql .= " AND query<>'".$db->escape($object_key_name).'='.$object_id."'";
        }

        $result = $db->query($sql);
        if ($result->num_rows) {
            foreach ($result->rows as $row) {
                $keywords[] = $row['keyword'];
            }

            $i = 0;
            while (in_array($seo_key, $keywords) && $i < 20) {
                $seo_key = $seo_key.'_'.($object_id ? $object_id : $i);
                ++$i;
            }
        }

        return $seo_key;
    }

    /////////////////
    public function getProductSeo($product_id, $option_id = 0)
    {
        $language_id = $this->language->getContentLanguageID();

        $product_seo = $this->db->query(
        'SELECT *
		FROM `'.DB_PREFIX."product_extra_seo`
		WHERE `product_id` = '".(int) $product_id."'
			 AND `language_id` = '".(int) $language_id."'
										 ");

        /*$product_seo = $this->db->query(
            "SELECT *
            FROM `" . DB_PREFIX . "product_extra_seo`
            LEFT JOIN `" . DB_PREFIX . "product_descriptions`
            ON `" . DB_PREFIX . "product_extra_seo`.`product_id` = `" . DB_PREFIX . "product_descriptions`.`product_id`
            AND `" . DB_PREFIX . "product_extra_seo`.`language_id` = `" . DB_PREFIX . "product_descriptions`.`language_id`
            WHERE  `" . DB_PREFIX . "product_descriptions`.`product_id` = '" . (int)$product_id . "'
                 AND `" . DB_PREFIX . "product_descriptions`.`language_id` = '" . (int)$language_id . "'
                                             "); */

        /*$product_seo = $this->db->query(
            "SELECT *
            FROM `" . DB_PREFIX . "product_extra_seo`
            LEFT JOIN `" . DB_PREFIX . "product_descriptions`
            ON `" . DB_PREFIX . "product_extra_seo`.`product_id` = `" . DB_PREFIX . "product_descriptions`.`product_id`
            WHERE  `" . DB_PREFIX . "product_descriptions`.`product_id` = '" . (int)$product_id . "'
                 AND `" . DB_PREFIX . "product_descriptions`.`language_id` = '" . (int)$language_id . "'
                             UNION
                            SELECT * FROM `" . DB_PREFIX . "product_extra_seo`
                            RIGHT JOIN `" . DB_PREFIX . "product_descriptions` ON `" . DB_PREFIX . "product_extra_seo`.`product_id` = `" . DB_PREFIX . "product_descriptions`.`product_id`
                            WHERE  `" . DB_PREFIX . "product_descriptions`.`product_id` = '" . (int)$product_id . "'
                                 AND `" . DB_PREFIX . "product_descriptions`.`language_id` = '" . (int)$language_id . "'
                                             ");/*
            /*SELECT * FROM `ac_product_extra_seo`
LEFT JOIN `ac_product_descriptions`
ON `ac_product_extra_seo`.`product_id` = `ac_product_descriptions`.`product_id`
WHERE `ac_product_descriptions`.`product_id` = '80'
AND `ac_product_descriptions`.`language_id` = '1'
UNION
SELECT * FROM `ac_product_extra_seo`
RIGHT JOIN `ac_product_descriptions`
ON `ac_product_extra_seo`.`product_id` = `ac_product_descriptions`.`product_id`
WHERE `ac_product_descriptions`.`product_id` = '80'
AND `ac_product_descriptions`.`language_id` = '1'*/

        if ($product_seo->num_rows) {
            $row = $product_seo->row;
            $row['language'] = $product_seo;

            return $row;
        } else {
            return null;
        }
    }

    // uniq
    public function getProductSeoUniq($product_id, $short_description)
    {
        $language_id = $this->language->getContentLanguageID();
        //'" . $this->db->escape($seo_title) . "'

        $product_seo_uniq = $this->db->query(
        'SELECT short_description, COUNT(*) c
		FROM `'.DB_PREFIX."product_extra_seo`
		WHERE `short_description` LIKE '%".$this->db->escape($short_description)."%'
			 AND `language_id` = '".(int) $language_id."'
			 	GROUP BY short_description HAVING c > 1
										 ");

        //`product_id` = '" . (int)$product_id . "'

        if ($product_seo_uniq->num_rows) {
            $row = $product_seo_uniq->row;
            $row['language'] = $product_seo_uniq;

            return $row;
        } else {
            return null;
        }
    }

    // uniq meta_description
    public function getProductSeoUniqMetaDescr($product_id, $meta_description)
    {
        $language_id = $this->language->getContentLanguageID();

        $product_seo_uniq_meta_descr = $this->db->query(
        'SELECT meta_description, COUNT(*) c
		FROM `'.DB_PREFIX."product_descriptions`
		WHERE `meta_description` LIKE '%".$this->db->escape($meta_description)."%'
			 AND `language_id` = '".(int) $language_id."'
			 	GROUP BY meta_description HAVING c > 1
										 ");

        //`product_id` = '" . (int)$product_id . "'

        if ($product_seo_uniq_meta_descr->num_rows) {
            $row = $product_seo_uniq_meta_descr->row;
            $row['language'] = $product_seo_uniq_meta_descr;

            return $row;
        } else {
            return null;
        }
    }

    // uniq title,name and h1
    public function getProductSeoUniqTitleh($product_id)
    {
        $language_id = $this->language->getContentLanguageID();

        $product_seo_uniq_title = $this->db->query(
        'SELECT '.DB_PREFIX.'product_descriptions.product_id, '.DB_PREFIX.'product_descriptions.name, '.DB_PREFIX.'product_extra_seo.seo_title, '.DB_PREFIX.'product_extra_seo.seo_h1
		FROM '.DB_PREFIX.'product_descriptions
		LEFT JOIN '.DB_PREFIX.'product_extra_seo ON '.DB_PREFIX.'product_descriptions.product_id='.DB_PREFIX.'product_extra_seo.product_id
		WHERE '.DB_PREFIX."product_descriptions.language_id = '".(int) $language_id."'
										 ");

        //`product_id` = '" . (int)$product_id . "'

        if ($product_seo_uniq_title->num_rows) {
            $row = $product_seo_uniq_title->rows;
            //$row['language'] = $product_seo_uniq_title;
            //$this->log->write(print_r($product_seo_uniq_title->rows , true).'ddddddd');
            /*
            [product_id] => 70
            ['name'] => Eau Parfumee au The Vert Shampoo
            ['seo_title'] =>
            ['seo_h1'] =>
             // print array to log */
            /*$ret = array();
            //$row = json_decode($row, true); // fix  Cannot use object of type stdClass as array
            foreach ($row as $value) {
            //	$this->log->write(print_r($value , true).'value');
                $ret['product_id'] = $value['product_id'];
            //	$this->log->write($value->product_id);
                if (mb_strlen($value->seo_title ) < 1)
                        {
                            $ret['seo_title'] = $value->name;
                        }
                        else
                        {$ret['seo_title'] = $value->seo_title;}

                        if (mb_strlen($value->seo_h1) < 1)
                                {
                                    $ret['seo_h1'] = $value->name;
                                } else
                                { $ret['seo_h1'] = $value->seo_h1;}


            }
                $this->log->write(print_r($ret , true).'-value');*/

            return $row;
        } else {
            return null;
        }
    }

    public function updateProductSeo($product_id, $data)
    {
        if (!(int) $product_id || !$data) {
            return false;
        }
        $language_id = $this->language->getContentLanguageID();

        //////////UPDATE EXTRA SEO TABLES
        if (isset($data['product_seo']) || isset($data['product_seo_h1']) || isset($data['short_description'])) {
            $seo_title = $data['product_seo'][0];
            $seo_h1 = $data['product_seo_h1'][0];
            $short_description = $data['short_description'][0];
            if ($this->getProductSeo($product_id) > 0) { //if already exist
                $queryt = 'UPDATE '.$this->db->table('product_extra_seo').' SET ';
                if (isset($data['product_seo'])) {
                    $queryt .= " seo_title = '".$this->db->escape($seo_title)."'";
                }
                if (isset($data['product_seo_h1'][0]) and isset($data['product_seo'])) {
                    $queryt .= ' , ';
                }
                if (isset($data['product_seo_h1'][0])) {
                    $queryt .= " seo_h1 = '".$this->db->escape($seo_h1)."'";
                }

                if ((isset($data['product_seo_h1'][0]) or isset($data['product_seo'])) and isset($data['short_description'][0])) {
                    $queryt .= ' , ';
                }
                if (isset($data['short_description'][0])) {
                    $queryt .= " short_description = '".$this->db->escape($short_description)."'";
                }

                $queryt .= " WHERE product_id = '".$product_id."' AND language_id = '".$language_id."' ";

                $this->db->query($queryt);
            //$this->log->write('exist');
            } else {
                $this->db->query('INSERT INTO '.$this->db->table('product_extra_seo')." SET product_id = '".(int) $product_id."', seo_title = '".$this->db->escape($seo_title)."', seo_h1 = '".$this->db->escape($seo_h1)."', short_description = '".$this->db->escape($short_description)."', language_id = '".$language_id."'");
                //$this->log->write('notexist');
            }
        }

        ////////UPDATE PRODUCTS DESCRIPTION
        if (isset($data['product_seo_meta_keywords']) || isset($data['product_seo_meta_description'])) {
            $seo_meta_keywords = $data['product_seo_meta_keywords'][0];
            $seo_meta_description = $data['product_seo_meta_description'][0];

            $queryupdate = 'UPDATE '.$this->db->table('product_descriptions').' SET ';
            if (isset($data['product_seo_meta_keywords'])) {
                $queryupdate .= " meta_keywords = '".$this->db->escape($seo_meta_keywords)."'";
            }
            if (isset($data['product_seo_meta_description'][0]) and isset($data['product_seo_meta_keywords'])) {
                $queryupdate .= ' , ';
            }
            if (isset($data['product_seo_meta_description'][0])) {
                $queryupdate .= " meta_description = '".$this->db->escape($seo_meta_description)."'";
            }
            $queryupdate .= " WHERE product_id = '".$product_id."' AND language_id = '".$language_id."' ";

            $this->db->query($queryupdate);
            //$this->log->write('exist');

            //$this->db->query("DELETE FROM " . $this->db->table("product_extra_seo") . " WHERE product_id = '" . (int)$product_id . "' AND `language_id` = '" . (int)$language_id . "'");
            //$vart = $data;
            //$this->log->write(serialize($vart) );

            /*foreach($data['product_seo'] as $seo_title){
                //$seo_title = $data['product_seo'][0];
                $seo_h1 = $data['product_seo_h1'][0];
            $this->db->query("INSERT INTO " . $this->db->table("product_extra_seo") . " SET product_id = '" . (int)$product_id . "', seo_title = '" . $this->db->escape($seo_title) . "', seo_h1 = '" . $this->db->escape($seo_h1) . "', language_id = '" . $language_id . "'");
            //$this->db->query("UPDATE " . $this->db->table("product_extra_seo") . " SET product_id = '" . (int)$product_id . "', seo_title = '" . $this->db->escape($seo_title) . "', seo_h1 = '" . $this->db->escape($seo_h1) . "', language_id = '" . $language_id . "'");
            }*/
        }

        if (isset($data['keyword'])) {
            $this->loadModel('extension/seo_generator');
            $seo = SEOEncode($data['keyword']); //getUniqueSeoKeyword( $data['keyword'], 'category_id', $category_id);
            $seo = $this->getUniKeywordDu($seo, 'product_id', $product_id);
            $this->language->replaceDescriptions('url_aliases',
        array('query' => 'product_id='.(int) $product_id),
        array((int) $this->language->getContentLanguageID() => array('keyword' => $seo)));
            /*$data['keyword'] =  SEOEncode($data['keyword']);
            if($data['keyword']){
            $this->language->replaceDescriptions('url_aliases',
                                                array('query' => "category_id=" . (int)$category_id),
                                                array((int)$this->language->getContentLanguageID() => array('keyword' => $data['keyword'])));
            }else{
                $this->db->query("DELETE
                                FROM " . $this->db->table("url_aliases") . "
                                WHERE query = 'category_id=" . (int)$category_id . "'
                                    AND language_id = '".(int)$this->language->getContentLanguageID()."'");
            }*/
        }

        $this->cache->delete('product');

        return true;
    }
}
