<?php
if (!defined('DIR_CORE') || !IS_ADMIN) {
    header('Location: static_pages/');
}

class ModelSeoPackCollection extends Model
{
    public function getCollection($collection_id)
    {
        $query = $this->db->query("SELECT DISTINCT *,
			(SELECT keyword
			FROM " . $this->db->table("url_aliases") . "
			WHERE query = 'collection_id=" . (int)$collection_id . "'
				AND language_id='".(int)$this->language->getContentLanguageID()."' ) AS keyword
		FROM " . $this->db->table("collections") . "
		WHERE collection_id = '" . (int)$collection_id . "'");
        return $query->row;
    }


    public function getUniKeywordDu($seo_key, $object_key_name='', $object_id=0)
    {
        // SELECT `keyword` FROM ac_url_aliases WHERE query like '%' AND `keyword` like 'face%'
        // SELECT * FROM ac_url_aliases WHERE query like '%' AND `keyword` like 'face%' AND query<>'product_id=71'
        $object_id=(int)$object_id;

        $registry = Registry::getInstance();
        $db = $registry->get('db');
        $sql = "SELECT `keyword`
				FROM ".$db->table('url_aliases')."
				WHERE query like '%'
						AND `keyword` like '".$db->escape($seo_key)."%'";
        if ($object_id) {
            // exclude keyword of given object (product, collection, content etc)
            $sql .= " AND query<>'".$db->escape($object_key_name)."=".$object_id."'";
        }

        $result = $db->query($sql);
        if ($result->num_rows) {
            foreach ($result->rows as $row) {
                $keywords[] = $row['keyword'];
            }

            $i=0;
            while (in_array($seo_key, $keywords) && $i<20) {
                $seo_key = $seo_key.'_'.($object_id?$object_id:$i);
                $i++;
            }
        }
        return $seo_key;
    }


    /////////////////////////////////////////////////////////////////////////
    public function getCollectionSeo($collection_id, $option_id = 0)
    {
        $language_id = $this->language->getContentLanguageID();
        $collection_seo = $this->db->query(
            "SELECT *
			FROM `" . DB_PREFIX . "product_extra_seo_collection`
			WHERE `collection_id` = '" . (int)$collection_id . "'
				 AND `language_id` = '" . (int)$language_id . "'
											 ");

        if ($collection_seo->num_rows) {
            $row = $collection_seo->row;
            $row['language'] = $collection_seo;
            return $row;
        } else {
            return null;
        }
    }


    public function updateCollectionSeo($collection_id, $data)
    {
        if (!(int)$collection_id || !$data) {
            return false;
        }
        $language_id = $this->language->getContentLanguageID();

        if (isset($data['collection_seo']) ||  isset($data['collection_seo_h1'])) {
            $seo_title = $data['collection_seo'][0];
            $seo_h1 = $data['collection_seo_h1'][0];
            if ($this->getCollectionSeo($collection_id) > 0) {
                $queryt = "UPDATE " . $this->db->table("product_extra_seo_collection") . " SET ";
                if (isset($data['collection_seo'])) {
                    $queryt .= " seo_title = '" . $this->db->escape($seo_title) . "'";
                }
                if (isset($data['collection_seo_h1'][0]) and isset($data['collection_seo'])) {
                    $queryt .=    " , ";
                }
                if (isset($data['collection_seo_h1'][0])) {
                    $queryt .=    " seo_h1 = '" . $this->db->escape($seo_h1) . "'";
                }
                $queryt .=  " WHERE collection_id = '" . $collection_id . "' AND language_id = '" . $language_id . "' ";

                $this->db->query($queryt);
                //$this->log->write('exist');
            } else {
                $this->db->query("INSERT INTO " . $this->db->table("product_extra_seo_collection") . " SET collection_id = '" . (int)$collection_id . "', seo_title = '" . $this->db->escape($seo_title) . "', seo_h1 = '" . $this->db->escape($seo_h1) . "', language_id = '" . $language_id . "'");
                //$this->log->write('notexist');
            }
        }




        if (isset($data['collection_seo_meta_keywords']) ||  isset($data['collection_seo_meta_description'])) {
            $seo_meta_keywords = $data['collection_seo_meta_keywords'][0];
            $seo_meta_description = $data['collection_seo_meta_description'][0];

            $queryupdate = "UPDATE " . $this->db->table("collection_descriptions") . " SET ";
            if (isset($data['collection_seo_meta_keywords'])) {
                $queryupdate .= " meta_keywords = '" . $this->db->escape($seo_meta_keywords) . "'";
            }
            if (isset($data['collection_seo_meta_description'][0]) and isset($data['collection_seo_meta_keywords'])) {
                $queryupdate .=    " , ";
            }
            if (isset($data['collection_seo_meta_description'][0])) {
                $queryupdate .=    " meta_description = '" . $this->db->escape($seo_meta_description) . "'";
            }
            $queryupdate .=  " WHERE collection_id = '" . $collection_id . "' AND language_id = '" . $language_id . "' ";

            $this->db->query($queryupdate);
                //$this->log->write('exist');
        }

        if (isset($data['keyword'])) {
            $this->loadModel('extension/seo_generator');
            $seo = SEOEncode($data['keyword']); //getUniqueSeoKeyword( $data['keyword'], 'collection_id', $collection_id);
                    $seo = $this->getUniKeywordDu($seo, 'collection_id', $collection_id);
            $this->language->replaceDescriptions('url_aliases',
                array('query' => "collection_id=" . (int)$collection_id),
                array((int)$this->language->getContentLanguageID() => array('keyword' => $seo )));
                /*$data['keyword'] =  SEOEncode($data['keyword']);
                if($data['keyword']){
                $this->language->replaceDescriptions('url_aliases',
                                                    array('query' => "collection_id=" . (int)$collection_id),
                                                    array((int)$this->language->getContentLanguageID() => array('keyword' => $data['keyword'])));
                }else{
                    $this->db->query("DELETE
                                    FROM " . $this->db->table("url_aliases") . "
                                    WHERE query = 'collection_id=" . (int)$collection_id . "'
                                        AND language_id = '".(int)$this->language->getContentLanguageID()."'");
                }*/
        }



        $this->cache->delete('collection');
        //127 $this->cache->remove('collection');
        return true;
    }







    public function getCollectionDescriptions($collection_id)
    {
        $collection_description_data = array();

        $query = $this->db->query("SELECT * FROM ".$this->db->table("collection_descriptions")." WHERE collection_id = '".(int)$collection_id."'");

        foreach ($query->rows as $result) {
            $collection_description_data[$result['language_id']] = array(
                'name'             => $result['title'],
                'meta_keywords'    => $result['meta_keywords'],
                'meta_description' => $result['meta_description'],
                'description'      => $result['description'],
            );
        }

        return $collection_description_data;
    }
}
