<h1 class="heading1">
  <span class="maintext"><i class="fa fa-group"></i> <?php echo $heading_title; ?></span>
  <span class="subtext"></span>
</h1>

<?php if ($success) { ?>
<div class="alert alert-success">
<button type="button" class="close" data-dismiss="alert">&times;</button>
<?php echo $success; ?>
</div>
<?php } ?>

<?php if ($error_warning) { ?>
<div class="alert alert-error alert-danger">
<button type="button" class="close" data-dismiss="alert">&times;</button>
<?php echo $error_warning; ?>
</div>
<?php } ?>

<div class="contentpanel">

	<?php echo $form['form_open']; ?>

		<h4 class="heading4"><?php echo $heading_title; ?></h4>
		<div class="registerbox form-horizontal">
			<fieldset>
			<?php
				$field_list = array('rma_request_status', 'rma_action','reason','email');

				foreach ($field_list as $field_name) {
					if(!$form[$field_name]){ continue;}
			?>
				<div class="form-group <?php echo ${'error_'.$field_name} ? 'has-error' : ''; ?>">
					<label class="control-label col-sm-4"><?php echo ${'text_'.$field_name}; ?></label>
					<div class="input-group col-sm-4" <?php echo is_string($form[$field_name]) ? 'style="padding-top: 7px;"':'' ?>>
					    <?php echo $form[$field_name]; ?>
					</div>
					<span class="help-block"><?php echo ${'error_'.$field_name}; ?></span>
				</div>
			<?php
				}
			?>
			<div id="rma_products" style="display:none;">
				<h4><?php echo $text_rma_products; ?></h4>
				<?php
					foreach ($form['rma_products'] as $product) {?>
						<div class="form-group">
							<label class="control-label col-sm-4">
								<a href="<?php echo $product['href']?>" target="_blank"><?php echo $product['name']; ?></a>
								<?php
								if ($product['option']) {
									echo "<br>";
									foreach ($product['option'] as $option) {
										?><small> - <?php echo $option['name']; ?> <?php echo $option['value']; ?></small><br>
									<?php
									}
								}?>
							</label>
							<div class="input-group col-sm-4">
								<?php echo $text_quantity.': '.$product['quantity'];?>
							</div>
						</div>

					<?php } ?>
					</table>
				</td>
			</div>
			<div class="form-group <?php echo $error_comment ? 'has-error' : ''; ?>">
				<label class="control-label col-sm-4"><?php echo $text_comment; ?></label>
				<div class="input-group col-sm-8">
					<?php if (is_array($form['conversation'])) { ?>
						<div id="rma_message_history"
							 style="text-align: left; overflow: auto; max-height: 600px; width: 100%; margin: 0 10px 10px 0;"
							 class="rma_history">
							<table style=" background-color: #f4f4f4; font-weight: bold; width: 100%; ">
								<?php
								foreach ($form['conversation'] as $mess) {
									echo '<tr ><td>' . $mess . '</td></tr>';
								} ?>
							</table>

						</div>
					<?php }
					echo $form['comment']; ?>
				</div>
				<span class="help-block"><?php echo $error_comment; ?></span>
			</div>
			<?php if ($form['return_code']) { ?>
			<div class="form-group <?php echo $error_return_code ? 'has-error' : ''; ?>">
				<label class="control-label col-sm-4"><?php echo $text_return_code; ?></label>
				<div class="input-group col-sm-4" <?php echo is_string($form['return_code']) ? 'style="padding-top: 7px;"':'' ?>>
					<?php echo $form['return_code'] . $form['request_id']; ?>
				</div>
				<span class="help-block"><?php echo $error_return_code; ?></span>
			</div>
			<?php } ?>

			</fieldset>
		</div>
		<div class="form-group">
			<div class="col-md-12">
				<a href="<?php echo $form['back']->href; ?>" class="btn btn-default mr10 pull-left" title="<?php echo $form['back']->text ?>">
					<i class="fa fa-arrow-left"></i>
					<?php echo $form['back']->text ?>
				</a>

	            <button class="btn btn-orange pull-right lock-on-click" title="<?php echo $form['submit']->name ?>" type="submit">
	                <i class="fa fa-check"></i>
	                <?php echo $form['submit']->text ?>
	            </button>

		    </div>
		</div>
</form>

</div>



<script type="text/javascript">

	$('#continue_button').click(function () {
		location = '<?php echo $continue; ?>';
	})

	$('#addRequestFrm_submit').click(function () {
		$('#addRequestFrm').submit();
	});

	function viewOrder(order_id) {
		location = '<?php echo $order_url; ?>&order_id=' + order_id;
	}
	$(document).ready(function () {
		$("#rma_message_history").animate({"scrollTop": $("#rma_message_history").scrollTop() + 1000});
		$("#addRequestFrm_rma_action").on('change', function () {
			if ($(this).val() == 1) {
				$("#rma_products").show();
			} else {
				$("#rma_products").hide();
			}
		});
		if($("#addRequestFrm_rma_action").val()!=undefined){
			$("#addRequestFrm_rma_action").change();
		}
		<?php if($rma_action==1){?>
		else{
			$("#rma_products").show();
		}
		<?php }?>
	});

</script>