<?php


if (!defined('DIR_CORE')){
	header('Location: static_pages/');
}

/**
 * @property ModelReturnsManagementReturnsManagement $model_returns_management_returns_management
 */
class ControllerPagesReturnsManagementReturnsManagement extends AController{
	public $data = array ();
	private $error = array ();

	public function main(){
		if (!$this->customer->isLogged()){
			$this->redirect($this->html->getSecureURL('account/login'));
		}

		$order_id = (int)$this->request->get['order_id'];
		if ($order_id){
			$allowed_order_statuses = unserialize($this->config->get('returns_management_order_status'));
			$this->loadModel('account/order');
			$order_info = $this->model_account_order->getOrder($order_id);
			$days = (int)abs($this->config->get('returns_management_period'));
			$range = $days * 86400;

			if (!in_array($order_info['order_status_id'], $allowed_order_statuses) || ($range != 0 && time() - dateISO2Int($order_info['date_added']) > $range)){
				$this->redirect($this->html->getSecureURL('account/invoice', '&order_id=' . $order_id));
			}
		}

		$this->loadLanguage('returns_management/returns_management');
		$this->loadModel('returns_management/returns_management');
		$this->document->setTitle($this->language->get('rma_heading_title'));
		$this->data = $this->model_returns_management_returns_management->getRequest($this->request->get['order_id']);
		$this->data['details'] = unserialize($this->data['details']);

		if ($this->request->is_POST() && $this->_validatePost()){
			$data = $this->request->post;
			$data['order_id'] = $this->request->get['order_id'];
			$data['customer_id'] = $this->customer->getId();
			$data['details'] = (array)$this->data['details'];
			$data['details']['quantity'] = $this->request->post['quantity'];

			$this->model_returns_management_returns_management->editRequest($data);
			$this->session->data['success'] = $this->language->get('text_rma_success_submited');

			$this->html->redirect($this->html->getSecureURL('returns_management/returns_management', '&order_id=' . $data['order_id']));
		} else{
			$this->data['customer_email'] = !$this->data['customer_email'] ? $this->customer->getEmail() : $this->data['customer_email'];
		}

		if (isset($this->session->data['warning'])){
			$this->data['error_warning'] = $this->session->data['warning'];
			$this->session->data['warning'] = '';
		}
		if (isset($this->session->data['success'])){
			$this->data['success'] = $this->session->data['success'];
			$this->session->data['success'] = '';
		}
		$this->data['heading_title'] = $this->language->get('rma_heading_title');


		$form = new AForm();
		$form->setForm(
				array ('form_name' => 'addRequestFrm')
		);

		$this->data['form']['id'] = 'addRequestFrm';
		$this->data['form']['form_open'] = $form->getFieldHtml(
				array ('type'   => 'form',
				       'name'   => 'addRequestFrm',
				       'action' => $this->html->getSecureURL('returns_management/returns_management', '&order_id=' . $this->request->get['order_id'])
				));
		$this->data['form']['back'] = $form->getFieldHtml(
				array ('type' => 'button',
				       'name' => 'back',
				       'text' => $this->language->get('button_back'),
				       'href' => $this->html->getSecureURL('account/invoice', '&order_id=' . $order_id),
				       'icon' => 'icon-arrow-right'
				));
		$this->data['form']['submit'] = $form->getFieldHtml(
				array ('type'  => 'button',
				       'name'  => 'submit',
				       'text'  => $this->language->get('button_continue'),
				       'style' => 'button1',
				       'icon'  => 'icon-arrow-right'
				));

		$this->data['text_rma_action'] = $this->language->get('text_rma_action');
		if ($this->data['request_status_id'] > 1){
			$this->data['form']['rma_action'] = $this->data['rma_action'] == 1 ? $this->language->get('text_rma_action_replace') : $this->language->get('text_rma_action_refund');
			$this->data['form']['rma_request_status'] = $this->model_returns_management_returns_management->getRequestStatusName($this->data['request_status_id']);
		} else{
			$this->data['form']['rma_action'] = $form->getFieldHtml(
					array ('type'     => 'selectbox',
					       'name'     => 'rma_action',
					       'options'  => array (1 => $this->language->get('text_rma_action_replace'),
					                            2 => $this->language->get('text_rma_action_refund')),
					       'value'    => $this->data['rma_action'],
					       'required' => true
					));
		}

		$this->data['text_reason'] = $this->language->get('text_reason');
		if ($this->data['request_status_id'] > 1){
			$this->data['form']['reason'] = $this->data['reason'];
		} else{
			$this->data['form']['reason'] = $form->getFieldHtml(
					array ('type'     => 'input',
					       'name'     => 'reason',
					       'value'    => $this->data['reason'],
					       'required' => true
					));
		}
		$this->data['text_comment'] = $this->language->get('text_conversation');
		$this->data['form']['conversation'] = unserialize($this->data['conversation']);

		$this->data['form']['comment'] = $form->getFieldHtml(
				array ('type'     => 'textarea',
				       'name'     => 'conversation',
				       'value'    => '',
				       'required' => true,
				       'style'    => 'input-large'
				));

		$this->data['rma_text_email'] = $this->language->get('rma_text_email');
		$this->data['form']['email'] = $form->getFieldHtml(
				array ('type'     => 'input',
				       'name'     => 'customer_email',
				       'value'    => $this->data['customer_email'],
				       'required' => true
				));

		$this->data['text_rma_products'] = $this->language->get('text_rma_products');
		$this->loadModel('account/order');
		$order_products = $this->model_account_order->getOrderProducts($this->request->get['order_id']);
		foreach ($order_products as $k => $product){
			$options = $this->model_account_order->getOrderOptions($this->request->get['order_id'], $product['order_product_id']);
			$option_data = array ();
			foreach ($options as $option){
				$option_data[] = array (
						'name'  => $option['name'],
						'value' => $option['value'],
				);
			}

			$options = array ();
			for ($i = 0; $i <= $product['quantity']; $i++){
				$options[$i] = $i;
			}

			$this->data['form']['rma_products'][$k] = array (
					'order_product_id' => $product['order_product_id'],
					'product_id'       => $product['product_id'],
					'name'             => $product['name'],
					'model'            => $product['model'],
					'option'           => $option_data,
					'price'            => $this->currency->format($product['price'], $order_info['currency'], $order_info['value']),
					'total'            => $this->currency->format($product['total'], $order_info['currency'], $order_info['value']),
					'href'             => $this->html->getSecureURL('product/product', '&product_id=' . $product['product_id'])
			);

			if ($this->data['request_status_id'] > 1){
				$this->data['form']['rma_products'][$k]['quantity'] = $this->data['details']['returns'][$product['order_product_id']]['return_quantity'];
			} else{
				$this->data['form']['rma_products'][$k]['quantity'] = $form->getFieldHtml(
						array ('type'    => 'selectbox',
						       'name'    => 'quantity[' . $product['order_product_id'] . ']',
						       'value'   => (int)$this->data['details']['quantity'][$product['order_product_id']],
						       'options' => $options,
						       'style'   => 'short input-short'
						));
			}

		}

		if ($this->data['return_code']){
			$this->data['text_return_code'] = $this->language->get('text_return_code');
			$this->data['form']['return_code'] = htmlentities($this->data['return_code'], ENT_QUOTES, 'UTF-8');
		}

		if ($this->data['request_id']){
			$this->data['form']['request_id'] = $form->getFieldHtml(
					array ('type'  => 'hidden',
					       'name'  => 'request_id',
					       'value' => $this->data['request_id']
					));
		}

		$this->view->batchAssign($this->data);
		$this->processTemplate('pages/returns_management/returns_management.tpl');

	}

	private function _validatePost(){
		$this->error = '';
		if (!isset($this->request->post['request_id'])){
			if (!trim($this->request->post['reason']) || !trim($this->request->post['conversation'])){
				$this->error = $this->language->get('error_rma_required');
			}

			$pattern = '/^[A-Z0-9._%-]+@[A-Z0-9][A-Z0-9.-]{0,61}[A-Z0-9]\.[A-Z]{2,6}$/i';
			if (!preg_match($pattern, $this->request->post['customer_email'])){
				$this->error = $this->language->get('error_rma_email');
			}

		}

		if ($this->error){
			$this->session->data['warning'] = $this->error;
			return false;
		} else{
			return true;
		}
	}
}
