<?php
if (! defined ( 'DIR_CORE' )) {
header ( 'Location: static_pages/' );
}

class ExtensionReturnsManagement extends Extension {

	public function onControllerCommonListingGrid_InitData() {

		$that =& $this->baseObject;
		if($that->data['table_id']=='order_grid'){
			$that->loadLanguage('returns_management/returns_management');
			$that->data['actions']['edit']['children']['rma'] = array(
					'text' => $that->language->get('returns_management_rma'),
					'href' => $that->html->getSecureURL('returns_management/returns_management', '&order_id=%ID%'),
			);
		}
	}

	public function onControllerPagesSaleOrderTabs_InitData() {
		$that =& $this->baseObject;
		$that->loadLanguage('returns_management/returns_management');

		$this->data = array();
		$this->data['tabs'][] = array(
			'href' => $that->html->getSecureURL('returns_management/returns_management', '&order_id=' . $that->request->get['order_id']),
			'text' => $that->language->get('returns_management_rma'),
			'active' => $that->data['active']=='rma' ? true : false
		);

		$view = new AView(Registry::getInstance(), 0);
		$view->batchAssign($this->data);
		$that->view->addHookVar('extension_tabs', $view->fetch('pages/returns_management/tabs.tpl'));
	}

	public function onControllerPagesAccountInvoice_InitData(){
		$this->baseObject->loadLanguage('returns_management/returns_management');
	}

	public function onControllerPagesAccountInvoice_UpdateData(){
		$that =& $this->baseObject;
		$order_id = $that->request->get['order_id'];
		$allowed_order_statuses = unserialize($that->config->get('returns_management_order_status'));
		$that->loadModel('account/order');
		$order_info = $that->model_account_order->getOrder($order_id);
		$days = (int)abs($that->config->get('returns_management_period'));
		$range = $days*86400;

		if(in_array($order_info['order_status_id'],$allowed_order_statuses)
				&& ($range==0 || time()-dateISO2Int($order_info['date_added'])<$range)
		){
			$request_button = $that->html->buildElement(
					array ( 'type'  => 'button',
						  'name' => 'return_request_button',
						  'text' => $that->language->get('rma_return_request'),
						  'href' => $that->html->getSecureURL( 'returns_management/returns_management',
						                                       '&order_id=' . $order_id),
						  'icon' => 'fa fa-thumbs-down'
						  ));

			$that->view->addHookVar('hk_additional_buttons', $request_button);
		}
	}
 }