<?php


if (!defined('DIR_CORE')) {
	header('Location: static_pages/');
}
/**
 * Class ModelReturnsManagementReturnsManagement
 * @property ModelSaleCustomerTransaction $model_sale_customer_transaction
 */
class ModelReturnsManagementReturnsManagement extends Model {
	public $data = array();
	private $error = array();

	/**
	 * @param array $data
	 * @param string $mode
	 * @return array | int
	 */
	public function getRequests($data, $mode = '') {

		$sql = "SELECT *, CONCAT(COALESCE(o.firstname,c.firstname), ' ', COALESCE(o.lastname,c.lastname)) AS `name`
				FROM " . $this->db->table('rma_requests') . " rma
				LEFT JOIN " . $this->db->table('orders') . " o ON o.order_id = rma.order_id
				LEFT JOIN " . $this->db->table('customers') . " c ON c.customer_id = rma.customer_id ";


		if (has_value($data['filter_request_status_id'])) {
			$sql .= " WHERE COALESCE(rma.request_status_id,1) = '" . (int)$data['filter_request_status_id'] . "'";
		} else {
			$sql .= " WHERE COALESCE(rma.request_status_id,-1) >= '0'";
		}

		if (has_value($data['filter_return_code'])) {
			$sql .= " AND return_code LIKE  '%" . $this->db->escape($data['filter_return_code']) . "%'";
		}


		if (has_value($data['subsql_filter'])) {
			$sql .= " AND ".str_replace('LOWER(`name`)','LOWER(CONCAT(COALESCE(o.firstname,c.firstname), \' \', COALESCE(o.lastname,c.lastname)))',$data['subsql_filter']);
		}


		$sort_data = array(
			'request_id',
			'rma.order_id',
			'name',
			'request_status_id',
			'rma.date_modified');

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY request_id";
		}

		if (isset($data['order']) && (strtoupper($data['order']) == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$result = $this->db->query($sql);

		if ($mode == 'total') {
			return (int)$result->num_rows;
		}
		if ($result->num_rows) {
			return $result->rows;
		}
		return array();
	}

	/**
	 * @param array $data
	 * @return int
	 */
	public function getTotalRequests($data) {
		return $this->getRequests($data, 'total');
	}

	public function editRequest($data) {

		if ($result = $this->getRequest((int)$data['order_id'])) {
			$data['request_id'] = (int)$result['request_id'];
			$conversation = unserialize($result['conversation']);
			if($result['request_status_id']!=$data['request_status_id']){
				$conversation[] = '(' . date($this->language->get('date_format_short') . ' ' . $this->language->get('time_format')) . ') ' . $this->language->get('text_request_status_changed') . " " . $this->getRequestStatusName($data['request_status_id']);
			}
		}


		$allowed_fields = array('request_status_id', 'rma_action', 'reason', 'details', 'conversation', 'customer_email', 'return_code');
		$update = array();

		if ($data['request_id']) {
			$customer_id = (int)$data['customer_id'];
			foreach ($allowed_fields as $field_name) {
				if (isset($data[$field_name])) {
					if ($field_name == 'conversation') {
						if($data[$field_name]){
							$data[$field_name] = htmlentities($data[$field_name], ENT_QUOTES, 'UTF-8');
							$conversation[] = '(' . date($this->language->get('date_format_short') . ' ' . $this->language->get('time_format')) . ') ' . $this->language->get('rma_text_merchant') . ":\n" . $data[$field_name];
						}
						$data[$field_name] = serialize($conversation);
					}elseif($field_name == 'details'){
						$data[$field_name] = serialize($data[$field_name]);
					}
					$update[] = "`" . $field_name . "`='" . $this->db->escape($data[$field_name]) . "'";
				}
			}

			$sql = "UPDATE " . $this->db->table('rma_requests') . "
					SET " . implode(", ", $update) . "
					WHERE customer_id=" . $customer_id . "
						AND request_id = " . $data['request_id'] . ";";
			$this->db->query($sql);
		} else {
			$allowed_fields[] = 'order_id';
			$allowed_fields[] = 'customer_id';

			foreach ($allowed_fields as $field_name) {
				if (isset($data[$field_name])) {
					$update[$field_name] = $this->db->escape($data[$field_name]);
				}
			}

			$sql = "INSERT INTO " . $this->db->table('rma_requests') . " (`" . implode("`, `", array_keys($update)) . "`)
					VALUES ('" . implode("', '", $update) . "');";
			$this->db->query($sql);
			$data['request_id'] = $this->db->getLastId();
		}

		$this->_processRequest($data['request_id'], $data['request_status_id'], $data['return_stock']);


		if ($result->num_rows) {
			return $result->rows;
		}
		return array();
	}

	public function getRequest($order_id = 0, $request_id = 0) {
		$order_id = (int)$order_id;
		$request_id = (int)$request_id;

		if (!$order_id && !$request_id) {
			return array();
		}

		$sql = "SELECT *,
						COALESCE(o.firstname,c.firstname) as first_name,
						COALESCE(o.lastname,c.lastname) AS last_name,
						COALESCE(rma.customer_email, o.email, c.email) as customer_email
				FROM " . $this->db->table('rma_requests') . " rma
				LEFT JOIN " . $this->db->table('orders') . " o ON o.order_id = rma.order_id
				LEFT JOIN " . $this->db->table('customers') . " c ON c.customer_id = rma.customer_id ";
		if ($order_id) {
			$sql .= "WHERE  rma.order_id=" . $order_id;
		} else {
			$sql .= "WHERE rma.request_id=" . $request_id;
		}

		$result = $this->db->query($sql);
		if ($result->num_rows) {

			return $result->row;
		}
		return array();
	}


	public function getRequestStatusName($status_id) {
		switch ($status_id) {
			case 1:
				$text = $this->language->get('text_rma_request_status_requested');
				break;
			case 2:
				$text = $this->language->get('text_rma_request_status_approved');
				break;
			case 3:
				$text = $this->language->get('text_rma_request_status_declined');
				break;
			case 4:
				$text = $this->language->get('text_rma_request_status_completed');
				break;
			default:
				$text = $this->language->get('text_rma_request_status_requested');
		}
		return $text;
	}


	public function getRequestStatusNames() {
		$output = array();
		$ids = array(1, 2, 3, 4);
		foreach ($ids as $id) {
			$output[$id] = $this->getRequestStatusName($id);
		}
		return $output;
	}

	/**
	 * Do process order when request status changing
	 * @param $request_id
	 * @param $request_status_id
	 * @param bool $recalculate_stock
	 * @return bool
	 * @internal param $order_id
	 * @internal param array $data
	 */
	private function _processRequest($request_id, $request_status_id, $recalculate_stock=false) {
		//check is request exists
		$request_info = $this->getRequest(0, $request_id);

		if (!$request_info) {
			$this->error = $this->language->get('error_request_not_exists');
			return false;
		}

		$request_details = unserialize($request_info['details']);
		if (!$request_details) {
			$request_details['refund'] = 0;
			$request_details['returns'] = array();
		}


		//for requested
		if ($request_status_id == 1) {
			$message_text = sprintf($this->language->get('rma_request_sent_message'),'#storefront#rt=returns_management/returns_management&order_id='.(int)$request_info['order_id']);
			$message_subj = html_entity_decode($this->language->get('rma_request_sent_message_subject'), ENT_QUOTES, 'UTF-8');
		//for approved
		}else if ($request_status_id == 2) {
			$message_text = sprintf($this->language->get('rma_request_approved_message'),'#storefront#rt=returns_management/returns_management&order_id='.(int)$request_info['order_id']);
			$message_subj = html_entity_decode($this->language->get('rma_request_approved_subject'), ENT_QUOTES, 'UTF-8');
			// for declined requests
		} else if ($request_status_id == 3) {
			$sql = "DELETE FROM " . $this->db->table('order_totals')."
					WHERE order_id = '" . (int)$request_info['order_id'] . "'
						AND `type`='rma'";
			$this->db->query($sql);
			$message_text = sprintf($this->language->get('rma_request_declined_message'),'#storefront#rt=returns_management/returns_management&order_id='.(int)$request_info['order_id']);
			$message_subj = html_entity_decode($this->language->get('rma_request_declined_subject'), ENT_QUOTES, 'UTF-8');
		} else if ($request_status_id == 4) {
			if (has_value($request_details['refund'])) {
				$refund_value = round((float)$this->currency->convert((float)$request_details['refund'], $request_info['currency'], $this->config->get('config_currency')),2);

				$sql = "INSERT INTO " . $this->db->table('order_totals')." (`order_id`,`title`,`text`,`value`,`sort_order`,`type`)
							VALUES ('" . (int)$request_info['order_id'] . "',
									'" . $this->db->escape($this->language->get('rma_total_title')) . "',
									'-" . $this->currency->format((float)$request_details['refund'], $request_info['currency'],1) . "',
									'-" . $refund_value . "',
									'400',
									'rma_refund')";
				$this->db->query($sql);

				$sql = "SELECT *
						FROM " . $this->db->table('order_totals')."
						WHERE type='total' AND order_id = '".(int)$request_info['order_id']."'";
				$res = $this->db->query($sql);
				$total = $res->row;

				$value = round($total['value'],2) - $refund_value;

				$text = $this->currency->format($value,$request_info['currency'],1);

				$sql = "UPDATE " . $this->db->table('order_totals')."
						SET `text` = '". $text. "',
						`value` = '".$value."'
						WHERE order_id = '".(int)$request_info['order_id']."'
							AND type='total'";
				$this->db->query($sql);

				if($request_details['enroll_in_balance']){
					$this->load->model('sale/customer_transaction');
					$transaction_data = array(
											'order_id' => (int)$request_info['order_id'],
											'customer_id' => (int)$request_info['customer_id'],
											'credit' => $refund_value,
											'transaction_type' => 'rma_refund',
											'description' => sprintf($this->language->get('text_rma_transaction_comment'),
																	$this->currency->format((float)$request_details['refund'],$request_info['currency'],1),
																	$request_id));

					$this->model_sale_customer_transaction->addCustomerTransaction($transaction_data);


				}


				// IF NEEDs TO RECALCULATE STOCK BALANCE
				if ($recalculate_stock && has_value($request_details['returns'])) {
					$this->load->model('sale/order');
					$order_products = $this->model_sale_order->getOrderProducts((int)$request_info['order_id']);
					$request_order_product_ids = array_keys($request_details['returns']);

					foreach ($order_products as $order_product) {
						$order_product_id = $order_product['order_product_id'];
						if (in_array($order_product_id, $request_order_product_ids)) {
							$to_return = (int)$request_details['returns'][$order_product_id]['return_quantity'];
							if ($order_product['quantity'] >= $to_return && $to_return>0) {
								// if needs to recalculate stock
								$sql = "UPDATE `" . $this->db->table("products") . "`
										SET quantity = (quantity + " . $to_return . ")
										WHERE product_id = '" . (int)$order_product['product_id'] . "'";
								$this->db->query($sql);

								$sql = "SELECT *
										FROM " . $this->db->table("order_options") . "
										WHERE order_id = '" . (int)$request_info['order_id'] . "'
											AND order_product_id = '" . (int)$order_product_id . "'";
								$option_query = $this->db->query($sql);

								foreach ($option_query->rows as $option) {
									$sql = "UPDATE " . $this->db->table("product_option_values") . "
											SET quantity = (quantity + " . $to_return . ")
											WHERE product_option_value_id = '" . (int)$option['product_option_value_id'] . "'";
									$this->db->query($sql);
								}
							}
						}
					}

				}
				$message_text = sprintf($this->language->get('rma_request_completed_message'),'#storefront#rt=returns_management/returns_management&order_id='.(int)$request_info['order_id']);
				$message_subj = html_entity_decode($this->language->get('rma_request_completed_subject'), ENT_QUOTES, 'UTF-8');
			}
		}

		if ($request_info['customer_email']) {
			if ($message_text) {
				$text = html_entity_decode($this->html->convertLinks($message_text,'message'), ENT_QUOTES, 'UTF-8');
				$text = str_replace('#link-text#',$this->language->get('text_rma_click_link'), $text);
				$this->_sendEmail($request_info['customer_email'], $message_subj, $text);
			}
		}

		return true;
	}

	private	function _sendEmail($to, $message_subj, $message_text) {

		$view = new AView($this->registry, 0);
		$data = array();

		$data['text_message'] = $message_text;
		if(is_file(DIR_RESOURCE.$this->config->get('config_logo'))){
			$data['logo_url'] = HTTP_DIR_RESOURCE . $this->config->get('config_logo');
		}else{
			$data['logo_url'] = HTTPS_CATALOG.$this->config->get('config_logo');
		}
		$data['store_name'] = $this->config->get('store_name');
		$data['store_url'] = HTTPS_CATALOG;
		$view->batchAssign($data);

		$mail = new AMail( $this->config );
		$mail->setTo($to);
		$mail->setFrom($this->config->get('store_main_email'));
		$mail->setSender($this->config->get('store_name'));
		$mail->setSubject($message_subj);
		$mail->setHtml($view->fetch('pages/returns_management/returns_management_mail.tpl'));
		$mail->send();
		if ($mail->error) {
			$this->error = 'Error: Emails does not sent! Please see error log for details.';
			return false;
		}
		return true;
		}
	}

