<?php


if (!defined('DIR_CORE')) {
	header('Location: static_pages/');
}
/**
 * @property ModelReturnsManagementReturnsManagement $model_returns_management_returns_management
 */

class ControllerResponsesReturnsManagementReturnsManagement extends AController {

	public $data = array();
	private $error = array();

	public function main() {
		$this->loadLanguage('sale/order');
		$this->loadModel('sale/order');

		$page = $this->request->post['page']; // get the requested page
		$limit = $this->request->post['rows']; // get how many rows we want to have into the grid
		$sidx = $this->request->post['sidx']; // get index row - i.e. user click to sort
		$sord = $this->request->post['sord']; // get the direction


		// process jGrid search parameter
		$allowedSortFields = array('request_id', 'order_id', 'name', 'status', 'update_date');

		$allowedDirection = array('asc', 'desc');

		if (!in_array($sidx, $allowedSortFields)) $sidx = $allowedSortFields[0];
		if (!in_array($sord, $allowedDirection)) $sord = $allowedDirection[0];

		if ($sidx == 'request_id' || $sidx == 'order_id' || $sidx == 'update_date' || $sidx == 'total') {
			$sidx = 'o.' . $sidx;
		}

		$data = array(
			'sort' => $sidx,
			'order' => $sord,
			'start' => ($page - 1) * $limit,
			'limit' => $limit,
		);

		if (has_value($this->request->get['status']) && $this->request->get['status']>0){
			$data['filter_request_status_id'] = (int)$this->request->get['status'];
		}


		if (has_value($this->request->get['return_code']) ) {
			$data['filter_return_code'] = trim($this->request->get['return_code']);
			if($this->language->get('text_search_hint')==$data['filter_return_code']){
				unset($data['filter_return_code']);
			}
		}


		$grid_filter_params = array('request_id', 'name', 'order_id');
		$filter_grid = new AFilter(array( 'method' => 'post', 'grid_filter_params' => $grid_filter_params ));
		$data = array_merge($data,$filter_grid->getFilterData());

		$total = $this->model_returns_management_returns_management->getTotalRequests($data);

		if ($total > 0) {
			$total_pages = ceil($total / $limit);
		} else {
			$total_pages = 0;
		}

		$response = new stdClass();
		$response->page = $page;
		$response->total = $total_pages;
		$response->records = $total;

		$results = $this->model_returns_management_returns_management->getRequests($data);

		$i = 0;
		foreach ($results as $result) {

			$response->rows[$i]['id'] = $result['order_id'];
			$response->rows[$i]['cell'] = array(
				$result['request_id'],
				$result['order_id'],
				$result['name'],
				$this->model_returns_management_returns_management->getRequestStatusName($result['request_status_id']),
				dateISO2Display($result['date_modified'])
			);
			$i++;
		}

		//update controller data
		$this->extensions->hk_UpdateData($this, __FUNCTION__);

		$this->load->library('json');
		$this->response->setOutput(AJson::encode($response));
	}


}
