<?php


if (!defined('DIR_CORE')){
	header('Location: static_pages/');
}

/**
 * @property ModelReturnsManagementReturnsManagement $model_returns_management_returns_management
 */
class ControllerPagesReturnsManagementReturnsManagement extends AController{
	public $data = array ();
	private $error = '';

	public function main(){

		if (!(int)$this->request->get['order_id']){
			$this->redirect($this->html->getSecureURL('returns_management/returns_management/listing'));
		}

		$this->loadLanguage('sale/order');
		$this->loadLanguage('returns_management/returns_management');
		$this->loadModel('returns_management/returns_management');
		$this->loadModel('sale/order');
		$order_id = $this->request->get['order_id'];
		$order_info = $this->model_sale_order->getOrder($order_id);

		if ($this->request->is_POST() && $this->_validatePost()){

			$request_info = $this->model_returns_management_returns_management->getRequest($order_id);
			$details = unserialize($request_info['details']);
			$data = $this->request->post;
			$data['order_id'] = $order_id;
			$details['returns'] = $data['returns'];
			$details['refund'] = preg_replace('/[^0-9\.]/', '', $data['refund']);
			$details['enroll_in_balance'] = $data['enroll_in_balance'];

			$data['details'] = $details;
			$data['customer_id'] = $order_info['customer_id'];

			if (!$this->request->post['customer_email']){
				$this->loadModel('sale/customer');
				$customer = $this->model_sale_customer->getCustomer($data['customer_id']);
				$data['customer_email'] = $customer['email'];
			}


			$this->model_returns_management_returns_management->editRequest($data);

			if ($this->model_returns_management_returns_management->error){
				$this->session->data['warning'] = $this->model_returns_management_returns_management->error;
			} else{
				$this->session->data['success'] = $this->language->get('text_success_saved');

			}


			$this->html->redirect($this->html->getSecureURL('returns_management/returns_management', '&order_id=' . $order_id));
		} else{
			$this->data['request_data'] = $this->model_returns_management_returns_management->getRequest($order_id);

			$this->data['request_data']['details'] = unserialize($this->data['request_data']['details']);
		}

		if (isset($this->session->data['warning'])){
			$this->data['error'] = $this->session->data['warning'];
			$this->session->data['warning'] = '';
		}

		if (isset($this->session->data['success'])){
			$this->data['success'] = $this->session->data['success'];
		}
		unset($this->session->data['success']);


		$this->data['heading_title'] = $this->language->get('returns_management_rma');
		$this->data['rma_requests'] = $this->model_returns_management_returns_management->getRequests($customer_id, $limit, $offset);

		$this->document->initBreadcrumb(array (
				'href'      => $this->html->getSecureURL('index/home'),
				'text'      => $this->language->get('text_home'),
				'separator' => false
		));

		$this->document->addBreadcrumb(array (
				'href'      => $this->html->getSecureURL('sale/order'),
				'text'      => $this->language->get('heading_title'),
				'separator' => ' :: '
		));
		$this->document->addBreadcrumb(array (
				'href'      => $this->html->getSecureURL('sale/order/details', '&order_id=' . $order_id),
				'text'      => $this->language->get('edit_title_details'),
				'separator' => ' :: '
		));
		$this->document->addBreadcrumb(array (
				'href'      => $this->html->getSecureURL('returns_management/returns_management', '&order_id=' . $order_id),
				'text'      => $this->language->get('returns_management_rma') . " " . $this->language->get('text_order_id') . '#' . $order_id,
				'separator' => ' :: ',
				'current'   => true
		));

		$this->document->setTitle($this->language->get('returns_management_rma'));

		$this->data['form_title'] = $this->language->get('returns_management_request_id');
		$form = new AForm('HT');
		$form->setForm(
				array ('form_name' => 'addRequestFrm')
		);

		$this->data['form']['id'] = 'addRequestFrm';
		$this->data['form']['form_open'] = $form->getFieldHtml(
				array ('type'   => 'form',
				       'name'   => 'addRequestFrm',
				       'action' => $this->html->getSecureURL('returns_management/returns_management', '&order_id=' . $order_id)
				));
		if ((int)$this->data['request_data']['request_status_id'] != 4){
			$this->data['form']['submit'] = $form->getFieldHtml(
					array ('type'  => 'button',
					       'name'  => 'submit',
					       'text'  => $this->language->get('text_apply'),
					       'style' => 'button1',
					));
			if (isset($this->data['request_data']['request_id'])){
				$this->data['form']['request_id'] = $form->getFieldHtml(
						array ('type'  => 'hidden',
						       'name'  => 'request_id',
						       'value' => (int)$this->data['request_data']['request_id']
						));
			}
		}
		switch((int)$this->data['request_data']['request_status_id']){
			case 1:
				$this->data['text_current_status'] = $this->language->get('text_rma_request_status_requested');
				$options = array (1 => $this->language->get('text_rma_request_status_requested'),
				                  2 => $this->language->get('text_rma_request_status_approved'),
				                  3 => $this->language->get('text_rma_request_status_declined'));
				break;
			case 2:
				$this->data['text_current_status'] = $this->language->get('text_rma_request_status_approved');
				$options = array (2 => $this->language->get('text_rma_request_status_approved'),
				                  4 => $this->language->get('text_rma_request_status_completed'));
				break;
			case 3:
				$this->data['text_current_status'] = $this->language->get('text_rma_request_status_declined');
				$options = array (3 => $this->language->get('text_rma_request_status_declined'));
				break;
			case 4:
				$this->data['text_current_status'] = $this->language->get('text_rma_request_status_completed');
				break;
			default:
				$this->data['text_current_status'] = $this->language->get('text_rma_request_status_requested');
				$options = array (1 => $this->language->get('text_rma_request_status_requested'),
				                  2 => $this->language->get('text_rma_request_status_approved'),
				                  3 => $this->language->get('text_rma_request_status_declined'));
		}

		$this->data['text_request_status'] = $this->language->get('text_rma_request_status');
		if ((int)$this->data['request_data']['request_status_id'] != 4){
			$this->data['form']['request_status'] = $this->language->get('text_rma_change_request_status') . $form->getFieldHtml(
							array ('type'    => 'selectbox',
							       'name'    => 'request_status_id',
							       'options' => $options,
							       'value'   => $this->data['request_data']['request_status_id'],
								   'style' => 'col-sm-1 medium-field'
							));
		}

		$this->data['text_rma_return_code'] = $this->language->get('text_rma_return_code');

		if (!$this->data['request_data']['return_code']){

			$this->data['form']['return_code'] = $form->getFieldHtml(
					array ('type'  => 'input',
					       'name'  => 'return_code',
					       'value' => md5(rand()),
					       'style' => 'large-field'
					));
		} else{
			$this->data['form']['return_code'] = htmlentities($this->data['request_data']['return_code'], ENT_QUOTES, 'UTF-8');
		}

		$this->data['text_rma_action'] = $this->language->get('text_rma_action');
		if ((int)$this->data['request_data']['request_status_id'] != 4){
			$this->data['form']['rma_action'] = $form->getFieldHtml(
					array ('type'    => 'selectbox',
					       'name'    => 'rma_action',
					       'options' => array (1 => $this->language->get('text_rma_action_replace'),
					                           2 => $this->language->get('text_rma_action_refund')),
					       'value'   => $this->data['request_data']['rma_action']
					));
		} else{
			$this->data['form']['rma_action'] = $this->data['request_data']['rma_action'] == 1 ? $this->language->get('text_rma_action_replace') : $this->language->get('text_rma_action_refund');
		}

		$this->data['text_reason'] = $this->language->get('text_reason');
		if ((int)$this->data['request_data']['request_status_id'] != 4){
			$this->data['form']['reason'] = $form->getFieldHtml(
					array ('type'     => 'input',
					       'name'     => 'reason',
					       'value'    => $this->data['request_data']['reason'],
					       'required' => !$this->data['request_data']['reason'] ? true : false,
					       'attr'     => ($this->data['request_data']['reason'] ? 'readonly' : '')
					));
		} else{
			$this->data['form']['reason'] = $this->data['request_data']['reason'];
		}

		$this->data['text_comment'] = $this->language->get('text_conversation');
		$this->data['text_message_history'] = $this->language->get('text_message_history');

		$this->data['form']['conversation'] = unserialize($this->data['request_data']['conversation']);
		if ((int)$this->data['request_data']['request_status_id'] != 4){
			$this->data['form']['comment'] = $form->getFieldHtml(
					array ('type'     => 'textarea',
					       'name'     => 'conversation',
					       'value'    => '',
					       'style'    => 'large-field'

					));
		}

		$this->data['rma_text_email'] = $this->language->get('rma_text_email');
		if ((int)$this->data['request_data']['request_status_id'] != 4){
			$this->data['form']['email'] = $form->getFieldHtml(
					array ('type'  => 'input',
					       'name'  => 'customer_email',
					       'value' => $this->data['request_data']['customer_email']
					));
		} else{
			$this->data['form']['email'] = $this->data['request_data']['customer_email'];
		}
		$this->_initTabs('rma');
		$this->addChild('pages/sale/order_summary', 'summary_form', 'pages/sale/order_summary.tpl');

		$this->loadModel('sale/order');
		$this->data['order_products'] = array ();

		$order_products = $this->model_sale_order->getOrderProducts($order_id);
		foreach ($order_products as $order_product){
			$option_data = array ();

			$options = $this->model_sale_order->getOrderOptions($order_id, $order_product['order_product_id']);

			foreach ($options as $option){
				$option_data[] = array (
						'name'  => $option['name'],
						'value' => $option['value']
				);
			}

			$value = isset($this->data['request_data']['details']['returns'][$order_product['order_product_id']]['return_quantity'])
					? (int)$this->data['request_data']['details']['returns'][$order_product['order_product_id']]['return_quantity']
					: (int)$this->data['request_data']['details']['quantity'][$order_product['order_product_id']];
			$qnty_options = array ();
			for ($i = 0; $i <= $order_product['quantity']; $i++){
				$qnty_options[$i] = $i;
			}
			if ((int)$this->data['request_data']['request_status_id'] != 4){
				$return_qty = $form->getFieldHtml(array (
						'type'    => 'selectbox',
						'name'    => 'returns[' . $order_product['order_product_id'] . '][return_quantity]',
						'style'   => 'medium-field',
						'options' => $qnty_options,
						'value'   => (int)$value));
			}else{
				$return_qty = (int)$value;
			}

			$this->data['order_products'][] = array (
					'order_product_id' => $order_product['order_product_id'],
					'product_id'       => $order_product['product_id'],
					'name'             => $order_product['name'],
					'model'            => $order_product['model'],
					'option'           => $option_data,
					'quantity'         => $order_product['quantity'],
					'return_quantity'  => $return_qty,
					'price'            => $this->currency->format($order_product['price'], $order_info['currency'], $order_info['value']),
					'total'            => $this->currency->format($order_product['total'], $order_info['currency'], $order_info['value']),
					'href'             => $this->html->getSecureURL('catalog/product/update', '&product_id=' . $order_product['product_id'])
			);
		}

		$this->data['totals'] = $this->model_sale_order->getOrderTotals($order_id);


		if ((int)$this->data['request_data']['request_status_id'] != 4){


			$this->data['form']['text_return_stock'] = $this->language->get('text_rma_return_stock');
			$this->data['form']['return_stock'] = $form->getFieldHtml(
					array ('type'       => 'checkbox',
					       'name'       => 'return_stock',
					       'label_text' => $this->data['form']['text_return_stock'],
					       'value'      => 1,
					       'checked'    => false
					));

			$this->data['text_refund'] = $this->language->get('text_refund') . ' (' . $order_info['currency'] . ')';
			$this->data['form']['refund'] = $form->getFieldHtml(
					array ('type'  => 'input',
					       'name'  => 'refund',
					       'value' => (float)$this->data['request_data']['details']['refund']
					));

			$this->data['form']['text_enroll_in_balance'] = $this->language->get('text_rma_enroll_in_balance');
			$this->data['form']['enroll_in_balance'] = $form->getFieldHtml(
					array ('type'       => 'checkbox',
					       'name'       => 'enroll_in_balance',
					       'label_text' => $this->data['form']['text_enroll_in_balance'],
					       'value'      => 1
					));
		}else{
			$this->data['text_refund'] = $this->language->get('text_refund') . ' (' . $order_info['currency'] . ')';
			$this->data['form']['refund'] =  moneyDisplayFormat($this->data['request_data']['details']['refund']);
		}

		$this->view->batchAssign($this->data);
		$this->processTemplate('pages/returns_management/returns_management.tpl');

	}

	private function _validatePost(){
		$this->error = '';
		if (!isset($this->request->post['request_id'])){
			if (!trim($this->request->post['reason']) || !trim($this->request->post['conversation'])){
				$this->error = $this->language->get('error_rma_required');
			}

			if ($this->request->post['customer_email']){
				$pattern = '/^[A-Z0-9._%-]+@[A-Z0-9][A-Z0-9.-]{0,61}[A-Z0-9]\.[A-Z]{2,6}$/i';
				if (!preg_match($pattern, $this->request->post['customer_email'])){
					$this->error = $this->language->get('error_rma_email');
				}
			}
		}

		if ($this->error){
			$this->session->data['warning'] = $this->error;
			return false;
		} else{
			return true;
		}
	}

	private function _initTabs($active){
		$this->data['active'] = $active;
		//load tabs controller
		$tabs_obj = $this->dispatch('pages/sale/order_tabs', array($this->data));
		$this->data['order_tabs'] = $tabs_obj->dispatchGetOutput();
	}


	//LISTING
	public function listing(){

		$this->loadLanguage('sale/order');
		$this->loadLanguage('returns_management/returns_management');
		$this->loadModel('returns_management/returns_management');

		$this->document->setTitle($this->language->get('returns_management_name'));
		$this->document->initBreadcrumb(array (
				'href'      => $this->html->getSecureURL('index/home'),
				'text'      => $this->language->get('text_home'),
				'separator' => false
		));
		$this->document->addBreadcrumb(array (
				'href'      => $this->html->getSecureURL('returns_management/returns_management'),
				'text'      => $this->language->get('returns_management_name'),
				'separator' => ' :: ',
				'current' => true
		));

		$this->document->setTitle($this->language->get('returns_management_name'));

		if (isset($this->session->data['error'])){
			$this->data['error_warning'] = $this->session->data['error'];
			unset($this->session->data['error']);
		} elseif (isset($this->error['warning'])){
			$this->data['error_warning'] = $this->error['warning'];
		} else{
			$this->data['error_warning'] = '';
		}

		if (isset($this->session->data['success'])){
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else{
			$this->data['success'] = '';
		}

		$grid_settings = array (
			//id of grid
				'table_id'    => 'rma_grid',
			// url to load data from
				'url'         => $this->html->getSecureURL('r/returns_management/returns_management'),
				'sortname'    => 'update_date',
				'sortorder'   => 'desc',
				'multiselect' => 'false',
			// actions
				'actions'     => array (
						'edit' => array (
								'text' => $this->language->get('text_edit'),
								'href' => $this->html->getSecureURL('returns_management/returns_management', '&order_id=%ID%')
						)
				),
		);

		$grid_settings['colNames'] = array (
				$this->language->get('column_request_id'),
				$this->language->get('column_order'),
				$this->language->get('column_name'),
				$this->language->get('column_status'),
				$this->language->get('column_update_date'),
		);
		$grid_settings['colModel'] = array (
				array ('name'   => 'request_id',
				       'index'  => 'request_id',
				       'width'  => 60,
				       'align'  => 'center',
				       'search' => false),
				array ('name'   => 'order_id',
				       'index'  => 'order_id',
				       'width'  => 60,
				       'align'  => 'center',
				       'search' => false),
				array ('name'  => 'name',
				       'index' => 'name',
				       'width' => 140,
				       'align' => 'center'),
				array ('name'   => 'status',
				       'index'  => 'status',
				       'width'  => 140,
				       'align'  => 'center',
				       'search' => false),
				array ('name'   => 'update_date',
				       'index'  => 'update_date',
				       'width'  => 90,
				       'align'  => 'center',
				       'search' => false)
		);

		$this->loadModel('localisation/order_status');
		$statuses = $this->model_returns_management_returns_management->getRequestStatusNames();

		$statuses = array_merge(array (0 => $this->language->get('text_select_status')), $statuses);


		$form = new AForm();
		$form->setForm(array (
				'form_name' => 'rma_grid_search',
		));

		$grid_search_form = array ();
		$grid_search_form['id'] = 'rma_grid_search';
		$grid_search_form['form_open'] = $form->getFieldHtml(array (
				'type'   => 'form',
				'name'   => 'rma_grid_search',
				'action' => '',
		));
		$grid_search_form['submit'] = $form->getFieldHtml(array (
				'type'  => 'button',
				'name'  => 'submit',
				'text'  => $this->language->get('button_go'),
				'style' => 'button1',
		));
		$grid_search_form['reset'] = $form->getFieldHtml(array (
				'type'  => 'button',
				'name'  => 'reset',
				'text'  => $this->language->get('button_reset'),
				'style' => 'button2',
		));
		$grid_search_form['fields']['status'] = $form->getFieldHtml(array (
				'type'    => 'selectbox',
				'name'    => 'status',
				'options' => $statuses,
		));

		$grid_search_form['fields']['return_code'] = $form->getFieldHtml(array (
				'type'  => 'input',
				'name'  => 'return_code',
				'placeholder' => $this->language->get('text_search_hint'),
				'style' => 'large-field'
		));
		$grid_settings['search_form'] = true;

		$grid = $this->dispatch('common/listing_grid', array ($grid_settings));
		$this->view->assign('listing_grid', $grid->dispatchGetOutput());
		$this->view->assign('search_form', $grid_search_form);

		$this->processTemplate('pages/returns_management/returns_management_listing.tpl');
	}

}
