<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * @property ModelAccountOrder $model_account_order
 * @property ModelExtensionEmailEditor $model_extension_email_editor
 */
class ModelReturnAuthorizationReturnAuthorization extends Model {
	public $data = [];
	private $error = [];
    public $placeholders = [];

    public function verifyEmailEditor() {
        if ($this->config->get('email_editor_status')) {
            $this->load->model('extension/email_editor_license_info');
            $license_key = $this->config->get('email_editor_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('email_editor_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_email_editor_license_info->getStoreId();
                    $license_key = $this->model_extension_email_editor_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_email_editor_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'email_editor');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_email_editor_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                return false;
            }
        }
    }

	/**
	 * @param int $customer_id
	 * @param int $limit
	 * @param int $offset
	 * @param string $order
	 * @return array
	 */
	public function getRequests($customer_id,$limit,$offset, $order=''){
		$customer_id = (int)$customer_id;
		$limit = (int)$limit;
		$offset = (int)$offset;
		$order = !$order ? 'date_added' : $order;
		if(!$customer_id){
			return [];
		}

		$sql = "SELECT *
				FROM ".$this->db->table('ra_requests')."
				WHERE customer_id=".$customer_id."
				ORDER BY ".$this->db->escape($order)."
				LIMIT ".$limit;
		if($offset){
			$sql .= " OFFSET ".$offset;
		}


		$result = $this->db->query($sql);
		if($result->num_rows){
			return $result->rows;
		}
		return [];
	}

    /**
     * @param $data
     * @return false|void
     * @throws AException
     * @throws \Symfony\Component\Mailer\Exception\TransportExceptionInterface
     */

	public function editRequest($data) {
        $this->load->model('account/order');
        $this->language->get('return_authorization/return_authorization');
        $customer_id = (int)$data['customer_id'];
		$data = (array)$data;

        $languageId = $this->language->getLanguageID();

        if( $request_info = $this->getRequest((int)$data['order_id'])){
			$data['request_id'] = (int)$request_info['request_id'];
			$conversation = unserialize($request_info['conversation']);
		}

		$allowed_fields = ['request_status_id','ra_action','reason','details','conversation','customer_email','return_code'];
		$update = [];

		if ($data['request_id']){
			foreach($allowed_fields as $field_name){
				if(isset($data[$field_name])){
					if($field_name=='conversation'){
						if($data['conversation']){
                            if ($this->customer->isLogged()) {
                                $customer_name = $this->customer->getFirstName() . ' ' . $this->customer->getLastName();
                            } else {
                                $customer_info = $this->model_account_order->getOrder($data['order_id'], '', 'view');
                                $customer_name = $customer_info['firstname'] . ' ' . $customer_info['lastname'];
                            }
							$data[$field_name] = htmlentities($data[$field_name],ENT_QUOTES,'UTF-8');
                            $data['comment'] = htmlentities($data[$field_name], ENT_QUOTES, 'UTF-8');
							$conversation[] = '('.date($this->language->get('date_format_short').' '.$this->language->get('time_format')).') '.$customer_name.":\n".$data[$field_name];
						}
						$data[$field_name] = serialize($conversation);
					} elseif($field_name=='details'){
						$data[$field_name] = serialize($data[$field_name]);
					}
					$update[] = "`".$field_name."`='".$this->db->escape($data[$field_name])."'";
				}
			}

            if ($this->customer->isLogged()) {
                $sql = "UPDATE " . $this->db->table('ra_requests') . "
					SET " . implode(", ", $update) . "
					WHERE customer_id=" . $customer_id . "
						AND request_id = " . $data['request_id'] . ";";
            } else {
                $sql = "UPDATE " . $this->db->table('ra_requests') . "
					SET " . implode(", ", $update) . "
					WHERE order_id=" . $data['order_id'] . "
						AND request_id = " . $data['request_id'] . ";";
            }
			$this->db->query($sql);
            $order_info = $this->model_account_order->getOrder($data['order_id'], '', 'view');
		} else {
            $allowed_fields[] = 'order_id';
            $allowed_fields[] = 'customer_id';

            $order_info = $this->model_account_order->getOrder($data['order_id'], '', 'view');
            if ($data['conversation']) {
                $data['comment'] = htmlentities($data['conversation'], ENT_QUOTES, 'UTF-8');
            }
            foreach ($allowed_fields as $field_name) {
                if (isset($data[$field_name])) {
                    if ($field_name == 'conversation') {
                        if (!$data[$field_name]) {
                            continue;
                        }
                        if ($this->customer->isLogged()) {
                            $customer_name = $this->customer->getFirstName() . ' ' . $this->customer->getLastName();
                        } else {
                            $customer_name = $order_info['firstname'] . ' ' . $order_info['lastname'];
                        }

                        $data[$field_name] = htmlentities($data[$field_name], ENT_QUOTES, 'UTF-8');
                        $conversation[] = '(' . date($this->language->get('date_format_short') . ' ' . $this->language->get('time_format')) . ') ' . $customer_name . ":\n" . $data[$field_name];
                        $data[$field_name] = serialize($conversation);
                    } elseif ($field_name == 'details') {
                        $data[$field_name] = serialize($data[$field_name]);
                    }

                    $update[$field_name] = $this->db->escape($data[$field_name]);
                }
            }

            $date_format = str_replace("/", "", $this->language->get('date_format_short'));

            $update['return_code'] = 'RA-' . date($date_format) . '-' . substr(md5(rand()), 0, 12);
            $date = date("Y-m-d H:i:s");
            $update['date_added'] = $date;
            $sql = "INSERT INTO " . $this->db->table('ra_requests') . " (`" . implode("`, `", array_keys($update)) . "`)
					VALUES ('" . implode("', '", $update) . "');";
            $this->db->query($sql);

            $data['request_id'] = $this->db->getLastId();

            $date_added = dateISO2Display(
                $order_info['date_added'],
                $this->language->get('date_format_short') . ' ' . $this->language->get('time_format')
            );

            $ra_date = dateISO2Display(
                $request_info['date_added'] ? $request_info['date_added'] : $update['date_added'],
                $this->language->get('date_format_short') . ' ' . $this->language->get('time_format')
            );

            $url = $this->html->getCatalogURL('return_authorization/return_authorization', '&order_id=' . $data['order_id']);

            if ($this->verifyEmailEditor()) {
                $this->load->model('extension/email_editor');
                $details = $this->model_extension_email_editor->getDetails('return_authorization');
                $sender_name = $details['sender_name'] ? $details['sender_name'] : $this->config->get('store_name');
                $sender_email = $details['sender_email'] ? $details['sender_email'] : $this->config->get('store_main_email');

                $signature = html_entity_decode($details['signature']);
                $this->data['mail_template_data']['return_status_subject'] = $this->language->get('ra_customer_new_message_subject');
                $this->data['mail_template_data']['order_id'] = $data['order_id'];
                $this->data['mail_template_data']['order_date'] = $date_added;
                $this->data['mail_template_data']['notification_email'] = $update['customer_email'];
                $this->data['mail_template_data']['return_code'] = $update['return_code'];
                $this->data['mail_template_data']['return_status'] = $this->language->get('ra_customer_new_message_subject');
                $this->data['mail_template_data']['request_date'] = $ra_date;
                $this->data['mail_template_data']['return_url'] = '<a href="' . $url . '" target="_blank">' . $url . '</a>';
                $this->data['mail_template_data']['comment'] = $data['comment'];

                $mustache = new Mustache_Engine(['escape' => function ($value) {
                    return $value;
                }]);

                $arAllowedPlaceholders = explode(',', $details['allowed_placeholders']);

                foreach ($arAllowedPlaceholders as &$placeholder) {
                    $placeholder = trim($placeholder);
                }

                foreach ($this->data['mail_template_data'] as $key => $val) {
                    if (in_array($key, $arAllowedPlaceholders, true)) {
                        $this->placeholders[$key] = $val;
                    }
                }

                $subject = $mustache->render($details['subject'], $this->placeholders);

                $content = $mustache->render($details['content'], $this->placeholders);
                $content = html_entity_decode($content);
                $notify_admin = $details['notify_admin'];
                $logos = $this->dispatch('pages/extension/email_logo', []);
                $logo = $logos->dispatchGetOutput();

                $this->data['mail_template_data']['logo'] = html_entity_decode($logo);
                $this->data['mail_template_data']['content'] = $content;
                $this->data['mail_template_data']['signature'] = $signature;
                $this->data['mail_template'] = DIR_EXT . 'return_authorization' . DIR_EXT_CORE . 'lib/return_authorization.tpl';

                $view = new AView($this->registry, 0);
                $view->batchAssign($this->data['mail_template_data']);
                $this->data['mail_plain_text'] = $view->fetch($this->data['mail_template']);
                $this->data['mail_plain_text'] = html_entity_decode($this->data['mail_plain_text'], ENT_QUOTES, 'UTF-8');
                //remove html-tags
                $breaks = ["<br />", "<br>", "<br/>"];
                $this->data['mail_plain_text'] = str_ireplace($breaks, "\r\n", $this->data['mail_plain_text']);
                $html_body = $view->fetch($this->data['mail_template']);
                $languageId = $this->language->getContentLanguageID() ?? $this->language->getLanguageID();
                $mailLogo = $this->config->get('config_mail_logo_' . $languageId)
                    ?: $this->config->get('config_mail_logo');
                $mailLogo = $mailLogo ?: $this->config->get('config_logo_' . $languageId);
                $mailLogo = $mailLogo ?: $this->config->get('config_logo');
                $this->_send_email($data['customer_email'], [
                        'subject' => $subject,
                        'sender_email' => $sender_email,
                        'sender_name' => $sender_name,
                        'txt_body' => $this->data['mail_plain_text'],
                        'html_body' => $html_body,
                        'config_mail_logo' => $mailLogo,
                        'notify_admin' => $notify_admin
                    ]
                );
            } else {
                $cust_view = new AView($this->registry, 0);
                $cust_viewdata = [];

                $cust_subj = sprintf($this->language->get('ra_customer_new_message_subject'));

                $url = $this->html->getCatalogURL('return_authorization/return_authorization', '&order_id=' . $data['order_id']);

                $cust_text = $this->language->get('text_request_order_id') . $data['order_id'] . '<br>';
                $cust_text .= $this->language->get('text_date_added') . $date_added . '<br>';
                $cust_text .= $this->language->get('text_notification_email') . $update['customer_email'] . '<br>';
                $cust_text .= $this->language->get('text_return_code') . $update['return_code'] . '<br>';
                $cust_text .= $this->language->get('text_request_status') . $this->language->get('ra_customer_new_message_subject') . '<br>';
                $cust_text .= $this->language->get('text_return_url') . '<a href="' . $url . '">' . $url . '</a>' . '<br><br>';
                $cust_text .= $this->language->get('text_comment') . '<br>' . $data['comment'] . '<br><br>';
                $cust_text .= $this->language->get('text_additional_notes');

                $mail = new AMail($this->config);

                $mailLogo = $this->config->get('config_mail_logo_' . $languageId)
                    ?: $this->config->get('config_mail_logo');
                $mailLogo = $mailLogo ?: $this->config->get('config_logo_' . $languageId);
                $mailLogo = $mailLogo ?: $this->config->get('config_logo');

                if ($mailLogo) {
                    $result = getMailLogoDetails($mailLogo);
                    $cust_viewdata['logo_uri'] = $result['uri'];
                    $cust_viewdata['logo_html'] = $result['html'];
                }

                $cust_viewdata['message'] = $cust_text;
                $cust_viewdata['store_name'] = $this->config->get('store_name');
                $cust_viewdata['store_url'] = HTTPS_SERVER;
                $cust_view->batchAssign($cust_viewdata);

                $mail->setTo($data['customer_email']);
                $mail->setFrom($this->config->get('store_main_email'));
                $mail->setSender($this->config->get('store_name'));
                $mail->setSubject($cust_subj);

                $attachments = [];
                if (is_file(DIR_RESOURCE . $mailLogo)) {
                    $attachments[] = [
                        'file' => DIR_RESOURCE . $mailLogo,
                        'name' => md5(pathinfo($mailLogo, PATHINFO_FILENAME))
                            . '.'
                            . pathinfo($mailLogo, PATHINFO_EXTENSION)
                    ];
                }

                $attachments = array_merge($attachments, (array)$this->data['mail_attachments']);
                foreach ($attachments as $attachment) {
                    $mail->addAttachment(
                        $attachment['file'],
                        $attachment['name']
                    );
                }

                $mail->setHtml($cust_view->fetch('pages/return_authorization/return_authorization_mail.tpl'));
                $mail->send();
                if ($mail->error) {
                    $this->error = 'Error: Emails does not sent! Please see error log for details.';
                }
            }
        }

        $date_added = dateISO2Display(
            $order_info['date_added'],
            $this->language->get('date_format_short') . ' ' . $this->language->get('time_format')
        );

        $ra_date = dateISO2Display(
            $request_info['date_added'] ? $request_info['date_added'] : $update['date_added'],
            $this->language->get('date_format_short') . ' ' . $this->language->get('time_format')
        );

        /**
         * Save notice
         */
        $subj = sprintf($this->language->get('ra_message_subject'), $data['request_id']);
        $admin_url = $this->html->getSecureURL('return_authorization/return_authorization',
            '&s=' . ADMIN_PATH . '&order_id=' . $data['order_id']);

        $text = sprintf($this->language->get('ra_message_text'),
            $data['request_id'],
            '#admin#rt=return_authorization/return_authorization&s=' . ADMIN_PATH . '&order_id=' . $data['order_id']
        );
        $admin_notice_url = $this->html->convertLinks(html_entity_decode($text, ENT_QUOTES, 'UTF-8'), 'message');

        $return_text = $this->language->get('text_return_code');
        $return_status = $this->language->get('text_request_status');

        $notice_cust_text = $this->language->get('text_request_order_id') . $data['order_id'] . '<br>';
        $notice_cust_text .= $this->language->get('text_date_added') . $date_added . '<br>';
        if ($request_info['return_code']) {
            $notice_cust_text .= $return_text.$request_info['return_code'] . '<br>' ;
        } else {
            $notice_cust_text .= $return_text.$update['return_code'] . '<br>' ;
        }

        if ($request_info['request_status_id']) {
            $notice_cust_text .= $return_status.$this->getRequestStatusName($request_info['request_status_id']) . '<br>' ;
        } else {
            $notice_cust_text .= $return_status.$this->language->get('ra_customer_new_message_subject'). '<br>' ;
        }

        $notice_cust_text .= $this->language->get('text_request_date') . $ra_date . '<br><br>';
        $notice_cust_text .= $this->language->get('text_return_url') . $admin_notice_url . '<br><br>';
        $notice_cust_text .= $this->language->get('text_comment') . '<br>' . $data['comment'] . '<br><br>';
        $notice_cust_text .= $this->language->get('text_additional_notes');

        $this->messages->saveNotice($subj, $notice_cust_text);

        if ($this->config->get('return_authorization_emails')) {
            if ($this->verifyEmailEditor()) {
                $this->load->model('extension/email_editor');
                $details = $this->model_extension_email_editor->getDetails('return_authorization');
                $sender_name = $details['sender_name'] ? $details['sender_name'] : $this->config->get('store_name');
                $sender_email = $details['sender_email'] ? $details['sender_email'] : $this->config->get('store_main_email');

                $signature = html_entity_decode($details['signature']);
                $this->data['mail_template_data']['return_status_subject'] = $subj;
                $this->data['mail_template_data']['order_id'] = $data['order_id'];
                $this->data['mail_template_data']['order_date'] = $date_added;
                $this->data['mail_template_data']['notification_email'] = $update['customer_email'];
                $this->data['mail_template_data']['return_code'] = $request_info['return_code'] ? $request_info['return_code'] : $update['return_code'];
                $this->data['mail_template_data']['return_url'] = '<a href="' . $admin_url . '" target="_blank">' . $admin_url . '</a>';
                $this->data['mail_template_data']['return_status'] = $request_info['request_status_id'] ? $this->getRequestStatusName($request_info['request_status_id'] ) : $this->language->get('ra_customer_new_message_subject');
                $this->data['mail_template_data']['request_date'] = $ra_date;
                $this->data['mail_template_data']['comment'] = $data['comment'];
                $mustache = new Mustache_Engine(['escape' => function ($value) {
                    return $value;
                }]);

                $arAllowedPlaceholders = explode(',', $details['allowed_placeholders']);

                foreach ($arAllowedPlaceholders as &$placeholder) {
                    $placeholder = trim($placeholder);
                }

                foreach ($this->data['mail_template_data'] as $key => $val) {
                    if (in_array($key, $arAllowedPlaceholders, true)) {
                        $this->placeholders[$key] = $val;
                    }
                }

                $subject = $mustache->render($details['subject'], $this->placeholders);

                $content = $mustache->render($details['content'], $this->placeholders);
                $content = html_entity_decode($content);

                $notify_admin = $details['notify_admin'];
                $logos = $this->dispatch('pages/extension/email_logo', []);
                $logo = $logos->dispatchGetOutput();

                $this->data['mail_template_data']['logo'] = html_entity_decode($logo);
                $this->data['mail_template_data']['content'] = $content;
                $this->data['mail_template_data']['signature'] = $signature;
                $this->data['mail_template'] = DIR_EXT . 'return_authorization' . DIR_EXT_CORE . 'lib/return_authorization.tpl';

                $view = new AView($this->registry, 0);
                $view->batchAssign($this->data['mail_template_data']);
                $html_body = $view->fetch($this->data['mail_template']);
                $languageId = $this->language->getContentLanguageID() ?? $this->language->getLanguageID();
                $mailLogo = $this->config->get('config_mail_logo_' . $languageId)
                    ?: $this->config->get('config_mail_logo');
                $mailLogo = $mailLogo ?: $this->config->get('config_logo_' . $languageId);
                $mailLogo = $mailLogo ?: $this->config->get('config_logo');

                $this->data['mail_plain_text'] = $view->fetch($this->data['mail_template']);
                $this->data['mail_plain_text'] = html_entity_decode($this->data['mail_plain_text'], ENT_QUOTES, 'UTF-8');
                //remove html-tags
                $breaks = ["<br />", "<br>", "<br/>"];
                $this->data['mail_plain_text'] = str_ireplace($breaks, "\r\n", $this->data['mail_plain_text']);

                $this->_send_email($this->config->get('return_authorization_emails'), [
                        'subject' => $subject,
                        'sender_email' => $sender_email,
                        'sender_name' => $sender_name,
                        'txt_body' => $this->data['mail_plain_text'],
                        'html_body' => $html_body,
                        'config_mail_logo' => $mailLogo,
                        'notify_admin' => $notify_admin
                    ]
                );
            } else {
                $view = new AView($this->registry, 0);
                $viewdata = [];

                $admin_url = $this->html->getSecureURL('return_authorization/return_authorization',
                    '&s=' . ADMIN_PATH . '&order_id=' . $data['order_id']);

                $cust_text = $this->language->get('text_request_order_id') . $data['order_id'] . '<br>';
                $cust_text .= $this->language->get('text_date_added') . $date_added . '<br>';
                $cust_text .= $this->language->get('text_notification_email') . $request_info['customer_email'] . '<br>';
                if ($request_info['return_code']) {
                    $cust_text .= $this->language->get('text_return_code') . $request_info['return_code'] .'<br>';
                } else {
                    $cust_text .= $this->language->get('text_return_code') . $update['return_code'] . '<br>';
                }
                if ($request_info['request_status_id']) {
                    $cust_text .= $this->language->get('text_request_status') .$this->getRequestStatusName($request_info['request_status_id']). '<br>' ;
                } else {
                    $cust_text .= $this->language->get('text_request_status') . $this->language->get('ra_customer_new_message_subject'). '<br>';
                }
                $cust_text .= $this->language->get('text_request_date') . $ra_date. '<br>';
                $cust_text .= $this->language->get('text_return_url') . '<a href="' . $admin_url . '">' . $admin_url . '</a>' . '<br><br>';
                $cust_text .= $this->language->get('text_comment') . '<br>' . $data['comment'] . '<br><br>';
                $cust_text .= $this->language->get('text_additional_notes');

                $viewdata['text_message'] = $cust_text;
                $viewdata['message'] = $cust_text;

                $languageId = $this->language->getLanguageID();

                $mailLogo = $this->config->get('config_mail_logo_' . $languageId)
                    ?: $this->config->get('config_mail_logo');
                $mailLogo = $mailLogo ?: $this->config->get('config_logo_' . $languageId);
                $mailLogo = $mailLogo ?: $this->config->get('config_logo');

                if ($mailLogo) {
                    $result = getMailLogoDetails($mailLogo);
                    $viewdata['logo_uri'] = $result['uri'];
                    $viewdata['logo_html'] = $result['html'];
                }

                $viewdata['text_footer'] = '';
                $viewdata['store_name'] = $this->config->get('store_name');
                $viewdata['store_url'] = HTTPS_SERVER;
                $view->batchAssign($viewdata);

                $mail = new AMail($this->config);
                $mail->setTo($this->config->get('return_authorization_emails'));
                $mail->setFrom($this->config->get('store_main_email'));
                $mail->setSender($this->config->get('store_name'));
                $mail->setSubject($subj);

                $attachments = [];
                if (is_file(DIR_RESOURCE . $mailLogo)) {
                    $attachments[] = [
                        'file' => DIR_RESOURCE . $mailLogo,
                        'name' => md5(pathinfo($mailLogo, PATHINFO_FILENAME))
                            . '.'
                            . pathinfo($mailLogo, PATHINFO_EXTENSION)
                    ];
                }

                $attachments = array_merge($attachments, (array)$this->data['mail_attachments']);
                foreach ($attachments as $attachment) {
                    $mail->addAttachment(
                        $attachment['file'],
                        $attachment['name']
                    );
                }

                $mail->setHtml($view->fetch('pages/return_authorization/return_authorization_mail.tpl'));
                $mail->send();
                if ($mail->error) {
                    $this->error = 'Error: Emails does not sent! Please see error log for details.';
                }
            }
        } else {
            if ($this->verifyEmailEditor()) {
                $this->load->model('extension/email_editor');
                $details = $this->model_extension_email_editor->getDetails('return_authorization');
                $sender_name = $details['sender_name'] ? $details['sender_name'] : $this->config->get('store_name');
                $sender_email = $details['sender_email'] ? $details['sender_email'] : $this->config->get('store_main_email');

                $signature = html_entity_decode($details['signature']);
                $this->data['mail_template_data']['return_status_subject'] = $subj;
                $this->data['mail_template_data']['order_id'] = $data['order_id'];
                $this->data['mail_template_data']['order_date'] = $date_added;
                $this->data['mail_template_data']['notification_email'] = $update['customer_email'];
                $this->data['mail_template_data']['return_code'] = $request_info['return_code'] ? $request_info['return_code'] : $update['return_code'];
                $this->data['mail_template_data']['return_url'] = '<a href="' . $admin_url . '" target="_blank">' . $admin_url . '</a>';
                $this->data['mail_template_data']['return_status'] = $request_info['request_status_id'] ? $this->getRequestStatusName($request_info['request_status_id'] ) : $this->language->get('ra_customer_new_message_subject');
                $this->data['mail_template_data']['request_date'] = $ra_date;
                $this->data['mail_template_data']['comment'] = $data['comment'];
                $mustache = new Mustache_Engine(['escape' => function ($value) {
                    return $value;
                }]);

                $arAllowedPlaceholders = explode(',', $details['allowed_placeholders']);

                foreach ($arAllowedPlaceholders as &$placeholder) {
                    $placeholder = trim($placeholder);
                }

                foreach ($this->data['mail_template_data'] as $key => $val) {
                    if (in_array($key, $arAllowedPlaceholders, true)) {
                        $this->placeholders[$key] = $val;
                    }
                }

                $subject = $mustache->render($details['subject'], $this->placeholders);

                $content = $mustache->render($details['content'], $this->placeholders);
                $content = html_entity_decode($content);

                $notify_admin = $details['notify_admin'];
                $logos = $this->dispatch('pages/extension/email_logo', []);
                $logo = $logos->dispatchGetOutput();

                $this->data['mail_template_data']['logo'] = html_entity_decode($logo);
                $this->data['mail_template_data']['content'] = $content;
                $this->data['mail_template_data']['signature'] = $signature;
                $this->data['mail_template'] = DIR_EXT . 'return_authorization' . DIR_EXT_CORE . 'lib/return_authorization.tpl';

                $view = new AView($this->registry, 0);
                $view->batchAssign($this->data['mail_template_data']);
                $html_body = $view->fetch($this->data['mail_template']);
                $languageId = $this->language->getContentLanguageID() ?? $this->language->getLanguageID();
                $mailLogo = $this->config->get('config_mail_logo_' . $languageId)
                    ?: $this->config->get('config_mail_logo');
                $mailLogo = $mailLogo ?: $this->config->get('config_logo_' . $languageId);
                $mailLogo = $mailLogo ?: $this->config->get('config_logo');

                $this->data['mail_plain_text'] = $view->fetch($this->data['mail_template']);
                $this->data['mail_plain_text'] = html_entity_decode($this->data['mail_plain_text'], ENT_QUOTES, 'UTF-8');
                //remove html-tags
                $breaks = ["<br />", "<br>", "<br/>"];
                $this->data['mail_plain_text'] = str_ireplace($breaks, "\r\n", $this->data['mail_plain_text']);

                $this->_send_email($sender_email, [
                        'subject' => '(Copy) '.$subject,
                        'sender_email' => $sender_email,
                        'sender_name' => $sender_name,
                        'txt_body' => $this->data['mail_plain_text'],
                        'html_body' => $html_body,
                        'config_mail_logo' => $mailLogo,
                        'notify_admin' => false
                    ]
                );
            }
        }
    }

    /**
     * @param $order_id
     * @return array
     * @throws AException
     */
	public function getRequest($order_id) {
		$customer_id = $this->customer->getId();
		$order_id = (int)$order_id;

		if( !$order_id){
			return [];
		}

        if ($this->customer->isLogged()) {
            $sql = "SELECT *
				FROM ".$this->db->table('ra_requests')."
				WHERE customer_id=".$customer_id." AND order_id=".$order_id;
        } else {
            $sql = "SELECT *
				FROM ".$this->db->table('ra_requests')."
				WHERE order_id=".$order_id;
        }

		$result = $this->db->query($sql);
		if($result->num_rows){
			return $result->row;
		}
		return [];
	}

    /**
     * @param $status_id
     * @return string|null
     * @throws AException
     */
	public function getRequestStatusName($status_id) {
		switch ($status_id) {
			case 1:
				$text = $this->language->get('text_ra_request_status_requested');
				break;
            case 2:
                $text = $this->language->get('text_ra_request_status_in_progress');
                break;
            case 3:
				$text = $this->language->get('text_ra_request_status_approved');
				break;
			case 4:
				$text = $this->language->get('text_ra_request_status_declined');
				break;
            case 5:
                $text = $this->language->get('text_ra_request_waiting_for_returns');
                break;
			case 6:
				$text = $this->language->get('text_ra_request_status_completed');
				break;
			default:
				$text = $this->language->get('text_ra_request_status_requested');
		}
		return $text;
	}

    /**
     * @param $customer_id
     * @return mixed
     * @throws AException
     */
    public function getImage($customer_id,$order_id) {
        $query = $this->db->query("SELECT `image_url` FROM ".$this->db->table('ra_requests_proof_image') ." WHERE `customer_id`=".(int)$customer_id. " AND `order_id`=".$order_id." ORDER BY uploaded_at DESC");
        return $query->rows;
    }

    /**
     * @param $image_url
     * @param $customer_id
     * @param $order_id
     * @return void
     * @throws AException
     */
    public function insertImage($image_url,$customer_id,$order_id) {
        $this->db->query("INSERT INTO ".$this->db->table('ra_requests_proof_image') ." SET `image_url`='".$image_url."', `customer_id`=".(int)$customer_id. ", `order_id`=".$order_id.",`uploaded_at`=NOW()");
    }

    /**
     * @param $image_url
     * @param $customer_id
     * @param $order_id
     * @return void
     * @throws AException
     */
    public function deleteImage($image_url,$customer_id,$order_id) {
        $this->db->query("DELETE FROM ".$this->db->table('ra_requests_proof_image') ." WHERE `image_url`='".$image_url."' AND `customer_id`=".(int)$customer_id. " AND `order_id`=".$order_id);
    }

    protected function dispatch($dispatch_rt, $args =[]) {
        return new ADispatcher($dispatch_rt, $args);
    }

    protected function _send_email($email, $data) {
        $mail = new AMail($this->config);
        $mail->setTo($email);
        $mail->setFrom($data['sender_email']);
        $mail->setSender($data['sender_name']);
        $mail->setSubject($data['subject']);
        $mail->setText(html_entity_decode($data['txt_body'], ENT_QUOTES, 'UTF-8'));

        if (is_file(DIR_RESOURCE.$data['config_mail_logo'])) {
            $mail->addAttachment(DIR_RESOURCE.$data['config_mail_logo'],
                md5(pathinfo($data['config_mail_logo'], PATHINFO_FILENAME))
                .'.'.pathinfo($data['config_mail_logo'], PATHINFO_EXTENSION));
        }
        $mail->setHtml($data['html_body']);
        $mail->send();

        if ($data['notify_admin']==='1') {
            $mail = new AMail($this->config);
            if ($this->config->get('return_authorization_emails')) {
                if (substr($this->config->get('return_authorization_emails'), -1) ===',') {
                    if ($data['sender_email']) {
                        $email_addresses = $this->config->get('return_authorization_emails').$data['sender_email'];
                    } else {
                        $email_addresses = $this->config->get('return_authorization_emails').$this->config->get('store_main_email');
                    }
                } else {
                    if ($data['sender_email']) {
                        $email_addresses = $this->config->get('return_authorization_emails').','.$data['sender_email'];
                    } else {
                        $email_addresses = $this->config->get('return_authorization_emails').','.$this->config->get('store_main_email');
                    }
                }
                $emails = implode(',',array_unique(explode(',', $email_addresses )));
            } else {
                if ($data['sender_email']) {
                    $emails = $data['sender_email'];
                } else {
                    $emails = $this->config->get('store_main_email');
                }
            }

            $mail->setTo($emails);
            $mail->setFrom($data['sender_email']);
            $mail->setSender($data['sender_name']);
            $mail->setSubject('(Copy) '.$data['subject']);
            $mail->setText(html_entity_decode($data['txt_body'], ENT_QUOTES, 'UTF-8'));

            if (is_file(DIR_RESOURCE.$data['config_mail_logo'])) {
                $mail->addAttachment(DIR_RESOURCE.$data['config_mail_logo'],
                    md5(pathinfo($data['config_mail_logo'], PATHINFO_FILENAME))
                    .'.'.pathinfo($data['config_mail_logo'], PATHINFO_EXTENSION));
            }
            $mail->setHtml($data['html_body']);
            $mail->send();
        }
    }

    /**
     * @param $order_id
     * @return mixed
     * @throws AException
     */
    public function getStatusByOrderId($order_id) {
        $sql = "SELECT `request_status_id` FROM ".$this->db->table("ra_requests")." WHERE `order_id`=".(int)$order_id;
        $query = $this->db->query($sql);
        return $query->row['request_status_id'];
    }

 }