<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2024 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * @property ModelReturnAuthorizationReturnAuthorization $model_return_authorization_return_authorization
 */
class ControllerResponsesReturnAuthorizationReturnAuthorization extends AController {

    public $data = [];

    public function upload() {
        $this->loadModel('return_authorization/return_authorization');
        $this->load->language('return_authorization/return_authorization');
        $json = $preview = $config = $error = [];

        // Make sure we have the correct directory
        $directory = $this->request->get['directory'];
        $customer_id = $this->request->get['customer_id'];
        $order_id = $this->request->get['order_id'];

        // Check its a directory
        if (!is_dir($directory)) {
            $json['error'] = $this->language->get('error_directory');
        }

        if (!$json) {

            $input = 'upload_damaged_product_proof'; // the input name for the fileinput plugin
            if (empty($_FILES[$input])) {
                return [];
            }
            $total = count($_FILES[$input]['name']); // multiple files

            for ($i = 0; $i < $total; $i++) {
                //if (!empty($_FILES[$input]['name'][$i]) && is_file($_FILES[$input]['tmp_name'][$i])) {
                    // Sanitize the filename
                $tmpFilePath = $_FILES[$input]['tmp_name'][$i]; // the temp file path
                $filename = basename(html_entity_decode($_FILES[$input]['name'][$i], ENT_QUOTES, 'UTF-8'));
                $extension = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
                $newFilename = strstr($filename, '.', true);
                $fileSize = $_FILES[$input]['size'][$i]; // the file size
                $new = $newFilename . '.' . $extension;
                if ($tmpFilePath != "") {
                    //Setup our new file path
                    $newFilePath = $directory . $new;
                    $newFileUrl = HTTPS_SERVER . $directory. $new;
                    //Upload the file into the new path
                    if (move_uploaded_file($tmpFilePath,  $directory . $new)) {
                        $fileId = $filename . $i; // some unique key to identify the file
                        $preview[] = $newFileUrl;
                        $config[] = [
                            'key' => $filename,
                            'caption' => $filename,
                            'size' => $fileSize,
                            'downloadUrl' => $newFileUrl, // the url to download the file
                            'url' => $this->html->getCatalogURL('r/return_authorization/return_authorization/delete','&order_id='.$order_id.'&customer_id='.$customer_id), // server api to delete the file based on key
                        ];
                    } else {
                        $errors[] = $filename;
                    }
                } else {
                    $errors[] = $filename;
                }
                $folder = 'image/RA/' . $order_id . '/' . $new;

                $this->model_return_authorization_return_authorization->insertImage($folder,$customer_id,$order_id);
            }
        }

        $json = ['initialPreview' => $preview, 'initialPreviewConfig' => $config, 'initialPreviewAsData' => true];

        if (!empty($errors)) {
            $img = count($errors) === 1 ? 'file "' . $error[0] . '" ' : 'files: "' . implode('", "', $errors) . '" ';
            $error_upload = str_replace("[img]",$img,$this->language->get('error_upload'));
            $json['error'] = $error_upload;
        }

        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));

    }

    public function delete() {
        $this->loadModel('return_authorization/return_authorization');
        $json = [];
        $key = $this->request->post['key'];
        $order_id = $this->request->get['order_id'];
        $customer_id = $this->request->get['customer_id'];
        unlink(DIR_IMAGE . 'RA/' .$order_id.'/'.$key);
        $image_url = 'image/RA/' . $order_id.'/'.$key;
        $this->model_return_authorization_return_authorization->deleteImage($image_url,$customer_id,$order_id);
        $this->response->addHeader('Content-Type: application/json');
        $this->response->setOutput(json_encode($json));
    }
}